/* application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <clutter-gtk/clutter-gtk.h>
#include <stdlib.h>
#include <clutter/clutter.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TWENTY_FORTY_EIGHT (twenty_forty_eight_get_type ())
#define TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEight))
#define TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))
#define IS_TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWENTY_FORTY_EIGHT))
#define IS_TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWENTY_FORTY_EIGHT))
#define TWENTY_FORTY_EIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))

typedef struct _TwentyFortyEight TwentyFortyEight;
typedef struct _TwentyFortyEightClass TwentyFortyEightClass;
typedef struct _TwentyFortyEightPrivate TwentyFortyEightPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
enum  {
	TWENTY_FORTY_EIGHT_0_PROPERTY,
	TWENTY_FORTY_EIGHT_NUM_PROPERTIES
};
static GParamSpec* twenty_forty_eight_properties[TWENTY_FORTY_EIGHT_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TwentyFortyEight {
	GtkApplication parent_instance;
	TwentyFortyEightPrivate * priv;
};

struct _TwentyFortyEightClass {
	GtkApplicationClass parent_class;
};

struct _TwentyFortyEightPrivate {
	GameWindow* _window;
	guint8 cols;
	guint8 rows;
};

static gint TwentyFortyEight_private_offset;
static gpointer twenty_forty_eight_parent_class = NULL;
static gchar* twenty_forty_eight_size;
static gboolean twenty_forty_eight_show_version;
static gboolean twenty_forty_eight_show_version = FALSE;
static gchar* twenty_forty_eight_size = NULL;
static gchar* twenty_forty_eight_cli;
static gchar* twenty_forty_eight_cli = NULL;

VALA_EXTERN GType twenty_forty_eight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TwentyFortyEight, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
static gboolean _twenty_forty_eight_cli (TwentyFortyEight* self,
                                  const gchar* option_name,
                                  const gchar* val);
static void twenty_forty_eight_quit_cb (TwentyFortyEight* self);
static void _twenty_forty_eight_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static gint twenty_forty_eight_main (gchar** args,
                              gint args_length1);
static TwentyFortyEight* twenty_forty_eight_new (void);
static TwentyFortyEight* twenty_forty_eight_construct (GType object_type);
static gint twenty_forty_eight_real_handle_local_options (GApplication* base,
                                                   GVariantDict* options);
VALA_EXTERN gboolean cli_parse_size (const gchar* size,
                         guint8* cols,
                         guint8* rows);
VALA_EXTERN gint cli_play_cli (const gchar* cli,
                   const gchar* schema_name,
                   guint8* cols,
                   guint8* rows);
static void twenty_forty_eight_real_startup (GApplication* base);
static void twenty_forty_eight_real_activate (GApplication* base);
VALA_EXTERN GameWindow* game_window_new (TwentyFortyEight* application,
                             guint8 cols,
                             guint8 rows);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   TwentyFortyEight* application,
                                   guint8 cols,
                                   guint8 rows);
static void twenty_forty_eight_finalize (GObject * obj);
static GType twenty_forty_eight_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TWENTY_FORTY_EIGHT_option_entries[4] = {{"cli", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) _twenty_forty_eight_cli, N_ ("Play in the terminal (see “--cli=help”)"), N_ ("COMMAND")}, {"size", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING, &twenty_forty_eight_size, N_ ("Start new game of given size"), N_ ("SIZE")}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &twenty_forty_eight_show_version, N_ ("Print release version and exit"), NULL}, {0}};
static const GActionEntry TWENTY_FORTY_EIGHT_action_entries[1] = {{"quit", _twenty_forty_eight_quit_cb_gsimple_action_activate_callback}};

static inline gpointer
twenty_forty_eight_get_instance_private (TwentyFortyEight* self)
{
	return G_STRUCT_MEMBER_P (self, TwentyFortyEight_private_offset);
}

static void
_twenty_forty_eight_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	twenty_forty_eight_quit_cb ((TwentyFortyEight*) self);
}

static gboolean
_twenty_forty_eight_cli (TwentyFortyEight* self,
                         const gchar* option_name,
                         const gchar* val)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (option_name == NULL) {
		_tmp0_ = "";
	} else {
		_tmp0_ = (const gchar*) option_name;
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (twenty_forty_eight_cli);
	twenty_forty_eight_cli = _tmp1_;
	result = TRUE;
	return result;
}

static gint
twenty_forty_eight_main (gchar** args,
                         gint args_length1)
{
	static const char application_name[] = "org.gnome.TwentyFortyEight";
	TwentyFortyEight* app = NULL;
	TwentyFortyEight* _tmp7_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (application_name);
	g_set_prgname ("org.gnome.TwentyFortyEight");
	gtk_window_set_default_icon_name ("org.gnome.TwentyFortyEight");
	{
		gtk_clutter_init ((gint*) (&args_length1), &args);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		GtkMessageDialog* _tmp2_;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp1_);
		g_object_ref_sink (_tmp2_);
		dialog = _tmp2_;
		_tmp3_ = dialog;
		gtk_window_set_title ((GtkWindow*) _tmp3_, application_name);
		_tmp4_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		result = EXIT_FAILURE;
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp6_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = twenty_forty_eight_new ();
	app = _tmp7_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return twenty_forty_eight_main (argv, argc);
}

static TwentyFortyEight*
twenty_forty_eight_construct (GType object_type)
{
	TwentyFortyEight * self = NULL;
	GOptionGroup* _tmp0_;
	self = (TwentyFortyEight*) g_object_new (object_type, "application-id", "org.gnome.TwentyFortyEight", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, TWENTY_FORTY_EIGHT_option_entries);
	_tmp0_ = clutter_get_option_group_without_init ();
	g_application_add_option_group ((GApplication*) self, _tmp0_);
	return self;
}

static TwentyFortyEight*
twenty_forty_eight_new (void)
{
	return twenty_forty_eight_construct (TYPE_TWENTY_FORTY_EIGHT);
}

static gint
twenty_forty_eight_real_handle_local_options (GApplication* base,
                                              GVariantDict* options)
{
	TwentyFortyEight * self;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp8_;
	gint result;
	self = (TwentyFortyEight*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (twenty_forty_eight_show_version) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "gnome-2048", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp2_ = twenty_forty_eight_size;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		guint8 _tmp4_ = 0U;
		guint8 _tmp5_ = 0U;
		gboolean _tmp6_;
		_tmp3_ = twenty_forty_eight_size;
		_tmp6_ = cli_parse_size ((const gchar*) _tmp3_, &_tmp4_, &_tmp5_);
		self->priv->cols = _tmp4_;
		self->priv->rows = _tmp5_;
		_tmp1_ = !_tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FILE* _tmp7_;
		_tmp7_ = stderr;
		fprintf (_tmp7_, "%s\n", _ ("Failed to parse size. Size must be between 2 and 9, or in the form 2x3" \
"."));
		result = EXIT_FAILURE;
		return result;
	}
	_tmp8_ = twenty_forty_eight_cli;
	if (_tmp8_ != NULL) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp15_;
		gint _tmp16_;
		_tmp10_ = twenty_forty_eight_cli;
		if (g_strcmp0 ((const gchar*) _tmp10_, "help") == 0) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = twenty_forty_eight_cli;
			_tmp9_ = g_strcmp0 ((const gchar*) _tmp11_, "HELP") == 0;
		}
		if (_tmp9_) {
			gchar* help_string = NULL;
			gchar* _tmp12_;
			FILE* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = g_strdup ("" "\n" "To play GNOME 2048 in command-line:" "\n" "  --cli         " "Display current game. Alias: “status” or “show”." "\n" "  --cli new     " "Start a new game; for changing size, use --size." "\n" "\n" "  --cli up      " "Move tiles up.    Alias: “u”." "\n" "  --cli down    " "Move tiles down.  Alias: “d”." "\n" "  --cli left    " "Move tiles left.  Alias: “l”." "\n" "  --cli right   " "Move tiles right. Alias: “r”." "\n\n");
			help_string = _tmp12_;
			_tmp13_ = stdout;
			_tmp14_ = help_string;
			fprintf (_tmp13_, "%s", _tmp14_);
			result = EXIT_SUCCESS;
			_g_free0 (help_string);
			return result;
		}
		_tmp15_ = twenty_forty_eight_cli;
		_tmp16_ = cli_play_cli ((const gchar*) _tmp15_, "org.gnome.TwentyFortyEight", &self->priv->cols, &self->priv->rows);
		result = _tmp16_;
		return result;
	}
	result = -1;
	return result;
}

static void
twenty_forty_eight_real_startup (GApplication* base)
{
	TwentyFortyEight * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	self = (TwentyFortyEight*) base;
	G_APPLICATION_CLASS (twenty_forty_eight_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, TWENTY_FORTY_EIGHT_action_entries, (gint) G_N_ELEMENTS (TWENTY_FORTY_EIGHT_action_entries), self);
	_tmp0_ = g_strdup ("<Primary>n");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.toggle-new-game", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Shift><Primary>n");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.new-game", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>q");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Primary>z");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.undo", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Shift>F1");
	_tmp13_ = g_strdup ("<Shift><Primary>F1");
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.about", _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("F1");
	_tmp17_ = g_strdup ("<Primary>F1");
	_tmp18_ = g_strdup ("<Primary>question");
	_tmp19_ = g_strdup ("<Shift><Primary>question");
	_tmp20_ = g_new0 (gchar*, 4 + 1);
	_tmp20_[0] = _tmp16_;
	_tmp20_[1] = _tmp17_;
	_tmp20_[2] = _tmp18_;
	_tmp20_[3] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 4;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-help-overlay", _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("F10");
	_tmp23_ = g_strdup ("Menu");
	_tmp24_ = g_new0 (gchar*, 2 + 1);
	_tmp24_[0] = _tmp22_;
	_tmp24_[1] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.toggle-hamburger", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
}

static void
twenty_forty_eight_real_activate (GApplication* base)
{
	TwentyFortyEight * self;
	GtkWindow* _tmp0_;
	GameWindow* _tmp2_;
	self = (TwentyFortyEight*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		GameWindow* _tmp1_;
		_tmp1_ = game_window_new (self, self->priv->cols, self->priv->rows);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp1_;
	}
	_tmp2_ = self->priv->_window;
	gtk_window_present ((GtkWindow*) _tmp2_);
}

static void
twenty_forty_eight_quit_cb (TwentyFortyEight* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		GameWindow* _tmp1_;
		_tmp1_ = self->priv->_window;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
}

static void
twenty_forty_eight_class_init (TwentyFortyEightClass * klass,
                               gpointer klass_data)
{
	twenty_forty_eight_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TwentyFortyEight_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) twenty_forty_eight_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) twenty_forty_eight_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) twenty_forty_eight_real_activate;
	G_OBJECT_CLASS (klass)->finalize = twenty_forty_eight_finalize;
}

static void
twenty_forty_eight_instance_init (TwentyFortyEight * self,
                                  gpointer klass)
{
	self->priv = twenty_forty_eight_get_instance_private (self);
	self->priv->cols = (guint8) 0;
	self->priv->rows = (guint8) 0;
}

static void
twenty_forty_eight_finalize (GObject * obj)
{
	TwentyFortyEight * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEight);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (twenty_forty_eight_parent_class)->finalize (obj);
}

static GType
twenty_forty_eight_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TwentyFortyEightClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) twenty_forty_eight_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TwentyFortyEight), 0, (GInstanceInitFunc) twenty_forty_eight_instance_init, NULL };
	GType twenty_forty_eight_type_id;
	twenty_forty_eight_type_id = g_type_register_static (gtk_application_get_type (), "TwentyFortyEight", &g_define_type_info, 0);
	TwentyFortyEight_private_offset = g_type_add_instance_private (twenty_forty_eight_type_id, sizeof (TwentyFortyEightPrivate));
	return twenty_forty_eight_type_id;
}

GType
twenty_forty_eight_get_type (void)
{
	static volatile gsize twenty_forty_eight_type_id__once = 0;
	if (g_once_init_enter (&twenty_forty_eight_type_id__once)) {
		GType twenty_forty_eight_type_id;
		twenty_forty_eight_type_id = twenty_forty_eight_get_type_once ();
		g_once_init_leave (&twenty_forty_eight_type_id__once, twenty_forty_eight_type_id);
	}
	return twenty_forty_eight_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

