/*
 * nUFRaw - new Unidentified Flying Raw converter for digital camera images
 *
 * nufraw_ui.h - Common definitions for nUFRaw's GUI.
 * Copyright 2016 by Matteo Lucarelli
 *
 * based on ufraw 0.23 Copyright 2004-2015 by Udi Fuchs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef _NUFRAW_UI_H
#define _NUFRAW_UI_H

#include "nufraw.h"

// height of curves
#define UI_CURVE_HEIGHT  200

// mimimum height of histograms
#define UI_HIS_MINHEIGHT  80
#define UI_HIS_MAXHEIGHT  800

// size of histograms and curve boxes 
#define UI_HIS_CURVE_MINWIDTH 260
#define UI_HIS_CURVE_MAXWIDTH 1000

// zoom % range
#define UI_MIN_ZOOM 5
#define UI_MAX_ZOOM 400

// exposure compensation range
#define UI_EXP_RANGE 10

// padding and borders
#define UI_FR_PADDING 3
#define UI_FR_SHADOW GTK_SHADOW_NONE

// icons and buttons size
#define UI_BT_SIZE GTK_ICON_SIZE_MENU
#define UI_IC_SIZE GTK_ICON_SIZE_MENU

// aspect ratio tolerance
#define UI_ASPECT_TOL 0.003

// blink speed
#define UI_BLINK_MS 300

// max raws/colums
#define UI_TABLE_SIZE 16

// singlechar labels for spot values
#define UI_SPOT_LABELS "RGBYZ"

typedef struct {
	GtkLabel *labels[5];// TODO: define
	int num;
	int format;
	gboolean forspot;
} colorLabels;

// predefined aspect ratios  
static const struct {
	float val;
	const char text[6];
} predef_aspects[] = {
	{ 21.0 / 9.0,  "21:9"  },
	{ 16.0 / 10.0, "16:10" },
	{ 16.0 / 9.0,  "16:9"  },
	{  3.0 / 2.0,  "3:2"   },
	{  7.0 / 5.0,  "7:5"   },
	{  4.0 / 3.0,  "4:3"   },
	{  5.0 / 4.0,  "5:4"   },
	{  1.0 / 1.0,  "1:1"   },
	{  4.0 / 5.0,  "4:5"   },
	{  3.0 / 4.0,  "3:4"   },
	{  5.0 / 7.0,  "5:7"   },
	{  2.0 / 3.0,  "2:3"   },
};

// presets for grayscale mixer (r+g+b=1)
static const float grayscale_filters[][3] = {
	{ 1.00 , 0.00, 0.00 },
	{ 0.76 , 0.18, 0.15 },
	{ 0.55 , 0.45, 0.00 },   
	{ 0.27 , 0.55, 0.08 },   
	{ 0.11 , 0.27, 0.62 },  
	{ 0.00 , 0.00, 1.00 },  
};

typedef enum { 
	render_default, render_overexposed, render_underexposed, render_zone
} RenderModeType;

typedef enum { cancel_button, ok_button, save_button, gimp_button } ControlButtons;

enum { base_curve, luminosity_curve };
enum { pixel_format, percent_format };

// "global" runtime variables for ui
typedef struct {

	nufraw_data *UF;
	int plugin;
	int LeftSpace;
	int raw_his[UI_HIS_CURVE_MAXWIDTH][4];   // TODO define
	GtkComboBox *InterpolationCombo;
	GtkToggleButton *SmoothingButton;
	GtkWidget *DetailButton, *HighlightButton;
	GtkWidget *PreviewWidget;
	GdkPixbuf *PreviewPixbuf;
	GtkWidget *PreviewEventBox;
	GtkWidget *PreviewScroll;
	GdkCursor *Cursor[cursor_num];
	GtkWidget *CursorButton[3];   // TODO define
	GtkWidget *RawHisto;
	GtkWidget *LiveHisto;
	GtkLabel *DarkFrameLabel;
	GtkWidget *BaseCurveWidget, *CurveWidget;
	GtkComboBox *BaseCurveCombo;
	GtkComboBox *CurveCombo;
	GtkComboBox *ProfileCombo[profile_types];
	GtkComboBox *OutputIntentCombo;
	GtkComboBox *BitDepthCombo; 
	GtkWidget *GrayscaleButtons[6];    // TODO: define
	GtkTable *GrayscaleMixerTable;
	GtkLabel *GrayscaleMixerColor;
	GtkLabel *SpotPatch;
	GtkLabel *HotpixelCount;
	colorLabels *SpotLabels, *AvrLabels, *DevLabels, *OverLabels, *UnderLabels;
	GtkToggleButton *AutoExposureButton, *AutoBlackButton;
	GtkToggleButton *AutoCropButton, *LockAspectButton;
	GtkWidget *AutoCurveButton;
	GtkWidget *ResetGammaButton, *ResetLinearButton;
	GtkWidget *ResetExposureButton, *ResetSaturationButton;
	GtkWidget *ResetThresholdButton;
	GtkWidget *ResetHotpixelButton;
#ifdef NUFRAW_CONTRAST
	GtkWidget *ResetContrastButton;
#endif
	GtkWidget *ResetBlackButton, *ResetBaseCurveButton, *ResetCurveButton;
	GtkWidget *ResetGrayscaleChannelMixerButton;
	GtkWidget *ResetDespeckleButton;
	GtkWidget *ResetAllButton;
	GtkWidget *ResetCropButton;
	GtkWidget *ResetWbButton;
	GtkWidget *ResetLens;
	GtkWidget *ResetDarkframe;
	GtkWidget *ResetShrink;
	GtkWidget *SaveButton;
	GtkProgressBar *ProgressBar;
	/* We need the adjustments for update_scale() */
	GtkAdjustment *GammaAdjustment;
	GtkAdjustment *LinearAdjustment;
	GtkAdjustment *ExposureAdjustment;
	GtkAdjustment *ThresholdAdjustment;
	GtkAdjustment *HotpixelAdjustment;
	GtkAdjustment *SaturationAdjustment;
	GtkAdjustment *BlackpointAdjustment;
#ifdef NUFRAW_CONTRAST
	GtkAdjustment *ContrastAdjustment;
#endif
	GtkWidget *LightnessHueSelectNewButton;
	GtkTable *LightnessAdjustmentTable[UF_MAX_LIGHTNESS_ADJUSTMENTS];
	GtkAdjustment *LightnessAdjustment[UF_MAX_LIGHTNESS_ADJUSTMENTS];
	GtkWidget *ResetLightnessAdjustmentButton[UF_MAX_LIGHTNESS_ADJUSTMENTS];
	GtkWidget *LightnessHueSelectButton[UF_MAX_LIGHTNESS_ADJUSTMENTS];
	GtkWidget *LightnessHueRemoveButton[UF_MAX_LIGHTNESS_ADJUSTMENTS];
	GtkAdjustment *CropX1Adjustment;
	GtkAdjustment *CropY1Adjustment;
	GtkAdjustment *CropX2Adjustment;
	GtkAdjustment *CropY2Adjustment;
	GtkAdjustment *ZoomAdjustment;
	GtkAdjustment *ShrinkAdjustment;
	GtkAdjustment *HeightAdjustment;
	GtkAdjustment *WidthAdjustment;
	GtkAdjustment *RotationAdjustment;
	GtkWidget *ResetRotationAdjustment;
	GtkAdjustment *GrayscaleMixers[3];// TODO: define
	GtkAdjustment *DespeckleWindowAdj[4];// TODO: define
	GtkAdjustment *DespeckleDecayAdj[4];// TODO: define
	GtkAdjustment *DespecklePassesAdj[4];// TODO: define
	GtkToggleButton *DespeckleLockChannelsButton;// TODO: define
	GtkToggleButton *ChannelSelectButton[4];// TODO: define
	GTimer *ProgressTimer;
	int ChannelSelect;
#ifdef HAVE_LENSFUN
	/* The GtkEntry with camera maker/model name */
	GtkWidget *CameraModel;
	/* The menu used to choose camera - either full or limited by search criteria */
	GtkWidget *CameraMenu;
	/* The GtkEntry with lens maker/model name */
	GtkWidget *LensModel;
	/* The menu used to choose lens - either full or limited by search criteria */
	GtkWidget *LensMenu;
	/* The lens fix notebook distortion page */
	GtkWidget *LensDistortionTable, *LensDistortionHelp;
	/* The lens fix notebook TCA page */
	GtkWidget *LensTCATable, *LensTCAHelp;
	/* The lens fix notebook vignetting page */
	GtkWidget *LensVignettingTable, *LensVignettingHelp;
	/* The hbox containing focal, aperture, distance combos */
	GtkWidget *LensParamBox;
#endif 
	// save function is different from plugin to standalone
	long(*SaveFunc)();
	// momentary render mode for zone, overrexposed, underexposed, ecc.
	RenderModeType RenderMode;
	/* Current subarea index (0-31). If negative, rendering has stopped */
	int RenderSubArea;
	/* Some actions update the progress bar while working, but meanwhile we
	* want to freeze all other actions. After we thaw the dialog we must
	* call update_scales() which was also frozen. */
	gboolean FreezeDialog;
	/* Since the event-box can be larger than the preview pixbuf we need: */
	gboolean PreviewButtonPressed, SpotDraw;
	int SpotX1, SpotY1, SpotX2, SpotY2;
	CursorType CropMotionType;
	int DrawnCropX1, DrawnCropX2, DrawnCropY1, DrawnCropY2;
	// shrink here is only the adjuster value
	double shrink, height, width;
	int UnnormalizedOrientation;
	/* Original aspect ratio (0) or actual aspect ratio */
	/* The aspect ratio entry field */
	GtkEntry *AspectEntry;
	/* Mouse coordinates in previous frame (used when dragging crop area) */
	int OldMouseX, OldMouseY;
	int OverUnderTicker;
	/* The event source number when the highlight blink function is enabled. */
	guint BlinkTimer;
	guint DrawCropID;
} ui_data;

#endif /* _NUFRAW_UI_H */

