/* imap-engine-account-operation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-engine-account-operation.vala, do not modify */

/*
 * Copyright 2017 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_0_PROPERTY,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_LOGGING_PARENT_PROPERTY,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_account_operation_properties[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_NUM_PROPERTIES];
enum  {
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_COMPLETED_SIGNAL,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_SUCCEEDED_SIGNAL,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_FAILED_SIGNAL,
	GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_NUM_SIGNALS
};
static guint geary_imap_engine_account_operation_signals[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_NUM_SIGNALS] = {0};
enum  {
	GEARY_IMAP_ENGINE_FOLDER_OPERATION_0_PROPERTY,
	GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY,
	GEARY_IMAP_ENGINE_FOLDER_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_folder_operation_properties[GEARY_IMAP_ENGINE_FOLDER_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapEngineAccountOperationPrivate {
	GearyAccount* _account;
};

struct _GearyImapEngineFolderOperationPrivate {
	GearyFolder* _folder;
};

static gint GearyImapEngineAccountOperation_private_offset;
static gpointer geary_imap_engine_account_operation_parent_class = NULL;
static GearyLoggingSourceIface * geary_imap_engine_account_operation_geary_logging_source_parent_iface = NULL;
static gint GearyImapEngineFolderOperation_private_offset;
static gpointer geary_imap_engine_folder_operation_parent_class = NULL;

static void geary_imap_engine_account_operation_set_account (GearyImapEngineAccountOperation* self,
                                                      GearyAccount* value);
static gboolean geary_imap_engine_account_operation_real_equal_to (GearyImapEngineAccountOperation* self,
                                                            GearyImapEngineAccountOperation* op);
static GearyLoggingState* geary_imap_engine_account_operation_real_to_logging_state (GearyImapEngineAccountOperation* self);
static void geary_imap_engine_account_operation_finalize (GObject * obj);
static GType geary_imap_engine_account_operation_get_type_once (void);
static void _vala_geary_imap_engine_account_operation_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_geary_imap_engine_account_operation_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void geary_imap_engine_folder_operation_set_folder (GearyImapEngineFolderOperation* self,
                                                    GearyFolder* value);
static gboolean geary_imap_engine_folder_operation_real_equal_to (GearyImapEngineAccountOperation* base,
                                                           GearyImapEngineAccountOperation* op);
static GearyLoggingState* geary_imap_engine_folder_operation_real_to_logging_state (GearyImapEngineAccountOperation* base);
static void geary_imap_engine_folder_operation_finalize (GObject * obj);
static GType geary_imap_engine_folder_operation_get_type_once (void);
static void _vala_geary_imap_engine_folder_operation_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_imap_engine_folder_operation_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
geary_imap_engine_account_operation_get_instance_private (GearyImapEngineAccountOperation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineAccountOperation_private_offset);
}

static GearyLoggingSource*
geary_imap_engine_account_operation_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyImapEngineAccountOperation* self;
	GearyAccount* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation);
	_tmp0_ = self->priv->_account;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource);
	return result;
}

GearyAccount*
geary_imap_engine_account_operation_get_account (GearyImapEngineAccountOperation* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
geary_imap_engine_account_operation_set_account (GearyImapEngineAccountOperation* self,
                                                 GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (self));
	old_value = geary_imap_engine_account_operation_get_account (self);
	if (old_value != value) {
		self->priv->_account = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_account_operation_properties[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY]);
	}
}

/**
     * Constructs a new account operation.
     *
     * The passed in `account` will be the account the operation will
     * apply to.
     */
GearyImapEngineAccountOperation*
geary_imap_engine_account_operation_construct (GType object_type,
                                               GearyAccount* account)
{
	GearyImapEngineAccountOperation * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), NULL);
	self = (GearyImapEngineAccountOperation*) geary_base_object_construct (object_type);
	geary_imap_engine_account_operation_set_account (self, account);
	return self;
}

void
geary_imap_engine_account_operation_execute (GearyImapEngineAccountOperation* self,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearyImapEngineAccountOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_imap_engine_account_operation_execute_finish (GearyImapEngineAccountOperation* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyImapEngineAccountOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

/**
     * Determines if this operation is equal to another.
     *
     * By default assumes that the same instance or two different
     * instances of the exact same type are equal. Implementations
     * should override it if they wish to guard against different
     * instances of the same high-level operation from being executed
     * twice.
     */
static gboolean
geary_imap_engine_account_operation_real_equal_to (GearyImapEngineAccountOperation* self,
                                                   GearyImapEngineAccountOperation* op)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (op), FALSE);
	if (op != NULL) {
		gboolean _tmp1_ = FALSE;
		if (self == op) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)) == G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (op, G_TYPE_OBJECT, GObject));
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_imap_engine_account_operation_equal_to (GearyImapEngineAccountOperation* self,
                                              GearyImapEngineAccountOperation* op)
{
	GearyImapEngineAccountOperationClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (self), FALSE);
	_klass_ = GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, op);
	}
	return FALSE;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_engine_account_operation_real_to_logging_state (GearyImapEngineAccountOperation* self)
{
	GearyAccount* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyAccountInformation* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* result;
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_account_get_information (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_account_information_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp4_);
	result = _tmp5_;
	return result;
}

GearyLoggingState*
geary_imap_engine_account_operation_to_logging_state (GearyImapEngineAccountOperation* self)
{
	GearyImapEngineAccountOperationClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (self), NULL);
	_klass_ = GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

static void
geary_imap_engine_account_operation_class_init (GearyImapEngineAccountOperationClass * klass,
                                                gpointer klass_data)
{
	geary_imap_engine_account_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineAccountOperation_private_offset);
	((GearyImapEngineAccountOperationClass *) klass)->equal_to = (gboolean (*) (GearyImapEngineAccountOperation*, GearyImapEngineAccountOperation*)) geary_imap_engine_account_operation_real_equal_to;
	((GearyImapEngineAccountOperationClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyImapEngineAccountOperation*)) geary_imap_engine_account_operation_real_to_logging_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_engine_account_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_engine_account_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_account_operation_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_LOGGING_PARENT_PROPERTY, geary_imap_engine_account_operation_properties[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The account this operation applies to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY, geary_imap_engine_account_operation_properties[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired by after processing when the operation has completed.
	     *
	     * This is fired regardless of if an error was thrown after {@link
	     * execute} is called. It is always fired after either {@link
	     * succeeded} or {@link failed} is fired.
	     *
	     * Implementations should not fire this themselves, the
	     * processor will do it for them.
	     */
	geary_imap_engine_account_operation_signals[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_COMPLETED_SIGNAL] = g_signal_new ("completed", GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired by the processor if the operation completes successfully.
	     *
	     * This is fired only after {@link execute} was called and did
	     * not raise an error.
	     *
	     * Implementations should not fire this themselves, the
	     * processor will do it for them.
	     */
	geary_imap_engine_account_operation_signals[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_SUCCEEDED_SIGNAL] = g_signal_new ("succeeded", GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired by the processor if the operation throws an error.
	     *
	     * This is fired only after {@link execute} was called and
	     * threw an error. The argument is the error that was thrown.
	     *
	     * Implementations should not fire this themselves, the
	     * processor will do it for them.
	     */
	geary_imap_engine_account_operation_signals[GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_FAILED_SIGNAL] = g_signal_new ("failed", GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
}

static void
geary_imap_engine_account_operation_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                                         gpointer iface_data)
{
	geary_imap_engine_account_operation_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_imap_engine_account_operation_to_logging_state;
	iface->get_logging_parent = geary_imap_engine_account_operation_real_get_logging_parent;
}

static void
geary_imap_engine_account_operation_instance_init (GearyImapEngineAccountOperation * self,
                                                   gpointer klass)
{
	self->priv = geary_imap_engine_account_operation_get_instance_private (self);
}

static void
geary_imap_engine_account_operation_finalize (GObject * obj)
{
	GearyImapEngineAccountOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation);
	G_OBJECT_CLASS (geary_imap_engine_account_operation_parent_class)->finalize (obj);
}

/**
 * A unit of work to be executed by {@link GenericAccount}.
 *
 * It is important that account operations are idempotent in that they
 * can be safely re-executed multiple times, and perform the same task
 * each time. This means that in practice instance properties should
 * only be used to store state passed to the operation via its
 * constructor (e.g. a target folder to be updated) and this state
 * should not be modified when the operation is executed (e.g. the
 * target folder should not be changed or set to `null` during or
 * after execution), any state needed to be maintained when executing
 * should be passed as arguments to internal methods (e.g. the list of
 * messages to be checked in the target folder should be passed around
 * as arguments), and the operation should perform any needed sanity
 * checks before proceeding (e.g. check the target folder sill exists
 * before updating it).
 *
 * To queue an operation for execution, pass an instance to {@link
 * GenericAccount.queue_operation} after the account has been
 * opened. It will added to the accounts queue and executed
 * asynchronously when it reaches the front.
 *
 * Execution of the operation is managed by {@link
 * AccountProcessor}. Since the processor will not en-queue duplicate
 * operations, implementations of this class may override the {@link
 * equal_to} method to specify which instances are considered to be
 * duplicates.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_account_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineAccountOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_account_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineAccountOperation), 0, (GInstanceInitFunc) geary_imap_engine_account_operation_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_imap_engine_account_operation_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_engine_account_operation_type_id;
	geary_imap_engine_account_operation_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapEngineAccountOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_imap_engine_account_operation_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyImapEngineAccountOperation_private_offset = g_type_add_instance_private (geary_imap_engine_account_operation_type_id, sizeof (GearyImapEngineAccountOperationPrivate));
	return geary_imap_engine_account_operation_type_id;
}

GType
geary_imap_engine_account_operation_get_type (void)
{
	static gsize geary_imap_engine_account_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_account_operation_type_id__once)) {
		GType geary_imap_engine_account_operation_type_id;
		geary_imap_engine_account_operation_type_id = geary_imap_engine_account_operation_get_type_once ();
		g_once_init_leave (&geary_imap_engine_account_operation_type_id__once, geary_imap_engine_account_operation_type_id);
	}
	return geary_imap_engine_account_operation_type_id__once;
}

static void
_vala_geary_imap_engine_account_operation_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	GearyImapEngineAccountOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		case GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY:
		g_value_set_object (value, geary_imap_engine_account_operation_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_engine_account_operation_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	GearyImapEngineAccountOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_ACCOUNT_PROPERTY:
		geary_imap_engine_account_operation_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_imap_engine_folder_operation_get_instance_private (GearyImapEngineFolderOperation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineFolderOperation_private_offset);
}

GearyFolder*
geary_imap_engine_folder_operation_get_folder (GearyImapEngineFolderOperation* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_FOLDER_OPERATION (self), NULL);
	_tmp0_ = self->priv->_folder;
	result = _tmp0_;
	return result;
}

static void
geary_imap_engine_folder_operation_set_folder (GearyImapEngineFolderOperation* self,
                                               GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_FOLDER_OPERATION (self));
	old_value = geary_imap_engine_folder_operation_get_folder (self);
	if (old_value != value) {
		self->priv->_folder = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_folder_operation_properties[GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY]);
	}
}

/**
     * Constructs a new folder operation.
     *
     * The passed in `folder` and `account` will be the objects the
     * operation will apply to.
     */
GearyImapEngineFolderOperation*
geary_imap_engine_folder_operation_construct (GType object_type,
                                              GearyAccount* account,
                                              GearyFolder* folder)
{
	GearyImapEngineFolderOperation * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (GEARY_IS_FOLDER (folder), NULL);
	self = (GearyImapEngineFolderOperation*) geary_imap_engine_account_operation_construct (object_type, account);
	geary_imap_engine_folder_operation_set_folder (self, folder);
	return self;
}

/**
     * Determines if another operation is equal to this.
     *
     * This method compares both chain's up to {@link
     * AccountOperation.equal_to} and if equal, compares the paths of
     * both operation's folders to determine if `op` is equal to this
     * operation.
     */
static gboolean
geary_imap_engine_folder_operation_real_equal_to (GearyImapEngineAccountOperation* base,
                                                  GearyImapEngineAccountOperation* op)
{
	GearyImapEngineFolderOperation * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation);
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_ACCOUNT_OPERATION (op), FALSE);
	if (GEARY_IMAP_ENGINE_ACCOUNT_OPERATION_CLASS (geary_imap_engine_folder_operation_parent_class)->equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation), op)) {
		GearyFolder* _tmp1_;
		GearyFolderPath* _tmp2_;
		GearyFolderPath* _tmp3_;
		GearyFolder* _tmp4_;
		GearyFolderPath* _tmp5_;
		GearyFolderPath* _tmp6_;
		_tmp1_ = self->priv->_folder;
		_tmp2_ = geary_folder_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (op, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation)->priv->_folder;
		_tmp5_ = geary_folder_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_HASHABLE, GeeHashable), _tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_engine_folder_operation_real_to_logging_state (GearyImapEngineAccountOperation* base)
{
	GearyImapEngineFolderOperation * self;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GearyFolder* _tmp6_;
	GearyFolderPath* _tmp7_;
	GearyFolderPath* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GearyLoggingState* _tmp11_;
	GearyLoggingState* _tmp12_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation);
	_tmp0_ = geary_imap_engine_account_operation_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, GearyImapEngineAccountOperation));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_account_get_information (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_account_information_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_folder;
	_tmp7_ = geary_folder_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_folder_path_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s:%s", _tmp5_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	result = _tmp12_;
	return result;
}

static void
geary_imap_engine_folder_operation_class_init (GearyImapEngineFolderOperationClass * klass,
                                               gpointer klass_data)
{
	geary_imap_engine_folder_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineFolderOperation_private_offset);
	((GearyImapEngineAccountOperationClass *) klass)->equal_to = (gboolean (*) (GearyImapEngineAccountOperation*, GearyImapEngineAccountOperation*)) geary_imap_engine_folder_operation_real_equal_to;
	((GearyImapEngineAccountOperationClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyImapEngineAccountOperation*)) geary_imap_engine_folder_operation_real_to_logging_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_engine_folder_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_engine_folder_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_folder_operation_finalize;
	/** The folder this operation applies to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY, geary_imap_engine_folder_operation_properties[GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY] = g_param_spec_object ("folder", "folder", "folder", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_engine_folder_operation_instance_init (GearyImapEngineFolderOperation * self,
                                                  gpointer klass)
{
	self->priv = geary_imap_engine_folder_operation_get_instance_private (self);
}

static void
geary_imap_engine_folder_operation_finalize (GObject * obj)
{
	GearyImapEngineFolderOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation);
	G_OBJECT_CLASS (geary_imap_engine_folder_operation_parent_class)->finalize (obj);
}

/**
 * An account operation that applies to a specific folder.
 *
 * By default, instances of this class require that another operation
 * applies to the same folder as well as having the same type to be
 * considered equal, for the purpose of not en-queuing duplicate
 * operations.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_folder_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineFolderOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_folder_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineFolderOperation), 0, (GInstanceInitFunc) geary_imap_engine_folder_operation_instance_init, NULL };
	GType geary_imap_engine_folder_operation_type_id;
	geary_imap_engine_folder_operation_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_ACCOUNT_OPERATION, "GearyImapEngineFolderOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyImapEngineFolderOperation_private_offset = g_type_add_instance_private (geary_imap_engine_folder_operation_type_id, sizeof (GearyImapEngineFolderOperationPrivate));
	return geary_imap_engine_folder_operation_type_id;
}

GType
geary_imap_engine_folder_operation_get_type (void)
{
	static gsize geary_imap_engine_folder_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_folder_operation_type_id__once)) {
		GType geary_imap_engine_folder_operation_type_id;
		geary_imap_engine_folder_operation_type_id = geary_imap_engine_folder_operation_get_type_once ();
		g_once_init_leave (&geary_imap_engine_folder_operation_type_id__once, geary_imap_engine_folder_operation_type_id);
	}
	return geary_imap_engine_folder_operation_type_id__once;
}

static void
_vala_geary_imap_engine_folder_operation_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineFolderOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY:
		g_value_set_object (value, geary_imap_engine_folder_operation_get_folder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_engine_folder_operation_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineFolderOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_FOLDER_OPERATION, GearyImapEngineFolderOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_FOLDER_OPERATION_FOLDER_PROPERTY:
		geary_imap_engine_folder_operation_set_folder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

