/* count-badge.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from count-badge.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <string.h>
#include <stdlib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>

#define COUNT_BADGE_FONT_SIZE_MESSAGE_COUNT 8
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COUNT_BADGE_0_PROPERTY,
	COUNT_BADGE_COUNT_PROPERTY,
	COUNT_BADGE_NUM_PROPERTIES
};
static GParamSpec* count_badge_properties[COUNT_BADGE_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CountBadgePrivate {
	gint _count;
	gint min;
};

static gint CountBadge_private_offset;
static gpointer count_badge_parent_class = NULL;

static void count_badge_render_internal (CountBadge* self,
                                  GtkWidget* widget,
                                  cairo_t* ctx,
                                  gint x,
                                  gint y,
                                  gboolean selected,
                                  gint** width,
                                  gint** height);
static gint* _int_dup (gint* self);
static PangoRectangle* _pango_rectangle_dup (PangoRectangle* self);
static void count_badge_finalize (GObject * obj);
static GType count_badge_get_type_once (void);
static void _vala_count_badge_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_count_badge_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
count_badge_get_instance_private (CountBadge* self)
{
	return G_STRUCT_MEMBER_P (self, CountBadge_private_offset);
}

gint
count_badge_get_count (CountBadge* self)
{
	gint result;
	g_return_val_if_fail (IS_COUNT_BADGE (self), 0);
	result = self->priv->_count;
	return result;
}

void
count_badge_set_count (CountBadge* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (IS_COUNT_BADGE (self));
	old_value = count_badge_get_count (self);
	if (old_value != value) {
		self->priv->_count = value;
		g_object_notify_by_pspec ((GObject *) self, count_badge_properties[COUNT_BADGE_COUNT_PROPERTY]);
	}
}

/**
     * Creates a count badge.
     * @param min Minimum count to draw.
     */
CountBadge*
count_badge_construct (GType object_type,
                       gint min)
{
	CountBadge * self = NULL;
	self = (CountBadge*) geary_base_object_construct (object_type);
	self->priv->min = min;
	return self;
}

CountBadge*
count_badge_new (gint min)
{
	return count_badge_construct (TYPE_COUNT_BADGE, min);
}

gint
count_badge_get_width (CountBadge* self,
                       GtkWidget* widget)
{
	gint width = 0;
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint result;
	g_return_val_if_fail (IS_COUNT_BADGE (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), 0);
	width = 0;
	count_badge_render_internal (self, widget, NULL, 0, 0, FALSE, &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	width = *_tmp1_;
	_g_free0 (_tmp1_);
	result = width;
	return result;
}

gint
count_badge_get_height (CountBadge* self,
                        GtkWidget* widget)
{
	gint height = 0;
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint result;
	g_return_val_if_fail (IS_COUNT_BADGE (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), 0);
	height = 0;
	count_badge_render_internal (self, widget, NULL, 0, 0, FALSE, NULL, &_tmp0_);
	_tmp1_ = _tmp0_;
	height = *_tmp1_;
	_g_free0 (_tmp1_);
	result = height;
	return result;
}

void
count_badge_render (CountBadge* self,
                    GtkWidget* widget,
                    cairo_t* ctx,
                    gint x,
                    gint y,
                    gboolean selected)
{
	g_return_if_fail (IS_COUNT_BADGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	count_badge_render_internal (self, widget, ctx, x, y, selected, NULL, NULL);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static PangoRectangle*
_pango_rectangle_dup (PangoRectangle* self)
{
	PangoRectangle* dup;
	dup = g_new0 (PangoRectangle, 1);
	memcpy (dup, self, sizeof (PangoRectangle));
	return dup;
}

static gpointer
__pango_rectangle_dup0 (gpointer self)
{
	return self ? _pango_rectangle_dup (self) : NULL;
}

static void
count_badge_render_internal (CountBadge* self,
                             GtkWidget* widget,
                             cairo_t* ctx,
                             gint x,
                             gint y,
                             gboolean selected,
                             gint** width,
                             gint** height)
{
	gint* _vala_width = NULL;
	gint* _vala_height = NULL;
	gint _tmp0_;
	gchar* mails = NULL;
	gint _tmp5_;
	gchar* _tmp6_;
	PangoLayout* layout_num = NULL;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	const gchar* _tmp9_;
	PangoLayout* _tmp10_;
	PangoRectangle* ink_rect = NULL;
	PangoRectangle* logical_rect = NULL;
	PangoLayout* _tmp11_;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_;
	PangoRectangle* _tmp15_;
	PangoRectangle _tmp16_;
	PangoRectangle* _tmp17_;
	PangoRectangle* _tmp22_;
	gint _tmp23_;
	gint* _tmp24_;
	PangoRectangle* _tmp25_;
	gint* _tmp26_;
	g_return_if_fail (IS_COUNT_BADGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_tmp0_ = self->priv->_count;
	if (_tmp0_ < self->priv->min) {
		gint _tmp1_;
		gint* _tmp2_;
		gint _tmp3_;
		gint* _tmp4_;
		_tmp1_ = 0;
		_tmp2_ = __int_dup0 (&_tmp1_);
		_g_free0 (_vala_width);
		_vala_width = _tmp2_;
		_tmp3_ = 0;
		_tmp4_ = __int_dup0 (&_tmp3_);
		_g_free0 (_vala_height);
		_vala_height = _tmp4_;
		if (width) {
			*width = _vala_width;
		} else {
			_g_free0 (_vala_width);
		}
		if (height) {
			*height = _vala_height;
		} else {
			_g_free0 (_vala_height);
		}
		return;
	}
	_tmp5_ = self->priv->_count;
	_tmp6_ = g_strdup_printf ("<span foreground='white' font='%d' weight='bold'> %d </span>", COUNT_BADGE_FONT_SIZE_MESSAGE_COUNT, _tmp5_);
	mails = _tmp6_;
	_tmp7_ = gtk_widget_create_pango_layout (widget, NULL);
	layout_num = _tmp7_;
	_tmp8_ = layout_num;
	_tmp9_ = mails;
	pango_layout_set_markup (_tmp8_, _tmp9_, -1);
	_tmp10_ = layout_num;
	pango_layout_set_alignment (_tmp10_, PANGO_ALIGN_RIGHT);
	_tmp11_ = layout_num;
	pango_layout_get_pixel_extents (_tmp11_, &_tmp12_, &_tmp13_);
	_g_free0 (ink_rect);
	_tmp14_ = _tmp12_;
	_tmp15_ = __pango_rectangle_dup0 (&_tmp14_);
	ink_rect = _tmp15_;
	_g_free0 (logical_rect);
	_tmp16_ = _tmp13_;
	_tmp17_ = __pango_rectangle_dup0 (&_tmp16_);
	logical_rect = _tmp17_;
	if (ctx != NULL) {
		gdouble bg_width = 0.0;
		PangoRectangle* _tmp18_;
		gdouble bg_height = 0.0;
		PangoRectangle* _tmp19_;
		gdouble radius = 0.0;
		gdouble degrees = 0.0;
		PangoRectangle* _tmp20_;
		PangoLayout* _tmp21_;
		_tmp18_ = logical_rect;
		bg_width = (gdouble) ((*_tmp18_).width + COUNT_BADGE_SPACING);
		_tmp19_ = logical_rect;
		bg_height = (gdouble) (*_tmp19_).height;
		radius = bg_height / 2.0;
		degrees = G_PI / 180.0;
		cairo_new_sub_path (ctx);
		cairo_arc (ctx, (x + bg_width) - radius, y + radius, radius, -90 * degrees, 0 * degrees);
		cairo_arc (ctx, (x + bg_width) - radius, (y + bg_height) - radius, radius, 0 * degrees, 90 * degrees);
		cairo_arc (ctx, x + radius, (y + bg_height) - radius, radius, 90 * degrees, 180 * degrees);
		cairo_arc (ctx, x + radius, y + radius, radius, 180 * degrees, 270 * degrees);
		cairo_close_path (ctx);
		util_gtk_set_source_color_from_string (ctx, COUNT_BADGE_UNREAD_BG_COLOR);
		cairo_fill_preserve (ctx);
		cairo_set_line_width (ctx, 2.0);
		cairo_stroke (ctx);
		_tmp20_ = logical_rect;
		cairo_move_to (ctx, (x + (bg_width / 2)) - ((*_tmp20_).width / 2), (gdouble) y);
		_tmp21_ = layout_num;
		pango_cairo_show_layout (ctx, _tmp21_);
	}
	_tmp22_ = logical_rect;
	_tmp23_ = (*_tmp22_).width + COUNT_BADGE_SPACING;
	_tmp24_ = __int_dup0 (&_tmp23_);
	_g_free0 (_vala_width);
	_vala_width = _tmp24_;
	_tmp25_ = logical_rect;
	_tmp26_ = __int_dup0 (&(*_tmp25_).height);
	_g_free0 (_vala_height);
	_vala_height = _tmp26_;
	_g_free0 (logical_rect);
	_g_free0 (ink_rect);
	_g_object_unref0 (layout_num);
	_g_free0 (mails);
	if (width) {
		*width = _vala_width;
	} else {
		_g_free0 (_vala_width);
	}
	if (height) {
		*height = _vala_height;
	} else {
		_g_free0 (_vala_height);
	}
}

static void
count_badge_class_init (CountBadgeClass * klass,
                        gpointer klass_data)
{
	count_badge_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CountBadge_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_count_badge_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_count_badge_set_property;
	G_OBJECT_CLASS (klass)->finalize = count_badge_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COUNT_BADGE_COUNT_PROPERTY, count_badge_properties[COUNT_BADGE_COUNT_PROPERTY] = g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
count_badge_instance_init (CountBadge * self,
                           gpointer klass)
{
	self->priv = count_badge_get_instance_private (self);
	self->priv->_count = 0;
	self->priv->min = 0;
}

static void
count_badge_finalize (GObject * obj)
{
	CountBadge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COUNT_BADGE, CountBadge);
	G_OBJECT_CLASS (count_badge_parent_class)->finalize (obj);
}

/**
 * Draws the count badge and calculates its dimensions.
 */
static GType
count_badge_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CountBadgeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) count_badge_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CountBadge), 0, (GInstanceInitFunc) count_badge_instance_init, NULL };
	GType count_badge_type_id;
	count_badge_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "CountBadge", &g_define_type_info, 0);
	CountBadge_private_offset = g_type_add_instance_private (count_badge_type_id, sizeof (CountBadgePrivate));
	return count_badge_type_id;
}

GType
count_badge_get_type (void)
{
	static volatile gsize count_badge_type_id__once = 0;
	if (g_once_init_enter (&count_badge_type_id__once)) {
		GType count_badge_type_id;
		count_badge_type_id = count_badge_get_type_once ();
		g_once_init_leave (&count_badge_type_id__once, count_badge_type_id);
	}
	return count_badge_type_id__once;
}

static void
_vala_count_badge_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	CountBadge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COUNT_BADGE, CountBadge);
	switch (property_id) {
		case COUNT_BADGE_COUNT_PROPERTY:
		g_value_set_int (value, count_badge_get_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_count_badge_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	CountBadge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COUNT_BADGE, CountBadge);
	switch (property_id) {
		case COUNT_BADGE_COUNT_PROPERTY:
		count_badge_set_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

