/* components-in-app-notification.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-in-app-notification.vala, do not modify */

/* Copyright 2017 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPONENTS_IN_APP_NOTIFICATION_0_PROPERTY,
	COMPONENTS_IN_APP_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* components_in_app_notification_properties[COMPONENTS_IN_APP_NOTIFICATION_NUM_PROPERTIES];

struct _ComponentsInAppNotificationPrivate {
	GtkLabel* message_label;
	GtkButton* action_button;
	guint duration;
};

static gint ComponentsInAppNotification_private_offset;
static gpointer components_in_app_notification_parent_class = NULL;

static void components_in_app_notification_real_show (GtkWidget* base);
static gboolean ___lambda68_ (ComponentsInAppNotification* self);
static gboolean ____lambda68__gsource_func (gpointer self);
static void _components_in_app_notification_close_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void components_in_app_notification_on_child_revealed (ComponentsInAppNotification* self,
                                                       GObject* src,
                                                       GParamSpec* p);
static void _components_in_app_notification_on_child_revealed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void components_in_app_notification_finalize (GObject * obj);
static GType components_in_app_notification_get_type_once (void);

static inline gpointer
components_in_app_notification_get_instance_private (ComponentsInAppNotification* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInAppNotification_private_offset);
}

/**
     * Creates an in-app notification.
     *
     * @param message The message that should be displayed.
     * @param duration The length of time to show the notification,
     * in seconds.
     */
ComponentsInAppNotification*
components_in_app_notification_construct (GType object_type,
                                          const gchar* message,
                                          guint duration)
{
	ComponentsInAppNotification * self = NULL;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (message != NULL, NULL);
	self = (ComponentsInAppNotification*) g_object_new (object_type, NULL);
	gtk_revealer_set_transition_type (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_revealer_get_type (), GtkRevealer), GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp0_ = self->priv->message_label;
	gtk_label_set_label (_tmp0_, message);
	self->priv->duration = duration;
	return self;
}

ComponentsInAppNotification*
components_in_app_notification_new (const gchar* message,
                                    guint duration)
{
	return components_in_app_notification_construct (COMPONENTS_TYPE_IN_APP_NOTIFICATION, message, duration);
}

/**
     * Sets a button for the notification.
     */
void
components_in_app_notification_set_button (ComponentsInAppNotification* self,
                                           const gchar* label,
                                           const gchar* action_name)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_IN_APP_NOTIFICATION (self));
	g_return_if_fail (label != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = self->priv->action_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp1_ = self->priv->action_button;
	gtk_button_set_label (_tmp1_, label);
	_tmp2_ = self->priv->action_button;
	gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_actionable_get_type (), GtkActionable), action_name);
}

static gboolean
___lambda68_ (ComponentsInAppNotification* self)
{
	gboolean result;
	components_in_app_notification_close (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda68__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda68_ ((ComponentsInAppNotification*) self);
	return result;
}

static void
components_in_app_notification_real_show (GtkWidget* base)
{
	ComponentsInAppNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_IN_APP_NOTIFICATION, ComponentsInAppNotification);
	if (self->priv->duration > ((guint) 0)) {
		GTK_WIDGET_CLASS (components_in_app_notification_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_revealer_get_type (), GtkRevealer), gtk_widget_get_type (), GtkWidget));
		gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_revealer_get_type (), GtkRevealer), TRUE);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, self->priv->duration, ____lambda68__gsource_func, g_object_ref (self), g_object_unref);
	}
}

/**
     * Closes the in-app notification.
     */
void
components_in_app_notification_close (ComponentsInAppNotification* self)
{
	g_return_if_fail (COMPONENTS_IS_IN_APP_NOTIFICATION (self));
	gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_revealer_get_type (), GtkRevealer), FALSE);
}

static void
_components_in_app_notification_close_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	components_in_app_notification_close ((ComponentsInAppNotification*) self);
}

static void
components_in_app_notification_on_child_revealed (ComponentsInAppNotification* self,
                                                  GObject* src,
                                                  GParamSpec* p)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (COMPONENTS_IS_IN_APP_NOTIFICATION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (src, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (p, G_TYPE_PARAM));
	_tmp0_ = gtk_revealer_get_child_revealed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_revealer_get_type (), GtkRevealer));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}

static void
_components_in_app_notification_on_child_revealed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	components_in_app_notification_on_child_revealed ((ComponentsInAppNotification*) self, _sender, pspec);
}

static void
components_in_app_notification_class_init (ComponentsInAppNotificationClass * klass,
                                           gpointer klass_data)
{
	components_in_app_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInAppNotification_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) components_in_app_notification_real_show;
	G_OBJECT_CLASS (klass)->finalize = components_in_app_notification_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-in-app-notification.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "message_label", FALSE, ComponentsInAppNotification_private_offset + G_STRUCT_OFFSET (ComponentsInAppNotificationPrivate, message_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_button", FALSE, ComponentsInAppNotification_private_offset + G_STRUCT_OFFSET (ComponentsInAppNotificationPrivate, action_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "close", G_CALLBACK(_components_in_app_notification_close_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_child_revealed", G_CALLBACK(_components_in_app_notification_on_child_revealed_g_object_notify));
}

static void
components_in_app_notification_instance_init (ComponentsInAppNotification * self,
                                              gpointer klass)
{
	self->priv = components_in_app_notification_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_in_app_notification_finalize (GObject * obj)
{
	ComponentsInAppNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_IN_APP_NOTIFICATION, ComponentsInAppNotification);
	G_OBJECT_CLASS (components_in_app_notification_parent_class)->finalize (obj);
}

/**
 * Represents an in-app notification.
 *
 * Following the GNOME HIG, it should only contain a label and maybe a button.
 * Looks like libadwaita toast, remove this when porting toward GTK4
 */
static GType
components_in_app_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInAppNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_in_app_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInAppNotification), 0, (GInstanceInitFunc) components_in_app_notification_instance_init, NULL };
	GType components_in_app_notification_type_id;
	components_in_app_notification_type_id = g_type_register_static (gtk_revealer_get_type (), "ComponentsInAppNotification", &g_define_type_info, 0);
	ComponentsInAppNotification_private_offset = g_type_add_instance_private (components_in_app_notification_type_id, sizeof (ComponentsInAppNotificationPrivate));
	return components_in_app_notification_type_id;
}

GType
components_in_app_notification_get_type (void)
{
	static volatile gsize components_in_app_notification_type_id__once = 0;
	if (g_once_init_enter (&components_in_app_notification_type_id__once)) {
		GType components_in_app_notification_type_id;
		components_in_app_notification_type_id = components_in_app_notification_get_type_once ();
		g_once_init_leave (&components_in_app_notification_type_id__once, components_in_app_notification_type_id);
	}
	return components_in_app_notification_type_id__once;
}

