/* do not edit automatically generated by mc from M2Batch.  */
/* M2Batch.mod implements a queue for modules pending compilation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Batch_C

#include "GM2Batch.h"
#   include "GM2Debug.h"
#   include "GSymbolTable.h"
#   include "GNameKey.h"
#   include "GM2Printf.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GIndexing.h"
#   include "GLists.h"
#   include "GStorage.h"
#   include "GDynamicStrings.h"
#   include "GM2Pass.h"

typedef struct M2Batch_DoProcedure_p M2Batch_DoProcedure;

typedef struct M2Batch__T1_r M2Batch__T1;

typedef M2Batch__T1 *M2Batch_Module;

struct M2Batch__T1_r {
                       unsigned int SymNo;
                       NameKey_Name Key;
                       DynamicStrings_String DefFile;
                       DynamicStrings_String ModFile;
                     };

static Indexing_Index SeenList;
static Lists_List PendingQueue;

/*
   MakeDefinitionSource - is given a Name, n, which is used to create a Definition
                          module.
                          The Definition Module will be placed onto the
                          compilation pending queue if it has not yet been
                          compiled.
                          If the module has been compiled then no action is
                          taken. The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeDefinitionSource (unsigned int tok, NameKey_Name n);

/*
   MakeImplementationSource - is given a Name, n, which is used to create an
                              implementation module.
                              The implementation Module will be placed onto
                              the compilation pending
                              queue if it has not yet been compiled.
                              If the module has been compiled then no
                              action is taken. The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeImplementationSource (unsigned int tok, NameKey_Name n);

/*
   MakeProgramSource - is given a Name, n, which is used to create a program module.
                       The program module will be placed onto the compilation
                       pending queue if it has not yet been compiled.
                       If the module has been compiled then no action is taken.
                       The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeProgramSource (unsigned int tok, NameKey_Name n);

/*
   GetSource - returns with the symbol Sym of the next module to be compiled.
               If Sym returns with value 0 then no module should be compiled.
*/

extern "C" unsigned int M2Batch_GetSource (void);

/*
   GetModuleNo - returns with symbol number of the nth module read during Pass 1.
*/

extern "C" unsigned int M2Batch_GetModuleNo (unsigned int nth);

/*
   IsModuleKnown - returns TRUE if the Name n matches a module.
*/

extern "C" bool M2Batch_IsModuleKnown (NameKey_Name n);

/*
   AssociateDefinition - associate the source file, filename, with the definition module,
                         Sym.
*/

extern "C" DynamicStrings_String M2Batch_AssociateDefinition (DynamicStrings_String filename, unsigned int Sym);

/*
   GetDefinitionModuleFile - returns the filename associated with the definition module, Sym.
                             It may return a temporary preprocessed file.
*/

extern "C" DynamicStrings_String M2Batch_GetDefinitionModuleFile (unsigned int Sym);

/*
   AssociateModule - associate the source file, filename, with the implementation/program
                     module, Sym.
*/

extern "C" DynamicStrings_String M2Batch_AssociateModule (DynamicStrings_String filename, unsigned int Sym);

/*
   GetModuleFile - returns the filename associated with the implementation/program module, Sym.
                   It may return a temporary preprocessed file.
*/

extern "C" DynamicStrings_String M2Batch_GetModuleFile (unsigned int Sym);

/*
   ForeachSourceModuleDo - for each source file call procedure, p.
*/

extern "C" void M2Batch_ForeachSourceModuleDo (M2Batch_DoProcedure p);

/*
   IsSourceSeen - returns TRUE if the source for the program module or
                  implementation module has been seen.
*/

extern "C" bool M2Batch_IsSourceSeen (unsigned int sym);

/*
   IsModuleSeen - returns TRUE if the source for module, name, has been seen.
*/

extern "C" bool M2Batch_IsModuleSeen (NameKey_Name n);

/*
   LookupModule - looks up a module in the current scope, if a module does not exist
                  then it creates a DefImp module.
*/

extern "C" unsigned int M2Batch_LookupModule (unsigned int tok, NameKey_Name n);

/*
   LookupOuterModule - looks up a module in the order of: current scope, then outer scope, finally if a
                       module does not exist then it creates a DefImp module.
*/

extern "C" unsigned int M2Batch_LookupOuterModule (unsigned int tok, NameKey_Name n);

/*
   Get - returns the module symbol matching name n.
*/

extern "C" unsigned int M2Batch_Get (NameKey_Name n);

/*
   DisplayModules - a debugging routine to textually emit the names of modules in the SeenList.
*/

extern "C" void M2Batch_DisplayModules (void);

/*
   Get - returns the module symbol matching name n.
*/

static void Put (unsigned int Sym, NameKey_Name n);

/*
   Get - returns the module symbol matching name n.
*/

static void Push (unsigned int Sym);

/*
   Get - returns the module symbol matching name n.
*/

static unsigned int Pop (void);


/*
   Get - returns the module symbol matching name n.
*/

static void Put (unsigned int Sym, NameKey_Name n)
{
  M2Batch_Module m;

  Storage_ALLOCATE ((void **) &m, sizeof (M2Batch__T1));
  Indexing_IncludeIndiceIntoIndex (SeenList, reinterpret_cast <void *> (m));
  m->SymNo = Sym;
  m->Key = n;
  m->DefFile = static_cast<DynamicStrings_String> (NULL);
  m->ModFile = static_cast<DynamicStrings_String> (NULL);
}


/*
   Get - returns the module symbol matching name n.
*/

static void Push (unsigned int Sym)
{
  Lists_IncludeItemIntoList (PendingQueue, Sym);
}


/*
   Get - returns the module symbol matching name n.
*/

static unsigned int Pop (void)
{
  unsigned int n;
  unsigned int Sym;

  n = Lists_NoOfItemsInList (PendingQueue);
  if (n == 0)
    {
      return SymbolTable_NulSym;
    }
  else
    {
      Sym = static_cast<unsigned int> (Lists_GetItemFromList (PendingQueue, n));
      Lists_RemoveItemFromList (PendingQueue, Sym);
      return Sym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeDefinitionSource - is given a Name, n, which is used to create a Definition
                          module.
                          The Definition Module will be placed onto the
                          compilation pending queue if it has not yet been
                          compiled.
                          If the module has been compiled then no action is
                          taken. The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeDefinitionSource (unsigned int tok, NameKey_Name n)
{
  unsigned int Sym;

  Sym = M2Batch_Get (n);
  if (Sym == SymbolTable_NulSym)
    {
      M2Debug_Assert ((((! (M2Pass_IsPass1 ())) && (! (M2Pass_IsPass2 ()))) && (! (M2Pass_IsPass3 ()))) && (! (M2Pass_IsPassC ())));
      /* Neither been compiled or on the Pending Queue  */
      Sym = SymbolTable_MakeDefImp (tok, n);
      Put (Sym, n);
      Push (Sym);
    }
  else
    {
      SymbolTable_PutDeclared (tok, Sym);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeImplementationSource - is given a Name, n, which is used to create an
                              implementation module.
                              The implementation Module will be placed onto
                              the compilation pending
                              queue if it has not yet been compiled.
                              If the module has been compiled then no
                              action is taken. The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeImplementationSource (unsigned int tok, NameKey_Name n)
{
  unsigned int Sym;

  Sym = M2Batch_Get (n);
  if (Sym == SymbolTable_NulSym)
    {
      M2Debug_Assert ((((! (M2Pass_IsPass1 ())) && (! (M2Pass_IsPass2 ()))) && (! (M2Pass_IsPass3 ()))) && (! (M2Pass_IsPassC ())));
      /* Neither been compiled or on the Pending Queue  */
      Sym = SymbolTable_MakeDefImp (tok, n);
      Put (Sym, n);
      Push (Sym);
    }
  else
    {
      SymbolTable_PutDeclared (tok, Sym);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeProgramSource - is given a Name, n, which is used to create a program module.
                       The program module will be placed onto the compilation
                       pending queue if it has not yet been compiled.
                       If the module has been compiled then no action is taken.
                       The Module Sym is returned.
*/

extern "C" unsigned int M2Batch_MakeProgramSource (unsigned int tok, NameKey_Name n)
{
  unsigned int Sym;

  Sym = M2Batch_Get (n);
  if (Sym == SymbolTable_NulSym)
    {
      M2Debug_Assert ((((! (M2Pass_IsPass1 ())) && (! (M2Pass_IsPass2 ()))) && (! (M2Pass_IsPass3 ()))) && (! (M2Pass_IsPassC ())));
      /* Neither been compiled or on the Pending Queue  */
      Sym = SymbolTable_MakeModule (tok, n);
      Put (Sym, n);
      Push (Sym);
    }
  else
    {
      SymbolTable_PutDeclared (tok, Sym);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSource - returns with the symbol Sym of the next module to be compiled.
               If Sym returns with value 0 then no module should be compiled.
*/

extern "C" unsigned int M2Batch_GetSource (void)
{
  return Pop ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModuleNo - returns with symbol number of the nth module read during Pass 1.
*/

extern "C" unsigned int M2Batch_GetModuleNo (unsigned int nth)
{
  M2Batch_Module m;

  M2Debug_Assert (nth != 0);
  if (Indexing_InBounds (SeenList, nth))
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, nth));
      return m->SymNo;
    }
  else
    {
      return SymbolTable_NulSym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsModuleKnown - returns TRUE if the Name n matches a module.
*/

extern "C" bool M2Batch_IsModuleKnown (NameKey_Name n)
{
  return (M2Batch_Get (n)) != SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssociateDefinition - associate the source file, filename, with the definition module,
                         Sym.
*/

extern "C" DynamicStrings_String M2Batch_AssociateDefinition (DynamicStrings_String filename, unsigned int Sym)
{
  unsigned int no;
  unsigned int i;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->SymNo == Sym)
        {
          m->DefFile = filename;
          return filename;
        }
      else
        {
          i += 1;
        }
    }
  M2Error_InternalError ((const char *) "failed to find module sym", 25);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Batch.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetDefinitionModuleFile - returns the filename associated with the definition module, Sym.
                             It may return a temporary preprocessed file.
*/

extern "C" DynamicStrings_String M2Batch_GetDefinitionModuleFile (unsigned int Sym)
{
  unsigned int no;
  unsigned int i;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->SymNo == Sym)
        {
          return m->DefFile;
        }
      else
        {
          i += 1;
        }
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssociateModule - associate the source file, filename, with the implementation/program
                     module, Sym.
*/

extern "C" DynamicStrings_String M2Batch_AssociateModule (DynamicStrings_String filename, unsigned int Sym)
{
  unsigned int no;
  unsigned int i;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->SymNo == Sym)
        {
          m->ModFile = filename;
          return filename;
        }
      else
        {
          i += 1;
        }
    }
  M2Error_InternalError ((const char *) "failed to find module sym", 25);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Batch.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetModuleFile - returns the filename associated with the implementation/program module, Sym.
                   It may return a temporary preprocessed file.
*/

extern "C" DynamicStrings_String M2Batch_GetModuleFile (unsigned int Sym)
{
  unsigned int no;
  unsigned int i;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->SymNo == Sym)
        {
          return m->ModFile;
        }
      else
        {
          i += 1;
        }
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ForeachSourceModuleDo - for each source file call procedure, p.
*/

extern "C" void M2Batch_ForeachSourceModuleDo (M2Batch_DoProcedure p)
{
  unsigned int i;
  unsigned int no;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->ModFile != NULL)
        {
          (*p.proc) (m->SymNo);
        }
      i += 1;
    }
}


/*
   IsSourceSeen - returns TRUE if the source for the program module or
                  implementation module has been seen.
*/

extern "C" bool M2Batch_IsSourceSeen (unsigned int sym)
{
  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  return (M2Batch_GetModuleFile (sym)) != NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsModuleSeen - returns TRUE if the source for module, name, has been seen.
*/

extern "C" bool M2Batch_IsModuleSeen (NameKey_Name n)
{
  return (M2Batch_Get (n)) != SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LookupModule - looks up a module in the current scope, if a module does not exist
                  then it creates a DefImp module.
*/

extern "C" unsigned int M2Batch_LookupModule (unsigned int tok, NameKey_Name n)
{
  unsigned int sym;

  sym = SymbolTable_GetSym (n);
  if (sym == SymbolTable_NulSym)
    {
      return M2Batch_MakeDefinitionSource (tok, n);
    }
  else if ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)))
    {
      /* avoid dangling else.  */
      return sym;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Batch_MakeDefinitionSource (tok, n);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LookupOuterModule - looks up a module in the order of: current scope, then outer scope, finally if a
                       module does not exist then it creates a DefImp module.
*/

extern "C" unsigned int M2Batch_LookupOuterModule (unsigned int tok, NameKey_Name n)
{
  unsigned int outer;
  unsigned int sym;

  sym = SymbolTable_GetSym (n);
  if (sym == SymbolTable_NulSym)
    {
      outer = SymbolTable_GetScope (SymbolTable_GetCurrentScope ());
      if (outer != SymbolTable_NulSym)
        {
          sym = SymbolTable_GetLocalSym (outer, n);
        }
      if (sym == SymbolTable_NulSym)
        {
          /* not a local module, so it must be refering to a definition module.  */
          sym = M2Batch_MakeDefinitionSource (tok, n);
        }
    }
  if ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)))
    {
      return sym;
    }
  else
    {
      return M2Batch_MakeDefinitionSource (tok, n);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Get - returns the module symbol matching name n.
*/

extern "C" unsigned int M2Batch_Get (NameKey_Name n)
{
  unsigned int i;
  unsigned int no;
  M2Batch_Module m;

  i = 1;
  no = Indexing_HighIndice (SeenList);
  while (i <= no)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      if (m->Key == n)
        {
          return m->SymNo;
        }
      else
        {
          i += 1;
        }
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisplayModules - a debugging routine to textually emit the names of modules in the SeenList.
*/

extern "C" void M2Batch_DisplayModules (void)
{
  M2Batch_Module m;
  unsigned int n;
  unsigned int i;

  i = 1;
  n = Indexing_HighIndice (SeenList);
  while (i <= n)
    {
      m = static_cast<M2Batch_Module> (Indexing_GetIndice (SeenList, i));
      M2Printf_printf2 ((const char *) "Module %a %d\\n", 14, (const unsigned char *) &m->Key, (sizeof (m->Key)-1), (const unsigned char *) &i, (sizeof (i)-1));
      i += 1;
    }
}

extern "C" void _M2_M2Batch_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Lists_InitList (&PendingQueue);
  SeenList = Indexing_InitIndex (1);
}

extern "C" void _M2_M2Batch_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
