/* do not edit automatically generated by mc from M2ALU.  */
/* M2ALU.mod gcc implementation of the M2ALU module.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2ALU_C

#include "GM2ALU.h"
#   include "GASCII.h"
#   include "GSYSTEM.h"
#   include "GNameKey.h"
#   include "GM2Error.h"
#   include "GM2Debug.h"
#   include "GStorage.h"
#   include "GStringConvert.h"
#   include "GM2GCCDeclare.h"
#   include "GM2GenGCC.h"
#   include "GM2Bitset.h"
#   include "GSymbolConversion.h"
#   include "GM2Printf.h"
#   include "GM2Base.h"
#   include "GDynamicStrings.h"
#   include "GM2LexBuf.h"
#   include "GM2MetaError.h"
#   include "GSymbolTable.h"
#   include "Ggcctypes.h"
#   include "Gm2linemap.h"
#   include "Gm2expr.h"
#   include "Gm2decl.h"
#   include "Gm2misc.h"
#   include "Gm2type.h"
#   include "Gm2convert.h"
#   include "Gm2block.h"

#   define Debugging false
#   define DebugGarbage true
typedef struct M2ALU_rList_r M2ALU_rList;

typedef M2ALU_rList *M2ALU_listOfRange;

typedef struct M2ALU_fList_r M2ALU_fList;

typedef M2ALU_fList *M2ALU_listOfFields;

typedef struct M2ALU_eList_r M2ALU_eList;

typedef M2ALU_eList *M2ALU_listOfElements;

typedef struct M2ALU_cell_r M2ALU_cell;

typedef struct M2ALU_DoSetProcedure_p M2ALU_DoSetProcedure;

typedef enum {M2ALU_none, M2ALU_integer, M2ALU_real, M2ALU_complex, M2ALU_set, M2ALU_constructor, M2ALU_array, M2ALU_record} M2ALU_cellType;

typedef M2ALU_cell *M2ALU_PtrToValue__opaque;

struct M2ALU_rList_r {
                       unsigned int low;
                       unsigned int high;
                       M2ALU_listOfRange next;
                     };

struct M2ALU_fList_r {
                       unsigned int field;
                       M2ALU_listOfFields next;
                     };

struct M2ALU_eList_r {
                       unsigned int element;
                       unsigned int by;
                       M2ALU_listOfElements next;
                     };

struct M2ALU_cell_r {
                      location_t location;
                      bool areAllConstants;
                      bool solved;
                      unsigned int constructorType;
                      M2ALU_PtrToValue__opaque next;
                      tree numberValue;
                      M2ALU_cellType type;  /* case tag */
                      union {
                              M2ALU_listOfRange setValue;
                              M2ALU_listOfFields fieldValues;
                              M2ALU_listOfElements arrayValues;
                            };
                    };

typedef M2ALU_listOfRange (*M2ALU_DoSetProcedure_t) (unsigned int, M2ALU_listOfRange, M2ALU_listOfRange);
struct M2ALU_DoSetProcedure_p { M2ALU_DoSetProcedure_t proc; };

static M2ALU_listOfElements ElementFreeList;
static M2ALU_listOfFields FieldFreeList;
static M2ALU_listOfRange RangeFreeList;
static M2ALU_PtrToValue__opaque FreeList;
static M2ALU_PtrToValue__opaque TopOfStack;
static tree EnumerationValue;
static unsigned int EnumerationField;
static unsigned int CurrentTokenNo;

/*
   InitValue - initializes and returns a memory cell.
*/

extern "C" M2ALU_PtrToValue M2ALU_InitValue (void);

/*
   IsValueTypeNone - returns TRUE if the value on the top stack has no value.
*/

extern "C" bool M2ALU_IsValueTypeNone (void);

/*
   IsValueTypeInteger - returns TRUE if the value on the top stack is an integer.
*/

extern "C" bool M2ALU_IsValueTypeInteger (void);

/*
   IsValueTypeReal - returns TRUE if the value on the top stack is a real.
*/

extern "C" bool M2ALU_IsValueTypeReal (void);

/*
   IsValueTypeComplex - returns TRUE if the value on the top stack is a complex.
*/

extern "C" bool M2ALU_IsValueTypeComplex (void);

/*
   IsValueTypeSet - returns TRUE if the value on the top stack is a set.
*/

extern "C" bool M2ALU_IsValueTypeSet (void);

/*
   IsValueTypeConstructor - returns TRUE if the value on the top
                            stack is a constructor.
*/

extern "C" bool M2ALU_IsValueTypeConstructor (void);

/*
   IsValueTypeArray - returns TRUE if the value on the top stack is
                      an array.
*/

extern "C" bool M2ALU_IsValueTypeArray (void);

/*
   IsValueTypeRecord - returns TRUE if the value on the top stack is
                       a record.
*/

extern "C" bool M2ALU_IsValueTypeRecord (void);

/*
   GetSetValueType - returns the set type on top of the ALU stack.
*/

extern "C" unsigned int M2ALU_GetSetValueType (void);

/*
   PushIntegerTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushIntegerTree (tree t);

/*
   PopIntegerTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopIntegerTree (void);

/*
   PushRealTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushRealTree (tree t);

/*
   PopRealTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopRealTree (void);

/*
   PushComplexTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushComplexTree (tree t);

/*
   PopComplexTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopComplexTree (void);

/*
   PushSetTree - pushes a gcc tree onto the ALU stack.
                 The tree, t, is expected to contain a
                 word value. It is converted into a set
                 type (sym). Bit 0 maps onto MIN(sym).
*/

extern "C" void M2ALU_PushSetTree (unsigned int tokenno, tree t, unsigned int sym);

/*
   PopSetTree - pops a gcc tree from the ALU stack.
*/

extern "C" tree M2ALU_PopSetTree (unsigned int tokenno);

/*
   PopConstructorTree - returns a tree containing the compound literal.
*/

extern "C" tree M2ALU_PopConstructorTree (unsigned int tokenno);

/*
   PushFrom - pushes a copy of the contents of, v, onto stack.
*/

extern "C" void M2ALU_PushFrom (M2ALU_PtrToValue v);

/*
   PopInto - pops the top element from the stack and places it into, v.
*/

extern "C" void M2ALU_PopInto (M2ALU_PtrToValue v);

/*
   PushCard - pushes a cardinal onto the stack.
*/

extern "C" void M2ALU_PushCard (unsigned int c);

/*
   PushInt - pushes an integer onto the stack.
*/

extern "C" void M2ALU_PushInt (int i);

/*
   PushChar - pushes a char onto the stack.
*/

extern "C" void M2ALU_PushChar (char c);

/*
   PopChar - pops a char from the stack.
*/

extern "C" char M2ALU_PopChar (unsigned int tokenno);

/*
   PushString - pushes the numerical value of the string onto the stack.
*/

extern "C" void M2ALU_PushString (unsigned int tokenno, NameKey_Name s, bool issueError);

/*
   CoerseLongRealToCard - performs a coersion between a REAL to a CARDINAL
*/

extern "C" void M2ALU_CoerseLongRealToCard (void);

/*
   ConvertRealToInt - converts a REAL into an INTEGER
*/

extern "C" void M2ALU_ConvertRealToInt (void);

/*
   ConvertToInt - converts the value into an INTEGER. This should be used
                  if we are computing the number of elements in a char set to
                  avoid an overflow.
*/

extern "C" void M2ALU_ConvertToInt (void);

/*
   ConvertToType - converts the top of stack to type, t.
*/

extern "C" void M2ALU_ConvertToType (unsigned int t);

/*
   IsSolved - returns true if the memory cell indicated by v
              has a known value.
*/

extern "C" bool M2ALU_IsSolved (M2ALU_PtrToValue v);

/*
   PutConstructorSolved - records that this constructor is solved.
*/

extern "C" void M2ALU_PutConstructorSolved (unsigned int sym);

/*
   EvaluateValue - attempts to evaluate the symbol, sym, value.
*/

extern "C" void M2ALU_EvaluateValue (unsigned int sym);

/*
   TryEvaluateValue - attempts to evaluate the symbol, sym, value.
*/

extern "C" void M2ALU_TryEvaluateValue (unsigned int sym);
extern "C" void M2ALU_Addn (void);

/*
   Sub - subtracts the top two elements on the stack.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |                   <- Ptr
         |------------|    +------------+
         | Op2        |    | Op2 - Op1  |
         |------------|    |------------|
*/

extern "C" void M2ALU_Sub (void);
extern "C" void M2ALU_Multn (void);

/*
   DivFloor - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_DivFloor (void);

/*
   ModFloor - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_ModFloor (void);

/*
   DivTrunc - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_DivTrunc (void);

/*
   ModTrunc - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_ModTrunc (void);

/*
   Equ - returns true if the top two elements on the stack
         are identical.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 = Op1 )
*/

extern "C" bool M2ALU_Equ (unsigned int tokenno);

/*
   NotEqu - returns true if the top two elements on the stack
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 # Op1 )
*/

extern "C" bool M2ALU_NotEqu (unsigned int tokenno);

/*
   Less - returns true if Op2 < Op1

          The Stack:

          Entry             Exit

   Ptr ->
          +------------+
          | Op1        |
          |------------|
          | Op2        |
          |------------|    Empty

          RETURN( Op2 < Op1 )
*/

extern "C" bool M2ALU_Less (unsigned int tokenno);

/*
   Gre - returns true if Op2 > Op1

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 > Op1 )
*/

extern "C" bool M2ALU_Gre (unsigned int tokenno);

/*
   LessEqu - returns true if Op2<Op1

             The Stack:

             Entry             Exit

      Ptr ->
             +------------+
             | Op1        |
             |------------|
             | Op2        |
             |------------|    Empty

             RETURN( Op2 <= Op1 )
*/

extern "C" bool M2ALU_LessEqu (unsigned int tokenno);

/*
   GreEqu - returns true if Op2 >= Op1
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 >= Op1 )
*/

extern "C" bool M2ALU_GreEqu (unsigned int tokenno);

/*
   IsNulSet - returns TRUE if the top element is the nul set constant, {}.
*/

extern "C" bool M2ALU_IsNulSet (void);

/*
   IsGenericNulSet - returns TRUE if the top element is the generic nul set constant, {}.
*/

extern "C" bool M2ALU_IsGenericNulSet (void);

/*
   PushNulSet - pushes an empty set {} onto the ALU stack. The subrange type used
                to construct the set is defined by, constructorType.
                If this is NulSym then
                the set is generic and compatible with all sets.

                The Stack:

                Entry             Exit

                                                 <- Ptr
                                  +------------+
                                  | {}         |
                Ptr ->            |------------|

*/

extern "C" void M2ALU_PushNulSet (unsigned int settype);

/*
   AddBitRange - adds the range op1..op2 to the underlying set.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Set        |      | Set        |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddBitRange (unsigned int tokenno, unsigned int op1, unsigned int op2);

/*
   AddBit - adds the bit op1 to the underlying set. INCL(Set, op1)

            Ptr ->
                                                      <- Ptr
                   +------------+      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

extern "C" void M2ALU_AddBit (unsigned int tokenno, unsigned int op1);

/*
   SubBit - removes a bit op1 from the underlying set. EXCL(Set, Op1)

            Ptr ->
                                                      <- Ptr
                   +------------+      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

extern "C" void M2ALU_SubBit (unsigned int tokenno, unsigned int op1);

/*
   SetIn - returns true if Op2 IN Op1

           The Stack:

           Entry             Exit

    Ptr ->
           +------------+
           | Set        |
           |------------|    Empty

           RETURN( Op1 IN Set )
*/

extern "C" bool M2ALU_SetIn (unsigned int tokenno, unsigned int Op1);

/*
   SetOr -  performs an inclusive OR of the top two elements on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Set1       |                   <- Ptr
            |------------|    +------------+
            | Set2       |    | Set1 + Set2|
            |------------|    |------------|

*/

extern "C" void M2ALU_SetOr (unsigned int tokenno);

/*
   SetAnd - performs a set AND the top two elements on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |                   <- Ptr
            |------------|    +------------+
            | Op2        |    | Op2 * Op1  |
            |------------|    |------------|
*/

extern "C" void M2ALU_SetAnd (unsigned int tokenno);

/*
   SetDifference - performs a set difference of the top two elements on the stack.
                   For each member in the set
                      if member in Op2 and not member in Op1

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +------------+
                   | Op1        |                   <- Ptr
                   |------------|    +-------------------+
                   | Op2        |    | Op2 and (not Op1) |
                   |------------|    |-------------------|
*/

extern "C" void M2ALU_SetDifference (unsigned int tokenno);

/*
   SetSymmetricDifference - performs a set difference of the top two elements on the stack.

                            The Stack:

                            Entry             Exit

                     Ptr ->
                            +------------+
                            | Op1        |                    <- Ptr
                            |------------|    +-------------+
                            | Op2        |    | Op2 xor Op1 |
                            |------------|    |-------------|
*/

extern "C" void M2ALU_SetSymmetricDifference (unsigned int tokenno);

/*
   SetNegate - negates the top set on the stack.

               Ptr ->                                               <- Ptr
                      +-----------+                  +------------+
                      | Set       |                  | Set        |
                      |-----------|                  |------------|
*/

extern "C" void M2ALU_SetNegate (unsigned int tokenno);

/*
   SetShift - if op1 is positive
              then
                 result := op2 << op1
              else
                 result := op2 >> op1
              fi


              The Stack:

                     Entry             Exit

              Ptr ->
                     +------------+
                     | Op1        |                   <- Ptr
                     |------------|    +------------+
                     | Op2        |    | result     |
                     |------------|    |------------|

*/

extern "C" void M2ALU_SetShift (unsigned int tokenno);

/*
   SetRotate - if op1 is positive
               then
                  result := ROTATERIGHT(op2, op1)
               else
                  result := ROTATELEFT(op2, op1)
               fi


               The Stack:

                      Entry             Exit

               Ptr ->
                      +------------+
                      | Op1        |                   <- Ptr
                      |------------|    +------------+
                      | Op2        |    | result     |
                      |------------|    |------------|
*/

extern "C" void M2ALU_SetRotate (unsigned int tokenno);

/*
   GetValue - returns and pops the value from the top of stack.
*/

extern "C" M2ALU_PtrToValue M2ALU_GetValue (unsigned int tokenno);

/*
   GetRange - returns TRUE if range number, n, exists in the value, v.
              A non empty set is defined by having 1..N ranges
*/

extern "C" bool M2ALU_GetRange (M2ALU_PtrToValue v, unsigned int n, unsigned int *low, unsigned int *high);

/*
   ConstructSetConstant - builds a struct of integers which represents the
                          set const as defined by, v.
*/

extern "C" tree M2ALU_ConstructSetConstant (unsigned int tokenno, M2ALU_PtrToValue v);

/*
   BuildRange - returns a integer sized constant which represents the
                value  {e1..e2}.
*/

extern "C" tree M2ALU_BuildRange (unsigned int tokenno, tree e1, tree e2);

/*
   IsConstructorDependants - return TRUE if all q(dependants) of,
                             sym, return TRUE.
*/

extern "C" bool M2ALU_IsConstructorDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkConstructorDependants - walk the constructor, sym, calling
                               p for each dependant.
*/

extern "C" void M2ALU_WalkConstructorDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsValueAndTreeKnown - returns TRUE if the value is known and the gcc tree
                         is defined.

                         The Stack:

                                Entry             Exit

                         Ptr ->
                                +------------+
                                | Op1        |                   <- Ptr
                                |------------|    +------------+
*/

extern "C" bool M2ALU_IsValueAndTreeKnown (void);

/*
   CheckOrResetOverflow - tests to see whether the tree, t, has caused
                          an overflow error and if so it generates an
                          error message.
*/

extern "C" void M2ALU_CheckOrResetOverflow (unsigned int tokenno, tree t, bool check);

/*
   AddElements - adds the elements, el BY, n, to the array constant.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Array      |      | Array      |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddElements (unsigned int tokenno, unsigned int el, unsigned int n);

/*
   AddField - adds the field op1 to the underlying constructor.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | const      |      | const      |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddField (unsigned int tokenno, unsigned int op1);

/*
   PushEmptyConstructor - pushes an empty constructor {} onto the ALU stack.
                          This is expected to be filled in by subsequent
                          calls to AddElements, AddRange or AddField.

                          The Stack:

                          Entry             Exit

                                                       <- Ptr
                                        +------------+
                                        | {}         |
                   Ptr ->               |------------|

*/

extern "C" void M2ALU_PushEmptyConstructor (unsigned int constype);

/*
   PushEmptyArray - pushes an empty array {} onto the ALU stack.
                    This is expected to be filled in by subsequent
                    calls to AddElements.

                    The Stack:

                    Entry             Exit

                                                     <- Ptr
                                      +------------+
                                      | {}         |
             Ptr ->                   |------------|

*/

extern "C" void M2ALU_PushEmptyArray (unsigned int arraytype);

/*
   PushEmptyRecord - pushes an empty record {} onto the ALU stack.
                     This is expected to be filled in by subsequent
                     calls to AddField.

                     The Stack:

                     Entry             Exit

                                                      <- Ptr
                                       +------------+
                                       | {}         |
              Ptr ->                   |------------|

*/

extern "C" void M2ALU_PushEmptyRecord (unsigned int recordtype);

/*
   ChangeToConstructor - change the top of stack value to a constructor, type.
                         (Constructor, Set, Array or Record).
*/

extern "C" void M2ALU_ChangeToConstructor (unsigned int tokenno, unsigned int constype);

/*
   IsValueConst - returns true if the memory cell indicated by v
                  is only defined by constants.  For example
                  no variables are used in the constructor.
*/

extern "C" bool M2ALU_IsValueConst (M2ALU_PtrToValue v);

/*
   PushTypeOfTree - pushes tree, gcc, to the stack and records the
                    front end type.
*/

extern "C" void M2ALU_PushTypeOfTree (unsigned int sym, tree gcc);

/*
   New - allocate a PtrToValue. Firstly check the FreeList, if empty call upon New.
*/

static M2ALU_PtrToValue__opaque New (void);

/*
   InitRecord - initialize the non variant fields of, v.  Return v.
*/

static M2ALU_PtrToValue__opaque InitRecord (M2ALU_PtrToValue__opaque v);

/*
   NewRange - assigns, v, to a new area of memory.
*/

static void NewRange (M2ALU_listOfRange *v);

/*
   DisposeRange - adds the list, v, to the free list.
*/

static void DisposeRange (M2ALU_listOfRange *v);

/*
   IsOnFieldFreeList - returns TRUE if, r, is on the FieldFreeList.
*/

static bool IsOnFieldFreeList (M2ALU_listOfFields r);

/*
   IsOnElementFreeList - returns TRUE if, r, is on the ElementFreeList.
*/

static bool IsOnElementFreeList (M2ALU_listOfElements r);

/*
   DisposeFields - adds the list, v, to the free list.
*/

static void DisposeFields (M2ALU_listOfFields *v);

/*
   NewField - adds the list, v, to the free list.
*/

static void NewField (M2ALU_listOfFields *v);

/*
   NewElement - returns a new element record.
*/

static void NewElement (M2ALU_listOfElements *e);

/*
   DisposeElements - returns the list, e, to the free list.
*/

static void DisposeElements (M2ALU_listOfElements *e);

/*
   CheckNotAlreadyOnFreeList - checks to see whether, v, is already on the free list
                               and aborts if this is the case.
*/

static void CheckNotAlreadyOnFreeList (M2ALU_PtrToValue__opaque v);

/*
   CheckNotOnStack - checks to see whether, v, is already on the stack
                     and aborts if this is the case.
*/

static void CheckNotOnStack (M2ALU_PtrToValue__opaque v);

/*
   Dispose - place, v, onto the FreeList.
*/

static void Dispose (M2ALU_PtrToValue__opaque v);

/*
   AddRange - returns a ListOfRange which is prepended to the front of the current list.
*/

static M2ALU_listOfRange AddRange (M2ALU_listOfRange head, unsigned int l, unsigned int h);

/*
   DupRange - duplicates and returns the list, t.
*/

static M2ALU_listOfRange DupRange (M2ALU_listOfRange r);

/*
   Pop - pops and returns top element from the stack.
*/

static M2ALU_PtrToValue__opaque Pop (void);

/*
   Push - pushes the value onto the stack.
*/

static void Push (M2ALU_PtrToValue__opaque v);

/*
   Reduce - remove the top element of the stack.
*/

static void Reduce (void);

/*
   PrintValue - debugging procedure to display the value on the top of the stack.
*/

static void PrintValue (void);

/*
   DupFields - duplicates the field list in order.
*/

static M2ALU_listOfFields DupFields (M2ALU_listOfFields f);

/*
   DupElements - duplicates the array list in order.
*/

static M2ALU_listOfElements DupElements (M2ALU_listOfElements f);

/*
   IsReal - returns TRUE if a is a REAL number.
*/

static bool IsReal (DynamicStrings_String a);

/*
   IsSolvedGCC - returns TRUE if the value, sym, is solved.
                 If TRUE then it also ensures this symbol is
                 entered into the double book keeping table
                 for GM2 <-> GCC.
*/

static bool IsSolvedGCC (unsigned int sym);

/*
   ConvertIntToReal - converts a INTEGER into a LONGREAL
*/

static void ConvertIntToReal (void);

/*
   EitherReal - returns TRUE if either, Op1, or, Op2, are Real.
*/

static bool EitherReal (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   EitherComplex - returns TRUE if either, Op1, or, Op2, are Real.
*/

static bool EitherComplex (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   RealAdd - adds two numbers. One of which is a Real.
*/

static void RealAdd (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   ComplexAdd - adds two complex numbers.
*/

static void ComplexAdd (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   RealSub - subtracts two numbers. One of which is a Real.
*/

static void RealSub (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   ComplexSub - subtracts two complex numbers.
*/

static void ComplexSub (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   RealMult - multiplies two numbers. One of which is a Real.
*/

static void RealMult (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   ComplexMult - multiplies two complex numbers.
*/

static void ComplexMult (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   RealDiv - divides two numbers. One of which is a Real.
*/

static void RealDiv (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   ComplexDiv - divides two complex numbers.
*/

static void ComplexDiv (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2);

/*
   AreSetsEqual - returns TRUE if sets, op1, and, op2, contain the same
                  members.
*/

static bool AreSetsEqual (unsigned int tokenno, M2ALU_PtrToValue__opaque op1, M2ALU_PtrToValue__opaque op2);

/*
   IsSubset - returns TRUE if the set as defined by, s1, is a subset of set, s2.
*/

static bool IsSubset (unsigned int tokenno, M2ALU_PtrToValue__opaque s1, M2ALU_PtrToValue__opaque s2);

/*
   IsSuperset - returns TRUE if the set as defined by, s1, is a superset of set, s2.
*/

static bool IsSuperset (unsigned int tokenno, M2ALU_PtrToValue__opaque s1, M2ALU_PtrToValue__opaque s2);

/*
   cellTypeString - returns a string corresponding to, s.
*/

static DynamicStrings_String cellTypeString (M2ALU_cellType s);

/*
   ToSetValue - converts a list of fields into a list of ranges.
                In effect it turns a generic constructor into
                a set type.
*/

static M2ALU_listOfRange ToSetValue (M2ALU_listOfFields f);

/*
   ToArrayValue - converts a list of fields into an array initialiser.
                  In effect it turns a generic constructor into
                  an array type.
*/

static M2ALU_listOfElements ToArrayValue (unsigned int tok, M2ALU_listOfFields f);

/*
   CoerseTo - attempts to coerses a cellType, v, into, type, t.
              Normally this will be a generic constructors converting
              into set or array.
*/

static M2ALU_PtrToValue__opaque CoerseTo (unsigned int tokenno, M2ALU_cellType t, M2ALU_PtrToValue__opaque v);

/*
   AddElementToEnd - appends, e, to the end of list, v.
*/

static void AddElementToEnd (M2ALU_PtrToValue__opaque v, M2ALU_listOfElements e);

/*
   AddFieldToEnd - appends, f, to the end of list, v.
*/

static void AddFieldToEnd (M2ALU_PtrToValue__opaque v, M2ALU_listOfFields f);

/*
   ElementsSolved - returns TRUE if all ranges in the set have been solved.
*/

static bool ElementsSolved (unsigned int tokenno, M2ALU_listOfRange r);

/*
   ArrayElementsSolved - returns TRUE if all ranges in the set have been solved.
*/

static bool ArrayElementsSolved (M2ALU_listOfElements e);

/*
   EvalFieldValues - returns TRUE if all fields in the record have been solved.
*/

static bool EvalFieldValues (M2ALU_listOfFields e);

/*
   Swap - swaps the contents of, i, and, j.
*/

static void Swap (M2ALU_listOfRange i, M2ALU_listOfRange j);

/*
   DisplayElements -
*/

static void DisplayElements (M2ALU_listOfRange i);

/*
   SortElements - sorts the list as defined by, h, into ascending range order.
                  The low element is the sort key.
*/

static void SortElements (unsigned int tokenno, M2ALU_listOfRange h);

/*
   CombineElements - given a sorted list determine whether there is any
                     overlap in the low..high bounds. If overlap exists
                     then remove it.
*/

static void CombineElements (unsigned int tokenno, M2ALU_listOfRange r);

/*
   EvalSetValues - returns TRUE if all elements in this set have been resolved.
*/

static bool EvalSetValues (unsigned int tokenno, M2ALU_listOfRange r);

/*
   Eval - attempts to solve a constructor type.
*/

static void Eval (unsigned int tokenno, M2ALU_PtrToValue__opaque v);

/*
   WalkSetValueDependants -
*/

static void WalkSetValueDependants (M2ALU_listOfRange r, M2GCCDeclare_WalkAction p);

/*
   IsSetValueDependants -
*/

static bool IsSetValueDependants (M2ALU_listOfRange r, M2GCCDeclare_IsAction q);

/*
   WalkFieldValueDependants -
*/

static void WalkFieldValueDependants (M2ALU_listOfFields f, M2GCCDeclare_WalkAction p);

/*
   IsFieldValueDependants -
*/

static bool IsFieldValueDependants (M2ALU_listOfFields f, M2GCCDeclare_IsAction q);

/*
   WalkArrayValueDependants -
*/

static void WalkArrayValueDependants (M2ALU_listOfElements a, M2GCCDeclare_WalkAction p);

/*
   IsArrayValueDependants -
*/

static bool IsArrayValueDependants (M2ALU_listOfElements a, M2GCCDeclare_IsAction q);

/*
   DefinedByConstants - returns TRUE if the value, v, is defined by constants.
                        It assigns, v^.areAllConstants, with the result.
*/

static bool DefinedByConstants (M2ALU_PtrToValue__opaque v);

/*
   rangeConstant - returns TRUE if all the range entities are constant.
*/

static bool rangeConstant (M2ALU_listOfRange r);

/*
   fieldsConstant - returns TRUE if all the field entities are constant.
*/

static bool fieldsConstant (M2ALU_listOfFields f);

/*
   arrayConstant - returns TRUE if the, element, and, by, components
                   of an array constructor are constant.
*/

static bool arrayConstant (M2ALU_listOfElements e);

/*
   FindValueEnum -
*/

static void FindValueEnum (unsigned int field);

/*
   Val - returns a GCC symbol enumeration or a GCC constant which has, value, and which is
         of type, type.
*/

static unsigned int Val (unsigned int tokenno, unsigned int type, tree value);

/*
   DupConst - duplicates and returns a constant, sym, but adds, offset to its value.
*/

static unsigned int DupConst (unsigned int tokenno, unsigned int sym, int offset);

/*
   DupConstAndAdd - duplicates and returns a constant, sym,
                    but adds the symbol, extra.
*/

static unsigned int DupConstAndAdd (unsigned int tokenno, unsigned int sym, tree extra);

/*
   DupConstAndAddMod - duplicates and returns a constant, sym,
                       but adds the symbol, extra, and ensures that
                       the result in within limits: min..max using
                       modulo arithmetic.
*/

static unsigned int DupConstAndAddMod (unsigned int tokenno, unsigned int sym, tree extra, unsigned int l, unsigned int h);

/*
   Remove - removes, v, from list, h.
*/

static void Remove (M2ALU_listOfRange *h, M2ALU_listOfRange v);

/*
   RemoveBit - remove bit, op1, from range, v, on list, h.
*/

static void RemoveBit (unsigned int tokenno, M2ALU_listOfRange *h, M2ALU_listOfRange v, unsigned int op1);

/*
   PerformSubBit -
*/

static void PerformSubBit (unsigned int tokenno, M2ALU_listOfRange *h, unsigned int op1);

/*
   PerformSetIn - returns TRUE if op1 is in set.
*/

static bool PerformSetIn (unsigned int tokenno, unsigned int op1, M2ALU_listOfRange h);

/*
   SetOp - perform the function doOp on the top two elements of the stack.
*/

static void SetOp (unsigned int tokenno, M2ALU_DoSetProcedure doOp);

/*
   PerformOr - performs a logical OR between the two ranges.
               The ranges, r1, r2, are destroyed.
*/

static M2ALU_listOfRange PerformOr (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2);

/*
   Min - returns the symbol which has the least value.
*/

static unsigned int Min (unsigned int tokenno, unsigned int a, unsigned int b);

/*
   Max - returns the symbol which has the greatest value.
*/

static unsigned int Max (unsigned int tokenno, unsigned int a, unsigned int b);

/*
   IsRangeIntersection - returns TRUE if ranges, r1, and, r2, intersect.
*/

static bool IsRangeIntersection (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2);

/*
   IsRangeLess - returns TRUE if r1^.low is < r2^.low
*/

static bool IsRangeLess (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2);

/*
   MinTree - returns the tree symbol which has the least value.
*/

static tree MinTree (unsigned int tokenno, tree a, tree b);

/*
   MaxTree - returns the symbol which has the greatest value.
*/

static tree MaxTree (unsigned int tokenno, tree a, tree b);

/*
   IsIntersectionTree - returns TRUE if ranges, a..b, and, c..d, intersect.
*/

static bool IsIntersectionTree (unsigned int tokenno, tree a, tree b, tree c, tree d);

/*
   SubTree - returns the tree value containing (a-b)
*/

static tree SubTree (tree a, tree b);

/*
   PerformAnd - performs a logical AND between the two ranges.
                The ranges, r1, r2, are unaltered.
*/

static M2ALU_listOfRange PerformAnd (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2);

/*
   BuildStructBitset - v is the PtrToValue.
                       low and high are the limits of the subrange.
*/

static tree BuildStructBitset (unsigned int tokenno, M2ALU_PtrToValue__opaque v, tree low, tree high);

/*
   ConstructLargeOrSmallSet - generates a constant representing the set value of the symbol, sym.
                              We manufacture the constant by using a initialization
                              structure of cardinals.

                              { (cardinal), (cardinal) etc }
*/

static tree ConstructLargeOrSmallSet (unsigned int tokenno, M2ALU_PtrToValue__opaque v, unsigned int low, unsigned int high);

/*
   ConvertConstToType - returns a Tree containing an initialiser,
                        init, ready to be assigned to a record or
                        array constructor.
*/

static tree ConvertConstToType (unsigned int tokenno, unsigned int field, unsigned int init);

/*
   ConstructRecordConstant - builds a struct initializer, as defined by, v.
*/

static tree ConstructRecordConstant (unsigned int tokenno, M2ALU_PtrToValue__opaque v);

/*
   GetConstructorField - returns a symbol containing the constructor field, i.
*/

static unsigned int GetConstructorField (M2ALU_PtrToValue__opaque v, unsigned int i);

/*
   GetConstructorElement - returns a symbol containing the array constructor element, i.
*/

static unsigned int GetConstructorElement (unsigned int tokenno, M2ALU_PtrToValue__opaque v, unsigned int i);

/*
   IsString - returns TRUE if sym is an ARRAY [..] OF CHAR
*/

static bool IsString (unsigned int sym);

/*
   StringFitsArray -
*/

static bool StringFitsArray (unsigned int arrayType, unsigned int el, unsigned int tokenno);

/*
   GetArrayLimits -
*/

static void GetArrayLimits (unsigned int array, unsigned int *low, unsigned int *high);

/*
   InitialiseArrayOfCharWithString -
*/

static tree InitialiseArrayOfCharWithString (unsigned int tokenno, void * cons, unsigned int el, unsigned int baseType, unsigned int arrayType);

/*
   CheckElementString -
*/

static tree CheckElementString (unsigned int el, unsigned int arrayType, unsigned int tokenno);

/*
   InitialiseArrayWith -
*/

static tree InitialiseArrayWith (unsigned int tokenno, void * cons, M2ALU_PtrToValue__opaque v, unsigned int el, unsigned int high, unsigned int low, unsigned int arrayType);

/*
   CheckGetCharFromString - return TRUE if a char from the position arrayIndex in the list of
                            constDecl elements can be extracted.  The character is returned
                            in value.
*/

static bool CheckGetCharFromString (location_t location, unsigned int tokenno, M2ALU_PtrToValue__opaque constDecl, unsigned int consType, unsigned int arrayIndex, tree *value);

/*
   InitialiseArrayOfCharWith -
*/

static tree InitialiseArrayOfCharWith (unsigned int tokenno, void * cons, M2ALU_PtrToValue__opaque constDecl, unsigned int el, unsigned int high, unsigned int low, unsigned int consType, unsigned int arrayType);

/*
   ConstructArrayConstant - builds a struct initializer, as defined by, v.
*/

static tree ConstructArrayConstant (unsigned int tokenno, M2ALU_PtrToValue__opaque v);

/*
   BuildBitset - given a set, v, construct the bitmask for its
                 constant value which lie in the range low..high.
*/

static tree BuildBitset (unsigned int tokenno, M2ALU_PtrToValue__opaque v, tree low, tree high);

/*
   CheckOverflow - tests to see whether the tree, t, has caused
                   an overflow error and if so it generates an
                   error message.
*/

static void CheckOverflow (unsigned int tokenno, tree t);

/*
   PushGCCArrayTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCArrayTree (tree gcc, unsigned int t);

/*
   PushGCCSetTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCSetTree (tree gcc, unsigned int t);

/*
   PushGCCRecordTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCRecordTree (tree gcc, unsigned int t);

/*
   Init - initialises the stack and the free list.
*/

static void Init (void);


/*
   New - allocate a PtrToValue. Firstly check the FreeList, if empty call upon New.
*/

static M2ALU_PtrToValue__opaque New (void)
{
  M2ALU_PtrToValue__opaque v;

  if (FreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &v, sizeof (M2ALU_cell));
    }
  else
    {
      v = FreeList;
      FreeList = FreeList->next;
    }
  v->numberValue = NULL;
  return InitRecord (v);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitRecord - initialize the non variant fields of, v.  Return v.
*/

static M2ALU_PtrToValue__opaque InitRecord (M2ALU_PtrToValue__opaque v)
{
  v->location = m2linemap_UnknownLocation ();
  v->areAllConstants = false;
  v->solved = false;
  v->constructorType = SymbolTable_NulSym;
  v->numberValue = NULL;
  return v;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewRange - assigns, v, to a new area of memory.
*/

static void NewRange (M2ALU_listOfRange *v)
{
  if (RangeFreeList == NULL)
    {
      /* avoid dangling else.  */
      Storage_ALLOCATE ((void **) &(*v), sizeof (M2ALU_rList));
      if ((*v) == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory error", 19);
        }
    }
  else
    {
      (*v) = RangeFreeList;
      RangeFreeList = RangeFreeList->next;
    }
}


/*
   DisposeRange - adds the list, v, to the free list.
*/

static void DisposeRange (M2ALU_listOfRange *v)
{
  M2ALU_listOfRange r;

  if ((*v) != NULL)
    {
      r = (*v);
      while ((r != NULL) && (r->next != NULL))
        {
          r = r->next;
        }
      if (r != NULL)
        {
          r->next = RangeFreeList;
        }
      RangeFreeList = (*v);
      (*v) = NULL;
    }
}


/*
   IsOnFieldFreeList - returns TRUE if, r, is on the FieldFreeList.
*/

static bool IsOnFieldFreeList (M2ALU_listOfFields r)
{
  M2ALU_listOfFields s;

  s = FieldFreeList;
  while (s != NULL)
    {
      if (s == r)
        {
          return true;
        }
      else
        {
          s = s->next;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsOnElementFreeList - returns TRUE if, r, is on the ElementFreeList.
*/

static bool IsOnElementFreeList (M2ALU_listOfElements r)
{
  M2ALU_listOfElements s;

  s = ElementFreeList;
  while (s != NULL)
    {
      if (s == r)
        {
          return true;
        }
      else
        {
          s = s->next;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisposeFields - adds the list, v, to the free list.
*/

static void DisposeFields (M2ALU_listOfFields *v)
{
  M2ALU_listOfFields r;

  if ((*v) != NULL)
    {
      r = (*v);
      while (r->next != NULL)
        {
          M2Debug_Assert (! (IsOnFieldFreeList (r)));
          r = r->next;
        }
      r->next = FieldFreeList;
      FieldFreeList = (*v);
      (*v) = NULL;
    }
}


/*
   NewField - adds the list, v, to the free list.
*/

static void NewField (M2ALU_listOfFields *v)
{
  if (FieldFreeList == NULL)
    {
      /* avoid dangling else.  */
      Storage_ALLOCATE ((void **) &(*v), sizeof (M2ALU_fList));
      if ((*v) == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory error", 19);
        }
    }
  else
    {
      (*v) = FieldFreeList;
      FieldFreeList = FieldFreeList->next;
    }
}


/*
   NewElement - returns a new element record.
*/

static void NewElement (M2ALU_listOfElements *e)
{
  if (ElementFreeList == NULL)
    {
      /* avoid dangling else.  */
      Storage_ALLOCATE ((void **) &(*e), sizeof (M2ALU_eList));
      if ((*e) == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory error", 19);
        }
    }
  else
    {
      (*e) = ElementFreeList;
      ElementFreeList = ElementFreeList->next;
    }
}


/*
   DisposeElements - returns the list, e, to the free list.
*/

static void DisposeElements (M2ALU_listOfElements *e)
{
  M2ALU_listOfElements r;

  if ((*e) != NULL)
    {
      r = (*e);
      while (r->next != NULL)
        {
          M2Debug_Assert (! (IsOnElementFreeList (r)));
          r = r->next;
        }
      r->next = ElementFreeList;
      ElementFreeList = (*e);
      (*e) = NULL;
    }
}


/*
   CheckNotAlreadyOnFreeList - checks to see whether, v, is already on the free list
                               and aborts if this is the case.
*/

static void CheckNotAlreadyOnFreeList (M2ALU_PtrToValue__opaque v)
{
  M2ALU_PtrToValue__opaque l;

  if (DebugGarbage)
    {
      l = FreeList;
      while (l != NULL)
        {
          if (l == v)
            {
              M2Error_InternalError ((const char *) "value is already on the free list", 33);
            }
          l = l->next;
        }
    }
}


/*
   CheckNotOnStack - checks to see whether, v, is already on the stack
                     and aborts if this is the case.
*/

static void CheckNotOnStack (M2ALU_PtrToValue__opaque v)
{
  M2ALU_PtrToValue__opaque l;

  if (DebugGarbage)
    {
      l = TopOfStack;
      while (l != NULL)
        {
          if (l == v)
            {
              M2Error_InternalError ((const char *) "value is already on the stack", 29);
            }
          l = l->next;
        }
    }
}


/*
   Dispose - place, v, onto the FreeList.
*/

static void Dispose (M2ALU_PtrToValue__opaque v)
{
  CheckNotAlreadyOnFreeList (v);
  CheckNotOnStack (v);
  switch (v->type)
    {
      case M2ALU_set:
        DisposeRange (&v->setValue);
        break;

      case M2ALU_constructor:
      case M2ALU_record:
        DisposeFields (&v->fieldValues);
        break;

      case M2ALU_array:
        DisposeElements (&v->arrayValues);
        break;


      default:
        break;
    }
  v->next = FreeList;
  FreeList = v;
}


/*
   AddRange - returns a ListOfRange which is prepended to the front of the current list.
*/

static M2ALU_listOfRange AddRange (M2ALU_listOfRange head, unsigned int l, unsigned int h)
{
  M2ALU_listOfRange r;

  NewRange (&r);
  r->low = l;
  r->high = h;
  r->next = head;
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupRange - duplicates and returns the list, t.
*/

static M2ALU_listOfRange DupRange (M2ALU_listOfRange r)
{
  M2ALU_listOfRange s;

  s = NULL;
  while (r != NULL)
    {
      s = AddRange (s, r->low, r->high);
      r = r->next;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Pop - pops and returns top element from the stack.
*/

static M2ALU_PtrToValue__opaque Pop (void)
{
  M2ALU_PtrToValue__opaque v;

  if (TopOfStack == NULL)
    {
      M2Error_InternalError ((const char *) "stack underflow error", 21);
    }
  else
    {
      v = TopOfStack;
      TopOfStack = TopOfStack->next;
    }
  CheckNotAlreadyOnFreeList (v);
  return v;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Push - pushes the value onto the stack.
*/

static void Push (M2ALU_PtrToValue__opaque v)
{
  CheckNotAlreadyOnFreeList (v);
  CheckNotOnStack (v);
  v->next = TopOfStack;
  TopOfStack = v;
}


/*
   Reduce - remove the top element of the stack.
*/

static void Reduce (void)
{
  Dispose (Pop ());
}


/*
   PrintValue - debugging procedure to display the value on the top of the stack.
*/

static void PrintValue (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_integer)
    {
      m2misc_DebugTree (v->numberValue);
    }
  Push (v);
}


/*
   DupFields - duplicates the field list in order.
*/

static M2ALU_listOfFields DupFields (M2ALU_listOfFields f)
{
  M2ALU_listOfFields p;
  M2ALU_listOfFields q;
  M2ALU_listOfFields l;

  p = NULL;
  l = NULL;
  while (f != NULL)
    {
      NewField (&q);
      if (p == NULL)
        {
          p = q;
        }
      q->field = f->field;
      q->next = NULL;
      if (l != NULL)
        {
          l->next = q;
        }
      l = q;
      f = f->next;
    }
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupElements - duplicates the array list in order.
*/

static M2ALU_listOfElements DupElements (M2ALU_listOfElements f)
{
  M2ALU_listOfElements p;
  M2ALU_listOfElements q;
  M2ALU_listOfElements l;

  p = NULL;
  l = NULL;
  while (f != NULL)
    {
      NewElement (&q);
      if (p == NULL)
        {
          p = q;
        }
      q->element = f->element;
      q->by = f->by;
      q->next = NULL;
      if (l != NULL)
        {
          l->next = q;
        }
      l = q;
      f = f->next;
    }
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsReal - returns TRUE if a is a REAL number.
*/

static bool IsReal (DynamicStrings_String a)
{
  return (DynamicStrings_Index (a, '.', 0)) != -1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSolvedGCC - returns TRUE if the value, sym, is solved.
                 If TRUE then it also ensures this symbol is
                 entered into the double book keeping table
                 for GM2 <-> GCC.
*/

static bool IsSolvedGCC (unsigned int sym)
{
  if (SymbolTable_IsValueSolved (sym))
    {
      if (! (SymbolConversion_GccKnowsAbout (sym)))
        {
          M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (sym), sym);
        }
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertIntToReal - converts a INTEGER into a LONGREAL
*/

static void ConvertIntToReal (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_integer)
    {
      v->numberValue = m2convert_ConvertConstantAndCheck (v->location, m2type_GetLongRealType (), v->numberValue);
      v->type = M2ALU_real;
      v->areAllConstants = true;
      v->solved = true;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting an INTEGER number", 27);
    }
  Push (v);
}


/*
   EitherReal - returns TRUE if either, Op1, or, Op2, are Real.
*/

static bool EitherReal (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  return (Op1->type == M2ALU_real) || (Op2->type == M2ALU_real);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EitherComplex - returns TRUE if either, Op1, or, Op2, are Real.
*/

static bool EitherComplex (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  return (Op1->type == M2ALU_complex) || (Op2->type == M2ALU_complex);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RealAdd - adds two numbers. One of which is a Real.
*/

static void RealAdd (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if (Op1->type == M2ALU_integer)
    {
      Push (Op1);
      ConvertIntToReal ();
      Op1 = Pop ();
    }
  if (Op2->type == M2ALU_integer)
    {
      Push (Op2);
      ConvertIntToReal ();
      Op2 = Pop ();
    }
  Temp = New ();
  Temp->location = Op1->location;
  Temp->numberValue = m2expr_BuildAdd (Temp->location, Op1->numberValue, Op2->numberValue, false);
  Temp->type = M2ALU_real;
  Temp->solved = true;
  Push (Temp);
}


/*
   ComplexAdd - adds two complex numbers.
*/

static void ComplexAdd (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if ((Op1->type == M2ALU_complex) && (Op2->type == M2ALU_complex))
    {
      Temp = New ();
      Temp->location = Op1->location;
      Temp->numberValue = m2expr_BuildAdd (Temp->location, Op1->numberValue, Op2->numberValue, false);
      Temp->type = M2ALU_complex;
      Temp->solved = true;
      Push (Temp);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting both operands to be of type COMPLEX", 45);
    }
}


/*
   RealSub - subtracts two numbers. One of which is a Real.
*/

static void RealSub (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if (Op1->type == M2ALU_integer)
    {
      Push (Op1);
      ConvertIntToReal ();
      Op1 = Pop ();
    }
  if (Op2->type == M2ALU_integer)
    {
      Push (Op2);
      ConvertIntToReal ();
      Op2 = Pop ();
    }
  Temp = New ();
  Temp->location = Op1->location;
  Temp->numberValue = m2expr_BuildSub (Temp->location, Op2->numberValue, Op1->numberValue, false);
  Temp->type = M2ALU_real;
  Temp->solved = true;
  Push (Temp);
}


/*
   ComplexSub - subtracts two complex numbers.
*/

static void ComplexSub (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if ((Op1->type == M2ALU_complex) && (Op2->type == M2ALU_complex))
    {
      Temp = New ();
      Temp->location = Op1->location;
      Temp->numberValue = m2expr_BuildSub (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->type = M2ALU_complex;
      Temp->solved = true;
      Push (Temp);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting both operands to be of type COMPLEX", 45);
    }
}


/*
   RealMult - multiplies two numbers. One of which is a Real.
*/

static void RealMult (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if (Op1->type == M2ALU_integer)
    {
      Push (Op1);
      ConvertIntToReal ();
      Op1 = Pop ();
    }
  if (Op2->type == M2ALU_integer)
    {
      Push (Op2);
      ConvertIntToReal ();
      Op2 = Pop ();
    }
  Temp = New ();  /* as it is a temp  */
  Temp->location = Op1->location;  /* as it is a temp  */
  Temp->numberValue = m2expr_BuildMult (Temp->location, Op2->numberValue, Op1->numberValue, false);
  Temp->type = M2ALU_real;
  Temp->solved = true;
  Push (Temp);
}


/*
   ComplexMult - multiplies two complex numbers.
*/

static void ComplexMult (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if ((Op1->type == M2ALU_complex) && (Op2->type == M2ALU_complex))
    {
      Temp = New ();
      Temp->location = Op1->location;
      Temp->numberValue = m2expr_BuildMult (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->type = M2ALU_complex;
      Temp->solved = true;
      Push (Temp);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting both operands to be of type COMPLEX", 45);
    }
}


/*
   RealDiv - divides two numbers. One of which is a Real.
*/

static void RealDiv (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if (Op1->type == M2ALU_integer)
    {
      Push (Op1);
      ConvertIntToReal ();
      Op1 = Pop ();
    }
  if (Op2->type == M2ALU_integer)
    {
      Push (Op2);
      ConvertIntToReal ();
      Op2 = Pop ();
    }
  Temp = New ();  /* as it is a temp  */
  Temp->location = Op1->location;  /* as it is a temp  */
  Temp->numberValue = m2expr_BuildDivTrunc (Temp->location, Op2->numberValue, Op1->numberValue, false);
  Temp->type = M2ALU_real;
  Temp->solved = true;
  Push (Temp);
}


/*
   ComplexDiv - divides two complex numbers.
*/

static void ComplexDiv (M2ALU_PtrToValue__opaque Op1, M2ALU_PtrToValue__opaque Op2)
{
  M2ALU_PtrToValue__opaque Temp;

  if ((Op1->type == M2ALU_complex) && (Op2->type == M2ALU_complex))
    {
      Temp = New ();
      Temp->location = Op1->location;
      Temp->numberValue = m2expr_BuildDivTrunc (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->type = M2ALU_complex;
      Temp->solved = true;
      Push (Temp);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting both operands to be of type COMPLEX", 45);
    }
}


/*
   AreSetsEqual - returns TRUE if sets, op1, and, op2, contain the same
                  members.
*/

static bool AreSetsEqual (unsigned int tokenno, M2ALU_PtrToValue__opaque op1, M2ALU_PtrToValue__opaque op2)
{
  unsigned int low1;
  unsigned int low2;
  unsigned int high1;
  unsigned int high2;
  unsigned int i;

  i = 1;
  Eval (tokenno, op1);
  Eval (tokenno, op2);
  if (! (op1->solved && op2->solved))
    {
      M2Error_InternalError ((const char *) "can only compare set values when they are known", 47);
    }
  for (;;)
  {
    if (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (op1), i, &low1, &high1))
      {
        if (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (op2), i, &low2, &high2))
          {
            SymbolTable_PushValue (low1);
            SymbolTable_PushValue (low2);
            if (M2ALU_NotEqu (tokenno))
              {
                return false;
              }
            SymbolTable_PushValue (high1);
            SymbolTable_PushValue (high2);
            if (M2ALU_NotEqu (tokenno))
              {
                return false;
              }
            i += 1;
          }
        else
          {
            /* op2 is out of ranges, but op1 still has >= 1 range left  */
            return false;
          }
      }
    else
      {
        if (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (op2), i, &low2, &high2))
          {
            /* op1 is out of ranges, but op2 still has >= 1 range left  */
            return false;
          }
        else
          {
            /* both out of ranges and they were the same  */
            return true;
          }
      }
  }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsSubset - returns TRUE if the set as defined by, s1, is a subset of set, s2.
*/

static bool IsSubset (unsigned int tokenno, M2ALU_PtrToValue__opaque s1, M2ALU_PtrToValue__opaque s2)
{
  Push (s1);
  Push (s2);
  M2ALU_SetAnd (tokenno);
  Push (s1);
  return M2ALU_Equ (tokenno);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSuperset - returns TRUE if the set as defined by, s1, is a superset of set, s2.
*/

static bool IsSuperset (unsigned int tokenno, M2ALU_PtrToValue__opaque s1, M2ALU_PtrToValue__opaque s2)
{
  M2ALU_PushFrom (static_cast<M2ALU_PtrToValue> (s1));
  M2ALU_PushFrom (static_cast<M2ALU_PtrToValue> (s2));
  M2ALU_SetAnd (tokenno);
  M2ALU_PushFrom (static_cast<M2ALU_PtrToValue> (s2));
  return M2ALU_Equ (tokenno);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   cellTypeString - returns a string corresponding to, s.
*/

static DynamicStrings_String cellTypeString (M2ALU_cellType s)
{
  switch (s)
    {
      case M2ALU_none:
        return DynamicStrings_InitString ((const char *) "none", 4);
        break;

      case M2ALU_integer:
        return DynamicStrings_InitString ((const char *) "integer", 7);
        break;

      case M2ALU_real:
        return DynamicStrings_InitString ((const char *) "real", 4);
        break;

      case M2ALU_complex:
        return DynamicStrings_InitString ((const char *) "complex", 7);
        break;

      case M2ALU_set:
        return DynamicStrings_InitString ((const char *) "set", 3);
        break;

      case M2ALU_constructor:
        return DynamicStrings_InitString ((const char *) "constructor", 11);
        break;

      case M2ALU_array:
        return DynamicStrings_InitString ((const char *) "array", 5);
        break;

      case M2ALU_record:
        return DynamicStrings_InitString ((const char *) "record", 6);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected value of s", 21);
        break;
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ToSetValue - converts a list of fields into a list of ranges.
                In effect it turns a generic constructor into
                a set type.
*/

static M2ALU_listOfRange ToSetValue (M2ALU_listOfFields f)
{
  M2ALU_listOfFields g;
  M2ALU_listOfRange r;
  M2ALU_listOfRange s;

  g = f;
  r = NULL;
  while (f != NULL)
    {
      NewRange (&s);
      s->low = f->field;
      s->high = s->low;
      s->next = r;
      if (r == NULL)
        {
          r = s;
        }
      f = f->next;
    }
  DisposeFields (&g);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ToArrayValue - converts a list of fields into an array initialiser.
                  In effect it turns a generic constructor into
                  an array type.
*/

static M2ALU_listOfElements ToArrayValue (unsigned int tok, M2ALU_listOfFields f)
{
  M2ALU_listOfFields g;
  M2ALU_listOfElements r;
  M2ALU_listOfElements s;

  g = f;
  r = NULL;
  while (f != NULL)
    {
      NewElement (&s);
      s->element = f->field;
      s->by = SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), M2Base_ZType);
      s->next = r;
      if (r == NULL)
        {
          r = s;
        }
      f = f->next;
    }
  DisposeFields (&g);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CoerseTo - attempts to coerses a cellType, v, into, type, t.
              Normally this will be a generic constructors converting
              into set or array.
*/

static M2ALU_PtrToValue__opaque CoerseTo (unsigned int tokenno, M2ALU_cellType t, M2ALU_PtrToValue__opaque v)
{
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  DynamicStrings_String s3;

  if (t == v->type)
    {
      return v;
    }
  else if ((v->type == M2ALU_constructor) && (t == M2ALU_set))
    {
      /* avoid dangling else.  */
      v->type = M2ALU_set;
      v->setValue = ToSetValue (v->fieldValues);
      return v;
    }
  else if ((v->type == M2ALU_constructor) && (t == M2ALU_array))
    {
      /* avoid dangling else.  */
      v->type = M2ALU_array;
      v->arrayValues = ToArrayValue (tokenno, v->fieldValues);
      return v;
    }
  else if ((v->type == M2ALU_constructor) && (t == M2ALU_record))
    {
      /* avoid dangling else.  */
      /* nothing to do other than change tag  */
      v->type = M2ALU_record;
      return v;
    }
  else
    {
      /* avoid dangling else.  */
      s1 = cellTypeString (t);
      s2 = cellTypeString (v->type);
      s3 = DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "cannot mix construction of a ", 29), DynamicStrings_Mark (DynamicStrings_ConCat (DynamicStrings_Mark (s1), DynamicStrings_Mark (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) " with a ", 8), DynamicStrings_Mark (s2))))));
      M2MetaError_MetaErrorStringT0 (tokenno, s3);
      return v;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddElementToEnd - appends, e, to the end of list, v.
*/

static void AddElementToEnd (M2ALU_PtrToValue__opaque v, M2ALU_listOfElements e)
{
  M2ALU_listOfElements a;

  if (v->arrayValues == NULL)
    {
      v->arrayValues = e;
    }
  else
    {
      a = v->arrayValues;
      while (a->next != NULL)
        {
          a = a->next;
        }
      a->next = e;
    }
}


/*
   AddFieldToEnd - appends, f, to the end of list, v.
*/

static void AddFieldToEnd (M2ALU_PtrToValue__opaque v, M2ALU_listOfFields f)
{
  M2ALU_listOfFields a;

  if (v->fieldValues == NULL)
    {
      v->fieldValues = f;
    }
  else
    {
      a = v->fieldValues;
      while (a->next != NULL)
        {
          a = a->next;
        }
      a->next = f;
    }
}


/*
   ElementsSolved - returns TRUE if all ranges in the set have been solved.
*/

static bool ElementsSolved (unsigned int tokenno, M2ALU_listOfRange r)
{
  while (r != NULL)
    {
      if (! (SymbolTable_IsConst (r->low)))
        {
          M2MetaError_MetaErrorT1 (tokenno, (const char *) "a constant set can only contain constant set elements, {%1Ead} is not a constant", 80, r->low);
        }
      if ((r->high != r->low) && (! (SymbolTable_IsConst (r->high))))
        {
          M2MetaError_MetaErrorT1 (tokenno, (const char *) "a constant set can only contain constant set elements, {%1Ead} is not a constant", 80, r->high);
        }
      if (! ((IsSolvedGCC (r->low)) && (IsSolvedGCC (r->high))))
        {
          return false;
        }
      r = r->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ArrayElementsSolved - returns TRUE if all ranges in the set have been solved.
*/

static bool ArrayElementsSolved (M2ALU_listOfElements e)
{
  while (e != NULL)
    {
      if (! ((IsSolvedGCC (e->element)) && (IsSolvedGCC (e->by))))
        {
          return false;
        }
      e = e->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EvalFieldValues - returns TRUE if all fields in the record have been solved.
*/

static bool EvalFieldValues (M2ALU_listOfFields e)
{
  while (e != NULL)
    {
      if (SymbolTable_IsConst (e->field))
        {
          /* avoid dangling else.  */
          if (! (IsSolvedGCC (e->field)))
            {
              return false;
            }
        }
      /* RETURN( FALSE )  */
      e = e->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Swap - swaps the contents of, i, and, j.
*/

static void Swap (M2ALU_listOfRange i, M2ALU_listOfRange j)
{
  unsigned int t;

  t = i->low;
  i->low = j->low;
  j->low = t;
  t = i->high;
  i->high = j->high;
  j->high = t;
}


/*
   DisplayElements -
*/

static void DisplayElements (M2ALU_listOfRange i)
{
  while (i != NULL)
    {
      SymbolTable_PushValue (i->low);
      PrintValue ();
      Reduce ();
      SymbolTable_PushValue (i->high);
      PrintValue ();
      Reduce ();
      i = i->next;
    }
}


/*
   SortElements - sorts the list as defined by, h, into ascending range order.
                  The low element is the sort key.
*/

static void SortElements (unsigned int tokenno, M2ALU_listOfRange h)
{
  M2ALU_listOfRange i;
  M2ALU_listOfRange j;
  M2ALU_listOfRange k;

  i = h;
  while (i != NULL)
    {
      j = i;
      k = i->next;
      while (k != NULL)
        {
          SymbolTable_PushValue (k->low);
          M2ALU_ConvertToInt ();
          SymbolTable_PushValue (j->low);
          M2ALU_ConvertToInt ();
          if (M2ALU_Less (tokenno))
            {
              j = k;
            }
          k = k->next;
        }
      Swap (i, j);
      i = i->next;
    }
}


/*
   CombineElements - given a sorted list determine whether there is any
                     overlap in the low..high bounds. If overlap exists
                     then remove it.
*/

static void CombineElements (unsigned int tokenno, M2ALU_listOfRange r)
{
  M2ALU_listOfRange t;
  M2ALU_listOfRange j;

  while (r != NULL)
    {
      j = r->next;
      while (j != NULL)
        {
          SymbolTable_PushValue (r->high);
          M2ALU_ConvertToInt ();
          M2ALU_PushCard (1);
          M2ALU_Addn ();
          SymbolTable_PushValue (j->low);
          M2ALU_ConvertToInt ();
          if (M2ALU_GreEqu (tokenno))
            {
              r->high = j->high;
              t = j->next;
              r->next = j->next;
              j->next = NULL;
              DisposeRange (&j);
              j = t;
            }
          else
            {
              j = NULL;
            }
        }
      r = r->next;
    }
}


/*
   EvalSetValues - returns TRUE if all elements in this set have been resolved.
*/

static bool EvalSetValues (unsigned int tokenno, M2ALU_listOfRange r)
{
  if (ElementsSolved (tokenno, r))
    {
      SortElements (tokenno, r);
      CombineElements (tokenno, r);
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Eval - attempts to solve a constructor type.
*/

static void Eval (unsigned int tokenno, M2ALU_PtrToValue__opaque v)
{
  CheckNotAlreadyOnFreeList (v);
  if (! v->solved)
    {
      if (SymbolTable_IsSet (SymbolTable_SkipType (v->constructorType)))
        {
          v = CoerseTo (tokenno, M2ALU_set, v);
        }
      else if (SymbolTable_IsRecord (SymbolTable_SkipType (v->constructorType)))
        {
          /* avoid dangling else.  */
          v = CoerseTo (tokenno, M2ALU_record, v);
        }
      else if (SymbolTable_IsArray (SymbolTable_SkipType (v->constructorType)))
        {
          /* avoid dangling else.  */
          v = CoerseTo (tokenno, M2ALU_array, v);
        }
      v->areAllConstants = DefinedByConstants (v);
      switch (v->type)
        {
          case M2ALU_set:
            M2Debug_Assert ((v->constructorType == SymbolTable_NulSym) || (SymbolTable_IsSet (SymbolTable_SkipType (v->constructorType))));
            v->solved = (M2GCCDeclare_CompletelyResolved (v->constructorType)) && (EvalSetValues (tokenno, v->setValue));
            break;

          case M2ALU_array:
            M2Debug_Assert ((v->constructorType == SymbolTable_NulSym) || (SymbolTable_IsArray (SymbolTable_SkipType (v->constructorType))));
            v->solved = (M2GCCDeclare_CompletelyResolved (v->constructorType)) && (ArrayElementsSolved (v->arrayValues));
            break;

          case M2ALU_record:
            M2Debug_Assert ((v->constructorType == SymbolTable_NulSym) || (SymbolTable_IsRecord (SymbolTable_SkipType (v->constructorType))));
            v->solved = (M2GCCDeclare_CompletelyResolved (v->constructorType)) && (EvalFieldValues (v->fieldValues));
            break;


          default:
            break;
        }
    }
  /* do nothing  */
}


/*
   WalkSetValueDependants -
*/

static void WalkSetValueDependants (M2ALU_listOfRange r, M2GCCDeclare_WalkAction p)
{
  while (r != NULL)
    {
      (*p.proc) (r->low);
      (*p.proc) (r->high);
      r = r->next;
    }
}


/*
   IsSetValueDependants -
*/

static bool IsSetValueDependants (M2ALU_listOfRange r, M2GCCDeclare_IsAction q)
{
  bool result;

  result = true;
  while (r != NULL)
    {
      if (! ((*q.proc) (r->low)))
        {
          result = false;
        }
      if (! ((*q.proc) (r->high)))
        {
          result = false;
        }
      r = r->next;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkFieldValueDependants -
*/

static void WalkFieldValueDependants (M2ALU_listOfFields f, M2GCCDeclare_WalkAction p)
{
  while (f != NULL)
    {
      (*p.proc) (f->field);
      f = f->next;
    }
}


/*
   IsFieldValueDependants -
*/

static bool IsFieldValueDependants (M2ALU_listOfFields f, M2GCCDeclare_IsAction q)
{
  bool result;

  result = true;
  while (f != NULL)
    {
      if (! ((*q.proc) (f->field)))
        {
          result = false;
        }
      f = f->next;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkArrayValueDependants -
*/

static void WalkArrayValueDependants (M2ALU_listOfElements a, M2GCCDeclare_WalkAction p)
{
  while (a != NULL)
    {
      (*p.proc) (a->element);
      (*p.proc) (a->by);
      a = a->next;
    }
}


/*
   IsArrayValueDependants -
*/

static bool IsArrayValueDependants (M2ALU_listOfElements a, M2GCCDeclare_IsAction q)
{
  bool result;

  result = true;
  while (a != NULL)
    {
      if (! ((*q.proc) (a->element)))
        {
          result = false;
        }
      if (! ((*q.proc) (a->by)))
        {
          result = false;
        }
      a = a->next;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DefinedByConstants - returns TRUE if the value, v, is defined by constants.
                        It assigns, v^.areAllConstants, with the result.
*/

static bool DefinedByConstants (M2ALU_PtrToValue__opaque v)
{
  switch (v->type)
    {
      case M2ALU_none:
      case M2ALU_integer:
      case M2ALU_real:
      case M2ALU_complex:
        v->areAllConstants = true;
        break;

      case M2ALU_set:
        v->areAllConstants = rangeConstant (v->setValue);
        break;

      case M2ALU_constructor:
      case M2ALU_record:
        v->areAllConstants = fieldsConstant (v->fieldValues);
        break;

      case M2ALU_array:
        v->areAllConstants = arrayConstant (v->arrayValues);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected type", 15);
        break;
    }
  return v->areAllConstants;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   rangeConstant - returns TRUE if all the range entities are constant.
*/

static bool rangeConstant (M2ALU_listOfRange r)
{
  while (r != NULL)
    {
      if ((! (SymbolTable_IsConst (r->low))) || (! (SymbolTable_IsConst (r->high))))
        {
          return false;
        }
      r = r->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   fieldsConstant - returns TRUE if all the field entities are constant.
*/

static bool fieldsConstant (M2ALU_listOfFields f)
{
  while (f != NULL)
    {
      if (! (SymbolTable_IsConst (f->field)))
        {
          return false;
        }
      f = f->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   arrayConstant - returns TRUE if the, element, and, by, components
                   of an array constructor are constant.
*/

static bool arrayConstant (M2ALU_listOfElements e)
{
  while (e != NULL)
    {
      if ((! (SymbolTable_IsConst (e->element))) && (! (SymbolTable_IsConst (e->by))))
        {
          return false;
        }
      e = e->next;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindValueEnum -
*/

static void FindValueEnum (unsigned int field)
{
  SymbolTable_PushValue (field);
  M2ALU_PushIntegerTree (EnumerationValue);
  if (M2ALU_Equ (CurrentTokenNo))
    {
      EnumerationField = static_cast<unsigned int> (field);
    }
}


/*
   Val - returns a GCC symbol enumeration or a GCC constant which has, value, and which is
         of type, type.
*/

static unsigned int Val (unsigned int tokenno, unsigned int type, tree value)
{
  unsigned int sym;

  if (SymbolTable_IsEnumeration (type))
    {
      EnumerationField = SymbolTable_NulSym;
      EnumerationValue = value;
      CurrentTokenNo = tokenno;
      SymbolTable_ForeachFieldEnumerationDo (type, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) FindValueEnum});
      if (EnumerationField == SymbolTable_NulSym)
        {
          M2Error_InternalError ((const char *) "enumeration value exceeds range", 31);
        }
      return EnumerationField;
    }
  else
    {
      sym = SymbolTable_MakeTemporary (tokenno, SymbolTable_ImmediateValue);
      SymbolTable_PutVar (sym, type);
      CheckOverflow (tokenno, value);
      M2ALU_PushIntegerTree (value);
      SymbolTable_PopValue (sym);
      return sym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupConst - duplicates and returns a constant, sym, but adds, offset to its value.
*/

static unsigned int DupConst (unsigned int tokenno, unsigned int sym, int offset)
{
  SymbolTable_PushValue (sym);
  M2ALU_PushInt (offset);
  M2ALU_Addn ();
  return Val (tokenno, SymbolTable_GetType (sym), M2ALU_PopIntegerTree ());
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupConstAndAdd - duplicates and returns a constant, sym,
                    but adds the symbol, extra.
*/

static unsigned int DupConstAndAdd (unsigned int tokenno, unsigned int sym, tree extra)
{
  SymbolTable_PushValue (sym);
  M2ALU_PushIntegerTree (extra);
  M2ALU_Addn ();
  return Val (tokenno, SymbolTable_GetType (sym), M2ALU_PopIntegerTree ());
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupConstAndAddMod - duplicates and returns a constant, sym,
                       but adds the symbol, extra, and ensures that
                       the result in within limits: min..max using
                       modulo arithmetic.
*/

static unsigned int DupConstAndAddMod (unsigned int tokenno, unsigned int sym, tree extra, unsigned int l, unsigned int h)
{
  /* result := (((sym-l) + extra) MOD (h-l)) + l)  */
  SymbolTable_PushValue (sym);
  SymbolTable_PushValue (l);
  M2ALU_Sub ();
  M2ALU_PushIntegerTree (extra);
  M2ALU_Addn ();
  SymbolTable_PushValue (h);
  SymbolTable_PushValue (l);
  M2ALU_Sub ();
  M2ALU_ModTrunc ();
  SymbolTable_PushValue (l);
  M2ALU_Addn ();
  return Val (tokenno, SymbolTable_GetType (sym), M2ALU_PopIntegerTree ());
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Remove - removes, v, from list, h.
*/

static void Remove (M2ALU_listOfRange *h, M2ALU_listOfRange v)
{
  M2ALU_listOfRange i;

  if ((*h) == v)
    {
      (*h) = (*h)->next;
    }
  else
    {
      i = (*h);
      while ((i != NULL) && (i->next != v))
        {
          i = i->next;
        }
      if (i == NULL)
        {
          M2Error_InternalError ((const char *) "expecting v to be on the list", 29);
        }
      else
        {
          i = v->next;
        }
    }
  v->next = NULL;
  DisposeRange (&v);
}


/*
   RemoveBit - remove bit, op1, from range, v, on list, h.
*/

static void RemoveBit (unsigned int tokenno, M2ALU_listOfRange *h, M2ALU_listOfRange v, unsigned int op1)
{
  SymbolTable_PushValue (v->low);
  SymbolTable_PushValue (v->high);
  if (M2ALU_Equ (tokenno))
    {
      /* avoid dangling else.  */
      /* single bit in this range  */
      SymbolTable_PushValue (v->low);
      SymbolTable_PushValue (op1);
      if (M2ALU_Equ (tokenno))
        {
          /* remove entry  */
          Remove (h, v);
          return;
        }
    }
  else
    {
      /* is op1 equal to low?  */
      SymbolTable_PushValue (op1);
      SymbolTable_PushValue (v->low);
      if (M2ALU_Equ (tokenno))
        {
          v->low = DupConst (tokenno, v->low, 1);
        }
      else
        {
          SymbolTable_PushValue (op1);
          SymbolTable_PushValue (v->high);
          if (M2ALU_Equ (tokenno))
            {
              v->high = DupConst (tokenno, v->high, -1);
            }
          else
            {
              v->high = DupConst (tokenno, op1, -1);
              (*h) = AddRange ((*h), DupConst (tokenno, op1, 1), v->high);
              SortElements (tokenno, (*h));
            }
        }
    }
}


/*
   PerformSubBit -
*/

static void PerformSubBit (unsigned int tokenno, M2ALU_listOfRange *h, unsigned int op1)
{
  M2ALU_listOfRange v;

  v = (*h);
  while (v != NULL)
    {
      SymbolTable_PushValue (v->low);
      SymbolTable_PushValue (op1);
      if (M2ALU_LessEqu (tokenno))
        {
          SymbolTable_PushValue (op1);
          SymbolTable_PushValue (v->high);
          if (M2ALU_LessEqu (tokenno))
            {
              RemoveBit (tokenno, h, v, op1);
              return;
            }
        }
      v = v->next;
    }
}


/*
   PerformSetIn - returns TRUE if op1 is in set.
*/

static bool PerformSetIn (unsigned int tokenno, unsigned int op1, M2ALU_listOfRange h)
{
  while (h != NULL)
    {
      SymbolTable_PushValue (op1);
      M2ALU_ConvertToInt ();
      SymbolTable_PushValue (h->low);
      M2ALU_ConvertToInt ();
      if (M2ALU_GreEqu (tokenno))
        {
          /* avoid dangling else.  */
          SymbolTable_PushValue (op1);
          SymbolTable_PushValue (h->high);
          if (M2ALU_LessEqu (tokenno))
            {
              return true;
            }
        }
      else
        {
          /* op1 is smaller than this and all subsequent ranges  */
          return false;
        }
      h = h->next;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetOp - perform the function doOp on the top two elements of the stack.
*/

static void SetOp (unsigned int tokenno, M2ALU_DoSetProcedure doOp)
{
  M2ALU_PtrToValue__opaque Result;
  M2ALU_PtrToValue__opaque Set1;
  M2ALU_PtrToValue__opaque Set2;

  Set1 = Pop ();
  Set2 = Pop ();
  Eval (tokenno, Set1);
  Eval (tokenno, Set2);
  if (! (Set1->solved && Set2->solved))
    {
      M2Error_InternalError ((const char *) "one or more operands have not been resolved", 43);
    }
  if (Set1->type != M2ALU_set)
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a set", 38);
    }
  if (Set2->type != M2ALU_set)
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a set", 38);
    }
  Result = New ();
  Result->type = M2ALU_set;
  Result->setValue = (*doOp.proc) (tokenno, Set1->setValue, Set2->setValue);
  Result->constructorType = M2Base_MixTypes (Set1->constructorType, Set2->constructorType, tokenno);
  Result->solved = false;
  /* Set1 and Set2 have given their range lists to the Result  */
  Set1->setValue = NULL;
  Set2->setValue = NULL;
  Eval (tokenno, Result);
  Push (Result);
  Dispose (Set1);
  Dispose (Set2);
}


/*
   PerformOr - performs a logical OR between the two ranges.
               The ranges, r1, r2, are destroyed.
*/

static M2ALU_listOfRange PerformOr (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2)
{
  M2ALU_listOfRange i;

  i = r1;
  while ((i != NULL) && (i->next != NULL))
    {
      i = i->next;
    }
  if (i == NULL)
    {
      r1 = r2;
    }
  else
    {
      i->next = r2;
    }
  SortElements (tokenno, r1);
  CombineElements (tokenno, r1);
  return r1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Min - returns the symbol which has the least value.
*/

static unsigned int Min (unsigned int tokenno, unsigned int a, unsigned int b)
{
  SymbolTable_PushValue (a);
  M2ALU_ConvertToInt ();
  SymbolTable_PushValue (b);
  M2ALU_ConvertToInt ();
  if (M2ALU_Less (tokenno))
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Max - returns the symbol which has the greatest value.
*/

static unsigned int Max (unsigned int tokenno, unsigned int a, unsigned int b)
{
  SymbolTable_PushValue (a);
  M2ALU_ConvertToInt ();
  SymbolTable_PushValue (b);
  M2ALU_ConvertToInt ();
  if (M2ALU_Gre (tokenno))
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRangeIntersection - returns TRUE if ranges, r1, and, r2, intersect.
*/

static bool IsRangeIntersection (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2)
{
  if ((r1 == NULL) || (r2 == NULL))
    {
      return false;
    }
  else
    {
      /* easier to prove NOT outside limits  */
      SymbolTable_PushValue (r1->low);
      M2ALU_ConvertToInt ();
      SymbolTable_PushValue (r2->high);
      M2ALU_ConvertToInt ();
      if (M2ALU_Gre (tokenno))
        {
          return false;
        }
      else
        {
          SymbolTable_PushValue (r1->high);
          M2ALU_ConvertToInt ();
          SymbolTable_PushValue (r2->low);
          M2ALU_ConvertToInt ();
          if (M2ALU_Less (tokenno))
            {
              return false;
            }
          else
            {
              return true;
            }
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRangeLess - returns TRUE if r1^.low is < r2^.low
*/

static bool IsRangeLess (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2)
{
  if ((r1 == NULL) || (r2 == NULL))
    {
      M2Error_InternalError ((const char *) "not expecting NIL ranges", 24);
    }
  SymbolTable_PushValue (r1->high);
  M2ALU_ConvertToInt ();
  SymbolTable_PushValue (r2->low);
  M2ALU_ConvertToInt ();
  return M2ALU_Less (tokenno);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MinTree - returns the tree symbol which has the least value.
*/

static tree MinTree (unsigned int tokenno, tree a, tree b)
{
  M2ALU_PushIntegerTree (a);
  M2ALU_ConvertToInt ();
  M2ALU_PushIntegerTree (b);
  M2ALU_ConvertToInt ();
  if (M2ALU_Less (tokenno))
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MaxTree - returns the symbol which has the greatest value.
*/

static tree MaxTree (unsigned int tokenno, tree a, tree b)
{
  M2ALU_PushIntegerTree (a);
  M2ALU_ConvertToInt ();
  M2ALU_PushIntegerTree (b);
  M2ALU_ConvertToInt ();
  if (M2ALU_Gre (tokenno))
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsIntersectionTree - returns TRUE if ranges, a..b, and, c..d, intersect.
*/

static bool IsIntersectionTree (unsigned int tokenno, tree a, tree b, tree c, tree d)
{
  /* easier to prove NOT outside limits  */
  M2ALU_PushIntegerTree (a);
  M2ALU_ConvertToInt ();
  M2ALU_PushIntegerTree (d);
  M2ALU_ConvertToInt ();
  if (M2ALU_Gre (tokenno))
    {
      return false;
    }
  else
    {
      M2ALU_PushIntegerTree (b);
      M2ALU_ConvertToInt ();
      M2ALU_PushIntegerTree (c);
      M2ALU_ConvertToInt ();
      if (M2ALU_Less (tokenno))
        {
          return false;
        }
      else
        {
          return true;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SubTree - returns the tree value containing (a-b)
*/

static tree SubTree (tree a, tree b)
{
  M2ALU_PushIntegerTree (a);
  M2ALU_PushIntegerTree (b);
  M2ALU_Sub ();
  return M2ALU_PopIntegerTree ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PerformAnd - performs a logical AND between the two ranges.
                The ranges, r1, r2, are unaltered.
*/

static M2ALU_listOfRange PerformAnd (unsigned int tokenno, M2ALU_listOfRange r1, M2ALU_listOfRange r2)
{
  M2ALU_listOfRange r;

  r = NULL;
  while ((r1 != NULL) && (r2 != NULL))
    {
      if (IsRangeIntersection (tokenno, r1, r2))
        {
          r = AddRange (r, Max (tokenno, r1->low, r2->low), Min (tokenno, r1->high, r2->high));
          if (r->high == r1->high)
            {
              r1 = r1->next;
            }
          else
            {
              r2 = r2->next;
            }
        }
      else if (IsRangeLess (tokenno, r1, r2))
        {
          /* avoid dangling else.  */
          /* move r1 onto the next range  */
          r1 = r1->next;
        }
      else
        {
          /* avoid dangling else.  */
          /* move r2 onto the next range  */
          r2 = r2->next;
        }
    }
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildStructBitset - v is the PtrToValue.
                       low and high are the limits of the subrange.
*/

static tree BuildStructBitset (unsigned int tokenno, M2ALU_PtrToValue__opaque v, tree low, tree high)
{
  tree BitsInSet;
  unsigned int bpw;
  m2type_Constructor cons;

  M2ALU_PushIntegerTree (low);
  M2ALU_ConvertToInt ();
  low = M2ALU_PopIntegerTree ();
  M2ALU_PushIntegerTree (high);
  M2ALU_ConvertToInt ();
  high = M2ALU_PopIntegerTree ();
  bpw = m2decl_GetBitsPerBitset ();
  M2ALU_PushIntegerTree (high);
  M2ALU_PushIntegerTree (low);
  M2ALU_Sub ();
  M2ALU_PushCard (1);
  M2ALU_Addn ();
  BitsInSet = M2ALU_PopIntegerTree ();
  cons = m2type_BuildStartSetConstructor (SymbolConversion_Mod2Gcc (v->constructorType));
  M2ALU_PushIntegerTree (BitsInSet);
  M2ALU_PushCard (0);
  while (M2ALU_Gre (tokenno))
    {
      M2ALU_PushIntegerTree (BitsInSet);
      M2ALU_PushCard (bpw-1);
      if (M2ALU_GreEqu (tokenno))
        {
          M2ALU_PushIntegerTree (low);
          M2ALU_PushCard (bpw-1);
          M2ALU_Addn ();
          m2type_BuildSetConstructorElement (cons, BuildBitset (tokenno, v, low, M2ALU_PopIntegerTree ()));
          M2ALU_PushIntegerTree (low);
          M2ALU_PushCard (bpw);
          M2ALU_Addn ();
          low = M2ALU_PopIntegerTree ();
          M2ALU_PushIntegerTree (BitsInSet);
          M2ALU_PushCard (bpw);
          M2ALU_Sub ();
          BitsInSet = M2ALU_PopIntegerTree ();
        }
      else
        {
          /* printf2('range is %a..%a
          ', GetSymName(low), GetSymName(high)) ;  */
          m2type_BuildSetConstructorElement (cons, BuildBitset (tokenno, v, low, high));
          M2ALU_PushCard (0);
          BitsInSet = M2ALU_PopIntegerTree ();
        }
      M2ALU_PushIntegerTree (BitsInSet);
      M2ALU_PushCard (0);
    }
  return m2type_BuildEndSetConstructor (cons);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstructLargeOrSmallSet - generates a constant representing the set value of the symbol, sym.
                              We manufacture the constant by using a initialization
                              structure of cardinals.

                              { (cardinal), (cardinal) etc }
*/

static tree ConstructLargeOrSmallSet (unsigned int tokenno, M2ALU_PtrToValue__opaque v, unsigned int low, unsigned int high)
{
  SymbolTable_PushValue (high);
  M2ALU_ConvertToInt ();
  SymbolTable_PushValue (low);
  M2ALU_ConvertToInt ();
  M2ALU_Sub ();
  M2ALU_PushCard (static_cast<unsigned int> (m2decl_GetBitsPerBitset ()));
  if (M2ALU_Less (tokenno))
    {
      /* small set  */
      return BuildBitset (tokenno, v, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
    }
  else
    {
      /* large set  */
      return BuildStructBitset (tokenno, v, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertConstToType - returns a Tree containing an initialiser,
                        init, ready to be assigned to a record or
                        array constructor.
*/

static tree ConvertConstToType (unsigned int tokenno, unsigned int field, unsigned int init)
{
  tree initT;
  tree nBytes;

  if (((SymbolTable_IsConstString (init)) && (SymbolTable_IsArray (SymbolTable_SkipType (SymbolTable_GetType (field))))) && ((SymbolTable_SkipTypeAndSubrange (SymbolTable_GetType (SymbolTable_GetType (field)))) == M2Base_Char))
    {
      if (! (M2GenGCC_PrepareCopyString (tokenno, &nBytes, &initT, init, SymbolTable_GetType (field))))
        {
          M2MetaError_MetaErrorT2 (tokenno, (const char *) "string constant {%1Ea} is too large to be assigned to the {%2d} {%2a}", 69, init, field);
        }
      return initT;
    }
  else
    {
      return m2convert_ConvertConstantAndCheck (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (SymbolTable_GetType (field)), SymbolConversion_Mod2Gcc (init));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstructRecordConstant - builds a struct initializer, as defined by, v.
*/

static tree ConstructRecordConstant (unsigned int tokenno, M2ALU_PtrToValue__opaque v)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int i;
  unsigned int Field;
  unsigned int baseType;
  m2type_Constructor cons;

  if (v->constructorType == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "record type must be known in order to generate a constant", 57);
    }
  else
    {
      baseType = SymbolTable_SkipType (v->constructorType);
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (v->constructorType);
          n2 = SymbolTable_GetSymName (baseType);
          M2Printf_printf2 ((const char *) "ConstructRecordConstant of type %a and baseType %a\\n", 52, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
      cons = m2type_BuildStartRecordConstructor (SymbolConversion_Mod2Gcc (baseType));
      i = 1;
      do {
        Field = SymbolTable_GetNth (baseType, i);
        if (Field != SymbolTable_NulSym)
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if (SymbolConversion_GccKnowsAbout (SymbolTable_GetType (Field)))
              {
                m2type_BuildRecordConstructorElement (cons, ConvertConstToType (tokenno, Field, GetConstructorField (v, i)));
              }
            else
              {
                M2MetaError_MetaErrorT0 (tokenno, (const char *) "trying to construct a compound literal and using a record field which does not exist", 84);
              }
          }
        i += 1;
      } while (! (Field == SymbolTable_NulSym));
      return m2type_BuildEndRecordConstructor (cons);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetConstructorField - returns a symbol containing the constructor field, i.
*/

static unsigned int GetConstructorField (M2ALU_PtrToValue__opaque v, unsigned int i)
{
  unsigned int j;
  M2ALU_listOfFields f;

  if (v->type != M2ALU_record)
    {
      M2Error_InternalError ((const char *) "constructor type must be a record in order to push a field", 58);
    }
  else
    {
      if (v->constructorType == SymbolTable_NulSym)
        {
          M2Error_InternalError ((const char *) "constructor type must be a record in order to push a field", 58);
        }
      else
        {
          j = 1;
          f = v->fieldValues;
          while ((j < i) && (f != NULL))
            {
              f = f->next;
              j += 1;
            }
          if (f == NULL)
            {
              M2MetaError_MetaError1 ((const char *) "the {%1EN} element does not exist in the constant compound literal", 66, i);
              return SymbolTable_NulSym;
            }
          else
            {
              return f->field;
            }
        }
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetConstructorElement - returns a symbol containing the array constructor element, i.
*/

static unsigned int GetConstructorElement (unsigned int tokenno, M2ALU_PtrToValue__opaque v, unsigned int i)
{
  tree j;
  M2ALU_listOfElements e;

  if (v->type != M2ALU_array)
    {
      M2Error_InternalError ((const char *) "constructor type must be an array", 33);
    }
  else
    {
      if (v->constructorType == SymbolTable_NulSym)
        {
          M2Error_InternalError ((const char *) "constructor type must be an array", 33);
        }
      else
        {
          M2ALU_PushCard (i);
          j = M2ALU_PopIntegerTree ();
          e = v->arrayValues;
          while (e != NULL)
            {
              SymbolTable_PushValue (e->by);
              M2ALU_PushIntegerTree (j);
              if (M2ALU_GreEqu (tokenno))
                {
                  return e->element;
                }
              M2ALU_PushIntegerTree (j);
              M2ALU_ConvertToInt ();
              SymbolTable_PushValue (e->by);
              M2ALU_ConvertToInt ();
              M2ALU_Sub ();
              j = M2ALU_PopIntegerTree ();
              e = e->next;
            }
          if (e == NULL)
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if ((SymbolTable_IsArray (SymbolTable_SkipType (v->constructorType))) && ((SymbolTable_GetType (SymbolTable_SkipType (v->constructorType))) == M2Base_Char))
                {
                  return SymbolTable_MakeConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_Char);
                }
              else
                {
                  M2MetaError_MetaErrorT2 (tokenno, (const char *) "the {%1EN} element does not exist in the {%2ad} array declaration used by the compound literal", 94, i, v->constructorType);
                }
            }
        }
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsString - returns TRUE if sym is an ARRAY [..] OF CHAR
*/

static bool IsString (unsigned int sym)
{
  return (((SymbolTable_IsArray (sym)) && ((SymbolTable_SkipType (SymbolTable_GetType (sym))) == M2Base_Char)) || (SymbolTable_IsConstString (sym))) || ((SymbolTable_IsConst (sym)) && ((SymbolTable_SkipType (SymbolTable_GetType (sym))) == M2Base_Char));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   StringFitsArray -
*/

static bool StringFitsArray (unsigned int arrayType, unsigned int el, unsigned int tokenno)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  M2ALU_PushIntegerTree (m2type_BuildNumberOfArrayElements (location, SymbolConversion_Mod2Gcc (arrayType)));
  if (SymbolTable_IsConstString (el))
    {
      M2ALU_PushCard (SymbolTable_GetStringLength (tokenno, el));
    }
  else if (((SymbolTable_IsConst (el)) && ((SymbolTable_SkipType (SymbolTable_GetType (el))) == M2Base_Char)) && (SymbolTable_IsValueSolved (el)))
    {
      /* avoid dangling else.  */
      M2ALU_PushCard (1);
    }
  else
    {
      /* avoid dangling else.  */
      M2ALU_PushCard (0);
      M2MetaError_MetaError1 ((const char *) "cannot build a string using {%1Ead}", 35, el);
    }
  return M2ALU_GreEqu (tokenno);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetArrayLimits -
*/

static void GetArrayLimits (unsigned int array, unsigned int *low, unsigned int *high)
{
  unsigned int Subscript;
  unsigned int Subrange;

  Subscript = SymbolTable_GetArraySubscript (array);
  Subrange = SymbolTable_SkipType (SymbolTable_GetType (Subscript));
  if (SymbolTable_IsEnumeration (Subrange))
    {
      M2Base_GetBaseTypeMinMax (Subrange, low, high);
    }
  else
    {
      SymbolTable_GetSubrange (Subrange, high, low);
    }
}


/*
   InitialiseArrayOfCharWithString -
*/

static tree InitialiseArrayOfCharWithString (unsigned int tokenno, void * cons, unsigned int el, unsigned int baseType, unsigned int arrayType)
{
  bool isChar;
  DynamicStrings_String s;
  DynamicStrings_String letter;
  unsigned int i;
  unsigned int l;
  unsigned int high;
  unsigned int low;
  tree value;
  tree indice;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  GetArrayLimits (baseType, &low, &high);
  l = 0;
  s = static_cast<DynamicStrings_String> (NULL);
  if (SymbolTable_IsConstString (el))
    {
      isChar = false;
      s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetString (el)));
      l = SymbolTable_GetStringLength (tokenno, el);
    }
  else if (((SymbolTable_IsConst (el)) && ((SymbolTable_SkipType (SymbolTable_GetType (el))) == M2Base_Char)) && (SymbolTable_IsValueSolved (el)))
    {
      /* avoid dangling else.  */
      isChar = true;
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "cannot build a string using {%1Ead}", 35, el);
      isChar = false;
    }
  i = 0;
  do {
    SymbolTable_PushValue (low);
    M2ALU_PushCard (i);
    M2ALU_Addn ();
    indice = M2ALU_PopIntegerTree ();
    letter = static_cast<DynamicStrings_String> (NULL);
    if (isChar)
      {
        isChar = false;
        SymbolTable_PushValue (el);
        value = M2ALU_PopIntegerTree ();
      }
    else if (i < l)
      {
        /* avoid dangling else.  */
        if ((i+1) < l)
          {
            letter = DynamicStrings_Slice (s, static_cast<int> (i), static_cast<int> (i+1));
          }
        else
          {
            letter = DynamicStrings_Slice (s, static_cast<int> (i), 0);
          }
        value = m2type_BuildCharConstant (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (letter))));
      }
    else
      {
        /* avoid dangling else.  */
        letter = DynamicStrings_InitStringChar (ASCII_nul);
        value = m2type_BuildCharConstant (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (letter))));
      }
    value = m2convert_ConvertConstantAndCheck (location, SymbolConversion_Mod2Gcc (arrayType), value);
    letter = DynamicStrings_KillString (letter);
    m2type_BuildArrayConstructorElement (cons, value, indice);
    SymbolTable_PushValue (low);
    M2ALU_PushCard (i);
    M2ALU_Addn ();
    SymbolTable_PushValue (high);
    i += 1;
  } while (! (M2ALU_GreEqu (tokenno)));
  s = DynamicStrings_KillString (s);
  if (! (StringFitsArray (baseType, el, tokenno)))
    {
      M2MetaError_MetaError2 ((const char *) "string {%1Ea} is too large to fit into array {%2ad}", 51, el, baseType);
    }
  /* 
   IF v#NIL
   THEN
      el := GetConstructorElement(tokenno, v, 2) ;
      IF el#NulSym
      THEN
         MetaError1('not allowed to have multiple strings to initialise an array of characters {%1Ua}', el)
      END
   END ;
  */
  return m2type_BuildEndArrayConstructor (cons);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckElementString -
*/

static tree CheckElementString (unsigned int el, unsigned int arrayType, unsigned int tokenno)
{
  void * cons;

  if ((IsString (arrayType)) && (IsString (el)))
    {
      cons = m2type_BuildStartArrayConstructor (SymbolConversion_Mod2Gcc (arrayType));
      return InitialiseArrayOfCharWithString (tokenno, cons, el, arrayType, SymbolTable_SkipType (SymbolTable_GetType (arrayType)));
    }
  else
    {
      return SymbolConversion_Mod2Gcc (el);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitialiseArrayWith -
*/

static tree InitialiseArrayWith (unsigned int tokenno, void * cons, M2ALU_PtrToValue__opaque v, unsigned int el, unsigned int high, unsigned int low, unsigned int arrayType)
{
  location_t location;
  unsigned int i;
  tree indice;
  tree value;

  location = M2LexBuf_TokenToLocation (tokenno);
  i = 0;
  while (el != SymbolTable_NulSym)
    {
      SymbolTable_PushValue (low);
      M2ALU_ConvertToInt ();
      M2ALU_PushInt (static_cast<int> (i));
      M2ALU_Addn ();
      indice = M2ALU_PopIntegerTree ();
      value = CheckElementString (el, arrayType, tokenno);
      if (value == NULL)
        {
          M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%W}too few characters found when trying to construct a compound literal array", 78);
          value = m2expr_GetCardinalZero (location);
        }
      value = m2convert_ConvertConstantAndCheck (location, SymbolConversion_Mod2Gcc (arrayType), value);
      m2type_BuildArrayConstructorElement (cons, value, indice);
      SymbolTable_PushValue (low);
      M2ALU_ConvertToInt ();
      M2ALU_PushInt (static_cast<int> (i));
      M2ALU_Addn ();
      SymbolTable_PushValue (high);
      M2ALU_ConvertToInt ();
      if (M2ALU_GreEqu (tokenno))
        {
          return m2type_BuildEndArrayConstructor (cons);
        }
      i += 1;
      el = GetConstructorElement (tokenno, v, i+1);
    }
  return m2type_BuildEndArrayConstructor (cons);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckGetCharFromString - return TRUE if a char from the position arrayIndex in the list of
                            constDecl elements can be extracted.  The character is returned
                            in value.
*/

static bool CheckGetCharFromString (location_t location, unsigned int tokenno, M2ALU_PtrToValue__opaque constDecl, unsigned int consType, unsigned int arrayIndex, tree *value)
{
  unsigned int elementIndex;
  unsigned int element;
  unsigned int offset;
  unsigned int totalLength;
  NameKey_Name key;

  totalLength = 0;
  elementIndex = 1;
  do {
    element = GetConstructorElement (tokenno, constDecl, elementIndex);
    offset = totalLength;
    if (SymbolTable_IsConstString (element))
      {
        /* avoid dangling else.  */
        totalLength += SymbolTable_GetStringLength (tokenno, element);
        if (totalLength > arrayIndex)
          {
            key = SymbolTable_GetString (element);
            arrayIndex -= offset;
            (*value) = m2type_BuildCharConstantChar (location, NameKey_CharKey (key, arrayIndex));
            return true;
          }
      }
    else if (((SymbolTable_IsConst (element)) && ((SymbolTable_SkipType (SymbolTable_GetType (element))) == M2Base_Char)) && (SymbolTable_IsValueSolved (element)))
      {
        /* avoid dangling else.  */
        totalLength += 1;
        if (totalLength > arrayIndex)
          {
            SymbolTable_PushValue (element);
            (*value) = m2convert_ConvertConstantAndCheck (location, m2type_GetM2CharType (), M2ALU_PopIntegerTree ());
            return true;
          }
      }
    else
      {
        /* avoid dangling else.  */
        totalLength += 1;
        if (totalLength > arrayIndex)
          {
            M2MetaError_MetaErrorT3 (tokenno, (const char *) "expecting {%kCHAR} datatype and not {%1Ea} a {%1tad} in the {%2N} component of the {%3a} {%3d}", 94, element, arrayIndex, consType);
            (*value) = m2expr_GetCardinalZero (location);
            return false;
          }
      }
    elementIndex += 1;
  } while (! (element == SymbolTable_NulSym));
  (*value) = m2expr_GetCardinalZero (location);
  M2MetaError_MetaErrorT2 (tokenno, (const char *) "unable to obtain a {%kCHAR} at the {%1EN} position in {%2ad}", 60, arrayIndex, consType);
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitialiseArrayOfCharWith -
*/

static tree InitialiseArrayOfCharWith (unsigned int tokenno, void * cons, M2ALU_PtrToValue__opaque constDecl, unsigned int el, unsigned int high, unsigned int low, unsigned int consType, unsigned int arrayType)
{
  location_t location;
  unsigned int arrayIndex;
  tree indice;
  tree value;

  location = M2LexBuf_TokenToLocation (tokenno);  /* arrayIndex is the char position index of the final string.  */
  arrayIndex = 0;
  while (el != SymbolTable_NulSym)
    {
      SymbolTable_PushValue (low);
      M2ALU_ConvertToInt ();
      M2ALU_PushInt (static_cast<int> (arrayIndex));
      M2ALU_Addn ();
      indice = M2ALU_PopIntegerTree ();
      if (! (CheckGetCharFromString (location, tokenno, constDecl, consType, arrayIndex, &value)))
        {}  /* empty.  */
      /* 
         MetaErrorT2 (tokenno,
                      'unable to obtain a {%kCHAR} at the {%1EN} position in {%2ad}',
                      arrayIndex, consType) ;
  */
      value = m2convert_ConvertConstantAndCheck (location, SymbolConversion_Mod2Gcc (arrayType), value);
      m2type_BuildArrayConstructorElement (cons, value, indice);
      SymbolTable_PushValue (low);
      M2ALU_ConvertToInt ();
      M2ALU_PushInt (static_cast<int> (arrayIndex));
      M2ALU_Addn ();
      SymbolTable_PushValue (high);
      M2ALU_ConvertToInt ();
      if (M2ALU_GreEqu (tokenno))
        {
          return m2type_BuildEndArrayConstructor (cons);
        }
      arrayIndex += 1;
    }
  return m2type_BuildEndArrayConstructor (cons);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstructArrayConstant - builds a struct initializer, as defined by, v.
*/

static tree ConstructArrayConstant (unsigned int tokenno, M2ALU_PtrToValue__opaque v)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int el1;
  unsigned int el2;
  unsigned int baseType;
  unsigned int arrayType;
  unsigned int high;
  unsigned int low;
  void * cons;

  if (v->constructorType == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "array type must be known in order to generate a constant", 56);
    }
  else
    {
      baseType = SymbolTable_SkipType (v->constructorType);
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (v->constructorType);
          n2 = SymbolTable_GetSymName (baseType);
          M2Printf_printf2 ((const char *) "ConstructArrayConstant of type %a and baseType %a\\n", 51, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
      cons = m2type_BuildStartArrayConstructor (SymbolConversion_Mod2Gcc (baseType));
      GetArrayLimits (baseType, &low, &high);
      arrayType = SymbolTable_GetType (baseType);
      el1 = GetConstructorElement (tokenno, v, 1);
      el2 = GetConstructorElement (tokenno, v, 2);
      if (((el2 == SymbolTable_NulSym) && (IsString (baseType))) && (IsString (el1)))
        {
          /* constructorType is ARRAY [low..high] OF CHAR and using a string to initialise it  */
          return InitialiseArrayOfCharWithString (tokenno, cons, el1, baseType, arrayType);
        }
      else if ((SymbolTable_SkipType (arrayType)) == M2Base_Char)
        {
          /* avoid dangling else.  */
          return InitialiseArrayOfCharWith (tokenno, cons, v, el1, high, low, baseType, arrayType);
        }
      else
        {
          /* avoid dangling else.  */
          return InitialiseArrayWith (tokenno, cons, v, el1, high, low, arrayType);
        }
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   BuildBitset - given a set, v, construct the bitmask for its
                 constant value which lie in the range low..high.
*/

static tree BuildBitset (unsigned int tokenno, M2ALU_PtrToValue__opaque v, tree low, tree high)
{
  tree tl;
  tree th;
  tree t;
  unsigned int n;
  unsigned int r1;
  unsigned int r2;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  low = m2convert_ToInteger (location, low);
  high = m2convert_ToInteger (location, high);
  n = 1;
  t = m2expr_GetCardinalZero (location);
  while (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (v), n, &r1, &r2))
    {
      SymbolTable_PushValue (r1);
      tl = m2convert_ToInteger (location, M2ALU_PopIntegerTree ());
      SymbolTable_PushValue (r2);
      th = m2convert_ToInteger (location, M2ALU_PopIntegerTree ());
      if (IsIntersectionTree (tokenno, tl, th, low, high))
        {
          tl = m2convert_ToCardinal (location, SubTree (MaxTree (tokenno, tl, low), low));
          th = m2convert_ToCardinal (location, SubTree (MinTree (tokenno, th, high), low));
          t = m2expr_BuildLogicalOr (location, t, M2ALU_BuildRange (tokenno, tl, th), false);
        }
      n += 1;
    }
  return m2convert_ToBitset (location, t);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckOverflow - tests to see whether the tree, t, has caused
                   an overflow error and if so it generates an
                   error message.
*/

static void CheckOverflow (unsigned int tokenno, tree t)
{
  if (m2expr_TreeOverflow (t))
    {
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "constant overflow error", 23);
      M2Error_FlushErrors ();
    }
}


/*
   PushGCCArrayTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCArrayTree (tree gcc, unsigned int t)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->constructorType = t;
  v->type = M2ALU_array;
  v->numberValue = gcc;
  v->arrayValues = NULL;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PushGCCSetTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCSetTree (tree gcc, unsigned int t)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->constructorType = t;
  v->type = M2ALU_set;
  v->numberValue = gcc;
  v->setValue = NULL;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PushGCCRecordTree - pushes a gcc tree value onto the ALU stack.
*/

static void PushGCCRecordTree (tree gcc, unsigned int t)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->constructorType = t;
  v->type = M2ALU_record;
  v->numberValue = gcc;
  v->fieldValues = NULL;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   Init - initialises the stack and the free list.
*/

static void Init (void)
{
  FreeList = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  TopOfStack = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  RangeFreeList = NULL;
  FieldFreeList = NULL;
  ElementFreeList = NULL;
}


/*
   InitValue - initializes and returns a memory cell.
*/

extern "C" M2ALU_PtrToValue M2ALU_InitValue (void)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  if (v == NULL)
    {
      M2Error_InternalError ((const char *) "out of memory error", 19);
    }
  else
    {
      v->location = m2linemap_UnknownLocation ();
      v->type = M2ALU_none;
      v->areAllConstants = true;
      v->solved = false;
      v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
      v->constructorType = SymbolTable_NulSym;
      return static_cast<M2ALU_PtrToValue> (v);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsValueTypeNone - returns TRUE if the value on the top stack has no value.
*/

extern "C" bool M2ALU_IsValueTypeNone (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_none)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeInteger - returns TRUE if the value on the top stack is an integer.
*/

extern "C" bool M2ALU_IsValueTypeInteger (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_integer)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeReal - returns TRUE if the value on the top stack is a real.
*/

extern "C" bool M2ALU_IsValueTypeReal (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_real)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeComplex - returns TRUE if the value on the top stack is a complex.
*/

extern "C" bool M2ALU_IsValueTypeComplex (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_complex)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeSet - returns TRUE if the value on the top stack is a set.
*/

extern "C" bool M2ALU_IsValueTypeSet (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_set)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeConstructor - returns TRUE if the value on the top
                            stack is a constructor.
*/

extern "C" bool M2ALU_IsValueTypeConstructor (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_constructor)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeArray - returns TRUE if the value on the top stack is
                      an array.
*/

extern "C" bool M2ALU_IsValueTypeArray (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_array)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValueTypeRecord - returns TRUE if the value on the top stack is
                       a record.
*/

extern "C" bool M2ALU_IsValueTypeRecord (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_record)
    {
      Push (v);
      return true;
    }
  else
    {
      Push (v);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSetValueType - returns the set type on top of the ALU stack.
*/

extern "C" unsigned int M2ALU_GetSetValueType (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  Push (v);
  if (v->type == M2ALU_set)
    {
      return v->constructorType;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting set type", 18);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PushIntegerTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushIntegerTree (tree t)
{
  M2ALU_PtrToValue__opaque v;

  v = static_cast<M2ALU_PtrToValue__opaque> (M2ALU_InitValue ());
  v->type = M2ALU_integer;
  v->numberValue = t;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PopIntegerTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopIntegerTree (void)
{
  M2ALU_PtrToValue__opaque v;
  tree t;

  v = Pop ();
  if (v->type == M2ALU_integer)
    {
      t = v->numberValue;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a whole number", 47);
    }
  Dispose (v);
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushRealTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushRealTree (tree t)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->type = M2ALU_real;
  v->numberValue = t;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PopRealTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopRealTree (void)
{
  M2ALU_PtrToValue__opaque v;
  tree t;

  v = Pop ();
  if (v->type == M2ALU_real)
    {
      t = v->numberValue;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a real number", 46);
    }
  Dispose (v);
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushComplexTree - pushes a gcc tree value onto the ALU stack.
*/

extern "C" void M2ALU_PushComplexTree (tree t)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->type = M2ALU_complex;
  v->numberValue = t;
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PopComplexTree - pops a gcc tree value from the ALU stack.
*/

extern "C" tree M2ALU_PopComplexTree (void)
{
  M2ALU_PtrToValue__opaque v;
  tree t;

  v = Pop ();
  if (v->type == M2ALU_complex)
    {
      t = v->numberValue;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a complex number", 49);
    }
  Dispose (v);
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushSetTree - pushes a gcc tree onto the ALU stack.
                 The tree, t, is expected to contain a
                 word value. It is converted into a set
                 type (sym). Bit 0 maps onto MIN(sym).
*/

extern "C" void M2ALU_PushSetTree (unsigned int tokenno, tree t, unsigned int sym)
{
  M2ALU_PtrToValue__opaque v;
  int c;
  int i;
  M2ALU_listOfRange r;
  location_t l;

  l = M2LexBuf_TokenToLocation (tokenno);
  r = NULL;
  i = 0;
  while ((i < (m2decl_GetBitsPerBitset ())) && ((m2expr_CompareTrees (m2expr_GetIntegerZero (l), t)) != 0))
    {
      if ((m2expr_CompareTrees (m2expr_GetIntegerOne (l), m2expr_BuildLogicalAnd (l, t, m2expr_GetIntegerOne (l), false))) == 0)
        {
          M2ALU_PushCard (static_cast<unsigned int> (i));
          c = Val (tokenno, SymbolTable_SkipType (sym), M2ALU_PopIntegerTree ());
          M2GCCDeclare_DeclareConstant (tokenno, static_cast<unsigned int> (c));
          r = AddRange (r, static_cast<unsigned int> (c), static_cast<unsigned int> (c));
        }
      t = m2expr_BuildLSR (l, t, m2expr_GetIntegerOne (l), false);
      i += 1;
    }
  SortElements (tokenno, r);
  CombineElements (tokenno, r);
  v = New ();
  v->location = l;
  v->type = M2ALU_set;
  v->constructorType = sym;
  v->areAllConstants = false;
  v->solved = false;
  v->setValue = r;
  Eval (tokenno, v);
  Push (v);
}


/*
   PopSetTree - pops a gcc tree from the ALU stack.
*/

extern "C" tree M2ALU_PopSetTree (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v;
  tree t;

  v = Pop ();
  if (v->type == M2ALU_set)
    {
      Eval (tokenno, v);
      if (! v->solved)
        {
          M2Error_InternalError ((const char *) "the set has not been resolved", 29);
        }
      if (! v->areAllConstants)
        {
          M2Error_InternalError ((const char *) "the set must only contain constants", 35);
        }
      t = M2ALU_ConstructSetConstant (tokenno, static_cast<M2ALU_PtrToValue> (v));
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting type of constant to be a set", 38);
    }
  Dispose (v);
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopConstructorTree - returns a tree containing the compound literal.
*/

extern "C" tree M2ALU_PopConstructorTree (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v;
  tree t;

  v = Pop ();
  Eval (tokenno, v);
  if (! v->solved)
    {
      M2Error_InternalError ((const char *) "the constructor has not been resolved", 37);
    }
  switch (v->type)
    {
      case M2ALU_constructor:
        M2Error_InternalError ((const char *) "expecting constructor to be resolved into specific type", 55);
        break;

      case M2ALU_array:
        t = ConstructArrayConstant (tokenno, v);
        break;

      case M2ALU_record:
        t = ConstructRecordConstant (tokenno, v);
        break;

      case M2ALU_set:
        t = M2ALU_ConstructSetConstant (tokenno, static_cast<M2ALU_PtrToValue> (v));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting type to be a constructor", 34);
        break;
    }
  Dispose (v);
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushFrom - pushes a copy of the contents of, v, onto stack.
*/

extern "C" void M2ALU_PushFrom (M2ALU_PtrToValue v)
{
  M2ALU_PtrToValue__opaque t;

  CheckNotAlreadyOnFreeList (static_cast<M2ALU_PtrToValue__opaque> (v));
  t = New ();  /* as it is a copy  */
  (*t) = (*static_cast<M2ALU_PtrToValue__opaque> (v));  /* as it is a copy  */
  switch (static_cast<M2ALU_PtrToValue__opaque> (v)->type)
    {
      case M2ALU_set:
        t->setValue = DupRange (static_cast<M2ALU_PtrToValue__opaque> (v)->setValue);
        break;

      case M2ALU_constructor:
      case M2ALU_record:
        t->fieldValues = DupFields (static_cast<M2ALU_PtrToValue__opaque> (v)->fieldValues);
        break;

      case M2ALU_array:
        t->arrayValues = DupElements (static_cast<M2ALU_PtrToValue__opaque> (v)->arrayValues);
        break;


      default:
        break;
    }
  Push (t);
}


/*
   PopInto - pops the top element from the stack and places it into, v.
*/

extern "C" void M2ALU_PopInto (M2ALU_PtrToValue v)
{
  M2ALU_PtrToValue__opaque t;

  t = Pop ();
  (*static_cast<M2ALU_PtrToValue__opaque> (v)) = (*t);
  switch (static_cast<M2ALU_PtrToValue__opaque> (v)->type)
    {
      case M2ALU_set:
        t->setValue = NULL;
        break;

      case M2ALU_record:
      case M2ALU_constructor:
        t->fieldValues = NULL;
        break;

      case M2ALU_array:
        t->arrayValues = NULL;
        break;

      case M2ALU_none:
      case M2ALU_integer:
      case M2ALU_real:
      case M2ALU_complex:
        static_cast<M2ALU_PtrToValue__opaque> (v)->numberValue = m2block_RememberConstant (m2expr_FoldAndStrip (t->numberValue));
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this value", 24);
        break;
    }
  Dispose (t);
}


/*
   PushCard - pushes a cardinal onto the stack.
*/

extern "C" void M2ALU_PushCard (unsigned int c)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->type = M2ALU_integer;
  v->numberValue = m2decl_BuildIntegerConstant ((int ) (c));
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PushInt - pushes an integer onto the stack.
*/

extern "C" void M2ALU_PushInt (int i)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->type = M2ALU_integer;
  v->numberValue = m2decl_BuildIntegerConstant (i);
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PushChar - pushes a char onto the stack.
*/

extern "C" void M2ALU_PushChar (char c)
{
  M2ALU_PtrToValue__opaque v;

  v = New ();
  v->type = M2ALU_integer;
  v->numberValue = m2decl_BuildIntegerConstant (static_cast<int> ( ((unsigned int) (c))));
  v->areAllConstants = true;
  v->solved = true;
  Push (v);
}


/*
   PopChar - pops a char from the stack.
*/

extern "C" char M2ALU_PopChar (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v;
  char ch;

  v = Pop ();
  ch = (char) 0;
  if (v->type == M2ALU_integer)
    {
      ch = (char ) (m2expr_GetCstInteger (v->numberValue));
    }
  else
    {
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%E}cannot convert constant to a CHAR", 37);
    }
  Push (v);
  return ch;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushString - pushes the numerical value of the string onto the stack.
*/

extern "C" void M2ALU_PushString (unsigned int tokenno, NameKey_Name s, bool issueError)
{
  char ch;
  DynamicStrings_String a;
  DynamicStrings_String b;
  unsigned int length;
  location_t location;

  a = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (s));
  b = static_cast<DynamicStrings_String> (NULL);
  length = DynamicStrings_Length (a);
  if (length > 0)
    {
      length -= 1;
      ch = DynamicStrings_char (a, static_cast<int> (length));
      location = M2LexBuf_TokenToLocation (tokenno);
      switch (ch)
        {
          case 'H':
            b = DynamicStrings_Slice (a, 0, -1);  /* hexadecimal  */
            M2ALU_PushIntegerTree (m2decl_BuildConstLiteralNumber (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (b))), 16, issueError));
            break;

          case 'A':
            b = DynamicStrings_Slice (a, 0, -1);  /* binary  */
            M2ALU_PushIntegerTree (m2decl_BuildConstLiteralNumber (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (b))), 2, issueError));
            break;

          case 'C':
          case 'B':
            b = DynamicStrings_Slice (a, 0, -1);  /* octal  */
            M2ALU_PushIntegerTree (m2decl_BuildConstLiteralNumber (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (b))), 8, issueError));
            break;


          default:
            if (IsReal (a))
              {
                M2ALU_PushRealTree (m2type_RealToTree (reinterpret_cast <char * > (NameKey_KeyToCharStar (s))));
              }
            else
              {
                M2ALU_PushIntegerTree (m2decl_BuildConstLiteralNumber (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (s))), 10, issueError));
              }
            break;
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting constant literal", 26);
    }
  a = DynamicStrings_KillString (a);
  b = DynamicStrings_KillString (b);
}


/*
   CoerseLongRealToCard - performs a coersion between a REAL to a CARDINAL
*/

extern "C" void M2ALU_CoerseLongRealToCard (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_real)
    {
      v->numberValue = m2convert_ConvertConstantAndCheck (v->location, m2type_GetIntegerType (), v->numberValue);
      v->type = M2ALU_integer;
      v->areAllConstants = true;
      v->solved = true;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting a REAL number", 23);
    }
  Push (v);
}


/*
   ConvertRealToInt - converts a REAL into an INTEGER
*/

extern "C" void M2ALU_ConvertRealToInt (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_real)
    {
      v->numberValue = m2convert_ConvertConstantAndCheck (v->location, m2type_GetIntegerType (), v->numberValue);
      v->type = M2ALU_integer;
      v->areAllConstants = true;
      v->solved = true;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting a REAL number", 23);
    }
  Push (v);
}


/*
   ConvertToInt - converts the value into an INTEGER. This should be used
                  if we are computing the number of elements in a char set to
                  avoid an overflow.
*/

extern "C" void M2ALU_ConvertToInt (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_integer)
    {
      v->numberValue = m2convert_ConvertConstantAndCheck (v->location, m2type_GetIntegerType (), v->numberValue);
      v->solved = true;
      v->areAllConstants = true;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting an INTEGER number", 27);
    }
  Push (v);
}


/*
   ConvertToType - converts the top of stack to type, t.
*/

extern "C" void M2ALU_ConvertToType (unsigned int t)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (t != SymbolTable_NulSym)
    {
      if (v->type == M2ALU_integer)
        {
          v->numberValue = m2convert_ConvertConstantAndCheck (v->location, SymbolConversion_Mod2Gcc (t), v->numberValue);
          v->solved = true;
          v->areAllConstants = true;
        }
      else
        {
          M2Error_InternalError ((const char *) "expecting an INTEGER number", 27);
        }
    }
  Push (v);
}


/*
   IsSolved - returns true if the memory cell indicated by v
              has a known value.
*/

extern "C" bool M2ALU_IsSolved (M2ALU_PtrToValue v)
{
  if (v == NULL)
    {
      M2Error_InternalError ((const char *) "uninitialized value", 19);
    }
  else
    {
      return static_cast<M2ALU_PtrToValue__opaque> (v)->solved;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutConstructorSolved - records that this constructor is solved.
*/

extern "C" void M2ALU_PutConstructorSolved (unsigned int sym)
{
  M2ALU_PtrToValue__opaque v;

  SymbolTable_PushValue (sym);
  v = Pop ();
  v->solved = true;
  Push (v);
  SymbolTable_PopValue (sym);
}


/*
   EvaluateValue - attempts to evaluate the symbol, sym, value.
*/

extern "C" void M2ALU_EvaluateValue (unsigned int sym)
{
  M2ALU_PtrToValue__opaque v;

  SymbolTable_PushValue (sym);
  v = Pop ();
  Eval (SymbolTable_GetDeclaredMod (sym), v);
  Push (v);
  SymbolTable_PopValue (sym);
}


/*
   TryEvaluateValue - attempts to evaluate the symbol, sym, value.
*/

extern "C" void M2ALU_TryEvaluateValue (unsigned int sym)
{
  M2ALU_PtrToValue__opaque v;

  SymbolTable_PushValue (sym);
  v = Pop ();
  switch (v->type)
    {
      case M2ALU_set:
      case M2ALU_array:
      case M2ALU_record:
        if (v->constructorType == SymbolTable_NulSym)
          {
            /* must wait  */
            return;
          }
        else
          {
            Eval (SymbolTable_GetDeclaredMod (sym), v);
          }
        break;


      default:
        break;
    }
  /* nothing to do  */
  if (v->solved)
    {
      Push (v);
      SymbolTable_PopValue (sym);
    }
}

extern "C" void M2ALU_Addn (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  /* 
   Add - adds the top two elements on the stack.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |                   <- Ptr
         |------------|    +------------+
         | Op2        |    | Op2 + Op1  |
         |------------|    |------------|
  */
  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      RealAdd (Op1, Op2);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      ComplexAdd (Op1, Op2);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildAdd (Temp->location, Op1->numberValue, Op2->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   Sub - subtracts the top two elements on the stack.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |                   <- Ptr
         |------------|    +------------+
         | Op2        |    | Op2 - Op1  |
         |------------|    |------------|
*/

extern "C" void M2ALU_Sub (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      RealSub (Op1, Op2);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      ComplexSub (Op1, Op2);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildSub (Temp->location, Op2->numberValue, Op1->numberValue, true);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}

extern "C" void M2ALU_Multn (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  /* 
   Mult - multiplies the top two elements on the stack.

          The Stack:

          Entry             Exit

   Ptr ->
          +------------+
          | Op1        |                   <- Ptr
          |------------|    +------------+
          | Op2        |    | Op2 * Op1  |
          |------------|    |------------|
  */
  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      RealMult (Op1, Op2);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      ComplexMult (Op1, Op2);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildMult (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   DivFloor - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_DivFloor (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      RealDiv (Op1, Op2);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      ComplexDiv (Op1, Op2);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildDivFloor (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   ModFloor - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_ModFloor (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      M2MetaError_MetaError0 ((const char *) "cannot perform {%EkMOD} on REAL types", 37);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError0 ((const char *) "cannot perform {%EkMOD} on COMPLEX types", 40);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildModFloor (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   DivTrunc - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_DivTrunc (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      RealDiv (Op1, Op2);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      ComplexDiv (Op1, Op2);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildDivTrunc (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   ModTrunc - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

extern "C" void M2ALU_ModTrunc (void)
{
  M2ALU_PtrToValue__opaque Temp;
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;

  Op1 = Pop ();
  Op2 = Pop ();
  if (EitherReal (Op1, Op2))
    {
      M2MetaError_MetaError0 ((const char *) "cannot perform {%EkMOD} on REAL types", 37);
    }
  else if (EitherComplex (Op1, Op2))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError0 ((const char *) "cannot perform {%EkMOD} on COMPLEX types", 40);
    }
  else
    {
      /* avoid dangling else.  */
      Temp = New ();  /* as it is a temp  */
      Temp->location = Op1->location;  /* as it is a temp  */
      Temp->type = M2ALU_integer;
      Temp->numberValue = m2expr_BuildModTrunc (Temp->location, Op2->numberValue, Op1->numberValue, false);
      Temp->solved = true;
      Push (Temp);
    }
  Dispose (Op1);
  Dispose (Op2);
}


/*
   Equ - returns true if the top two elements on the stack
         are identical.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 = Op1 )
*/

extern "C" bool M2ALU_Equ (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque Op1;
  M2ALU_PtrToValue__opaque Op2;
  bool result;

  Op1 = Pop ();
  Op2 = Pop ();
  if ((Op1->type == M2ALU_set) && (Op2->type == M2ALU_set))
    {
      result = AreSetsEqual (tokenno, Op1, Op2);
    }
  else if ((Op1->type == M2ALU_set) || (Op2->type == M2ALU_set))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a number and a set", 54);
      result = false;
    }
  else
    {
      /* avoid dangling else.  */
      if (Op1->type != Op2->type)
        {
          M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a different type constants", 62);
          result = false;
        }
      else if ((Op1->type == M2ALU_complex) || (Op1->type == M2ALU_real))
        {
          /* avoid dangling else.  */
          result = m2expr_AreRealOrComplexConstantsEqual (Op1->numberValue, Op2->numberValue);
        }
      else
        {
          /* avoid dangling else.  */
          result = m2expr_AreConstantsEqual (Op1->numberValue, Op2->numberValue);
        }
    }
  Dispose (Op1);
  Dispose (Op2);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NotEqu - returns true if the top two elements on the stack
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 # Op1 )
*/

extern "C" bool M2ALU_NotEqu (unsigned int tokenno)
{
  return ! (M2ALU_Equ (tokenno));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Less - returns true if Op2 < Op1

          The Stack:

          Entry             Exit

   Ptr ->
          +------------+
          | Op1        |
          |------------|
          | Op2        |
          |------------|    Empty

          RETURN( Op2 < Op1 )
*/

extern "C" bool M2ALU_Less (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v1;
  M2ALU_PtrToValue__opaque v2;
  bool result;
  int res;

  v1 = Pop ();
  v2 = Pop ();
  if ((v1->type == M2ALU_set) && (v2->type == M2ALU_set))
    {
      result = ! (IsSuperset (tokenno, v2, v1));
    }
  else if ((v1->type == M2ALU_set) || (v2->type == M2ALU_set))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a number and a set", 54);
      result = false;
    }
  else
    {
      /* avoid dangling else.  */
      res = m2expr_CompareTrees (v2->numberValue, v1->numberValue);
      if (res == -1)
        {
          result = true;
        }
      else
        {
          result = false;
        }
    }
  /* result := (CompareTrees(v2^.numberValue, v1^.numberValue)=-1)  */
  Dispose (v1);
  Dispose (v2);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Gre - returns true if Op2 > Op1

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 > Op1 )
*/

extern "C" bool M2ALU_Gre (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v1;
  M2ALU_PtrToValue__opaque v2;
  bool result;

  v1 = Pop ();
  v2 = Pop ();
  if ((v1->type == M2ALU_set) && (v2->type == M2ALU_set))
    {
      result = ! (IsSubset (tokenno, v2, v1));
    }
  else if ((v1->type == M2ALU_set) || (v2->type == M2ALU_set))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a number and a set", 54);
      M2Error_FlushErrors ();
      result = false;
    }
  else
    {
      /* avoid dangling else.  */
      result = (m2expr_CompareTrees (v2->numberValue, v1->numberValue)) == 1;
    }
  Dispose (v1);
  Dispose (v2);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LessEqu - returns true if Op2<Op1

             The Stack:

             Entry             Exit

      Ptr ->
             +------------+
             | Op1        |
             |------------|
             | Op2        |
             |------------|    Empty

             RETURN( Op2 <= Op1 )
*/

extern "C" bool M2ALU_LessEqu (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v1;
  M2ALU_PtrToValue__opaque v2;
  bool result;

  v1 = Pop ();
  v2 = Pop ();
  if ((v1->type == M2ALU_set) && (v2->type == M2ALU_set))
    {
      result = IsSubset (tokenno, v2, v1);
    }
  else if ((v1->type == M2ALU_set) || (v2->type == M2ALU_set))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a number and a set", 54);
      M2Error_FlushErrors ();
      result = false;
    }
  else
    {
      /* avoid dangling else.  */
      result = (m2expr_CompareTrees (v2->numberValue, v1->numberValue)) <= 0;
    }
  Dispose (v1);
  Dispose (v2);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GreEqu - returns true if Op2 >= Op1
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 >= Op1 )
*/

extern "C" bool M2ALU_GreEqu (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v1;
  M2ALU_PtrToValue__opaque v2;
  bool result;

  v1 = Pop ();
  v2 = Pop ();
  if ((v1->type == M2ALU_set) && (v2->type == M2ALU_set))
    {
      result = IsSuperset (tokenno, v2, v1);
    }
  else if ((v1->type == M2ALU_set) || (v2->type == M2ALU_set))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a comparison between a number and a set", 54);
      M2Error_FlushErrors ();
      result = false;
    }
  else
    {
      /* avoid dangling else.  */
      result = (m2expr_CompareTrees (v2->numberValue, v1->numberValue)) >= 0;
    }
  Dispose (v1);
  Dispose (v2);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsNulSet - returns TRUE if the top element is the nul set constant, {}.
*/

extern "C" bool M2ALU_IsNulSet (void)
{
  M2ALU_PtrToValue__opaque v;
  bool r;

  v = Pop ();
  r = (v->type == M2ALU_set) && (v->setValue == NULL);
  Push (v);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGenericNulSet - returns TRUE if the top element is the generic nul set constant, {}.
*/

extern "C" bool M2ALU_IsGenericNulSet (void)
{
  M2ALU_PtrToValue__opaque v;
  bool r;

  v = Pop ();
  r = ((v->type == M2ALU_set) && (v->setValue == NULL)) && (v->constructorType == SymbolTable_NulSym);
  Push (v);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushNulSet - pushes an empty set {} onto the ALU stack. The subrange type used
                to construct the set is defined by, constructorType.
                If this is NulSym then
                the set is generic and compatible with all sets.

                The Stack:

                Entry             Exit

                                                 <- Ptr
                                  +------------+
                                  | {}         |
                Ptr ->            |------------|

*/

extern "C" void M2ALU_PushNulSet (unsigned int settype)
{
  M2ALU_PtrToValue__opaque v;

  v = static_cast<M2ALU_PtrToValue__opaque> (M2ALU_InitValue ());
  v->type = M2ALU_set;
  v->constructorType = settype;
  v->areAllConstants = true;
  v->solved = M2GCCDeclare_CompletelyResolved (settype);
  v->setValue = NULL;
  v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  Push (v);
}


/*
   AddBitRange - adds the range op1..op2 to the underlying set.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Set        |      | Set        |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddBitRange (unsigned int tokenno, unsigned int op1, unsigned int op2)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  v = CoerseTo (tokenno, M2ALU_set, v);
  if (v->type == M2ALU_set)
    {
      v->setValue = AddRange (v->setValue, op1, op2);
      v->solved = (v->solved && (IsSolvedGCC (op1))) && (IsSolvedGCC (op2));
      v->areAllConstants = (v->areAllConstants && (SymbolTable_IsConst (op1))) && (SymbolTable_IsConst (op2));
    }
  Push (v);
}


/*
   AddBit - adds the bit op1 to the underlying set. INCL(Set, op1)

            Ptr ->
                                                      <- Ptr
                   +------------+      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

extern "C" void M2ALU_AddBit (unsigned int tokenno, unsigned int op1)
{
  M2ALU_AddBitRange (tokenno, op1, op1);
}


/*
   SubBit - removes a bit op1 from the underlying set. EXCL(Set, Op1)

            Ptr ->
                                                      <- Ptr
                   +------------+      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

extern "C" void M2ALU_SubBit (unsigned int tokenno, unsigned int op1)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v->type == M2ALU_set)
    {
      Eval (tokenno, v);
      if (v->solved)
        {
          if (IsSolvedGCC (op1))
            {
              PerformSubBit (tokenno, &v->setValue, op1);
              v->solved = false;
            }
          else
            {
              M2Error_InternalError ((const char *) "can only subtract a bit from a set when the bit value is known", 62);
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "can only subtract a bit from a set when the set value is known", 62);
        }
      Eval (tokenno, v);
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting set type constant", 27);
    }
  Push (v);
}


/*
   SetIn - returns true if Op2 IN Op1

           The Stack:

           Entry             Exit

    Ptr ->
           +------------+
           | Set        |
           |------------|    Empty

           RETURN( Op1 IN Set )
*/

extern "C" bool M2ALU_SetIn (unsigned int tokenno, unsigned int Op1)
{
  M2ALU_PtrToValue__opaque Set;
  bool result;

  Set = Pop ();
  if (Set->type != M2ALU_set)
    {
      M2Error_InternalError ((const char *) "expecting ALU operand to be a set", 33);
    }
  Eval (tokenno, Set);
  if ((IsSolvedGCC (Op1)) && Set->solved)
    {
      result = PerformSetIn (tokenno, Op1, Set->setValue);
    }
  else
    {
      M2Error_InternalError ((const char *) "one or more operands have not been resolved", 43);
    }
  Dispose (Set);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetOr -  performs an inclusive OR of the top two elements on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Set1       |                   <- Ptr
            |------------|    +------------+
            | Set2       |    | Set1 + Set2|
            |------------|    |------------|

*/

extern "C" void M2ALU_SetOr (unsigned int tokenno)
{
  SetOp (tokenno, (M2ALU_DoSetProcedure) {(M2ALU_DoSetProcedure_t) PerformOr});
}


/*
   SetAnd - performs a set AND the top two elements on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |                   <- Ptr
            |------------|    +------------+
            | Op2        |    | Op2 * Op1  |
            |------------|    |------------|
*/

extern "C" void M2ALU_SetAnd (unsigned int tokenno)
{
  SetOp (tokenno, (M2ALU_DoSetProcedure) {(M2ALU_DoSetProcedure_t) PerformAnd});
}


/*
   SetDifference - performs a set difference of the top two elements on the stack.
                   For each member in the set
                      if member in Op2 and not member in Op1

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +------------+
                   | Op1        |                   <- Ptr
                   |------------|    +-------------------+
                   | Op2        |    | Op2 and (not Op1) |
                   |------------|    |-------------------|
*/

extern "C" void M2ALU_SetDifference (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque Set1;
  M2ALU_PtrToValue__opaque Set2;

  Set1 = Pop ();
  Set2 = Pop ();
  Eval (tokenno, Set1);
  Eval (tokenno, Set2);
  if (! (Set1->solved && Set2->solved))
    {
      M2Error_InternalError ((const char *) "one or more operands have not been resolved", 43);
    }
  if (Set1->setValue == NULL)
    {
      /* null set, return Set2  */
      Push (Set1);
    }
  else
    {
      Push (Set1);
      M2ALU_SetNegate (tokenno);
      Push (Set2);
      M2ALU_SetAnd (tokenno);
    }
}


/*
   SetSymmetricDifference - performs a set difference of the top two elements on the stack.

                            The Stack:

                            Entry             Exit

                     Ptr ->
                            +------------+
                            | Op1        |                    <- Ptr
                            |------------|    +-------------+
                            | Op2        |    | Op2 xor Op1 |
                            |------------|    |-------------|
*/

extern "C" void M2ALU_SetSymmetricDifference (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque Set1;
  M2ALU_PtrToValue__opaque Set2;

  Set1 = Pop ();
  Set2 = Pop ();
  Eval (tokenno, Set1);
  Eval (tokenno, Set2);
  if (! (Set1->solved && Set2->solved))
    {
      M2Error_InternalError ((const char *) "one or more operands have not been resolved", 43);
    }
  if (Set1->setValue == NULL)
    {
      Dispose (Set1);
      Push (Set2);
    }
  else if (Set2->setValue == NULL)
    {
      /* avoid dangling else.  */
      Dispose (Set2);
      Push (Set1);
    }
  else
    {
      /* avoid dangling else.  */
      /* Set1 or Set2 and (not (Set1 and Set2))  */
      M2ALU_PushFrom (static_cast<M2ALU_PtrToValue> (Set1));
      M2ALU_PushFrom (static_cast<M2ALU_PtrToValue> (Set2));
      M2ALU_SetAnd (tokenno);
      M2ALU_SetNegate (tokenno);
      Push (Set1);
      Push (Set2);
      M2ALU_SetOr (tokenno);
      M2ALU_SetAnd (tokenno);
    }
}


/*
   SetNegate - negates the top set on the stack.

               Ptr ->                                               <- Ptr
                      +-----------+                  +------------+
                      | Set       |                  | Set        |
                      |-----------|                  |------------|
*/

extern "C" void M2ALU_SetNegate (unsigned int tokenno)
{
  unsigned int min;
  unsigned int max;
  M2ALU_listOfRange r;
  M2ALU_listOfRange s;
  M2ALU_PtrToValue__opaque v;
  unsigned int i;

  v = Pop ();
  Eval (tokenno, v);
  if (v->constructorType == SymbolTable_NulSym)
    {
      M2MetaError_MetaError0 ((const char *) "cannot negate a generic set, set should be prefixed by a simple type", 68);
    }
  r = NULL;
  min = M2GCCDeclare_GetTypeMin (SymbolTable_GetType (v->constructorType));
  max = M2GCCDeclare_GetTypeMax (SymbolTable_GetType (v->constructorType));
  i = min;
  s = v->setValue;
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "attempting to negate set\\n", 26);
      DisplayElements (s);
    }
  while (s != NULL)
    {
      SymbolTable_PushValue (s->low);
      SymbolTable_PushValue (min);
      if (M2ALU_Gre (tokenno))
        {
          SymbolTable_PushValue (i);
          SymbolTable_PushValue (max);
          if (M2ALU_LessEqu (tokenno))
            {
              r = AddRange (r, i, DupConst (tokenno, s->low, -1));
            }
        }
      SymbolTable_PushValue (s->high);
      SymbolTable_PushValue (max);
      if (M2ALU_Less (tokenno))
        {
          i = DupConst (tokenno, s->high, 1);
          s = s->next;
        }
      else
        {
          s = NULL;
        }
    }
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "negated set so far\\n", 20);
      DisplayElements (r);
    }
  DisposeRange (&v->setValue);
  SymbolTable_PushValue (i);
  SymbolTable_PushValue (max);
  if (M2ALU_LessEqu (tokenno))
    {
      r = AddRange (r, i, max);
    }
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "final negated set value\\n", 25);
      DisplayElements (r);
    }
  v->solved = false;
  v->setValue = r;
  Eval (tokenno, v);
  Push (v);
}


/*
   SetShift - if op1 is positive
              then
                 result := op2 << op1
              else
                 result := op2 >> op1
              fi


              The Stack:

                     Entry             Exit

              Ptr ->
                     +------------+
                     | Op1        |                   <- Ptr
                     |------------|    +------------+
                     | Op2        |    | result     |
                     |------------|    |------------|

*/

extern "C" void M2ALU_SetShift (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque res;
  M2ALU_PtrToValue__opaque Shift;
  M2ALU_PtrToValue__opaque Set;
  unsigned int n;
  unsigned int r1;
  unsigned int r2;

  if (! (M2ALU_IsValueTypeInteger ()))
    {
      M2Error_InternalError ((const char *) "expecting integer type", 22);
    }
  Shift = Pop ();
  if (! (M2ALU_IsValueTypeSet ()))
    {
      M2Error_InternalError ((const char *) "expecting set type", 18);
    }
  Set = Pop ();
  Eval (tokenno, Set);
  if (! Set->solved)
    {
      M2Error_InternalError ((const char *) "set has not been resolved", 25);
    }
  if (Set->setValue == NULL)
    {
      Push (Set);
    }
  else
    {
      res = New ();
      (*res) = (*Set);
      res->setValue = NULL;
      n = 1;
      while (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (Set), n, &r1, &r2))
        {
          res->setValue = AddRange (res->setValue, DupConstAndAdd (tokenno, r1, reinterpret_cast <tree> (Shift)), DupConstAndAdd (tokenno, r2, reinterpret_cast <tree> (Shift)));
          n += 1;
        }
      Push (res);
      if (res->constructorType != SymbolTable_NulSym)
        {
          M2ALU_PushNulSet (res->constructorType);
          M2ALU_SetNegate (tokenno);
          M2ALU_SetAnd (tokenno);
        }
      Dispose (Set);
    }
}


/*
   SetRotate - if op1 is positive
               then
                  result := ROTATERIGHT(op2, op1)
               else
                  result := ROTATELEFT(op2, op1)
               fi


               The Stack:

                      Entry             Exit

               Ptr ->
                      +------------+
                      | Op1        |                   <- Ptr
                      |------------|    +------------+
                      | Op2        |    | result     |
                      |------------|    |------------|
*/

extern "C" void M2ALU_SetRotate (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque res;
  M2ALU_PtrToValue__opaque Rotate;
  M2ALU_PtrToValue__opaque Set;
  unsigned int n;
  unsigned int l;
  unsigned int h;
  unsigned int type;
  unsigned int r1;
  unsigned int r2;

  if (! (M2ALU_IsValueTypeInteger ()))
    {
      M2Error_InternalError ((const char *) "expecting integer type", 22);
    }
  Rotate = Pop ();
  if (! (M2ALU_IsValueTypeSet ()))
    {
      M2Error_InternalError ((const char *) "expecting set type", 18);
    }
  Set = Pop ();
  Eval (tokenno, Set);
  if (! Set->solved)
    {
      M2Error_InternalError ((const char *) "set has not been resolved", 25);
    }
  if (Set->setValue == NULL)
    {
      Push (Set);
    }
  else
    {
      type = Set->constructorType;
      if (type == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrorT0 (tokenno, (const char *) "cannot perform a ROTATE on a generic set", 40);
          Push (Set);
          return;
        }
      l = M2GCCDeclare_GetTypeMin (type);
      h = M2GCCDeclare_GetTypeMax (type);
      res = New ();
      (*res) = (*Set);
      res->setValue = NULL;
      n = 1;
      while (M2ALU_GetRange (static_cast<M2ALU_PtrToValue> (Set), n, &r1, &r2))
        {
          res->setValue = AddRange (res->setValue, DupConstAndAddMod (tokenno, r1, reinterpret_cast <tree> (Rotate), l, h), DupConstAndAddMod (tokenno, r2, reinterpret_cast <tree> (Rotate), l, h));
          n += 1;
        }
      Push (res);
      Dispose (Set);
    }
}


/*
   GetValue - returns and pops the value from the top of stack.
*/

extern "C" M2ALU_PtrToValue M2ALU_GetValue (unsigned int tokenno)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  Eval (tokenno, v);
  return static_cast<M2ALU_PtrToValue> (v);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetRange - returns TRUE if range number, n, exists in the value, v.
              A non empty set is defined by having 1..N ranges
*/

extern "C" bool M2ALU_GetRange (M2ALU_PtrToValue v, unsigned int n, unsigned int *low, unsigned int *high)
{
  M2ALU_listOfRange l;

  if (static_cast<M2ALU_PtrToValue__opaque> (v)->type != M2ALU_set)
    {
      M2Error_InternalError ((const char *) "expecting set constant", 22);
    }
  l = static_cast<M2ALU_PtrToValue__opaque> (v)->setValue;
  while (n > 1)
    {
      if (l == NULL)
        {
          return false;
        }
      l = l->next;
      n -= 1;
    }
  if (l == NULL)
    {
      return false;
    }
  (*low) = l->low;
  (*high) = l->high;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstructSetConstant - builds a struct of integers which represents the
                          set const as defined by, v.
*/

extern "C" tree M2ALU_ConstructSetConstant (unsigned int tokenno, M2ALU_PtrToValue v)
{
  NameKey_Name n1;
  NameKey_Name n2;
  tree gccsym;
  unsigned int baseType;
  unsigned int high;
  unsigned int low;

  if (static_cast<M2ALU_PtrToValue__opaque> (v)->constructorType == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "set type must be known in order to generate a constant", 54);
    }
  else
    {
      baseType = SymbolTable_SkipType (SymbolTable_GetType (static_cast<M2ALU_PtrToValue__opaque> (v)->constructorType));
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (static_cast<M2ALU_PtrToValue__opaque> (v)->constructorType);
          n2 = SymbolTable_GetSymName (baseType);
          M2Printf_printf2 ((const char *) "ConstructSetConstant of type %a and baseType %a\\n", 49, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
      if (SymbolTable_IsSubrange (baseType))
        {
          SymbolTable_GetSubrange (baseType, &high, &low);
          gccsym = ConstructLargeOrSmallSet (tokenno, static_cast<M2ALU_PtrToValue__opaque> (v), low, high);
        }
      else
        {
          gccsym = ConstructLargeOrSmallSet (tokenno, static_cast<M2ALU_PtrToValue__opaque> (v), M2GCCDeclare_GetTypeMin (baseType), M2GCCDeclare_GetTypeMax (baseType));
        }
      return gccsym;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   BuildRange - returns a integer sized constant which represents the
                value  {e1..e2}.
*/

extern "C" tree M2ALU_BuildRange (unsigned int tokenno, tree e1, tree e2)
{
  tree c;
  tree i;
  tree t;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  M2ALU_PushIntegerTree (e1);
  M2ALU_PushIntegerTree (e2);
  if (M2ALU_Gre (tokenno))
    {
      c = e1;
      e1 = e2;
      e2 = c;
    }
  t = (tree) (NULL);
  M2ALU_PushIntegerTree (e1);
  i = M2ALU_PopIntegerTree ();
  do {
    if (t == ((tree) (NULL)))
      {
        t = m2expr_BuildLSL (location, m2expr_GetWordOne (location), m2convert_ToWord (location, i), false);
      }
    else
      {
        t = m2expr_BuildLogicalOr (location, t, m2expr_BuildLSL (location, m2expr_GetWordOne (location), m2convert_ToWord (location, i), false), false);
      }
    M2ALU_PushIntegerTree (i);
    M2ALU_PushIntegerTree (m2expr_GetIntegerOne (location));
    M2ALU_Addn ();
    i = M2ALU_PopIntegerTree ();
    M2ALU_PushIntegerTree (i);
    M2ALU_PushIntegerTree (e2);
  } while (! (M2ALU_Gre (tokenno)));
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstructorDependants - return TRUE if all q(dependants) of,
                             sym, return TRUE.
*/

extern "C" bool M2ALU_IsConstructorDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  M2ALU_PtrToValue__opaque v;
  bool typeResult;
  bool result;

  SymbolTable_PushValue (sym);
  if (M2ALU_IsValueTypeNone ())
    {
      v = Pop ();
      result = false;
    }
  else
    {
      v = Pop ();
      typeResult = (*q.proc) (v->constructorType);
      switch (v->type)
        {
          case M2ALU_none:
            result = false;
            break;

          case M2ALU_set:
            result = IsSetValueDependants (v->setValue, q);
            break;

          case M2ALU_constructor:
          case M2ALU_record:
            result = IsFieldValueDependants (v->fieldValues, q);
            break;

          case M2ALU_array:
            result = IsArrayValueDependants (v->arrayValues, q);
            break;


          default:
            M2Error_InternalError ((const char *) "not expecting this type", 23);
            break;
        }
      result = result && typeResult;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkConstructorDependants - walk the constructor, sym, calling
                               p for each dependant.
*/

extern "C" void M2ALU_WalkConstructorDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  M2ALU_PtrToValue__opaque v;

  SymbolTable_PushValue (sym);
  if (M2ALU_IsValueTypeNone ())
    {
      v = Pop ();
    }
  else
    {
      v = Pop ();
      (*p.proc) (v->constructorType);
      switch (v->type)
        {
          case M2ALU_none:
            break;

          case M2ALU_set:
            WalkSetValueDependants (v->setValue, p);
            break;

          case M2ALU_constructor:
          case M2ALU_record:
            WalkFieldValueDependants (v->fieldValues, p);
            break;

          case M2ALU_array:
            WalkArrayValueDependants (v->arrayValues, p);
            break;


          default:
            M2Error_InternalError ((const char *) "not expecting this type", 23);
            break;
        }
    }
}


/*
   IsValueAndTreeKnown - returns TRUE if the value is known and the gcc tree
                         is defined.

                         The Stack:

                                Entry             Exit

                         Ptr ->
                                +------------+
                                | Op1        |                   <- Ptr
                                |------------|    +------------+
*/

extern "C" bool M2ALU_IsValueAndTreeKnown (void)
{
  M2ALU_PtrToValue__opaque v;

  v = Pop ();
  if (v != NULL)
    {
      if (v->solved)
        {
          switch (v->type)
            {
              case M2ALU_integer:
              case M2ALU_real:
              case M2ALU_complex:
                if (v->numberValue == NULL)
                  {
                    Dispose (v);
                    return false;
                  }
                break;


              default:
                break;
            }
        }
      else
        {
          Dispose (v);
          return false;
        }
      Dispose (v);
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckOrResetOverflow - tests to see whether the tree, t, has caused
                          an overflow error and if so it generates an
                          error message.
*/

extern "C" void M2ALU_CheckOrResetOverflow (unsigned int tokenno, tree t, bool check)
{
  if (check)
    {
      CheckOverflow (tokenno, t);
    }
  else
    {
      t = m2expr_RemoveOverflow (t);
    }
}


/*
   AddElements - adds the elements, el BY, n, to the array constant.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Array      |      | Array      |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddElements (unsigned int tokenno, unsigned int el, unsigned int n)
{
  M2ALU_PtrToValue__opaque v;
  M2ALU_listOfElements e;

  v = Pop ();
  v = CoerseTo (tokenno, M2ALU_array, v);
  if (v->type == M2ALU_array)
    {
      NewElement (&e);
      e->element = el;
      e->by = n;
      e->next = NULL;
      AddElementToEnd (v, e);
      v->solved = (v->solved && (IsSolvedGCC (el))) && (IsSolvedGCC (n));
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting array type", 20);
    }
  Push (v);
}


/*
   AddField - adds the field op1 to the underlying constructor.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | const      |      | const      |
                        |------------|      |------------|

*/

extern "C" void M2ALU_AddField (unsigned int tokenno, unsigned int op1)
{
  M2ALU_PtrToValue__opaque v;
  M2ALU_listOfFields f;
  M2ALU_listOfElements e;

  v = Pop ();
  switch (v->type)
    {
      case M2ALU_set:
        Push (v);
        M2ALU_AddBit (tokenno, op1);
        return;
        break;

      case M2ALU_array:
        v->solved = v->solved && (IsSolvedGCC (op1));
        v->areAllConstants = v->areAllConstants && (SymbolTable_IsConst (op1));
        NewElement (&e);
        e->element = op1;
        e->by = SymbolTable_MakeConstLit (tokenno, NameKey_MakeKey ((const char *) "1", 1), M2Base_ZType);
        e->next = NULL;
        AddElementToEnd (v, e);
        break;

      case M2ALU_constructor:
      case M2ALU_record:
        v->solved = v->solved && (IsSolvedGCC (op1));
        v->areAllConstants = v->areAllConstants && (SymbolTable_IsConst (op1));
        NewField (&f);
        f->field = op1;
        f->next = NULL;
        AddFieldToEnd (v, f);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this constant type", 32);
        break;
    }
  Push (v);
}


/*
   PushEmptyConstructor - pushes an empty constructor {} onto the ALU stack.
                          This is expected to be filled in by subsequent
                          calls to AddElements, AddRange or AddField.

                          The Stack:

                          Entry             Exit

                                                       <- Ptr
                                        +------------+
                                        | {}         |
                   Ptr ->               |------------|

*/

extern "C" void M2ALU_PushEmptyConstructor (unsigned int constype)
{
  M2ALU_PtrToValue__opaque v;

  v = static_cast<M2ALU_PtrToValue__opaque> (M2ALU_InitValue ());
  v->type = M2ALU_constructor;
  v->constructorType = constype;
  v->areAllConstants = true;
  v->solved = M2GCCDeclare_CompletelyResolved (constype);
  v->fieldValues = NULL;
  v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  Push (v);
}


/*
   PushEmptyArray - pushes an empty array {} onto the ALU stack.
                    This is expected to be filled in by subsequent
                    calls to AddElements.

                    The Stack:

                    Entry             Exit

                                                     <- Ptr
                                      +------------+
                                      | {}         |
             Ptr ->                   |------------|

*/

extern "C" void M2ALU_PushEmptyArray (unsigned int arraytype)
{
  M2ALU_PtrToValue__opaque v;

  v = static_cast<M2ALU_PtrToValue__opaque> (M2ALU_InitValue ());
  v->type = M2ALU_array;
  v->constructorType = arraytype;
  v->areAllConstants = true;
  v->solved = M2GCCDeclare_CompletelyResolved (arraytype);
  v->arrayValues = NULL;
  v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  Push (v);
}


/*
   PushEmptyRecord - pushes an empty record {} onto the ALU stack.
                     This is expected to be filled in by subsequent
                     calls to AddField.

                     The Stack:

                     Entry             Exit

                                                      <- Ptr
                                       +------------+
                                       | {}         |
              Ptr ->                   |------------|

*/

extern "C" void M2ALU_PushEmptyRecord (unsigned int recordtype)
{
  M2ALU_PtrToValue__opaque v;

  v = static_cast<M2ALU_PtrToValue__opaque> (M2ALU_InitValue ());
  v->type = M2ALU_record;
  v->constructorType = recordtype;
  v->areAllConstants = true;
  v->solved = M2GCCDeclare_CompletelyResolved (recordtype);
  v->arrayValues = NULL;
  v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
  Push (v);
}


/*
   ChangeToConstructor - change the top of stack value to a constructor, type.
                         (Constructor, Set, Array or Record).
*/

extern "C" void M2ALU_ChangeToConstructor (unsigned int tokenno, unsigned int constype)
{
  M2ALU_PtrToValue__opaque v;

  if ((((M2ALU_IsValueTypeConstructor ()) || (M2ALU_IsValueTypeSet ())) || (M2ALU_IsValueTypeArray ())) || (M2ALU_IsValueTypeRecord ()))
    {
      return;
    }
  else if (M2ALU_IsValueTypeNone ())
    {
      /* avoid dangling else.  */
      v = Pop ();
      v->type = M2ALU_constructor;
      v->constructorType = constype;
      v->solved = M2GCCDeclare_CompletelyResolved (constype);
      v->fieldValues = NULL;
      v->next = static_cast<M2ALU_PtrToValue__opaque> (NULL);
      if (SymbolTable_IsSet (SymbolTable_SkipType (constype)))
        {
          v = CoerseTo (tokenno, M2ALU_set, v);
        }
      else if (SymbolTable_IsRecord (SymbolTable_SkipType (constype)))
        {
          /* avoid dangling else.  */
          v = CoerseTo (tokenno, M2ALU_record, v);
        }
      else if (SymbolTable_IsArray (SymbolTable_SkipType (constype)))
        {
          /* avoid dangling else.  */
          v = CoerseTo (tokenno, M2ALU_array, v);
        }
      Push (v);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "cannot change constant to a constructor type", 44);
    }
}


/*
   IsValueConst - returns true if the memory cell indicated by v
                  is only defined by constants.  For example
                  no variables are used in the constructor.
*/

extern "C" bool M2ALU_IsValueConst (M2ALU_PtrToValue v)
{
  if (v == NULL)
    {
      M2Error_InternalError ((const char *) "uninitialized value", 19);
    }
  else
    {
      return static_cast<M2ALU_PtrToValue__opaque> (v)->areAllConstants;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2ALU.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PushTypeOfTree - pushes tree, gcc, to the stack and records the
                    front end type.
*/

extern "C" void M2ALU_PushTypeOfTree (unsigned int sym, tree gcc)
{
  unsigned int t;

  t = SymbolTable_SkipType (SymbolTable_GetType (sym));
  if (t == SymbolTable_NulSym)
    {
      M2ALU_PushIntegerTree (gcc);
    }
  else if (M2Base_IsComplexType (t))
    {
      /* avoid dangling else.  */
      M2ALU_PushComplexTree (gcc);
    }
  else if (SymbolTable_IsArray (t))
    {
      /* avoid dangling else.  */
      PushGCCArrayTree (gcc, t);
    }
  else if (SymbolTable_IsSet (t))
    {
      /* avoid dangling else.  */
      PushGCCSetTree (gcc, t);
    }
  else if (SymbolTable_IsRecord (t))
    {
      /* avoid dangling else.  */
      PushGCCRecordTree (gcc, t);
    }
  else if (M2Base_IsRealType (t))
    {
      /* avoid dangling else.  */
      M2ALU_PushRealTree (gcc);
    }
  else
    {
      /* avoid dangling else.  */
      M2ALU_PushIntegerTree (gcc);
    }
}

extern "C" void _M2_M2ALU_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2ALU_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
