/* do not edit automatically generated by mc from SEnvironment.  */
/* SEnvironment.mod provides access to the environment of a process.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _SEnvironment_C

#include "GSEnvironment.h"
#   include "GDynamicStrings.h"
#   include "Glibc.h"


/*
   GetEnvironment - gets the environment variable Env and places
      	       	    a copy of its value into String, dest.
                    It returns TRUE if the string Env was found in
                    the processes environment.
*/

extern "C" bool SEnvironment_GetEnvironment (DynamicStrings_String Env, DynamicStrings_String *dest);

/*
   PutEnvironment - change or add an environment variable definition EnvDef.
                    TRUE is returned if the environment variable was
                    set or changed successfully.
*/

extern "C" bool SEnvironment_PutEnvironment (DynamicStrings_String EnvDef);


/*
   GetEnvironment - gets the environment variable Env and places
      	       	    a copy of its value into String, dest.
                    It returns TRUE if the string Env was found in
                    the processes environment.
*/

extern "C" bool SEnvironment_GetEnvironment (DynamicStrings_String Env, DynamicStrings_String *dest)
{
  typedef char *GetEnvironment__T1;

  GetEnvironment__T1 Addr;

  if (Env == NULL)
    {
      (*dest) = static_cast<DynamicStrings_String> (NULL);
      return false;
    }
  else
    {
      Addr = static_cast<GetEnvironment__T1> (libc_getenv (DynamicStrings_string (Env)));
      if (Addr == NULL)
        {
          (*dest) = static_cast<DynamicStrings_String> (NULL);
          return false;
        }
      else
        {
          (*dest) = DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (Addr));
          return true;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutEnvironment - change or add an environment variable definition EnvDef.
                    TRUE is returned if the environment variable was
                    set or changed successfully.
*/

extern "C" bool SEnvironment_PutEnvironment (DynamicStrings_String EnvDef)
{
  return (libc_putenv (DynamicStrings_string (EnvDef))) == 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_SEnvironment_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_SEnvironment_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
