/* do not edit automatically generated by mc from SymbolTable.  */
/* SymbolTable.def provides access to the symbol table.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_SymbolTable_H)
#   define _SymbolTable_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GSymbolKey.h"
#   include "GNameKey.h"
#   include "Ggcctypes.h"
#   include "GDynamicStrings.h"
#   include "GM2Error.h"
#   include "GLists.h"

#   if defined (_SymbolTable_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#   define SymbolTable_NulSym 0
typedef struct SymbolTable_FamilyOperation_p SymbolTable_FamilyOperation;

typedef enum {SymbolTable_NoValue, SymbolTable_ImmediateValue, SymbolTable_RightValue, SymbolTable_LeftValue} SymbolTable_ModeOfAddr;

typedef enum {SymbolTable_ProperProcedure, SymbolTable_ForwardProcedure, SymbolTable_DefProcedure} SymbolTable_ProcedureKind;

typedef void (*SymbolTable_FamilyOperation_t) (unsigned int, unsigned int, unsigned int);
struct SymbolTable_FamilyOperation_p { SymbolTable_FamilyOperation_t proc; };


/*
   FinalSymbol - returns the highest number symbol used.
*/

EXTERN unsigned int SymbolTable_FinalSymbol (void);

/*
   MakeComponentRecord - make a temporary which will be used to reference and field
                         (or sub field) of record.
*/

EXTERN unsigned int SymbolTable_MakeComponentRecord (unsigned int tok, SymbolTable_ModeOfAddr Mode, unsigned int record);

/*
   MakeComponentRef - use, sym, to reference, field, sym is returned.
*/

EXTERN unsigned int SymbolTable_MakeComponentRef (unsigned int sym, unsigned int field);

/*
   IsComponent - returns TRUE if symbol, sym, is a temporary and a component
                 reference.
*/

EXTERN bool SymbolTable_IsComponent (unsigned int sym);

/*
   MakeTemporary - makes a new temporary variable at the highest real scope.
                   The addressing mode of the temporary is set to Mode.
*/

EXTERN unsigned int SymbolTable_MakeTemporary (unsigned int tok, SymbolTable_ModeOfAddr Mode);

/*
   MakeTemporaryFromExpression - makes a new temporary variable at the
                                 highest real scope.  The addressing
                                 mode of the temporary is set and the
                                 type is determined by expressions, e.
*/

EXTERN unsigned int SymbolTable_MakeTemporaryFromExpression (unsigned int tok, unsigned int e, SymbolTable_ModeOfAddr mode);

/*
   MakeTemporaryFromExpressions - makes a new temporary variable at the
                                  highest real scope.  The addressing
                                  mode of the temporary is set and the
                                  type is determined by expressions,
                                  e1 and e2.
*/

EXTERN unsigned int SymbolTable_MakeTemporaryFromExpressions (unsigned int tok, unsigned int e1, unsigned int e2, SymbolTable_ModeOfAddr mode);

/*
   PutMode - Puts the addressing mode, SymMode, into symbol Sym.
      	     The mode may only be altered if the mode is None.
*/

EXTERN void SymbolTable_PutMode (unsigned int Sym, SymbolTable_ModeOfAddr SymMode);

/*
   GetMode - Returns the addressing mode of a symbol.
*/

EXTERN SymbolTable_ModeOfAddr SymbolTable_GetMode (unsigned int Sym);

/*
   StartScope - starts a block scope at Sym.
*/

EXTERN void SymbolTable_StartScope (unsigned int Sym);

/*
   EndScope - ends a block scope started by StartScope. The current
              head of the symbol scope reverts back to the symbol
              which was the Head of the symbol scope before the
              last StartScope was called.
*/

EXTERN void SymbolTable_EndScope (void);

/*
   PseudoScope - starts a pseudo scope. This is used to implement
                 enumeration types. It is nesessary since the
                 enumeration type does not have an explicit
                 structure, as opposed to RECORD, WITH, MODULE and
                 PROCEDURE. Therefore there is no explicit end and
                 hence the end of an outer scope would cause the
                 end of the enumeration scope. Thus we need to have
                 a pseudo scope which will be treated the same
                 during the search of a symbol, but will be popped
                 automatically when the EndScope calls - for a
                 structured scope end.
*/

EXTERN void SymbolTable_PseudoScope (unsigned int Sym);

/*
   GetCurrentScope - returns the symbol who is responsible for the current
                     scope. Note that it ignores pseudo scopes.
*/

EXTERN unsigned int SymbolTable_GetCurrentScope (void);

/*
   IsDeclaredIn - returns TRUE if a symbol was declared in, scope.
*/

EXTERN bool SymbolTable_IsDeclaredIn (unsigned int scope, unsigned int sym);

/*
   SetCurrentModule - Used to set the CurrentModule to a symbol, Sym.
                      This Sym may represent an inner module.
*/

EXTERN void SymbolTable_SetCurrentModule (unsigned int Sym);

/*
   SetFileModule - Used to set the FileModule to a symbol, Sym.
                   This Sym must represent the current program module
                   file which is being parsed.
*/

EXTERN void SymbolTable_SetFileModule (unsigned int Sym);

/*
   SetMainModule - Used to set the MainModule to a symbol, Sym.
                   This Sym must represent the main module which was
                   envoked by the user to be compiled.
*/

EXTERN void SymbolTable_SetMainModule (unsigned int Sym);

/*
   CheckAnonymous - checks to see whether the name is NulName and if so
                    it creates a unique anonymous name.
*/

EXTERN NameKey_Name SymbolTable_CheckAnonymous (NameKey_Name name);

/*
   IsNameAnonymous - returns TRUE if the symbol, sym, has an anonymous name
                     or no name.
*/

EXTERN bool SymbolTable_IsNameAnonymous (unsigned int sym);

/*
   NoOfVariables - returns the number of variables in scope.  The scope maybe
                   a procedure, module or defimp scope.
*/

EXTERN unsigned int SymbolTable_NoOfVariables (unsigned int scope);

/*
   MakeModule - creates a module sym with ModuleName. It returns the
                symbol index.
*/

EXTERN unsigned int SymbolTable_MakeModule (unsigned int tok, NameKey_Name ModuleName);

/*
   MakeDefImp - creates a definition and implementation module sym
                with name DefImpName. It returns the symbol index.
*/

EXTERN unsigned int SymbolTable_MakeDefImp (unsigned int tok, NameKey_Name DefImpName);

/*
   MakeInnerModule - creates an inner module sym with ModuleName. It returns the
                     symbol index.
*/

EXTERN unsigned int SymbolTable_MakeInnerModule (unsigned int tok, NameKey_Name ModuleName);

/*
   MakeProcedure - creates a procedure sym with name. It returns
                   the symbol index.
*/

EXTERN unsigned int SymbolTable_MakeProcedure (unsigned int tok, NameKey_Name ProcedureName);

/*
   MakeProcedureCtorExtern - creates an extern ctor procedure
*/

EXTERN unsigned int SymbolTable_MakeProcedureCtorExtern (unsigned int tokenno, NameKey_Name libname, NameKey_Name modulename);

/*
   PutLibName - places libname into defimp or module sym.
*/

EXTERN void SymbolTable_PutLibName (unsigned int sym, NameKey_Name libname);

/*
   GetLibName - returns libname associated with a defimp or module sym.
*/

EXTERN NameKey_Name SymbolTable_GetLibName (unsigned int sym);

/*
   PutMonoName - changes the IsMonoName boolean inside the procedure.
*/

EXTERN void SymbolTable_PutMonoName (unsigned int sym, bool value);

/*
   IsMonoName - returns the public boolean associated with a procedure.
*/

EXTERN bool SymbolTable_IsMonoName (unsigned int sym);

/*
   PutExtern - changes the extern boolean inside the procedure.
*/

EXTERN void SymbolTable_PutExtern (unsigned int sym, bool value);

/*
   IsExtern - returns the public boolean associated with a procedure.
*/

EXTERN bool SymbolTable_IsExtern (unsigned int sym);

/*
   PutPublic - changes the public boolean inside the procedure.
*/

EXTERN void SymbolTable_PutPublic (unsigned int sym, bool value);

/*
   IsPublic - returns the public boolean associated with a procedure.
*/

EXTERN bool SymbolTable_IsPublic (unsigned int sym);

/*
   PutCtor - changes the ctor boolean inside the procedure.
*/

EXTERN void SymbolTable_PutCtor (unsigned int sym, bool value);

/*
   IsCtor - returns the ctor boolean associated with a procedure.
*/

EXTERN bool SymbolTable_IsCtor (unsigned int sym);

/*
   GetModuleCtors - mod can be a DefImp or Module symbol.  ctor, init and fini
                    are assigned for this module.  An inner module ctor value will
                    be NulSym.
*/

EXTERN void SymbolTable_GetModuleCtors (unsigned int mod, unsigned int *ctor, unsigned int *init, unsigned int *fini, unsigned int *dep);

/*
   MakeModuleCtor - for a defimp or module symbol create all the ctor
                    related procedures.
*/

EXTERN void SymbolTable_MakeModuleCtor (unsigned int moduleTok, unsigned int beginTok, unsigned int finallyTok, unsigned int moduleSym);

/*
   PutModuleCtorExtern - for every ctor related procedure in module sym.
                         Make it external.  It will create any missing
                         init/fini procedures but not any missing dep/ctor
                         procedures.
*/

EXTERN void SymbolTable_PutModuleCtorExtern (unsigned int tok, unsigned int sym, bool external);

/*
   PutVarHeap - assigns ArrayRef field with value.
*/

EXTERN void SymbolTable_PutVarHeap (unsigned int sym, bool value);

/*
   IsVarHeap - returns ArrayRef field value.
*/

EXTERN bool SymbolTable_IsVarHeap (unsigned int sym);

/*
   MakeVar - creates a variable sym with VarName. It returns the
             symbol index.
*/

EXTERN unsigned int SymbolTable_MakeVar (unsigned int tok, NameKey_Name VarName);

/*
   PutVarConditional - assign IsConditional to value.
*/

EXTERN void SymbolTable_PutVarConditional (unsigned int sym, bool value);

/*
   IsVarConditional - return TRUE if the symbol is a var symbol
                      containing the result of a boolean conditional.
*/

EXTERN bool SymbolTable_IsVarConditional (unsigned int sym);

/*
   MakeRecord - makes a Record symbol with name RecordName.
*/

EXTERN unsigned int SymbolTable_MakeRecord (unsigned int tok, NameKey_Name RecordName);

/*
   MakeVarient - creates a new symbol, a varient symbol for record or varient field
                 symbol, RecOrVarFieldSym.
*/

EXTERN unsigned int SymbolTable_MakeVarient (unsigned int tok, unsigned int RecOrVarFieldSym);

/*
   MakeFieldVarient - returns a FieldVarient symbol which has been
                      assigned to the Varient symbol, Sym.
*/

EXTERN unsigned int SymbolTable_MakeFieldVarient (NameKey_Name n, unsigned int Sym);

/*
   MakeEnumeration - places a new symbol in the current scope, the symbol
                     is an enumeration symbol. The symbol index is returned.
*/

EXTERN unsigned int SymbolTable_MakeEnumeration (unsigned int tok, NameKey_Name EnumerationName);

/*
   MakeType - makes a type symbol with name TypeName.
*/

EXTERN unsigned int SymbolTable_MakeType (unsigned int tok, NameKey_Name TypeName);

/*
   MakeHiddenType - makes a type symbol that is hidden from the
                    definition module.
                    This symbol is placed into the UnImplemented list of
                    the definition/implementation module.
                    The type will be filled in when the implementation module
                    is reached.
*/

EXTERN unsigned int SymbolTable_MakeHiddenType (unsigned int tok, NameKey_Name TypeName);

/*
   MakeConstant - create a constant cardinal and return the symbol.
*/

EXTERN unsigned int SymbolTable_MakeConstant (unsigned int tok, unsigned int value);

/*
   MakeConstLit - returns a constant literal of type, constType, with a constName,
                  at location, tok.
*/

EXTERN unsigned int SymbolTable_MakeConstLit (unsigned int tok, NameKey_Name constName, unsigned int constType);

/*
   MakeConstVar - makes a ConstVar type with name ConstVarName.
*/

EXTERN unsigned int SymbolTable_MakeConstVar (unsigned int tok, NameKey_Name ConstVarName);

/*
   MakeConstString - create a string constant in the symboltable.
*/

EXTERN unsigned int SymbolTable_MakeConstString (unsigned int tok, NameKey_Name ConstName);

/*
   MakeConstStringCnul - creates a constant string nul terminated string suitable for C.
                         If known is TRUE then name is assigned to the contents
                         and the escape sequences will be converted into characters.
*/

EXTERN unsigned int SymbolTable_MakeConstStringCnul (unsigned int tok, NameKey_Name name, bool known);

/*
   MakeConstStringM2nul - creates a constant string nul terminated string suitable for M2.
                          If known is TRUE then name is assigned to the contents
                          however the escape sequences are not converted into characters.
*/

EXTERN unsigned int SymbolTable_MakeConstStringM2nul (unsigned int tok, NameKey_Name name, bool known);

/*
   PutConstStringKnown - if sym is a constvar then convert it into a conststring.
                         If known is FALSE then contents is ignored and NulName is
                         stored.  If escape is TRUE then the contents will have
                         any escape sequences converted into single characters.
*/

EXTERN void SymbolTable_PutConstStringKnown (unsigned int tok, unsigned int sym, NameKey_Name contents, bool escape, bool known);

/*
   CopyConstString - copies string contents from expr to des
                     and retain the kind of string.
*/

EXTERN void SymbolTable_CopyConstString (unsigned int tok, unsigned int des, unsigned int expr);

/*
   IsConstStringKnown - returns TRUE if sym is a const string
                        and the contents are known.
*/

EXTERN bool SymbolTable_IsConstStringKnown (unsigned int sym);

/*
   IsConstStringM2 - returns whether this conststring is a
                     Modula-2 string.
*/

EXTERN bool SymbolTable_IsConstStringM2 (unsigned int sym);

/*
   IsConstStringC - returns whether this conststring is a C style string
                    which will have any escape translated.
*/

EXTERN bool SymbolTable_IsConstStringC (unsigned int sym);

/*
   IsConstStringM2nul - returns whether this conststring is a Modula-2 string which
                        contains a nul terminator.
*/

EXTERN bool SymbolTable_IsConstStringM2nul (unsigned int sym);

/*
   IsConstStringCnul - returns whether this conststring is a C style string
                       which will have any escape translated and also contains
                       a nul terminator.
*/

EXTERN bool SymbolTable_IsConstStringCnul (unsigned int sym);

/*
   MakeSubrange - makes a new symbol into a subrange type with
                  name SubrangeName.
*/

EXTERN unsigned int SymbolTable_MakeSubrange (unsigned int tok, NameKey_Name SubrangeName);

/*
   MakeSet - makes a set Symbol with name, SetName.
*/

EXTERN unsigned int SymbolTable_MakeSet (unsigned int tok, NameKey_Name SetName);

/*
   MakeArray - makes an Array symbol with name ArrayName.
*/

EXTERN unsigned int SymbolTable_MakeArray (unsigned int tok, NameKey_Name ArrayName);

/*
   PutArrayLarge - indicates that this is a large array in which case
                   the interface to gcc maps this array from 0..high-low,
                   using an integer indice.
*/

EXTERN void SymbolTable_PutArrayLarge (unsigned int array);

/*
   IsArrayLarge - returns TRUE if we need to treat this as a large array.
*/

EXTERN bool SymbolTable_IsArrayLarge (unsigned int array);

/*
   PutPriority - places a interrupt, priority, value into module, module.
*/

EXTERN void SymbolTable_PutPriority (unsigned int module, unsigned int priority);

/*
   GetPriority - returns the interrupt priority which was assigned to
                 module, module.
*/

EXTERN unsigned int SymbolTable_GetPriority (unsigned int module);

/*
   PutNeedSavePriority - set a boolean flag indicating that this procedure
                         needs to save and restore interrupts.
*/

EXTERN void SymbolTable_PutNeedSavePriority (unsigned int sym);

/*
   GetNeedSavePriority - returns the boolean flag indicating whether this procedure
                         needs to save and restore interrupts.
*/

EXTERN bool SymbolTable_GetNeedSavePriority (unsigned int sym);

/*
   PutVariableAtAddress - determines that a variable, sym, is declared at
                          a specific address.
*/

EXTERN void SymbolTable_PutVariableAtAddress (unsigned int sym, unsigned int address);

/*
   GetVariableAtAddress - returns the address at which variable, sym, is declared.
*/

EXTERN unsigned int SymbolTable_GetVariableAtAddress (unsigned int sym);

/*
   IsVariableAtAddress - returns TRUE if a variable, sym, was declared at
                         a specific address.
*/

EXTERN bool SymbolTable_IsVariableAtAddress (unsigned int sym);

/*
   PutVariableSSA - assigns value to the SSA field within variable sym.
*/

EXTERN void SymbolTable_PutVariableSSA (unsigned int sym, bool value);

/*
   IsVariableSSA - returns TRUE if variable is known to be a SSA.
*/

EXTERN bool SymbolTable_IsVariableSSA (unsigned int sym);

/*
   PutVarConst - sets the IsConst field to value indicating the variable is read only.
*/

EXTERN void SymbolTable_PutVarConst (unsigned int sym, bool value);

/*
   MakeGnuAsm - create a GnuAsm symbol.
*/

EXTERN unsigned int SymbolTable_MakeGnuAsm (void);

/*
   PutGnuAsm - places the instruction textual name into the GnuAsm symbol.
*/

EXTERN void SymbolTable_PutGnuAsm (unsigned int sym, unsigned int string);

/*
   PutGnuAsmOutput - places the interface object, out, into GnuAsm symbol, sym.
*/

EXTERN void SymbolTable_PutGnuAsmOutput (unsigned int sym, unsigned int out);

/*
   PutGnuAsmInput - places the interface object, in, into GnuAsm symbol, sym.
*/

EXTERN void SymbolTable_PutGnuAsmInput (unsigned int sym, unsigned int in);

/*
   PutGnuAsmTrash - places the interface object, trash, into GnuAsm symbol, sym.
*/

EXTERN void SymbolTable_PutGnuAsmTrash (unsigned int sym, unsigned int trash);

/*
   GetGnuAsm - returns the string symbol, representing the instruction textual
               of the GnuAsm symbol. It will return a ConstString.
*/

EXTERN unsigned int SymbolTable_GetGnuAsm (unsigned int sym);

/*
   GetGnuAsmInput - returns the input list of registers.
*/

EXTERN unsigned int SymbolTable_GetGnuAsmInput (unsigned int sym);

/*
   GetGnuAsmOutput - returns the output list of registers.
*/

EXTERN unsigned int SymbolTable_GetGnuAsmOutput (unsigned int sym);

/*
   GetGnuAsmTrash - returns the list of trashed registers.
*/

EXTERN unsigned int SymbolTable_GetGnuAsmTrash (unsigned int sym);

/*
   PutGnuAsmVolatile - defines a GnuAsm symbol as VOLATILE.
*/

EXTERN void SymbolTable_PutGnuAsmVolatile (unsigned int Sym);

/*
   PutGnuAsmSimple - defines a GnuAsm symbol as a simple kind.
*/

EXTERN void SymbolTable_PutGnuAsmSimple (unsigned int Sym);

/*
   MakeRegInterface - creates and returns a register interface symbol.
*/

EXTERN unsigned int SymbolTable_MakeRegInterface (void);

/*
   PutRegInterface - places a, name, string, and, object, into the interface array,
                     sym, at position, i.
                     The string symbol will either be a register name or a constraint.
                     The object is an optional Modula-2 variable or constant symbol.
                     read and write are the quadruple numbers representing any read
                     or write operation.
*/

EXTERN void SymbolTable_PutRegInterface (unsigned int tok, unsigned int sym, unsigned int i, NameKey_Name n, unsigned int string, unsigned int object, unsigned int read_, unsigned int write_);

/*
   GetRegInterface - gets a, name, string, and, object, from the interface array,
                     sym, from position, i.
*/

EXTERN void SymbolTable_GetRegInterface (unsigned int sym, unsigned int i, unsigned int *tok, NameKey_Name *n, unsigned int *string, unsigned int *object);

/*
   GetModule - Returns the Module symbol for the module with name, n.
*/

EXTERN unsigned int SymbolTable_GetModule (NameKey_Name name);

/*
   GetCurrentModule - returns the current module Sym that is being
                      compiled. It may return an inner module.
*/

EXTERN unsigned int SymbolTable_GetCurrentModule (void);

/*
   GetFileModule - returns the FileModule symbol that was requested by
                   the user to be compiled.
*/

EXTERN unsigned int SymbolTable_GetFileModule (void);

/*
   GetBaseModule - returns the base module symbol that contains Modula-2
                   base types, procedures and functions.
*/

EXTERN unsigned int SymbolTable_GetBaseModule (void);

/*
   GetMainModule - returns the main module symbol that was requested by
                   the user to be compiled.
*/

EXTERN unsigned int SymbolTable_GetMainModule (void);

/*
   GetCurrentModuleScope - returns the module symbol which forms the
                           current (possibly inner most) module.
*/

EXTERN unsigned int SymbolTable_GetCurrentModuleScope (void);

/*
   GetLastModuleScope - returns the last module scope encountered,
                        the module scope before the Current Module Scope.
*/

EXTERN unsigned int SymbolTable_GetLastModuleScope (void);

/*
   AddSymToModuleScope - adds a symbol, Sym, to the scope of the module
                         ModSym.
*/

EXTERN void SymbolTable_AddSymToModuleScope (unsigned int ModSym, unsigned int Sym);

/*
   GetType - Returns the symbol that is the TYPE symbol to Sym.
             If NulSym is returned then we assume type unknown.
*/

EXTERN unsigned int SymbolTable_GetType (unsigned int Sym);

/*
   SkipType - if sym is a TYPE foo = bar
              then call SkipType(bar)
              else return sym

              it does not skip over hidden types.
*/

EXTERN unsigned int SymbolTable_SkipType (unsigned int Sym);

/*
   SkipTypeAndSubrange - if sym is a TYPE foo = bar OR
                            sym is declared as a subrange of bar
                         then call SkipTypeAndSubrange(bar)
                         else return sym

                         it does not skip over hidden types.
*/

EXTERN unsigned int SymbolTable_SkipTypeAndSubrange (unsigned int Sym);

/*
   GetLowestType - Returns the lowest type in the type chain of
                   symbol Sym.
                   If NulSym is returned then we assume type unknown.
*/

EXTERN unsigned int SymbolTable_GetLowestType (unsigned int Sym);

/*
   GetLType - get lowest type.  It returns the lowest type
              of symbol, sym.  It skips over type equivalences.
*/

EXTERN unsigned int SymbolTable_GetLType (unsigned int sym);

/*
   GetSType - get source type.  It returns the type closest
              to the object.  It does not skip over type
              equivalences.
*/

EXTERN unsigned int SymbolTable_GetSType (unsigned int sym);

/*
   GetDType - get gcc declared type.  It returns the type
              of the object which is declared to GCC.
              It does skip over type equivalences but only
              if they do not contain a user alignment.
              It does not skip over hidden types.

              This is the same as SkipType(GetType(sym))
*/

EXTERN unsigned int SymbolTable_GetDType (unsigned int sym);

/*
   GetTypeMode - return the type of sym, it returns Address is the
                 symbol is a LValue.
*/

EXTERN unsigned int SymbolTable_GetTypeMode (unsigned int sym);

/*
   GetSym - searches the current scope (and previous scopes if the
            scope tranparent allows) for a symbol with Name.
*/

EXTERN unsigned int SymbolTable_GetSym (NameKey_Name name);

/*
   GetDeclareSym - searches for a symbol with a name SymName in the
                   current and previous scopes.
                   If the symbol is found then it is returned
                   else an unknown symbol is returned.
                   This procedure assumes that SymName is being
                   declared at this point and therefore it does
                   not examine the base scope (for pervasive
                   identifiers).
*/

EXTERN unsigned int SymbolTable_GetDeclareSym (unsigned int tok, NameKey_Name SymName);

/*
   GetLocalSym - only searches the scope Sym for a symbol with Name
                 and returns the index to the symbol.
*/

EXTERN unsigned int SymbolTable_GetLocalSym (unsigned int Sym, NameKey_Name name);

/*
   GetRecord - fetches the record symbol from the parent of Sym.
               Sym maybe a varient symbol in which case its parent is searched
               etc.
*/

EXTERN unsigned int SymbolTable_GetRecord (unsigned int Sym);

/*
   FromModuleGetSym - attempts to find a symbol of name, n, in the
                      module, mod, scope.  An unknown symbol is created
                      at token position tok if necessary.
*/

EXTERN unsigned int SymbolTable_FromModuleGetSym (unsigned int tok, NameKey_Name n, unsigned int mod);

/*
   GetNth - returns the n th symbol in the list associated with the scope
            of Sym.  Sym may be a Module, DefImp, Procedure, Record or
            Enumeration symbol.
*/

EXTERN unsigned int SymbolTable_GetNth (unsigned int Sym, unsigned int n);

/*
   GetNthParam - returns the n th parameter in procedure Sym.
                 Sym may be an ordinary procedure or a
                 procedure variable.
                 ParamNo of zero yields the return argument
                 if the procedure is a function.
                 NOTE that this is returned as a type NOT
                 a parameter.
*/

EXTERN unsigned int SymbolTable_GetNthParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);

/*
   GetVarScope - returns the symbol definining the scope where, Sym, was declared.
                 ie a Module, DefImp or Procedure Symbol.
*/

EXTERN unsigned int SymbolTable_GetVarScope (unsigned int Sym);

/*
   GetSubrange - returns HighSym and LowSym - two constants
                 which make up the subrange.
*/

EXTERN void SymbolTable_GetSubrange (unsigned int Sym, unsigned int *HighSym, unsigned int *LowSym);

/*
   GetParam - returns the ParamNo parameter from procedure ProcSym
*/

EXTERN unsigned int SymbolTable_GetParam (unsigned int Sym, unsigned int ParamNo);

/*
   GetString - returns the actual string key for ConstString symbol Sym,
               which is not necessarily the same as its name.
               ie CONST
                     hello = 'HELLO' ;      Name = hello, string = HELLO
                     GetString returns HELLO

               and simply 'Hello World'     Name will be same
                     GetString returns Hello World
*/

EXTERN NameKey_Name SymbolTable_GetString (unsigned int Sym);

/*
   GetStringLength - returns the actual string length for ConstString
                     symbol sym.
*/

EXTERN unsigned int SymbolTable_GetStringLength (unsigned int tok, unsigned int sym);

/*
   GetProcedureBuiltin - returns the builtin name for the equivalent procedure, Sym.
*/

EXTERN NameKey_Name SymbolTable_GetProcedureBuiltin (unsigned int Sym);

/*
   PutProcedureBuiltin - assigns the builtin name for the equivalent procedure, Sym.
*/

EXTERN void SymbolTable_PutProcedureBuiltin (unsigned int Sym, NameKey_Name name);

/*
   IsProcedureBuiltin - returns TRUE if this procedure has a builtin equivalent.
*/

EXTERN bool SymbolTable_IsProcedureBuiltin (unsigned int Sym);

/*
   PutProcedureInline - determines that procedure, Sym, has been requested to be inlined.
*/

EXTERN void SymbolTable_PutProcedureInline (unsigned int Sym);

/*
   IsProcedureInline - returns TRUE if this procedure was declared as inlined.
*/

EXTERN bool SymbolTable_IsProcedureInline (unsigned int Sym);

/*
   PutExceptionBlock - sets a BOOLEAN in block module/procedure/defimp,
                       sym, indicating that this block as an EXCEPT
                       statement sequence.
*/

EXTERN void SymbolTable_PutExceptionBlock (unsigned int sym);

/*
   HasExceptionBlock - returns a BOOLEAN determining whether
                       module/procedure/defimp, sym, has
                       an EXCEPT statement sequence.
*/

EXTERN bool SymbolTable_HasExceptionBlock (unsigned int sym);

/*
   PutExceptionFinally - sets a BOOLEAN in block module/defimp,
                         sym, indicating that this FINALLY block
                         as an EXCEPT statement sequence.
*/

EXTERN void SymbolTable_PutExceptionFinally (unsigned int sym);

/*
   HasExceptionFinally - returns a BOOLEAN determining whether
                         module/defimp, sym, has
                         an EXCEPT statement sequence.
*/

EXTERN bool SymbolTable_HasExceptionFinally (unsigned int sym);

/*
   PutVar - gives the variable symbol Sym a type VarType.
*/

EXTERN void SymbolTable_PutVar (unsigned int Sym, unsigned int VarType);

/*
   PutVarTok - gives the VarSym symbol Sym a type Type at typetok.
*/

EXTERN void SymbolTable_PutVarTok (unsigned int Sym, unsigned int VarType, unsigned int typetok);

/*
   PutLeftValueFrontBackType - gives the variable symbol a front and backend type.
                               The variable must be a LeftValue.
*/

EXTERN void SymbolTable_PutLeftValueFrontBackType (unsigned int Sym, unsigned int FrontType, unsigned int BackType);

/*
   GetVarBackEndType - returns the back end type if specified.
*/

EXTERN unsigned int SymbolTable_GetVarBackEndType (unsigned int Sym);

/*
   PutVarPointerCheck - marks variable, sym, as requiring (or not
                        depending upon the, value), a NIL pointer check
                        when this symbol is dereferenced.
*/

EXTERN void SymbolTable_PutVarPointerCheck (unsigned int sym, bool value);

/*
   GetVarPointerCheck - returns TRUE if this symbol is a variable and
                        has been marked as needing a pointer via NIL check.
*/

EXTERN bool SymbolTable_GetVarPointerCheck (unsigned int sym);

/*
   PutVarWritten - marks variable, sym, as being written to (or not
                   depending upon the, value).
*/

EXTERN void SymbolTable_PutVarWritten (unsigned int sym, bool value);

/*
   GetVarWritten - returns TRUE if this symbol is a variable and
                   has been marked as being written.
*/

EXTERN bool SymbolTable_GetVarWritten (unsigned int sym);

/*
   PutConst - gives the constant symbol Sym a type ConstType.
*/

EXTERN void SymbolTable_PutConst (unsigned int Sym, unsigned int ConstType);

/*
   PutConstSet - informs the constant symbol, sym, that it is or will contain
                 a set value.
*/

EXTERN void SymbolTable_PutConstSet (unsigned int Sym);

/*
   IsConstSet - returns TRUE if the constant is declared as a set.
*/

EXTERN bool SymbolTable_IsConstSet (unsigned int Sym);

/*
   PutConstructor - informs the symbol sym that this will be
                    a constructor constant.
*/

EXTERN void SymbolTable_PutConstructor (unsigned int Sym);

/*
   PutConstructorFrom - sets the from type field in constructor
                        Sym to from.
*/

EXTERN void SymbolTable_PutConstructorFrom (unsigned int Sym, unsigned int from);

/*
   PutFieldRecord - places a field, FieldName and FieldType into a record, Sym.
                    VarSym is a optional varient symbol which can be returned
                    by a call to GetVarient(fieldsymbol).  The created field
                    is returned.
*/

EXTERN unsigned int SymbolTable_PutFieldRecord (unsigned int Sym, NameKey_Name FieldName, unsigned int FieldType, unsigned int VarSym);

/*
   PutFieldVarient - places the field varient, Field, as a brother to, the
                     varient symbol, sym.
*/

EXTERN void SymbolTable_PutFieldVarient (unsigned int Field, unsigned int Sym);

/*
   GetVarient - returns the varient symbol associated with the
                record or varient field symbol, Field.
*/

EXTERN unsigned int SymbolTable_GetVarient (unsigned int Field);

/*
   IsRecordFieldAVarientTag - returns TRUE if record field, sym, is
                              a varient tag.
*/

EXTERN bool SymbolTable_IsRecordFieldAVarientTag (unsigned int sym);

/*
   IsEmptyFieldVarient - returns TRUE if the field variant has
                         no fields.  This will occur then the
                         compiler constructs 'else end' variants.
*/

EXTERN bool SymbolTable_IsEmptyFieldVarient (unsigned int sym);

/*
   GetVarientTag - returns the varient tag from, Sym.
*/

EXTERN unsigned int SymbolTable_GetVarientTag (unsigned int Sym);

/*
   PutVarientTag - places, Tag, into varient, Sym.
*/

EXTERN void SymbolTable_PutVarientTag (unsigned int Sym, unsigned int Tag);

/*
   PutFieldEnumeration - places a field into the enumeration type
                         Sym. The field has a name FieldName and a
                         value FieldVal.
*/

EXTERN void SymbolTable_PutFieldEnumeration (unsigned int tok, unsigned int Sym, NameKey_Name FieldName);

/*
   PutSubrange - places LowSym and HighSym as two symbols
                 which provide the limits of the range.
*/

EXTERN void SymbolTable_PutSubrange (unsigned int Sym, unsigned int LowSym, unsigned int HighSym, unsigned int TypeSymbol);

/*
   PutSet - places SimpleType as the type for set, Sym.
*/

EXTERN void SymbolTable_PutSet (unsigned int Sym, unsigned int SimpleType, bool packed);

/*
   IsSetPacked - returns TRUE if Sym is packed.
*/

EXTERN bool SymbolTable_IsSetPacked (unsigned int Sym);

/*
   GetArraySubscript - returns the subrange symbol for array, Sym.
*/

EXTERN unsigned int SymbolTable_GetArraySubscript (unsigned int Sym);

/*
   PutArraySubscript - places an index field into the array Sym. The
                       index field is a subscript sym.
*/

EXTERN void SymbolTable_PutArraySubscript (unsigned int Sym, unsigned int SubscriptSymbol);

/*
   PutType - gives a type symbol Sym type TypeSymbol.
*/

EXTERN void SymbolTable_PutType (unsigned int Sym, unsigned int TypeSymbol);

/*
   PutFunction - Places a TypeSym as the return type to a procedure Sym.
*/

EXTERN void SymbolTable_PutFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym);

/*
   PutOptFunction - places a TypeSym as the optional return type to a procedure Sym.
*/

EXTERN void SymbolTable_PutOptFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym);

/*
   IsReturnOptional - returns TRUE if the return value for, sym, is
                      optional.
*/

EXTERN bool SymbolTable_IsReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   IsReturnOptionalAny - returns TRUE if the return value for sym is
                         optional.
*/

EXTERN bool SymbolTable_IsReturnOptionalAny (unsigned int sym);

/*
   PutParam - Places a Non VAR parameter ParamName with type ParamType into
              procedure Sym:kind.  The parameter number is ParamNo.
              If the procedure Sym already has this parameter then
              the parameter is checked for consistancy and the
              consistancy test is returned.
*/

EXTERN bool SymbolTable_PutParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok);

/*
   PutVarParam - Places a Non VAR parameter ParamName with type
                 ParamType into procedure Sym:kind.
                 The parameter number is ParamNo.
                 If the procedure Sym already has this parameter then
                 the parameter is checked for consistancy and the
                 consistancy test is returned.
*/

EXTERN bool SymbolTable_PutVarParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok);

/*
   PutParamName - assigns a name to paramater no of procedure ProcSym:kind.
*/

EXTERN void SymbolTable_PutParamName (unsigned int tok, unsigned int ProcSym, SymbolTable_ProcedureKind kind, unsigned int no, NameKey_Name name, unsigned int ParamType, unsigned int typetok);

/*
   PutProcedureReachable - Sets the procedure, Sym, to be reachable by the
                           main Module.
*/

EXTERN void SymbolTable_PutProcedureReachable (unsigned int Sym);

/*
   IsProcedureReachable - Returns true if the procedure, Sym, is
                          reachable from the main Module.
*/

EXTERN bool SymbolTable_IsProcedureReachable (unsigned int Sym);

/*
   PutProcedureNoReturn - places value into the no return attribute
                          field of procedure sym.
*/

EXTERN void SymbolTable_PutProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind, bool value);

/*
   IsProcedureNoReturn - returns TRUE if this procedure never returns.
*/

EXTERN bool SymbolTable_IsProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureProcType - returns the proctype matching procedure sym.
*/

EXTERN unsigned int SymbolTable_GetProcedureProcType (unsigned int sym);

/*
   PutModuleStartQuad - Places QuadNumber into the Module symbol, Sym.
                        QuadNumber is the start quad of Module,
                        Sym.
*/

EXTERN void SymbolTable_PutModuleStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleEndQuad - Places QuadNumber into the Module symbol, Sym.
                      QuadNumber is the end quad of Module,
                      Sym.
*/

EXTERN void SymbolTable_PutModuleEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleFinallyStartQuad - Places QuadNumber into the Module symbol, Sym.
                               QuadNumber is the finally start quad of
                               Module, Sym.
*/

EXTERN void SymbolTable_PutModuleFinallyStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleFinallyEndQuad - Places QuadNumber into the Module symbol, Sym.
                             QuadNumber is the end quad of the finally block
                             in Module, Sym.
*/

EXTERN void SymbolTable_PutModuleFinallyEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   GetModuleQuads - Returns, StartInit EndInit StartFinish EndFinish,
                    Quads of a Module, Sym.
                    Start and End represent the initialization code
                    of the Module, Sym.
*/

EXTERN void SymbolTable_GetModuleQuads (unsigned int Sym, unsigned int *StartInit, unsigned int *EndInit, unsigned int *StartFinish, unsigned int *EndFinish);

/*
   PutModuleFinallyFunction - Places Tree, finally, into the Module symbol, Sym.
*/

EXTERN void SymbolTable_PutModuleFinallyFunction (unsigned int Sym, tree finally);

/*
   GetModuleFinallyFunction - returns the finally tree from the Module symbol, Sym.
*/

EXTERN tree SymbolTable_GetModuleFinallyFunction (unsigned int Sym);

/*
   PutProcedureScopeQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of procedure,
                           Sym.
*/

EXTERN void SymbolTable_PutProcedureScopeQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutProcedureStartQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of procedure,
                           Sym.
*/

EXTERN void SymbolTable_PutProcedureStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutProcedureEndQuad - Places QuadNumber into the Procedure symbol, Sym.
                         QuadNumber is the end quad of procedure,
                         Sym.
*/

EXTERN void SymbolTable_PutProcedureEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   GetProcedureQuads - Returns, Start and End, Quads of a procedure, Sym.
*/

EXTERN void SymbolTable_GetProcedureQuads (unsigned int Sym, unsigned int *scope, unsigned int *start, unsigned int *end);

/*
   GetQuads - assigns Start and End to the beginning and end of
              symbol, Sym, usage.
*/

EXTERN void SymbolTable_GetQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   GetReadQuads - assigns Start and End to the beginning and end of
                  symbol, Sym, usage.
*/

EXTERN void SymbolTable_GetReadQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   GetWriteQuads - assigns Start and End to the beginning and end of
                   symbol, Sym, usage.
*/

EXTERN void SymbolTable_GetWriteQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   PutReadQuad - places Quad into the list of symbol usage.
*/

EXTERN void SymbolTable_PutReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   RemoveReadQuad - places Quad into the list of symbol usage.
*/

EXTERN void SymbolTable_RemoveReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   PutWriteQuad - places Quad into the list of symbol usage.
*/

EXTERN void SymbolTable_PutWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   RemoveWriteQuad - places Quad into the list of symbol usage.
*/

EXTERN void SymbolTable_RemoveWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   GetReadLimitQuads - returns Start and End which have been assigned
                       the start and end of when the symbol was read
                       to within: StartLimit..EndLimit.
*/

EXTERN void SymbolTable_GetReadLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End);

/*
   GetWriteLimitQuads - returns Start and End which have been assigned
                        the start and end of when the symbol was written
                        to within: StartLimit..EndLimit.
*/

EXTERN void SymbolTable_GetWriteLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End);

/*
   GetNthProcedure - Returns the Nth procedure in Module, Sym.
*/

EXTERN unsigned int SymbolTable_GetNthProcedure (unsigned int Sym, unsigned int n);

/*
   GetDeclaredDef - returns the token where this symbol was declared
                    with the priority of the definition, implementation,
                    program.
*/

EXTERN unsigned int SymbolTable_GetDeclaredDef (unsigned int Sym);

/*
   GetDeclaredMod - returns the token where this symbol was declared.
                    with the priority of the implementation, program
                    and definition.
*/

EXTERN unsigned int SymbolTable_GetDeclaredMod (unsigned int Sym);

/*
   GetDeclaredFor - returns the token where this symbol was declared.
                    It chooses the first from the forward declaration,
                    implementation module, program module
                    and definition module.
*/

EXTERN unsigned int SymbolTable_GetDeclaredFor (unsigned int Sym);

/*
   GetDeclaredDefinition - returns the token where this symbol
                           was declared in the definition module.
*/

EXTERN unsigned int SymbolTable_GetDeclaredDefinition (unsigned int Sym);

/*
   GetDeclaredModule - returns the token where this symbol was declared
                       in an implementation or program module.
*/

EXTERN unsigned int SymbolTable_GetDeclaredModule (unsigned int Sym);

/*
   PutDeclared - adds an entry to symbol, Sym, indicating that it
                 was declared at, tok.  This routine
                 may be called twice, once for definition module
                 partial declaration and once when parsing the
                 implementation module.
*/

EXTERN void SymbolTable_PutDeclared (unsigned int tok, unsigned int Sym);

/*
   GetFirstUsed - returns the token where this symbol was first used.
*/

EXTERN unsigned int SymbolTable_GetFirstUsed (unsigned int Sym);

/*
   PutProcedureBegin - assigns begin as the token number matching the
                       procedure BEGIN.
*/

EXTERN void SymbolTable_PutProcedureBegin (unsigned int Sym, unsigned int begin);

/*
   PutProcedureEnd - assigns end as the token number matching the
                     procedure END.
*/

EXTERN void SymbolTable_PutProcedureEnd (unsigned int Sym, unsigned int end);

/*
   GetProcedureBeginEnd - assigns, begin, end, to the stored token values.
*/

EXTERN void SymbolTable_GetProcedureBeginEnd (unsigned int Sym, unsigned int *begin, unsigned int *end);

/*
   ForeachProcedureDo - for each procedure in module, Sym, do procedure, P.
*/

EXTERN void SymbolTable_ForeachProcedureDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachModuleDo - for each module do procedure, P.
*/

EXTERN void SymbolTable_ForeachModuleDo (SymbolKey_PerformOperation P);

/*
   ForeachInnerModuleDo - for each inner module in module, Sym,
                          do procedure, P.
*/

EXTERN void SymbolTable_ForeachInnerModuleDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   IsVarParam - Returns a conditional depending whether parameter ParamNo
                is a VAR procedure parameter.
*/

EXTERN bool SymbolTable_IsVarParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);

/*
   IsVarParamAny - Returns a conditional depending whether parameter ParamNo
                   is a VAR parameter.
*/

EXTERN bool SymbolTable_IsVarParamAny (unsigned int Sym, unsigned int ParamNo);

/*
   IsUnboundedParam - Returns a conditional depending whether parameter
                      ParamNo is an unbounded array procedure parameter.
*/

EXTERN bool SymbolTable_IsUnboundedParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);
EXTERN bool SymbolTable_IsUnboundedParamAny (unsigned int Sym, unsigned int ParamNo);

/*
   IsParameterUnbounded - returns TRUE if parameter, Sym, is
                          unbounded.
*/

EXTERN bool SymbolTable_IsParameterUnbounded (unsigned int Sym);

/*
   IsParameterVar - returns true if parameter symbol Sym
                    was declared as a VAR.
*/

EXTERN bool SymbolTable_IsParameterVar (unsigned int Sym);

/*
   GetParameterShadowVar - returns the local variable associated with the
                           parameter symbol, sym.
*/

EXTERN unsigned int SymbolTable_GetParameterShadowVar (unsigned int sym);

/*
   NoOfParam - Returns the number of parameters that procedure Sym contains.
*/

EXTERN unsigned int SymbolTable_NoOfParam (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   HasVarParameters - returns TRUE if procedure, p, has any VAR parameters.
*/

EXTERN bool SymbolTable_HasVarParameters (unsigned int p);

/*
   NoOfLocalVar - returns the number of local variables that exist in
                  procedure Sym. Parameters are NOT included in the
                  count.
*/

EXTERN unsigned int SymbolTable_NoOfLocalVar (unsigned int Sym);

/*
   IsDefImp - returns true is the Sym is a DefImp symbol.
              Definition/Implementation module symbol.
*/

EXTERN bool SymbolTable_IsDefImp (unsigned int Sym);

/*
   IsModule - returns true if the Sym is a Module symbol.
              Program module symbol.
              Includes inner modules.
*/

EXTERN bool SymbolTable_IsModule (unsigned int Sym);

/*
   IsInnerModule - returns true if the symbol, Sym, is an inner module.
*/

EXTERN bool SymbolTable_IsInnerModule (unsigned int Sym);

/*
   GetSymName - returns the symbol name.
*/

EXTERN NameKey_Name SymbolTable_GetSymName (unsigned int Sym);

/*
   RenameSym - renames a symbol, Sym, with SymName.
               It also checks the unknown tree for a symbol
               with this new name.
*/

EXTERN void SymbolTable_RenameSym (unsigned int Sym, NameKey_Name SymName);

/*
   IsUnknown - returns true is the symbol Sym is unknown.
*/

EXTERN bool SymbolTable_IsUnknown (unsigned int Sym);

/*
   IsPartialUnbounded - returns TRUE if, sym, is a partially unbounded symbol.
*/

EXTERN bool SymbolTable_IsPartialUnbounded (unsigned int sym);

/*
   RequestSym - searches for a symbol with a name SymName in the
                current and previous scopes.
                If the symbol is found then it is returned
                else an unknown symbol is returned create at token
                position, tok.
                This procedure does search the base scope (for
                pervasive identifiers).
*/

EXTERN unsigned int SymbolTable_RequestSym (unsigned int tok, NameKey_Name SymName);

/*
   PutImported - places a symbol, Sym, into the current main scope.
*/

EXTERN void SymbolTable_PutImported (unsigned int Sym);

/*
   PutIncluded - places a symbol, Sym, into the included list of the
                 current module.
                 Symbols that are placed in this list are indirectly declared
                 by:

                 import modulename ;

                 modulename.identifier
*/

EXTERN void SymbolTable_PutIncluded (unsigned int Sym);

/*
   PutExported - places a symbol, Sym into the the next level out module.
                 Sym is also placed in the ExportTree of the current inner
                 module.
*/

EXTERN void SymbolTable_PutExported (unsigned int Sym);

/*
   PutExportQualified - places a symbol with the name, SymName,
                        into the export tree of the
                        Definition module being compiled.
                        The symbol with SymName has been export QUALIFIED
                        by the definition module and therefore any reference
                        to this symbol in the code generation phase
                        will be in the form _Module_SymName.
*/

EXTERN void SymbolTable_PutExportQualified (unsigned int tokenno, NameKey_Name SymName);

/*
   PutExportUnQualified - places a symbol with the name, SymName,
                          into the export tree of the
                          Definition module being compiled.
                          The symbol with SymName has been export unqualified
                          by the definition module and therefore any reference
                          to this symbol in the code generation phase
                          will be in the form _SymName.
*/

EXTERN void SymbolTable_PutExportUnQualified (unsigned int tokenno, NameKey_Name SymName);

/*
   PutExportUnImplemented - places a symbol, Sym, into the currently compiled
                            DefImp module NeedToBeImplemented list.
*/

EXTERN void SymbolTable_PutExportUnImplemented (unsigned int tokenno, unsigned int Sym);

/*
   GetExported - returns the symbol which has a name SymName,
                 and is exported from module ModSym.

*/

EXTERN unsigned int SymbolTable_GetExported (unsigned int tokenno, unsigned int ModSym, NameKey_Name SymName);

/*
   GetFromOuterModule - returns a symbol with name, SymName, which comes
                        from outside the current module.
*/

EXTERN unsigned int SymbolTable_GetFromOuterModule (unsigned int tokenno, NameKey_Name SymName);

/*
   TryMoveUndeclaredSymToInnerModule - attempts to move a symbol of
                                       name, name, which is
                                       currently undefined in the
                                       outer scope to the inner scope.
                                       If successful then the symbol is
                                       returned otherwise NulSym is
                                       returned.
*/

EXTERN unsigned int SymbolTable_TryMoveUndeclaredSymToInnerModule (unsigned int OuterScope, unsigned int InnerScope, NameKey_Name name);

/*
   IsExportQualified - returns true if a symbol, Sym, was defined as
                       being EXPORT QUALIFIED.
                       Sym is expected to be either a procedure or a
                       variable.
*/

EXTERN bool SymbolTable_IsExportQualified (unsigned int Sym);

/*
   IsExportUnQualified - returns true if a symbol, Sym, was defined as
                         being EXPORT UNQUALIFIED.
                         Sym is expected to be either a procedure or a
                         variable.
*/

EXTERN bool SymbolTable_IsExportUnQualified (unsigned int Sym);

/*
   IsExported - returns true if a symbol, Sym, is exported
                from module, ModSym.
                If ModSym is a DefImp symbol then its
                ExportQualified and ExportUnQualified lists are examined.
*/

EXTERN bool SymbolTable_IsExported (unsigned int ModSym, unsigned int Sym);

/*
   IsImplicityExported - returns TRUE if, Sym, is implicitly exported from module, ModSym.
                         ModSym must be a defimp symbol.
*/

EXTERN bool SymbolTable_IsImplicityExported (unsigned int ModSym, unsigned int Sym);

/*
   IsImported - returns true if a symbol, Sym, in module, ModSym,
                was imported.
*/

EXTERN bool SymbolTable_IsImported (unsigned int ModSym, unsigned int Sym);

/*
   PutIncludedByDefinition - places a module symbol, Sym, into the
                             included list of the current definition module.
*/

EXTERN void SymbolTable_PutIncludedByDefinition (unsigned int Sym);

/*
   IsIncludedByDefinition - returns TRUE if definition module symbol, Sym, was included
                            by ModSyms definition module.
*/

EXTERN bool SymbolTable_IsIncludedByDefinition (unsigned int ModSym, unsigned int Sym);

/*
   ForeachImportedDo - calls a procedure, P, foreach imported symbol
                       in module, ModSym.
*/

EXTERN void SymbolTable_ForeachImportedDo (unsigned int ModSym, SymbolKey_PerformOperation P);

/*
   ForeachExportedDo - calls a procedure, P, foreach exported symbol
                       from module, ModSym.
*/

EXTERN void SymbolTable_ForeachExportedDo (unsigned int ModSym, SymbolKey_PerformOperation P);

/*
   CheckForExportedImplementation - checks to see whether an implementation
                                    module is currently being compiled, if so,
                                    symbol, Sym, is removed from the
                                    NeedToBeImplemented list.
                                    This procedure is called whenever a symbol
                                    is declared, thus attenpting to reduce
                                    the NeedToBeImplemented list.
                                    Only needs to be called when a TYPE or
                                    PROCEDURE is built since the implementation
                                    module can only implement these objects
                                    declared in the definition module.
*/

EXTERN void SymbolTable_CheckForExportedImplementation (unsigned int Sym);

/*
   CheckForUnImplementedExports - displays an error and the offending symbols
                                  which have been EXPORTed but not implemented
                                  from the current compiled module.
*/

EXTERN void SymbolTable_CheckForUnImplementedExports (void);

/*
   CheckForUndeclaredExports - displays an error and the offending symbols
                               which have been EXPORTed but not declared
                               from module, ModSym.
*/

EXTERN void SymbolTable_CheckForUndeclaredExports (unsigned int ModSym);

/*
   CheckForUnknownInModule - checks for any unknown symbols in the
                             current module.
                             If any unknown symbols are found then
                             an error message is displayed.
*/

EXTERN void SymbolTable_CheckForUnknownInModule (void);

/*
   UnknownReported - if sym is an unknown symbol and has not been reported
                     then include it into the set of reported unknowns.
*/

EXTERN void SymbolTable_UnknownReported (unsigned int sym);

/*
   IsReallyPointer - returns TRUE is sym is a pointer, address or a
                     type declared as a pointer or address.
*/

EXTERN bool SymbolTable_IsReallyPointer (unsigned int Sym);

/*
   CheckHiddenTypeAreAddress - checks to see that any hidden types
                               which we have declared are actually
                               of type ADDRESS or map onto a POINTER type.
*/

EXTERN void SymbolTable_CheckHiddenTypeAreAddress (void);

/*
   PutDefinitionForC - sets a flag in the module, Sym, which
                       indicates that this module is a wrapper for a C
                       file. Parameters passes to procedures in this module
                       will adopt the C calling convention.
*/

EXTERN void SymbolTable_PutDefinitionForC (unsigned int Sym);

/*
   IsDefinitionForC - returns true if this definition module was declared
                      as a DEFINITION MODULE FOR "C".
*/

EXTERN bool SymbolTable_IsDefinitionForC (unsigned int Sym);

/*
   PutDoesNeedExportList - sets a flag in module, Sym, which
                           indicates that this module requires an explicit
                           EXPORT QUALIFIED or UNQUALIFIED list. PIM-2
*/

EXTERN void SymbolTable_PutDoesNeedExportList (unsigned int Sym);

/*
   PutDoesNotNeedExportList - sets a flag in module, Sym, which
                              indicates that this module does not require an explicit
                              EXPORT QUALIFIED or UNQUALIFIED list. PIM-3|4
*/

EXTERN void SymbolTable_PutDoesNotNeedExportList (unsigned int Sym);

/*
   DoesNotNeedExportList - returns TRUE if module, Sym, does not require an explicit
                           EXPORT QUALIFIED list.
*/

EXTERN bool SymbolTable_DoesNotNeedExportList (unsigned int Sym);

/*
   CheckForEnumerationInCurrentModule - checks to see whether the enumeration
                                        type symbol, Sym, has been entered into
                                        the current modules scope list.
*/

EXTERN void SymbolTable_CheckForEnumerationInCurrentModule (unsigned int Sym);

/*
   SanityCheckConstants - must only be called once all constants, types, procedures
                          have been declared.  It checks to see that constants are
                          not used as PROCEDURE parameter types.
*/

EXTERN void SymbolTable_SanityCheckConstants (void);

/*
   ForeachLocalSymDo - foreach local symbol in module, Sym, or procedure, Sym,
                       perform the procedure, P.
*/

EXTERN void SymbolTable_ForeachLocalSymDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachParamSymDo - foreach parameter symbol in procedure Sym
                       perform the procedure P.  Each symbol
                       looked up will be VarParam or Param
                       (not the shadow variable).  Every parameter
                       from each KindProcedure is iterated over.
*/

EXTERN void SymbolTable_ForeachParamSymDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachFieldEnumerationDo - for each field in enumeration, Sym,
                               do procedure, P.  Each call to P contains
                               an enumeration field, the order is alphabetical.
                               Use ForeachLocalSymDo for declaration order.
*/

EXTERN void SymbolTable_ForeachFieldEnumerationDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   IsType - returns true if the Sym is a type symbol.
*/

EXTERN bool SymbolTable_IsType (unsigned int Sym);

/*
   IsProcedure - returns true is Sym is a PROCEDURE symbol.
*/

EXTERN bool SymbolTable_IsProcedure (unsigned int Sym);

/*
   IsParameter - returns true if Sym is a parameter symbol.
*/

EXTERN bool SymbolTable_IsParameter (unsigned int Sym);

/*
   GetProcedureKind - returns the procedure kind given the declaration tok.
                      The declaration tok must match the ident tok in the
                      procedure name.  It is only safe to call this
                      procedure function during pass 2 onwards.
*/

EXTERN SymbolTable_ProcedureKind SymbolTable_GetProcedureKind (unsigned int sym, unsigned int tok);

/*
   GetProcedureDeclaredTok - return the token where the
                             declaration of procedure sym:kind
                             occurred.
*/

EXTERN unsigned int SymbolTable_GetProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutProcedureDeclaredTok - places the tok where the
                             declaration of procedure sym:kind
                             occurred.
*/

EXTERN void SymbolTable_PutProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok);

/*
   GetReturnTypeTok - return the token where the
                      return type procedure sym:kind was defined.
*/

EXTERN unsigned int SymbolTable_GetReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutReturnTypeTok - places the tok where the return type of procedure sym:kind
                      was defined.
*/

EXTERN void SymbolTable_PutReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok);

/*
   PutProcedureParametersDefined - the procedure symbol sym:kind
                                   parameters have been defined.
*/

EXTERN void SymbolTable_PutProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureParametersDefined - returns true if procedure symbol sym:kind
                                   parameters are defined.
*/

EXTERN bool SymbolTable_GetProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutProcedureDefined - the procedure symbol sym:kind is defined.
*/

EXTERN void SymbolTable_PutProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureDefined - returns true if procedure symbol sym:kind
                         is defined.
*/

EXTERN bool SymbolTable_GetProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutUseVarArgs - tell the symbol table that this procedure, Sym, uses varargs.
                   The procedure _must_ be declared inside a
                   DEFINITION FOR "C"

*/

EXTERN void SymbolTable_PutUseVarArgs (unsigned int Sym);

/*
   UsesVarArgs - returns TRUE if procedure, Sym, uses varargs.
                 The procedure _must_ be declared inside a
                 DEFINITION FOR "C"
*/

EXTERN bool SymbolTable_UsesVarArgs (unsigned int Sym);

/*
   PutUseOptArg - tell the symbol table that this procedure, Sym,
                  uses an optarg.
*/

EXTERN void SymbolTable_PutUseOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   UsesOptArg - returns TRUE if procedure, Sym, uses varargs.
*/

EXTERN bool SymbolTable_UsesOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   PutOptArgInit - makes symbol, Sym, the initializer value to
                   procedure, ProcSym.
*/

EXTERN void SymbolTable_PutOptArgInit (unsigned int ProcSym, unsigned int Sym);

/*
   GetOptArgInit - returns the initializer value to the optional parameter in
                   procedure, ProcSym.
*/

EXTERN unsigned int SymbolTable_GetOptArgInit (unsigned int ProcSym);

/*
   MakePointer - returns a pointer symbol with PointerName.
*/

EXTERN unsigned int SymbolTable_MakePointer (unsigned int tok, NameKey_Name PointerName);

/*
   PutPointer - gives a pointer symbol a type, PointerType.
*/

EXTERN void SymbolTable_PutPointer (unsigned int Sym, unsigned int PointerType);

/*
   IsPointer - returns true is Sym is a pointer type symbol.
*/

EXTERN bool SymbolTable_IsPointer (unsigned int Sym);

/*
   IsRecord - returns true is Sym is a record type symbol.
*/

EXTERN bool SymbolTable_IsRecord (unsigned int Sym);

/*
   IsVarient - returns true if the symbol, Sym, is a
               varient symbol.
*/

EXTERN bool SymbolTable_IsVarient (unsigned int Sym);

/*
  IsFieldVarient - returns true if the symbol, Sym, is a
                   varient field.
*/

EXTERN bool SymbolTable_IsFieldVarient (unsigned int Sym);

/*
   IsFieldEnumeration - returns true if the symbol, Sym, is an
                        enumeration field.
*/

EXTERN bool SymbolTable_IsFieldEnumeration (unsigned int Sym);

/*
   IsArray - returns true is Sym is an array type symbol.
*/

EXTERN bool SymbolTable_IsArray (unsigned int Sym);

/*
   IsEnumeration - returns true if Sym is an enumeration symbol.
*/

EXTERN bool SymbolTable_IsEnumeration (unsigned int Sym);

/*
   IsSet - returns TRUE if Sym is a set symbol.
*/

EXTERN bool SymbolTable_IsSet (unsigned int Sym);

/*
   IsHiddenType - returns TRUE if, Sym, is a Type and is also declared as a hidden type.
*/

EXTERN bool SymbolTable_IsHiddenType (unsigned int Sym);

/*
   IsOAFamily - returns TRUE if, Sym, is an OAFamily symbol.
*/

EXTERN bool SymbolTable_IsOAFamily (unsigned int Sym);

/*
   GetDimension - return the number of dimensions associated with
                  this unbounded ARRAY parameter.
*/

EXTERN unsigned int SymbolTable_GetDimension (unsigned int sym);

/*
   MakeOAFamily - makes an OAFamily symbol based on SimpleType.
                  It returns the OAFamily symbol.  A new symbol
                  is created if one does not already exist for
                  SimpleType.
*/

EXTERN unsigned int SymbolTable_MakeOAFamily (unsigned int SimpleType);

/*
   GetOAFamily - returns the oafamily symbol associated with
                 SimpleType.
*/

EXTERN unsigned int SymbolTable_GetOAFamily (unsigned int SimpleType);

/*
   ForeachOAFamily - call, p[oaf, ndim, symbol] for every unbounded symbol,
                     sym, in the oaf.
*/

EXTERN void SymbolTable_ForeachOAFamily (unsigned int sym, SymbolTable_FamilyOperation p);

/*
   IsUnbounded - returns true if Sym is an unbounded symbol.
*/

EXTERN bool SymbolTable_IsUnbounded (unsigned int Sym);

/*
   GetUnbounded - returns the unbounded symbol associated with
                  SimpleType.
*/

EXTERN unsigned int SymbolTable_GetUnbounded (unsigned int oaf, unsigned int ndim);

/*
   GetUnboundedRecordType - returns the record type used to
                            implement the unbounded array.
*/

EXTERN unsigned int SymbolTable_GetUnboundedRecordType (unsigned int Sym);

/*
   GetUnboundedAddressOffset - returns the offset of the address field
                               inside the record used to implement the
                               unbounded type.
*/

EXTERN unsigned int SymbolTable_GetUnboundedAddressOffset (unsigned int sym);

/*
   GetUnboundedHighOffset - returns the offset of the high field
                            inside the record used to implement the
                            unbounded type.
*/

EXTERN unsigned int SymbolTable_GetUnboundedHighOffset (unsigned int sym, unsigned int ndim);

/*
   MakeSubscript - makes a subscript Symbol.
                   No name is required.
*/

EXTERN unsigned int SymbolTable_MakeSubscript (void);

/*
   PutSubscript - gives a subscript symbol a type, SimpleType.
*/

EXTERN void SymbolTable_PutSubscript (unsigned int Sym, unsigned int SimpleType);

/*
   MakeUnbounded - makes an unbounded array Symbol.
                   ndim is the number of dimensions required.
                   No name is required.
*/

EXTERN unsigned int SymbolTable_MakeUnbounded (unsigned int tok, unsigned int SimpleType, unsigned int ndim);

/*
   NoOfElements - Returns the number of elements in array Sym,
                  or the number of elements in an enumeration Sym.
*/

EXTERN unsigned int SymbolTable_NoOfElements (unsigned int Sym);

/*
   PutArray - places a type symbol into an arraysym.
*/

EXTERN void SymbolTable_PutArray (unsigned int arraysym, unsigned int typesym);

/*
   ResolveImports -
*/

EXTERN void SymbolTable_ResolveImports (void);

/*
   ResolveConstructorTypes - to be called at the end of pass three.  Its
                             purpose is to fix up all constructors whose
                             types are unknown.
*/

EXTERN void SymbolTable_ResolveConstructorTypes (void);

/*
   AddNameToScope - adds a Name, n, to the list of objects declared at the
                    current scope.
*/

EXTERN void SymbolTable_AddNameToScope (NameKey_Name n);

/*
   AddNameToImportList - adds a Name, n, to the import list of the current
                         module.
*/

EXTERN void SymbolTable_AddNameToImportList (NameKey_Name n);

/*
   GetScope - returns the declaration scope of the symbol.
*/

EXTERN unsigned int SymbolTable_GetScope (unsigned int Sym);

/*
   GetModuleScope - returns the module scope of symbol, sym.
                    If sym was declared within a nested procedure
                    then return the module which defines the
                    procedure.
*/

EXTERN unsigned int SymbolTable_GetModuleScope (unsigned int sym);

/*
   GetProcedureScope - returns the innermost procedure (if any)
                       in which the symbol, sym, resides.
                       A module inside the PROCEDURE is skipped
                       over.
*/

EXTERN unsigned int SymbolTable_GetProcedureScope (unsigned int sym);

/*
   IsModuleWithinProcedure - returns TRUE if module, sym, is
                             inside a procedure.
*/

EXTERN bool SymbolTable_IsModuleWithinProcedure (unsigned int sym);

/*
   GetParent - returns the parent of symbol, Sym.
*/

EXTERN unsigned int SymbolTable_GetParent (unsigned int Sym);

/*
   IsRecordField - returns true if Sym is a record field.
*/

EXTERN bool SymbolTable_IsRecordField (unsigned int Sym);

/*
   MakeProcType - returns a procedure type symbol with ProcTypeName.
*/

EXTERN unsigned int SymbolTable_MakeProcType (unsigned int tok, NameKey_Name ProcTypeName);

/*
   PutProcTypeParam - Places a Non VAR parameter ParamName with type
                      ParamType into ProcType Sym.
*/

EXTERN void SymbolTable_PutProcTypeParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded);

/*
   PutProcTypeVarParam - Places a Non VAR parameter ParamName with type
                         ParamType into ProcType Sym.
*/

EXTERN void SymbolTable_PutProcTypeVarParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded);

/*
   IsProcType - returns true if Sym is a ProcType Symbol.
*/

EXTERN bool SymbolTable_IsProcType (unsigned int Sym);

/*
   IsVar - returns true if Sym is a Var Symbol.
*/

EXTERN bool SymbolTable_IsVar (unsigned int Sym);

/*
   IsVarConst - returns the IsConst field indicating the variable is read only.
*/

EXTERN bool SymbolTable_IsVarConst (unsigned int sym);

/*
   IsConst - returns true is Sym is a Const Symbol.
*/

EXTERN bool SymbolTable_IsConst (unsigned int Sym);

/*
   IsConstString - returns true if Sym is a string.
*/

EXTERN bool SymbolTable_IsConstString (unsigned int sym);

/*
   IsConstStringNulTerminated - returns TRUE if the constant string, sym,
                                should be created with a nul terminator.
*/

EXTERN bool SymbolTable_IsConstStringNulTerminated (unsigned int sym);

/*
   IsConstLit - returns true if Sym is a literal constant.
*/

EXTERN bool SymbolTable_IsConstLit (unsigned int Sym);

/*
   IsConstructor - returns TRUE if the constant is declared as a
                   constant set, array or record.
*/

EXTERN bool SymbolTable_IsConstructor (unsigned int Sym);

/*
   IsDummy - returns true if Sym is a Dummy symbol.
*/

EXTERN bool SymbolTable_IsDummy (unsigned int Sym);

/*
   IsTemporary - returns true if Sym is a Temporary symbol.
*/

EXTERN bool SymbolTable_IsTemporary (unsigned int Sym);

/*
   IsVarAParam - returns true if Sym is a variable declared as a parameter.
*/

EXTERN bool SymbolTable_IsVarAParam (unsigned int Sym);

/*
   IsSubscript - returns true if Sym is a subscript symbol.
*/

EXTERN bool SymbolTable_IsSubscript (unsigned int Sym);

/*
   IsSubrange - returns true if Sym is a subrange symbol.
*/

EXTERN bool SymbolTable_IsSubrange (unsigned int Sym);

/*
   IsProcedureVariable - returns true if a Sym is a variable and
                         it was declared within a procedure.
*/

EXTERN bool SymbolTable_IsProcedureVariable (unsigned int Sym);

/*
   IsProcedureNested - returns TRUE if procedure, Sym, was
                       declared as a nested procedure.
*/

EXTERN bool SymbolTable_IsProcedureNested (unsigned int Sym);

/*
   IsAModula2Type - returns true if Sym, is a:
                    IsType, IsPointer, IsRecord, IsEnumeration,
                    IsSubrange, IsArray, IsUnbounded, IsProcType.
                    NOTE that it different from IsType.
                    IsType is used for:
                    TYPE
                       a = CARDINAL ;   IsType(a)=TRUE 
*/

EXTERN bool SymbolTable_IsAModula2Type (unsigned int Sym);

/*
   IsGnuAsmVolatile - returns TRUE if a GnuAsm symbol was defined as VOLATILE.
*/

EXTERN bool SymbolTable_IsGnuAsmVolatile (unsigned int Sym);

/*
   IsGnuAsmSimple - returns TRUE if a GnuAsm symbol is a simple statement of the
                    form ASM("instruction"), which differs from ASM("instruction" :)
                    slightly.
*/

EXTERN bool SymbolTable_IsGnuAsmSimple (unsigned int Sym);

/*
   IsGnuAsm - returns TRUE if Sym is a GnuAsm symbol.
*/

EXTERN bool SymbolTable_IsGnuAsm (unsigned int Sym);

/*
   IsRegInterface - returns TRUE if Sym is a RegInterface symbol.
*/

EXTERN bool SymbolTable_IsRegInterface (unsigned int Sym);

/*
   IsSizeSolved - returns true if the size of Sym is solved.
*/

EXTERN bool SymbolTable_IsSizeSolved (unsigned int Sym);

/*
   IsOffsetSolved - returns true if the Offset of Sym is solved.
*/

EXTERN bool SymbolTable_IsOffsetSolved (unsigned int Sym);

/*
   IsValueSolved - returns true if the value of Sym is solved.
*/

EXTERN bool SymbolTable_IsValueSolved (unsigned int Sym);

/*
   IsConstructorConstant - returns TRUE if constructor, Sym, is
                           defined by only constants.
*/

EXTERN bool SymbolTable_IsConstructorConstant (unsigned int Sym);

/*
   IsComposite - returns TRUE if symbol, sym, is a composite
                 type:  ie an ARRAY or RECORD.
*/

EXTERN bool SymbolTable_IsComposite (unsigned int sym);

/*
   IsSumOfParamSizeSolved - has the sum of parameters been solved yet?
*/

EXTERN bool SymbolTable_IsSumOfParamSizeSolved (unsigned int Sym);

/*
   PutAlignment - assigns the alignment constant associated with,
                  type, with, align.
*/

EXTERN void SymbolTable_PutAlignment (unsigned int type, unsigned int align);

/*
   GetAlignment - returns the alignment constant associated with,
                  type.
*/

EXTERN unsigned int SymbolTable_GetAlignment (unsigned int type);

/*
   GetDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

EXTERN unsigned int SymbolTable_GetDefaultRecordFieldAlignment (unsigned int sym);

/*
   PutDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

EXTERN void SymbolTable_PutDefaultRecordFieldAlignment (unsigned int sym, unsigned int align);

/*
   PutUnused - sets, sym, as unused.  This is a gm2 pragma.
*/

EXTERN void SymbolTable_PutUnused (unsigned int sym);

/*
   IsUnused - returns TRUE if the symbol was declared as unused with a
              gm2 pragma.
*/

EXTERN bool SymbolTable_IsUnused (unsigned int sym);

/*
   PutDeclaredPacked - sets the Packed field of the record or record field symbol.
*/

EXTERN void SymbolTable_PutDeclaredPacked (unsigned int sym, bool b);

/*
   IsDeclaredPacked - was the record symbol or record field, sym,
                      declared as packed?
*/

EXTERN bool SymbolTable_IsDeclaredPacked (unsigned int sym);

/*
   IsDeclaredPackedResolved - do we know if the record symbol or record
                              field, sym, declared as packed or not packed?
*/

EXTERN bool SymbolTable_IsDeclaredPackedResolved (unsigned int sym);

/*
   GetPackedEquivalent - returns the packed equivalent of type, sym.
                         sym must be a type, subrange, set or enumerated type.
*/

EXTERN unsigned int SymbolTable_GetPackedEquivalent (unsigned int sym);

/*
   GetNonPackedEquivalent - returns the equivalent non packed symbol
                            associated with, sym.
*/

EXTERN unsigned int SymbolTable_GetNonPackedEquivalent (unsigned int sym);

/*
   IsEquivalent - returns TRUE if, sym, is an equivalent symbol.
*/

EXTERN bool SymbolTable_IsEquivalent (unsigned int sym);

/*
   PushSize - pushes the size of Sym.
*/

EXTERN void SymbolTable_PushSize (unsigned int Sym);

/*
   PopSize - pops the ALU stack into Size of Sym.
*/

EXTERN void SymbolTable_PopSize (unsigned int Sym);

/*
   PushValue - pushes the Value of Sym onto the ALU stack.
*/

EXTERN void SymbolTable_PushValue (unsigned int Sym);

/*
   PushVarSize - pushes the size of a variable, Sym.
                 The runtime size of Sym will depend upon its addressing mode,
                 RightValue has size PushSize(GetType(Sym)) and
                 LeftValue has size PushSize(Address) since it points to a
                 variable.
                 However this procedure uses the Type of Sym therefore
                 this Type must be solved before this procedure is called.
*/

EXTERN void SymbolTable_PushVarSize (unsigned int Sym);

/*
   PopValue - pops the ALU stack into Value of Sym.
*/

EXTERN void SymbolTable_PopValue (unsigned int Sym);

/*
   IsObject - returns TRUE if the symbol is an object symbol.
*/

EXTERN bool SymbolTable_IsObject (unsigned int Sym);

/*
   IsTuple - returns TRUE if the symbol is a tuple symbol.
*/

EXTERN bool SymbolTable_IsTuple (unsigned int Sym);

/*
   Make2Tuple - creates and returns a 2 tuple from, a, and, b.
*/

EXTERN unsigned int SymbolTable_Make2Tuple (unsigned int a, unsigned int b);

/*
   MakeError - creates an error node, which can be used in MetaError messages.
               It will be removed from ExportUndeclared and Unknown trees.
*/

EXTERN unsigned int SymbolTable_MakeError (unsigned int tok, NameKey_Name name);

/*
   MakeErrorS - creates an error node from a string, which can be used
                in MetaError messages.
                It will be removed from ExportUndeclared and Unknown trees.
*/

EXTERN unsigned int SymbolTable_MakeErrorS (unsigned int tok, DynamicStrings_String name);

/*
   IsError - returns TRUE if the symbol is an error symbol.
*/

EXTERN bool SymbolTable_IsError (unsigned int Sym);

/*
   IsLegal - returns TRUE if, sym, is a legal symbol.
*/

EXTERN bool SymbolTable_IsLegal (unsigned int sym);

/*
   PutModuleContainsBuiltin - sets a flag in the current compiled module which
                              indicates that a builtin PROCEDURE is being declared.
                              This is only expected to be called when we are
                              parsing the definition module.
*/

EXTERN void SymbolTable_PutModuleContainsBuiltin (void);

/*
   IsBuiltinInModule - returns true if a module, Sym, has declared a builtin procedure.
*/

EXTERN bool SymbolTable_IsBuiltinInModule (unsigned int Sym);

/*
   PutHiddenTypeDeclared - sets a flag in the current compiled module which
                           indicates that a Hidden Type is declared within
                           the implementation part of the module.
                           This procedure is expected to be called while
                           compiling the associated definition module.
*/

EXTERN void SymbolTable_PutHiddenTypeDeclared (void);

/*
   IsHiddenTypeDeclared - returns true if a Hidden Type was declared in
                          the module, Sym.
*/

EXTERN bool SymbolTable_IsHiddenTypeDeclared (unsigned int Sym);

/*
   IsHiddenReallyPointer - returns TRUE is sym is a pointer, address or a
                           type declared as a pointer or address.
*/

EXTERN bool SymbolTable_IsHiddenReallyPointer (unsigned int Sym);

/*
   DisplayTrees - displays the SymbolTrees for Module symbol, ModSym.
*/

EXTERN void SymbolTable_DisplayTrees (unsigned int ModSym);

/*
   DebugLineNumbers - internal debugging, emit all procedure names in this module
                      together with the line numbers for the corresponding begin/end
                      tokens.
*/

EXTERN void SymbolTable_DebugLineNumbers (unsigned int sym);

/*
   GetErrorScope - returns the error scope for a symbol.
                   The error scope is the title scope which is used to
                   announce the symbol in the GCC error message.
*/

EXTERN M2Error_ErrorScope SymbolTable_GetErrorScope (unsigned int sym);

/*
   MakeImport - create and return an import symbol.
                moduleSym is the symbol being imported.
                isqualified is FALSE if it were IMPORT modulename and
                TRUE for the qualified FROM modulename IMPORT etc.
                listno is the import list count for this module.
                tok should match this modulename position.
*/

EXTERN unsigned int SymbolTable_MakeImport (unsigned int tok, unsigned int moduleSym, unsigned int listno, bool isqualified);

/*
   MakeImportStatement - return a dependent symbol which represents an import statement
                         or a qualified import statement.  The tok should either match
                         the FROM token or the IMPORT token.  listno is the import list
                         count for the module.
*/

EXTERN unsigned int SymbolTable_MakeImportStatement (unsigned int tok, unsigned int listno);

/*
   IsImport - returns TRUE if sym is an import symbol.
*/

EXTERN bool SymbolTable_IsImport (unsigned int sym);

/*
   IsImportStatement - returns TRUE if sym is a dependent symbol.
*/

EXTERN bool SymbolTable_IsImportStatement (unsigned int sym);

/*
   GetImportModule - returns the module associated with the import symbol.
*/

EXTERN unsigned int SymbolTable_GetImportModule (unsigned int sym);

/*
   GetImportDeclared - returns the token associated with the import symbol.
*/

EXTERN unsigned int SymbolTable_GetImportDeclared (unsigned int sym);

/*
   GetImportStatementList - returns the list of imports for this dependent.
                            Each import symbol corresponds to a module.
*/

EXTERN Lists_List SymbolTable_GetImportStatementList (unsigned int sym);

/*
   GetModuleDefImportStatementList - returns the list of dependents associated with
                                     the definition module.
*/

EXTERN Lists_List SymbolTable_GetModuleDefImportStatementList (unsigned int sym);

/*
   GetModuleModImportStatementList - returns the list of dependents associated with
                                     the implementation or program module.
*/

EXTERN Lists_List SymbolTable_GetModuleModImportStatementList (unsigned int sym);

/*
   AppendModuleImportStatement - appends the ImportStatement symbol onto the
                                 module import list.

                                 For example:

                                 FROM x IMPORT y, z ;
                                 ^^^^

                                 also:

                                 IMPORT p, q, r;
                                 ^^^^^^
                                 will result in a new ImportStatement symbol added
                                 to the current module import list.
                                 The ImportStatement symbol is expected to be created
                                 by MakeImportStatement using the token positions
                                 outlined above.
*/

EXTERN void SymbolTable_AppendModuleImportStatement (unsigned int module, unsigned int statement);

/*
   AppendModuleOnImportStatement - appends the import symbol onto the
                                   dependent list (chain).

                                   For example each:

                                   FROM x IMPORT y, z ;
                                        ^
                                   x are added to the dependent list.

                                   also:

                                   IMPORT p, q, r;
                                          ^  ^  ^
                                   will result in p, q and r added to
                                   to the dependent list.

                                   The import symbol is created by MakeImport
                                   and the token is expected to match the module
                                   name outlined above.
*/

EXTERN void SymbolTable_AppendModuleOnImportStatement (unsigned int module, unsigned int import);

/*
   PutModLink - assigns link to module sym.
*/

EXTERN void SymbolTable_PutModLink (unsigned int sym, bool link);

/*
   IsModLink - returns the ModLink value associated with the module symbol.
*/

EXTERN bool SymbolTable_IsModLink (unsigned int sym);

/*
   PutDefLink - assigns link to the definition module sym.
*/

EXTERN void SymbolTable_PutDefLink (unsigned int sym, bool link);

/*
   IsDefLink - returns the DefLink value associated with the definition module symbol.
*/

EXTERN bool SymbolTable_IsDefLink (unsigned int sym);

/*
   IsModuleBuiltin - returns TRUE if the module is a builtin module.
                     (For example _BaseTypes).
*/

EXTERN bool SymbolTable_IsModuleBuiltin (unsigned int sym);

/*
   PutModuleBuiltin - sets the Builtin flag to value.
*/

EXTERN void SymbolTable_PutModuleBuiltin (unsigned int sym, bool value);

/*
   PutVarArrayRef - assigns ArrayRef field with value.
*/

EXTERN void SymbolTable_PutVarArrayRef (unsigned int sym, bool value);

/*
   IsVarArrayRef - returns ArrayRef field value.
*/

EXTERN bool SymbolTable_IsVarArrayRef (unsigned int sym);

/*
   VarCheckReadInit - returns TRUE if sym has been initialized.
*/

EXTERN bool SymbolTable_VarCheckReadInit (unsigned int sym, SymbolTable_ModeOfAddr mode);

/*
   VarInitState - initializes the init state for variable sym.
*/

EXTERN void SymbolTable_VarInitState (unsigned int sym);

/*
   PutVarInitialized - set sym as initialized.
*/

EXTERN void SymbolTable_PutVarInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode);

/*
   PutVarFieldInitialized - records that field has been initialized with
                            variable sym.  TRUE is returned if the field
                            is detected and changed to initialized.
*/

EXTERN bool SymbolTable_PutVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist);

/*
   GetVarFieldInitialized - return TRUE if fieldlist has been initialized
                            within variable sym.
*/

EXTERN bool SymbolTable_GetVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist);

/*
   PrintInitialized - display variable sym initialization state.
*/

EXTERN void SymbolTable_PrintInitialized (unsigned int sym);

/*
   GetParameterHeapVar - return the heap variable associated with the
                         parameter or NulSym.
*/

EXTERN unsigned int SymbolTable_GetParameterHeapVar (unsigned int ParSym);

/*
   PutProcedureParameterHeapVars - creates heap variables for parameter sym.
*/

EXTERN void SymbolTable_PutProcedureParameterHeapVars (unsigned int sym);

/*
   IsProcedureBuiltinAvailable - return TRUE if procedure is available as a builtin
                                 for the target architecture.
*/

EXTERN bool SymbolTable_IsProcedureBuiltinAvailable (unsigned int procedure);

/*
   PutConstLitInternal - marks the sym as being an internal constant.
                         Currently this is used when generating a default
                         BY constant expression during a FOR loop.
                         A constant marked as internal will always pass
                         an expression type check.
*/

EXTERN void SymbolTable_PutConstLitInternal (unsigned int sym, bool value);

/*
   IsConstLitInternal - returns the value of the IsInternal field within
                        a constant expression.
*/

EXTERN bool SymbolTable_IsConstLitInternal (unsigned int sym);

/*
   GetVarDeclTypeTok - returns the TypeTok field associate with variable sym.
*/

EXTERN unsigned int SymbolTable_GetVarDeclTypeTok (unsigned int sym);

/*
   PutVarDeclTypeTok - assigns the TypeTok field to typetok.
                       sym can be a variable or parameter.
*/

EXTERN void SymbolTable_PutVarDeclTypeTok (unsigned int sym, unsigned int typetok);

/*
   GetVarDeclTok - returns the TypeTok field associate with variable sym.
*/

EXTERN unsigned int SymbolTable_GetVarDeclTok (unsigned int sym);

/*
   PutVarDeclTok - assigns the VarTok field to vartok.
                   sym can be a variable or parameter.
*/

EXTERN void SymbolTable_PutVarDeclTok (unsigned int sym, unsigned int vartok);

/*
   GetVarDeclFullTok - returns the full virtual token containing var: type.
*/

EXTERN unsigned int SymbolTable_GetVarDeclFullTok (unsigned int sym);

/*
   IsProcedureAnyNoReturn - return TRUE if any of the defined kinds
                            of procedure sym is declared no return.
*/

EXTERN bool SymbolTable_IsProcedureAnyNoReturn (unsigned int sym);

/*
   GetNthParamAny - returns the nth parameter from the order
                    proper procedure, forward declaration
                    or definition module procedure.
*/

EXTERN unsigned int SymbolTable_GetNthParamAny (unsigned int sym, unsigned int ParamNo);

/*
   NoOfParamAny - return the number of parameters for sym.
*/

EXTERN unsigned int SymbolTable_NoOfParamAny (unsigned int sym);

/*
   SetReturnOptional - sets the ReturnOptional field in the Procedure:kind or
                       ProcType symboltable entry.
*/

EXTERN void SymbolTable_SetReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind, bool isopt);

/*
   UsesOptArgAny - returns TRUE if procedure, Sym, uses varargs.
*/

EXTERN bool SymbolTable_UsesOptArgAny (unsigned int Sym);

/*
   GetProcedureKindDesc - return a string describing kind.
*/

EXTERN DynamicStrings_String SymbolTable_GetProcedureKindDesc (SymbolTable_ProcedureKind kind);

/*
   GetNthParamAnyClosest - returns the nth parameter from the order
                           proper procedure, forward declaration
                           or definition module procedure.
                           It chooses the parameter which is closest
                           in source terms to currentmodule.
                           The same module will return using the order
                           proper procedure, forward procedure, definition module.
                           Whereas an imported procedure will choose from
                           DefProcedure, ProperProcedure, ForwardProcedure.
*/

EXTERN unsigned int SymbolTable_GetNthParamAnyClosest (unsigned int sym, unsigned int ParamNo, unsigned int currentmodule);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
