/* do not edit automatically generated by mc from M2GenGCC.  */
/* M2GenGCC.def convert the quadruples into GCC trees.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2GenGCC_H)
#   define _M2GenGCC_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GM2GCCDeclare.h"
#   include "Ggcctypes.h"
#   include "GM2BasicBlock.h"

#   if defined (_M2GenGCC_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   ConvertQuadsToTree - runs through the quadruple list, Start..End, and converts it into
                        the GCC tree structure.
*/

EXTERN void M2GenGCC_ConvertQuadsToTree (unsigned int Start, unsigned int End);

/*
   ResolveConstantExpressions - resolves constant expressions from the quadruple list.
                                It returns TRUE if one or more constants were folded.
                                When a constant symbol value is solved, the call back
                                p(sym) is invoked.
*/

EXTERN bool M2GenGCC_ResolveConstantExpressions (M2GCCDeclare_WalkAction p, M2BasicBlock_BasicBlock bb);

/*
   GetHighFromUnbounded - returns a Tree containing the value of
                          param.HIGH.
*/

EXTERN tree M2GenGCC_GetHighFromUnbounded (location_t location, unsigned int dim, unsigned int param);

/*
   StringToChar - if type=Char and str is a string (of size <= 1)
                  then convert the string into a character constant.
*/

EXTERN tree M2GenGCC_StringToChar (tree t, unsigned int type, unsigned int str);

/*
   LValueToGenericPtr - returns a Tree representing symbol, sym.
                        It coerces a lvalue into an internal pointer type
*/

EXTERN tree M2GenGCC_LValueToGenericPtr (location_t location, unsigned int sym);

/*
   ZConstToTypedConst - checks whether op1 and op2 are constants and
                        coerces, t, appropriately.
*/

EXTERN tree M2GenGCC_ZConstToTypedConst (tree t, unsigned int op1, unsigned int op2);

/*
   PrepareCopyString - returns two trees:
                       length    number of bytes to be copied (including the nul if room)
                       srcTreeType the new string type (with the extra nul character).

                       Pre condition:  destStrType the dest type string.
                                       src is the original string (without a nul)
                                       to be copied.
                       Post condition: TRUE or FALSE is returned.
                                       if true length and srcTreeType will be assigned
                                       else length is set to the maximum length to be
                                            copied and srcTree is set to the max length
                                            which fits in dest.
*/

EXTERN bool M2GenGCC_PrepareCopyString (unsigned int tokenno, tree *length, tree *srcTree, unsigned int src, unsigned int destStrType);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
