/* HideTracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from HideTracker.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <glib.h>
#include <gio/gio.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <float.h>
#include <math.h>
#include <mtk/mtk.h>
#include "gala.h"
#include <meta/meta-context.h>
#include <meta/meta-backend.h>
#include <meta/barrier.h>
#include <meta/meta-cursor-tracker.h>
#include <meta/compositor-mutter.h>
#include <meta/meta-monitor-manager.h>

#define GALA_HIDE_TRACKER_BARRIER_OFFSET 50
#define GALA_HIDE_TRACKER_UPDATE_TIMEOUT 200
#define GALA_HIDE_TRACKER_HIDE_DELAY 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_HIDE_TRACKER (gala_hide_tracker_get_type ())
#define GALA_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTracker))
#define GALA_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))
#define GALA_IS_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HIDE_TRACKER))
#define GALA_IS_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HIDE_TRACKER))
#define GALA_HIDE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))

typedef struct _GalaHideTracker GalaHideTracker;
typedef struct _GalaHideTrackerClass GalaHideTrackerClass;
typedef struct _GalaHideTrackerPrivate GalaHideTrackerPrivate;

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;

#define GALA_TYPE_PANEL_WINDOW (gala_panel_window_get_type ())
#define GALA_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindow))
#define GALA_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))
#define GALA_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PANEL_WINDOW))
#define GALA_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PANEL_WINDOW))
#define GALA_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))

typedef struct _GalaPanelWindow GalaPanelWindow;
typedef struct _GalaPanelWindowClass GalaPanelWindowClass;

#define GALA_TYPE_BARRIER (gala_barrier_get_type ())
#define GALA_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BARRIER, GalaBarrier))
#define GALA_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BARRIER, GalaBarrierClass))
#define GALA_IS_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BARRIER))
#define GALA_IS_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BARRIER))
#define GALA_BARRIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BARRIER, GalaBarrierClass))

typedef struct _GalaBarrier GalaBarrier;
typedef struct _GalaBarrierClass GalaBarrierClass;
enum  {
	GALA_HIDE_TRACKER_0_PROPERTY,
	GALA_HIDE_TRACKER_DISPLAY_PROPERTY,
	GALA_HIDE_TRACKER_PANEL_PROPERTY,
	GALA_HIDE_TRACKER_NUM_PROPERTIES
};
static GParamSpec* gala_hide_tracker_properties[GALA_HIDE_TRACKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
enum  {
	GALA_HIDE_TRACKER_HIDE_SIGNAL,
	GALA_HIDE_TRACKER_SHOW_SIGNAL,
	GALA_HIDE_TRACKER_NUM_SIGNALS
};
static guint gala_hide_tracker_signals[GALA_HIDE_TRACKER_NUM_SIGNALS] = {0};

struct _GalaHideTracker {
	GObject parent_instance;
	GalaHideTrackerPrivate * priv;
};

struct _GalaHideTrackerClass {
	GObjectClass parent_class;
};

struct _GalaHideTrackerPrivate {
	MetaDisplay* _display;
	GalaPanelWindow* _panel;
	ClutterPanAction* pan_action;
	gboolean hovered;
	guint num_transients;
	GalaBarrier* barrier;
	guint hide_timeout_id;
};

static gint GalaHideTracker_private_offset;
static gpointer gala_hide_tracker_parent_class = NULL;
static GSettings* gala_hide_tracker_behavior_settings;
static GSettings* gala_hide_tracker_behavior_settings = NULL;

VALA_EXTERN GType gala_hide_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHideTracker, g_object_unref)
VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPanelWindow, g_object_unref)
VALA_EXTERN GType gala_barrier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBarrier, g_object_unref)
VALA_EXTERN GalaHideTracker* gala_hide_tracker_new (MetaDisplay* display,
                                        GalaPanelWindow* panel);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_construct (GType object_type,
                                              MetaDisplay* display,
                                              GalaPanelWindow* panel);
static void gala_hide_tracker_on_window_created (GalaHideTracker* self,
                                          MetaWindow* new_window);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static void __lambda12_ (GalaHideTracker* self,
                  MetaWindowActor* new_window_actor);
VALA_EXTERN GalaPanelWindow* gala_hide_tracker_get_panel (GalaHideTracker* self);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
static void gala_hide_tracker_check_trigger_conditions (GalaHideTracker* self);
static void __lambda14_ (GalaHideTracker* self);
static void ___lambda14__meta_window_unmanaged (MetaWindow* _sender,
                                         gpointer self);
static void ___lambda12__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                   gpointer self);
static gboolean gala_hide_tracker_get_has_transients (GalaHideTracker* self);
static void gala_hide_tracker_trigger_show (GalaHideTracker* self);
static void gala_hide_tracker_trigger_hide (GalaHideTracker* self);
static void gala_hide_tracker_reset_hide_timeout (GalaHideTracker* self);
static void __lambda13_ (GalaHideTracker* self);
static void ___lambda13__gsource_once_func (gpointer self);
static gboolean gala_hide_tracker_check_valid_gesture (GalaHideTracker* self);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_anchor gala_panel_window_get_anchor (GalaPanelWindow* self);
VALA_EXTERN MetaDisplay* gala_hide_tracker_get_display (GalaHideTracker* self);
static gboolean gala_hide_tracker_on_pan (GalaHideTracker* self);
static void gala_hide_tracker_setup_barrier (GalaHideTracker* self);
static void gala_hide_tracker_setup_barrier_top (GalaHideTracker* self,
                                          MtkRectangle* monitor_geom,
                                          gint offset);
static void gala_hide_tracker_setup_barrier_bottom (GalaHideTracker* self,
                                             MtkRectangle* monitor_geom,
                                             gint offset);
VALA_EXTERN GalaBarrier* gala_barrier_new (MetaBackend* backend,
                               gint x1,
                               gint y1,
                               gint x2,
                               gint y2,
                               MetaBarrierDirection directions,
                               gdouble trigger_pressure_threshold,
                               gdouble release_pressure_threshold,
                               gdouble retrigger_pressure_threshold,
                               gint retrigger_delay);
VALA_EXTERN GalaBarrier* gala_barrier_construct (GType object_type,
                                     MetaBackend* backend,
                                     gint x1,
                                     gint y1,
                                     gint x2,
                                     gint y2,
                                     MetaBarrierDirection directions,
                                     gdouble trigger_pressure_threshold,
                                     gdouble release_pressure_threshold,
                                     gdouble retrigger_pressure_threshold,
                                     gint retrigger_delay);
static void gala_hide_tracker_on_barrier_triggered (GalaHideTracker* self);
static void _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger (GalaBarrier* _sender,
                                                                   gpointer self);
VALA_EXTERN gboolean gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display);
static void gala_hide_tracker_set_display (GalaHideTracker* self,
                                    MetaDisplay* value);
static void gala_hide_tracker_set_panel (GalaHideTracker* self,
                                  GalaPanelWindow* value);
static GObject * gala_hide_tracker_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_hide_tracker___lambda15_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda15__meta_window_unmanaging (MetaWindow* _sender,
                                                             gpointer self);
static void _gala_hide_tracker___lambda16_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda16__meta_cursor_tracker_position_invalidated (MetaCursorTracker* _sender,
                                                                               gpointer self);
static void _gala_hide_tracker_on_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                       MetaWindow* object,
                                                                       gpointer self);
static gboolean _gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin (ClutterGestureAction* _sender,
                                                                                      ClutterActor* actor,
                                                                                      gpointer self);
static gboolean _gala_hide_tracker_on_pan_clutter_pan_action_pan (ClutterPanAction* _sender,
                                                           ClutterActor* actor,
                                                           gboolean is_interpolated,
                                                           gpointer self);
static void _gala_hide_tracker_setup_barrier_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _gala_hide_tracker___lambda17_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda17__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                            gpointer self);
static void gala_hide_tracker_finalize (GObject * obj);
static GType gala_hide_tracker_get_type_once (void);
static void _vala_gala_hide_tracker_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_hide_tracker_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_hide_tracker_get_instance_private (GalaHideTracker* self)
{
	return G_STRUCT_MEMBER_P (self, GalaHideTracker_private_offset);
}

GalaHideTracker*
gala_hide_tracker_construct (GType object_type,
                             MetaDisplay* display,
                             GalaPanelWindow* panel)
{
	GalaHideTracker * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (panel != NULL, NULL);
	self = (GalaHideTracker*) g_object_new (object_type, "display", display, "panel", panel, NULL);
	return self;
}

GalaHideTracker*
gala_hide_tracker_new (MetaDisplay* display,
                       GalaPanelWindow* panel)
{
	return gala_hide_tracker_construct (GALA_TYPE_HIDE_TRACKER, display, panel);
}

static void
__lambda14_ (GalaHideTracker* self)
{
	guint _tmp0_;
	_tmp0_ = self->priv->num_transients;
	self->priv->num_transients = _tmp0_ - 1;
	gala_hide_tracker_check_trigger_conditions (self);
}

static void
___lambda14__meta_window_unmanaged (MetaWindow* _sender,
                                    gpointer self)
{
	__lambda14_ ((GalaHideTracker*) self);
}

static void
__lambda12_ (GalaHideTracker* self,
             MetaWindowActor* new_window_actor)
{
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	guint _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	g_return_if_fail (new_window_actor != NULL);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = meta_window_actor_get_meta_window (new_window_actor);
	_tmp4_ = _tmp3_;
	if (!meta_window_is_ancestor_of_transient (_tmp2_, _tmp4_)) {
		return;
	}
	_tmp5_ = self->priv->num_transients;
	self->priv->num_transients = _tmp5_ + 1;
	gala_hide_tracker_check_trigger_conditions (self);
	_tmp6_ = meta_window_actor_get_meta_window (new_window_actor);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "unmanaged", (GCallback) ___lambda14__meta_window_unmanaged, self, 0);
}

static void
___lambda12__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                              gpointer self)
{
	__lambda12_ ((GalaHideTracker*) self, window_actor);
}

static void
gala_hide_tracker_on_window_created (GalaHideTracker* self,
                                     MetaWindow* new_window)
{
	MetaWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_window != NULL);
	_tmp0_ = new_window;
	gala_internal_utils_wait_for_window_actor (_tmp0_, ___lambda12__gala_internal_utils_window_actor_ready_callback, g_object_ref (self), g_object_unref);
}

static void
gala_hide_tracker_check_trigger_conditions (GalaHideTracker* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->hovered) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gala_hide_tracker_get_has_transients (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gala_hide_tracker_trigger_show (self);
	} else {
		gala_hide_tracker_trigger_hide (self);
	}
}

static void
__lambda13_ (GalaHideTracker* self)
{
	g_signal_emit (self, gala_hide_tracker_signals[GALA_HIDE_TRACKER_HIDE_SIGNAL], 0);
	self->priv->hide_timeout_id = (guint) 0;
}

static void
___lambda13__gsource_once_func (gpointer self)
{
	__lambda13_ ((GalaHideTracker*) self);
}

static void
gala_hide_tracker_trigger_hide (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	gala_hide_tracker_reset_hide_timeout (self);
	self->priv->hide_timeout_id = g_timeout_add_once ((guint) GALA_HIDE_TRACKER_HIDE_DELAY, ___lambda13__gsource_once_func, self);
}

static void
gala_hide_tracker_reset_hide_timeout (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->hide_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->hide_timeout_id);
		self->priv->hide_timeout_id = (guint) 0;
	}
}

static void
gala_hide_tracker_trigger_show (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	gala_hide_tracker_reset_hide_timeout (self);
	g_signal_emit (self, gala_hide_tracker_signals[GALA_HIDE_TRACKER_SHOW_SIGNAL], 0);
}

static gboolean
gala_hide_tracker_check_valid_gesture (GalaHideTracker* self)
{
	GalaPanelWindow* _tmp0_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp1_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp2_;
	gfloat y = 0.0F;
	ClutterPanAction* _tmp3_;
	gfloat _tmp4_ = 0.0F;
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp5_;
	GalaPanelWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MtkRectangle _tmp9_ = {0};
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_panel_window_get_anchor (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM) {
		g_debug ("HideTracker.vala:134: Swipe to reveal is currently only supported for " \
"bottom anchors");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->pan_action;
	clutter_gesture_action_get_press_coords ((ClutterGestureAction*) _tmp3_, (guint) 0, NULL, &_tmp4_);
	y = _tmp4_;
	_tmp5_ = self->priv->_display;
	_tmp6_ = self->priv->_panel;
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp6_);
	_tmp8_ = _tmp7_;
	meta_display_get_monitor_geometry (_tmp5_, meta_window_get_monitor (_tmp8_), &_tmp9_);
	monitor_geom = _tmp9_;
	_tmp10_ = monitor_geom;
	_tmp11_ = monitor_geom;
	if (fabsf ((y - _tmp10_.y) - _tmp11_.height) < ((gfloat) 50)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gala_hide_tracker_on_pan (GalaHideTracker* self)
{
	gfloat delta_y = 0.0F;
	ClutterPanAction* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pan_action;
	clutter_pan_action_get_motion_delta (_tmp0_, (guint) 0, NULL, &_tmp1_);
	delta_y = _tmp1_;
	if (delta_y < ((gfloat) 0)) {
		GalaPanelWindow* _tmp2_;
		MetaWindow* _tmp3_;
		MetaWindow* _tmp4_;
		ClutterPanAction* _tmp5_;
		ClutterEvent* _tmp6_;
		_tmp2_ = self->priv->_panel;
		_tmp3_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->pan_action;
		_tmp6_ = clutter_gesture_action_get_last_event ((ClutterGestureAction*) _tmp5_, (guint) 0);
		meta_window_focus (_tmp4_, clutter_event_get_time (_tmp6_));
		gala_hide_tracker_trigger_show (self);
	}
	result = FALSE;
	return result;
}

static void
gala_hide_tracker_setup_barrier (GalaHideTracker* self)
{
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	gint offset = 0;
	GalaPanelWindow* _tmp5_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp6_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_display;
	meta_display_get_monitor_geometry (_tmp0_, meta_display_get_primary_monitor (_tmp1_), &_tmp2_);
	monitor_geom = _tmp2_;
	_tmp3_ = self->priv->_display;
	_tmp4_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp3_, meta_display_get_primary_monitor (_tmp4_));
	offset = gala_utils_scale_to_int (GALA_HIDE_TRACKER_BARRIER_OFFSET, scale);
	_tmp5_ = self->priv->_panel;
	_tmp6_ = gala_panel_window_get_anchor (_tmp5_);
	_tmp7_ = _tmp6_;
	switch (_tmp7_) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		{
			MtkRectangle _tmp8_;
			_tmp8_ = monitor_geom;
			gala_hide_tracker_setup_barrier_top (self, &_tmp8_, offset);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			MtkRectangle _tmp9_;
			_tmp9_ = monitor_geom;
			gala_hide_tracker_setup_barrier_bottom (self, &_tmp9_, offset);
			break;
		}
		default:
		{
			g_warning ("HideTracker.vala:176: Barrier side not supported yet");
			break;
		}
	}
}

static void
_gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger (GalaBarrier* _sender,
                                                              gpointer self)
{
	gala_hide_tracker_on_barrier_triggered ((GalaHideTracker*) self);
}

static void
gala_hide_tracker_setup_barrier_top (GalaHideTracker* self,
                                     MtkRectangle* monitor_geom,
                                     gint offset)
{
	MetaDisplay* _tmp0_;
	MetaContext* _tmp1_;
	MetaBackend* _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	GalaBarrier* _tmp8_;
	GalaBarrier* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_context (_tmp0_);
	_tmp2_ = meta_context_get_backend (_tmp1_);
	_tmp3_ = *monitor_geom;
	_tmp4_ = *monitor_geom;
	_tmp5_ = *monitor_geom;
	_tmp6_ = *monitor_geom;
	_tmp7_ = *monitor_geom;
	_tmp8_ = gala_barrier_new (_tmp2_, _tmp3_.x + offset, _tmp4_.y, (_tmp5_.x + _tmp6_.width) - offset, _tmp7_.y, META_BARRIER_DIRECTION_POSITIVE_Y, (gdouble) 0, (gdouble) 0, (gdouble) G_MAXINT, G_MAXINT);
	_g_object_unref0 (self->priv->barrier);
	self->priv->barrier = _tmp8_;
	_tmp9_ = self->priv->barrier;
	g_signal_connect_object (_tmp9_, "trigger", (GCallback) _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger, self, 0);
}

static void
gala_hide_tracker_setup_barrier_bottom (GalaHideTracker* self,
                                        MtkRectangle* monitor_geom,
                                        gint offset)
{
	MetaDisplay* _tmp0_;
	MetaContext* _tmp1_;
	MetaBackend* _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	GalaBarrier* _tmp10_;
	GalaBarrier* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_context (_tmp0_);
	_tmp2_ = meta_context_get_backend (_tmp1_);
	_tmp3_ = *monitor_geom;
	_tmp4_ = *monitor_geom;
	_tmp5_ = *monitor_geom;
	_tmp6_ = *monitor_geom;
	_tmp7_ = *monitor_geom;
	_tmp8_ = *monitor_geom;
	_tmp9_ = *monitor_geom;
	_tmp10_ = gala_barrier_new (_tmp2_, _tmp3_.x + offset, _tmp4_.y + _tmp5_.height, (_tmp6_.x + _tmp7_.width) - offset, _tmp8_.y + _tmp9_.height, META_BARRIER_DIRECTION_NEGATIVE_Y, 2.5, (gdouble) 0, (gdouble) G_MAXINT, G_MAXINT);
	_g_object_unref0 (self->priv->barrier);
	self->priv->barrier = _tmp10_;
	_tmp11_ = self->priv->barrier;
	g_signal_connect_object (_tmp11_, "trigger", (GCallback) _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger, self, 0);
}

static void
gala_hide_tracker_on_barrier_triggered (GalaHideTracker* self)
{
	MetaDisplay* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaDisplay* _tmp2_;
	GalaPanelWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	if (gala_internal_utils_get_x11_in_fullscreen (_tmp0_)) {
		return;
	}
	_tmp2_ = self->priv->_display;
	_tmp3_ = self->priv->_panel;
	_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (!meta_display_get_monitor_in_fullscreen (_tmp2_, meta_window_get_monitor (_tmp5_))) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp6_;
		_tmp6_ = gala_hide_tracker_behavior_settings;
		_tmp1_ = g_settings_get_boolean (_tmp6_, "enable-hotcorners-in-fullscreen");
	}
	if (_tmp1_) {
		gala_hide_tracker_trigger_show (self);
	}
}

MetaDisplay*
gala_hide_tracker_get_display (GalaHideTracker* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_hide_tracker_set_display (GalaHideTracker* self,
                               MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hide_tracker_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_hide_tracker_properties[GALA_HIDE_TRACKER_DISPLAY_PROPERTY]);
	}
}

GalaPanelWindow*
gala_hide_tracker_get_panel (GalaHideTracker* self)
{
	GalaPanelWindow* result;
	GalaPanelWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_panel;
	result = _tmp0_;
	return result;
}

static void
gala_hide_tracker_set_panel (GalaHideTracker* self,
                             GalaPanelWindow* value)
{
	GalaPanelWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hide_tracker_get_panel (self);
	if (old_value != value) {
		self->priv->_panel = value;
		g_object_notify_by_pspec ((GObject *) self, gala_hide_tracker_properties[GALA_HIDE_TRACKER_PANEL_PROPERTY]);
	}
}

static gboolean
gala_hide_tracker_get_has_transients (GalaHideTracker* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->num_transients > ((guint) 0);
	return result;
}

static void
_gala_hide_tracker___lambda15_ (GalaHideTracker* self)
{
	gala_hide_tracker_reset_hide_timeout (self);
}

static void
__gala_hide_tracker___lambda15__meta_window_unmanaging (MetaWindow* _sender,
                                                        gpointer self)
{
	_gala_hide_tracker___lambda15_ ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker___lambda16_ (GalaHideTracker* self)
{
	gboolean has_pointer = FALSE;
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	has_pointer = meta_window_has_pointer (_tmp2_);
	if (self->priv->hovered != has_pointer) {
		self->priv->hovered = has_pointer;
		gala_hide_tracker_check_trigger_conditions (self);
	}
}

static void
__gala_hide_tracker___lambda16__meta_cursor_tracker_position_invalidated (MetaCursorTracker* _sender,
                                                                          gpointer self)
{
	_gala_hide_tracker___lambda16_ ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker_on_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                  MetaWindow* object,
                                                                  gpointer self)
{
	gala_hide_tracker_on_window_created ((GalaHideTracker*) self, object);
}

static gboolean
_gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin (ClutterGestureAction* _sender,
                                                                             ClutterActor* actor,
                                                                             gpointer self)
{
	gboolean result;
	result = gala_hide_tracker_check_valid_gesture ((GalaHideTracker*) self);
	return result;
}

static gboolean
_gala_hide_tracker_on_pan_clutter_pan_action_pan (ClutterPanAction* _sender,
                                                  ClutterActor* actor,
                                                  gboolean is_interpolated,
                                                  gpointer self)
{
	gboolean result;
	result = gala_hide_tracker_on_pan ((GalaHideTracker*) self);
	return result;
}

static void
_gala_hide_tracker_setup_barrier_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	gala_hide_tracker_setup_barrier ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker___lambda17_ (GalaHideTracker* self)
{
	gala_hide_tracker_setup_barrier (self);
}

static void
__gala_hide_tracker___lambda17__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                       gpointer self)
{
	_gala_hide_tracker___lambda17_ ((GalaHideTracker*) self);
}

static GObject *
gala_hide_tracker_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaHideTracker * self;
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaCursorTracker* cursor_tracker = NULL;
	MetaDisplay* _tmp3_;
	MetaCursorTracker* _tmp4_;
	MetaCursorTracker* _tmp5_;
	MetaDisplay* _tmp6_;
	ClutterPanAction* _tmp7_ = NULL;
	ClutterPanAction* _tmp8_;
	ClutterPanAction* _tmp9_;
	MetaDisplay* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterPanAction* _tmp12_;
	GalaPanelWindow* _tmp13_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp14_;
	MetaContext* _tmp15_;
	MetaBackend* _tmp16_;
	MetaMonitorManager* _tmp17_;
	MetaMonitorManager* _tmp18_;
	MetaMonitorManager* _tmp19_;
	parent_class = G_OBJECT_CLASS (gala_hide_tracker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "unmanaging", (GCallback) __gala_hide_tracker___lambda15__meta_window_unmanaging, self, G_CONNECT_AFTER);
	_tmp3_ = self->priv->_display;
	_tmp4_ = meta_cursor_tracker_get_for_display (_tmp3_);
	cursor_tracker = _tmp4_;
	_tmp5_ = cursor_tracker;
	g_signal_connect_object (_tmp5_, "position-invalidated", (GCallback) __gala_hide_tracker___lambda16__meta_cursor_tracker_position_invalidated, self, 0);
	_tmp6_ = self->priv->_display;
	g_signal_connect_object (_tmp6_, "window-created", (GCallback) _gala_hide_tracker_on_window_created_meta_display_window_created, self, 0);
	_tmp7_ = (ClutterPanAction*) clutter_pan_action_new ();
	clutter_gesture_action_set_n_touch_points ((ClutterGestureAction*) _tmp7_, 1);
	clutter_pan_action_set_pan_axis (_tmp7_, CLUTTER_PAN_X_AXIS);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->pan_action);
	self->priv->pan_action = _tmp7_;
	_tmp8_ = self->priv->pan_action;
	g_signal_connect_object ((ClutterGestureAction*) _tmp8_, "gesture-begin", (GCallback) _gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin, self, 0);
	_tmp9_ = self->priv->pan_action;
	g_signal_connect_object (_tmp9_, "pan", (GCallback) _gala_hide_tracker_on_pan_clutter_pan_action_pan, self, 0);
	_tmp10_ = self->priv->_display;
	_tmp11_ = meta_get_stage_for_display (_tmp10_);
	_tmp12_ = self->priv->pan_action;
	clutter_actor_add_action_full (_tmp11_, "panel-swipe-gesture", CLUTTER_PHASE_CAPTURE, (ClutterAction*) _tmp12_);
	_tmp13_ = self->priv->_panel;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::anchor", (GCallback) _gala_hide_tracker_setup_barrier_g_object_notify, self, 0);
	_tmp14_ = self->priv->_display;
	_tmp15_ = meta_display_get_context (_tmp14_);
	_tmp16_ = meta_context_get_backend (_tmp15_);
	_tmp17_ = meta_backend_get_monitor_manager (_tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	monitor_manager = _tmp18_;
	_tmp19_ = monitor_manager;
	g_signal_connect_object (_tmp19_, "monitors-changed", (GCallback) __gala_hide_tracker___lambda17__meta_monitor_manager_monitors_changed, self, 0);
	gala_hide_tracker_setup_barrier (self);
	_g_object_unref0 (monitor_manager);
	return obj;
}

static void
gala_hide_tracker_class_init (GalaHideTrackerClass * klass,
                              gpointer klass_data)
{
	GSettings* _tmp0_;
	gala_hide_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaHideTracker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_hide_tracker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_hide_tracker_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_hide_tracker_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_hide_tracker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HIDE_TRACKER_DISPLAY_PROPERTY, gala_hide_tracker_properties[GALA_HIDE_TRACKER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HIDE_TRACKER_PANEL_PROPERTY, gala_hide_tracker_properties[GALA_HIDE_TRACKER_PANEL_PROPERTY] = g_param_spec_object ("panel", "panel", "panel", GALA_TYPE_PANEL_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_hide_tracker_signals[GALA_HIDE_TRACKER_HIDE_SIGNAL] = g_signal_new ("hide", GALA_TYPE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_hide_tracker_signals[GALA_HIDE_TRACKER_SHOW_SIGNAL] = g_signal_new ("show", GALA_TYPE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (gala_hide_tracker_behavior_settings);
	gala_hide_tracker_behavior_settings = _tmp0_;
}

static void
gala_hide_tracker_instance_init (GalaHideTracker * self,
                                 gpointer klass)
{
	self->priv = gala_hide_tracker_get_instance_private (self);
	self->priv->hovered = FALSE;
	self->priv->num_transients = (guint) 0;
	self->priv->hide_timeout_id = (guint) 0;
}

static void
gala_hide_tracker_finalize (GObject * obj)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->pan_action);
	_g_object_unref0 (self->priv->barrier);
	G_OBJECT_CLASS (gala_hide_tracker_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_hide_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaHideTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_hide_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaHideTracker), 0, (GInstanceInitFunc) gala_hide_tracker_instance_init, NULL };
	GType gala_hide_tracker_type_id;
	gala_hide_tracker_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaHideTracker", &g_define_type_info, 0);
	GalaHideTracker_private_offset = g_type_add_instance_private (gala_hide_tracker_type_id, sizeof (GalaHideTrackerPrivate));
	return gala_hide_tracker_type_id;
}

GType
gala_hide_tracker_get_type (void)
{
	static gsize gala_hide_tracker_type_id__once = 0;
	if (g_once_init_enter (&gala_hide_tracker_type_id__once)) {
		GType gala_hide_tracker_type_id;
		gala_hide_tracker_type_id = gala_hide_tracker_get_type_once ();
		g_once_init_leave (&gala_hide_tracker_type_id__once, gala_hide_tracker_type_id);
	}
	return gala_hide_tracker_type_id__once;
}

static void
_vala_gala_hide_tracker_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	switch (property_id) {
		case GALA_HIDE_TRACKER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_hide_tracker_get_display (self));
		break;
		case GALA_HIDE_TRACKER_PANEL_PROPERTY:
		g_value_set_object (value, gala_hide_tracker_get_panel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_hide_tracker_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	switch (property_id) {
		case GALA_HIDE_TRACKER_DISPLAY_PROPERTY:
		gala_hide_tracker_set_display (self, g_value_get_object (value));
		break;
		case GALA_HIDE_TRACKER_PANEL_PROPERTY:
		gala_hide_tracker_set_panel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

