/* WindowIcon.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowIcon.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <meta/window.h>
#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_WINDOW_ICON_0_PROPERTY,
	GALA_WINDOW_ICON_WINDOW_PROPERTY,
	GALA_WINDOW_ICON_ICON_SIZE_PROPERTY,
	GALA_WINDOW_ICON_SCALE_PROPERTY,
	GALA_WINDOW_ICON_NUM_PROPERTIES
};
static GParamSpec* gala_window_icon_properties[GALA_WINDOW_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaWindowIconPrivate {
	MetaWindow* _window;
	gint _icon_size;
	gint _scale;
};

static gint GalaWindowIcon_private_offset;
static gpointer gala_window_icon_parent_class = NULL;

static void gala_window_icon_reload_icon (GalaWindowIcon* self);
static GObject * gala_window_icon_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _gala_window_icon_reload_icon_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void gala_window_icon_finalize (GObject * obj);
static GType gala_window_icon_get_type_once (void);
static void _vala_gala_window_icon_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_gala_window_icon_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
gala_window_icon_get_instance_private (GalaWindowIcon* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowIcon_private_offset);
}

/**
     * Creates a new WindowIcon
     *
     * @param window               The window for which to create the icon
     * @param icon_size            The size of the icon in pixels
     * @param scale                The desired scale of the icon
     */
GalaWindowIcon*
gala_window_icon_construct (GType object_type,
                            MetaWindow* window,
                            gint icon_size,
                            gint scale)
{
	GalaWindowIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowIcon*) g_object_new (object_type, "window", window, "icon-size", icon_size, "scale", scale, NULL);
	return self;
}

GalaWindowIcon*
gala_window_icon_new (MetaWindow* window,
                      gint icon_size,
                      gint scale)
{
	return gala_window_icon_construct (GALA_TYPE_WINDOW_ICON, window, icon_size, scale);
}

static void
gala_window_icon_reload_icon (GalaWindowIcon* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkPixbuf* pixbuf = NULL;
	MetaWindow* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GdkPixbuf* _tmp7_;
	GalaImage* image = NULL;
	GalaImage* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_icon_size;
	_tmp1_ = self->priv->_scale;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (_tmp0_ * _tmp1_));
	_tmp2_ = self->priv->_icon_size;
	_tmp3_ = self->priv->_scale;
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (_tmp2_ * _tmp3_));
	_tmp4_ = self->priv->_window;
	_tmp5_ = self->priv->_icon_size;
	_tmp6_ = self->priv->_scale;
	_tmp7_ = gala_utils_get_icon_for_window (_tmp4_, _tmp5_, _tmp6_);
	pixbuf = _tmp7_;
	_tmp8_ = gala_image_new_from_pixbuf (pixbuf);
	image = _tmp8_;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) image);
	_g_object_unref0 (image);
	_g_object_unref0 (pixbuf);
}

MetaWindow*
gala_window_icon_get_window (GalaWindowIcon* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_window_icon_set_window (GalaWindowIcon* self,
                             MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_icon_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_icon_properties[GALA_WINDOW_ICON_WINDOW_PROPERTY]);
	}
}

gint
gala_window_icon_get_icon_size (GalaWindowIcon* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}

static void
gala_window_icon_set_icon_size (GalaWindowIcon* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_icon_get_icon_size (self);
	if (old_value != value) {
		self->priv->_icon_size = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_icon_properties[GALA_WINDOW_ICON_ICON_SIZE_PROPERTY]);
	}
}

gint
gala_window_icon_get_scale (GalaWindowIcon* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scale;
	return result;
}

static void
gala_window_icon_set_scale (GalaWindowIcon* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_icon_get_scale (self);
	if (old_value != value) {
		self->priv->_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_icon_properties[GALA_WINDOW_ICON_SCALE_PROPERTY]);
	}
}

static void
_gala_window_icon_reload_icon_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	gala_window_icon_reload_icon ((GalaWindowIcon*) self);
}

static GObject *
gala_window_icon_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowIcon * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	parent_class = G_OBJECT_CLASS (gala_window_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_ICON, GalaWindowIcon);
	_tmp0_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::wm-class", (GCallback) _gala_window_icon_reload_icon_g_object_notify, self, 0);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::gtk-application-id", (GCallback) _gala_window_icon_reload_icon_g_object_notify, self, 0);
	gala_window_icon_reload_icon (self);
	return obj;
}

static void
gala_window_icon_class_init (GalaWindowIconClass * klass,
                             gpointer klass_data)
{
	gala_window_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowIcon_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_icon_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_WINDOW_PROPERTY, gala_window_icon_properties[GALA_WINDOW_ICON_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_ICON_SIZE_PROPERTY, gala_window_icon_properties[GALA_WINDOW_ICON_ICON_SIZE_PROPERTY] = g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_SCALE_PROPERTY, gala_window_icon_properties[GALA_WINDOW_ICON_SCALE_PROPERTY] = g_param_spec_int ("scale", "scale", "scale", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_icon_instance_init (GalaWindowIcon * self,
                                gpointer klass)
{
	self->priv = gala_window_icon_get_instance_private (self);
}

static void
gala_window_icon_finalize (GObject * obj)
{
	GalaWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_ICON, GalaWindowIcon);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (gala_window_icon_parent_class)->finalize (obj);
}

/**
 * Creates a new ClutterTexture with an icon for the window at the given size.
 * This is recommended way to grab an icon for a window as this method will make
 * sure the icon is updated if it becomes available at a later point.
 */
 G_GNUC_NO_INLINE static GType
gala_window_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowIcon), 0, (GInstanceInitFunc) gala_window_icon_instance_init, NULL };
	GType gala_window_icon_type_id;
	gala_window_icon_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowIcon", &g_define_type_info, 0);
	GalaWindowIcon_private_offset = g_type_add_instance_private (gala_window_icon_type_id, sizeof (GalaWindowIconPrivate));
	return gala_window_icon_type_id;
}

GType
gala_window_icon_get_type (void)
{
	static gsize gala_window_icon_type_id__once = 0;
	if (g_once_init_enter (&gala_window_icon_type_id__once)) {
		GType gala_window_icon_type_id;
		gala_window_icon_type_id = gala_window_icon_get_type_once ();
		g_once_init_leave (&gala_window_icon_type_id__once, gala_window_icon_type_id);
	}
	return gala_window_icon_type_id__once;
}

static void
_vala_gala_window_icon_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GalaWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_ICON, GalaWindowIcon);
	switch (property_id) {
		case GALA_WINDOW_ICON_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_icon_get_window (self));
		break;
		case GALA_WINDOW_ICON_ICON_SIZE_PROPERTY:
		g_value_set_int (value, gala_window_icon_get_icon_size (self));
		break;
		case GALA_WINDOW_ICON_SCALE_PROPERTY:
		g_value_set_int (value, gala_window_icon_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_icon_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GalaWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_ICON, GalaWindowIcon);
	switch (property_id) {
		case GALA_WINDOW_ICON_WINDOW_PROPERTY:
		gala_window_icon_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_ICON_ICON_SIZE_PROPERTY:
		gala_window_icon_set_icon_size (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_ICON_SCALE_PROPERTY:
		gala_window_icon_set_scale (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

