/* Category.c generated by valac 0.56.18, the Vala compiler
 * generated from Category.vala, do not modify */

/* Category.vala
 *
 * Copyright (C) 2009-2024 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "font-manager.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;
typedef struct _FontManagerCacheablePrivate FontManagerCacheablePrivate;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;
typedef struct _FontManagerFontListFilterPrivate FontManagerFontListFilterPrivate;

#define FONT_MANAGER_TYPE_CATEGORY (font_manager_category_get_type ())
#define FONT_MANAGER_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory))
#define FONT_MANAGER_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))
#define FONT_MANAGER_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))

typedef struct _FontManagerCategory FontManagerCategory;
typedef struct _FontManagerCategoryClass FontManagerCategoryClass;
typedef struct _FontManagerCategoryPrivate FontManagerCategoryPrivate;
enum  {
	FONT_MANAGER_CATEGORY_0_PROPERTY,
	FONT_MANAGER_CATEGORY_SQL_PROPERTY,
	FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY,
	FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY,
	FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY,
	FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY,
	FONT_MANAGER_CATEGORY_SIZE_PROPERTY,
	FONT_MANAGER_CATEGORY_NUM_PROPERTIES
};
static GParamSpec* font_manager_category_properties[FONT_MANAGER_CATEGORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FontManagerCategoryUpdateData FontManagerCategoryUpdateData;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _FontManagerCacheable {
	GObject parent_instance;
	FontManagerCacheablePrivate * priv;
};

struct _FontManagerCacheableClass {
	GObjectClass parent_class;
	gboolean (*deserialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec, JsonNode* node);
	JsonNode* (*serialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec);
};

struct _FontManagerFontListFilter {
	FontManagerCacheable parent_instance;
	FontManagerFontListFilterPrivate * priv;
};

struct _FontManagerFontListFilterClass {
	FontManagerCacheableClass parent_class;
	void (*update) (FontManagerFontListFilter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (FontManagerFontListFilter* self, GAsyncResult* _res_);
	gboolean (*matches) (FontManagerFontListFilter* self, GObject* item);
	gchar* (*get_name) (FontManagerFontListFilter* self);
	void (*set_name) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_icon) (FontManagerFontListFilter* self);
	void (*set_icon) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_comment) (FontManagerFontListFilter* self);
	void (*set_comment) (FontManagerFontListFilter* self, const gchar* value);
	gint (*get_index) (FontManagerFontListFilter* self);
	void (*set_index) (FontManagerFontListFilter* self, gint value);
	gint (*get_size) (FontManagerFontListFilter* self);
	gint (*get_depth) (FontManagerFontListFilter* self);
	void (*set_depth) (FontManagerFontListFilter* self, gint value);
};

struct _FontManagerCategory {
	FontManagerFontListFilter parent_instance;
	FontManagerCategoryPrivate * priv;
};

struct _FontManagerCategoryClass {
	FontManagerFontListFilterClass parent_class;
};

struct _FontManagerCategoryPrivate {
	gchar* _sql;
	FontManagerStringSet* _families;
	FontManagerStringSet* _variations;
	gboolean _update_required;
	GPtrArray* _children;
};

struct _FontManagerCategoryUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FontManagerCategory* self;
	gboolean _tmp0_;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	const gchar* _tmp3_;
	FontManagerDatabase* db;
	FontManagerDatabase* _tmp4_;
	FontManagerDatabase* _tmp5_;
	FontManagerStringSet* _tmp6_;
	FontManagerStringSet* _tmp7_;
	const gchar* _tmp8_;
	gint i;
	gboolean _tmp9_;
	gint _tmp10_;
	GPtrArray* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GPtrArray* _tmp14_;
	gconstpointer _tmp15_;
	GError* e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_;
};

struct _Block17Data {
	int _ref_count_;
	FontManagerCategory* self;
	GPtrArray* res;
};

struct _Block18Data {
	int _ref_count_;
	FontManagerCategory* self;
	JsonObject* obj;
};

static gint FontManagerCategory_private_offset;
static gpointer font_manager_category_parent_class = NULL;

VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
VALA_EXTERN GType font_manager_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategory, g_object_unref)
VALA_EXTERN void font_manager_font_list_filter_update (FontManagerFontListFilter* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void font_manager_font_list_filter_update_finish (FontManagerFontListFilter* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN gboolean font_manager_font_list_filter_matches (FontManagerFontListFilter* self,
                                                GObject* item);
VALA_EXTERN gboolean font_manager_cacheable_deserialize_property (FontManagerCacheable* self,
                                                      const gchar* prop_name,
                                                      GValue* val,
                                                      GParamSpec* pspec,
                                                      JsonNode* node);
VALA_EXTERN JsonNode* font_manager_cacheable_serialize_property (FontManagerCacheable* self,
                                                     const gchar* prop_name,
                                                     GValue* val,
                                                     GParamSpec* pspec);
VALA_EXTERN gint font_manager_font_list_filter_get_size (FontManagerFontListFilter* self);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN FontManagerCategory* font_manager_category_new (const gchar* name,
                                                const gchar* comment,
                                                const gchar* icon,
                                                const gchar* sql,
                                                gint index);
VALA_EXTERN FontManagerCategory* font_manager_category_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* comment,
                                                      const gchar* icon,
                                                      const gchar* sql,
                                                      gint index);
static void font_manager_category_real_update_data_free (gpointer _data);
static void font_manager_category_real_update (FontManagerFontListFilter* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean font_manager_category_real_update_co (FontManagerCategoryUpdateData* _data_);
VALA_EXTERN gboolean font_manager_category_get_update_required (FontManagerCategory* self);
VALA_EXTERN FontManagerStringSet* font_manager_category_get_families (FontManagerCategory* self);
VALA_EXTERN FontManagerStringSet* font_manager_category_get_variations (FontManagerCategory* self);
VALA_EXTERN const gchar* font_manager_category_get_sql (FontManagerCategory* self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
VALA_EXTERN GPtrArray* font_manager_category_get_children (FontManagerCategory* self);
static void font_manager_category_update_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void font_manager_category_set_update_required (FontManagerCategory* self,
                                                gboolean value);
static gboolean font_manager_category_real_matches (FontManagerFontListFilter* base,
                                             GObject* item);
static gboolean font_manager_category_real_deserialize_property (FontManagerCacheable* base,
                                                          const gchar* prop_name,
                                                          GValue* val,
                                                          GParamSpec* pspec,
                                                          JsonNode* node);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void ___lambda26_ (Block17Data* _data17_,
                   JsonObject* obj,
                   const gchar* name,
                   JsonNode* node);
static void ____lambda26__json_object_foreach (JsonObject* object,
                                        const gchar* member_name,
                                        JsonNode* member_node,
                                        gpointer self);
static JsonNode* font_manager_category_real_serialize_property (FontManagerCacheable* base,
                                                         const gchar* prop_name,
                                                         GValue* val,
                                                         GParamSpec* pspec);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void ___lambda27_ (Block18Data* _data18_,
                   FontManagerCategory* child);
VALA_EXTERN gchar* font_manager_font_list_filter_get_name (FontManagerFontListFilter* self);
static void ____lambda27__gfunc (gconstpointer data,
                          gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void font_manager_category_set_sql (FontManagerCategory* self,
                                    const gchar* value);
VALA_EXTERN void font_manager_category_set_families (FontManagerCategory* self,
                                         FontManagerStringSet* value);
VALA_EXTERN void font_manager_category_set_variations (FontManagerCategory* self,
                                           FontManagerStringSet* value);
VALA_EXTERN void font_manager_category_set_children (FontManagerCategory* self,
                                         GPtrArray* value);
static void font_manager_category_finalize (GObject * obj);
static GType font_manager_category_get_type_once (void);
static void _vala_font_manager_category_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_font_manager_category_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_category_get_instance_private (FontManagerCategory* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerCategory_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

FontManagerCategory*
font_manager_category_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* comment,
                                 const gchar* icon,
                                 const gchar* sql,
                                 gint index)
{
	FontManagerCategory * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (comment != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (FontManagerCategory*) g_object_new (object_type, "name", name, "icon", icon, "comment", comment, "sql", sql, "index", index, NULL);
	return self;
}

FontManagerCategory*
font_manager_category_new (const gchar* name,
                           const gchar* comment,
                           const gchar* icon,
                           const gchar* sql,
                           gint index)
{
	return font_manager_category_construct (FONT_MANAGER_TYPE_CATEGORY, name, comment, icon, sql, index);
}

static void
font_manager_category_real_update_data_free (gpointer _data)
{
	FontManagerCategoryUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FontManagerCategoryUpdateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
font_manager_category_real_update (FontManagerFontListFilter* base,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	FontManagerCategory * self;
	FontManagerCategoryUpdateData* _data_;
	FontManagerCategory* _tmp0_;
	self = (FontManagerCategory*) base;
	_data_ = g_slice_new0 (FontManagerCategoryUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, font_manager_category_real_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	font_manager_category_real_update_co (_data_);
}

static void
font_manager_category_update_finish (FontManagerFontListFilter* base,
                                     GAsyncResult* _res_)
{
	FontManagerCategoryUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
font_manager_category_update_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	FontManagerCategoryUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	font_manager_category_real_update_co (_data_);
}

static gboolean
font_manager_category_real_update_co (FontManagerCategoryUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_update_required;
	if (!_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_families;
	font_manager_string_set_clear (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_variations;
	font_manager_string_set_clear (_data_->_tmp2_);
	{
		_data_->_tmp3_ = _data_->self->priv->_sql;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = font_manager_database_proxy_get_default_db ();
			_data_->db = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->db;
			_data_->_tmp6_ = _data_->self->priv->_families;
			_data_->_tmp7_ = _data_->self->priv->_variations;
			_data_->_tmp8_ = _data_->self->priv->_sql;
			font_manager_get_matching_families_and_fonts (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->db);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->db);
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp9_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp9_) {
						_data_->_tmp10_ = _data_->i;
						_data_->i = _data_->_tmp10_ + 1;
					}
					_data_->_tmp9_ = FALSE;
					_data_->_tmp11_ = _data_->self->priv->_children;
					_data_->_tmp12_ = vala_g_ptr_array_get_length (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					if (!(_data_->i < _data_->_tmp13_)) {
						break;
					}
					_data_->_tmp14_ = _data_->self->priv->_children;
					_data_->_tmp15_ = g_ptr_array_index (_data_->_tmp14_, (guint) _data_->i);
					_data_->_state_ = 1;
					font_manager_font_list_filter_update ((FontManagerFontListFilter*) ((FontManagerCategory*) _data_->_tmp15_), font_manager_category_update_ready, _data_);
					return FALSE;
					_state_1:
					font_manager_font_list_filter_update_finish ((FontManagerFontListFilter*) ((FontManagerCategory*) _data_->_tmp15_), _data_->_res_);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("Category.vala:56: %s", _data_->_tmp17_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	font_manager_category_set_update_required (_data_->self, FALSE);
	g_signal_emit_by_name ((FontManagerCacheable*) _data_->self, "changed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
font_manager_category_real_matches (FontManagerFontListFilter* base,
                                    GObject* item)
{
	FontManagerCategory * self;
	const gchar* _tmp0_;
	gboolean visible = FALSE;
	gboolean result;
	self = (FontManagerCategory*) base;
	_tmp0_ = self->priv->_sql;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	visible = FALSE;
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, font_manager_family_get_type ())) {
		FontManagerStringSet* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->_families;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (item, font_manager_family_get_type (), FontManagerFamily), "family", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		visible = font_manager_string_set_contains (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, font_manager_font_get_type ())) {
			FontManagerStringSet* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = self->priv->_variations;
			g_object_get (G_TYPE_CHECK_INSTANCE_CAST (item, font_manager_font_get_type (), FontManagerFont), "description", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			visible = font_manager_string_set_contains (_tmp5_, _tmp8_);
			_g_free0 (_tmp8_);
		}
	}
	result = visible;
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		FontManagerCategory* self;
		self = _data17_->self;
		_g_ptr_array_unref0 (_data17_->res);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
___lambda26_ (Block17Data* _data17_,
              JsonObject* obj,
              const gchar* name,
              JsonNode* node)
{
	FontManagerCategory* self;
	GObject* child = NULL;
	GObject* _tmp0_;
	GPtrArray* _tmp1_;
	FontManagerCategory* _tmp2_;
	self = _data17_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_gobject_deserialize (FONT_MANAGER_TYPE_CATEGORY, node);
	child = _tmp0_;
	_tmp1_ = _data17_->res;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory));
	g_ptr_array_add (_tmp1_, _tmp2_);
	_g_object_unref0 (child);
}

static void
____lambda26__json_object_foreach (JsonObject* object,
                                   const gchar* member_name,
                                   JsonNode* member_node,
                                   gpointer self)
{
	___lambda26_ (self, object, member_name, member_node);
}

static gboolean
font_manager_category_real_deserialize_property (FontManagerCacheable* base,
                                                 const gchar* prop_name,
                                                 GValue* val,
                                                 GParamSpec* pspec,
                                                 JsonNode* node)
{
	FontManagerCategory * self;
	GValue _vala_val = {0};
	GValue _tmp0_ = {0};
	gboolean result;
	self = (FontManagerCategory*) base;
	g_return_val_if_fail (prop_name != NULL, FALSE);
	g_return_val_if_fail (pspec != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	g_value_init (&_tmp0_, pspec->value_type);
	G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	_vala_val = _tmp0_;
	if (pspec->value_type == G_TYPE_PTR_ARRAY) {
		Block17Data* _data17_;
		GPtrArray* _tmp1_;
		JsonObject* _tmp2_;
		GPtrArray* _tmp3_;
		_data17_ = g_slice_new0 (Block17Data);
		_data17_->_ref_count_ = 1;
		_data17_->self = g_object_ref (self);
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_data17_->res = _tmp1_;
		_tmp2_ = json_node_get_object (node);
		json_object_foreach_member (_tmp2_, ____lambda26__json_object_foreach, _data17_);
		_tmp3_ = _data17_->res;
		g_value_set_boxed (&_vala_val, _tmp3_);
		result = TRUE;
		block17_data_unref (_data17_);
		_data17_ = NULL;
		if (val) {
			*val = _vala_val;
		} else {
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
		}
		return result;
	} else {
		if (pspec->value_type == font_manager_string_set_get_type ()) {
			FontManagerStringSet* res = NULL;
			FontManagerStringSet* _tmp4_;
			FontManagerStringSet* _tmp5_;
			_tmp4_ = font_manager_string_set_new ();
			res = _tmp4_;
			_tmp5_ = res;
			g_value_set_object (&_vala_val, (GObject*) _tmp5_);
			result = TRUE;
			_g_object_unref0 (res);
			if (val) {
				*val = _vala_val;
			} else {
				G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			}
			return result;
		} else {
			GValue _tmp6_ = {0};
			gboolean _tmp7_;
			_tmp7_ = FONT_MANAGER_CACHEABLE_CLASS (font_manager_category_parent_class)->deserialize_property ((FontManagerCacheable*) G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter), prop_name, &_tmp6_, pspec, node);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp6_;
			result = _tmp7_;
			if (val) {
				*val = _vala_val;
			} else {
				G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			}
			return result;
		}
	}
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		FontManagerCategory* self;
		self = _data18_->self;
		_json_object_unref0 (_data18_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
___lambda27_ (Block18Data* _data18_,
              FontManagerCategory* child)
{
	FontManagerCategory* self;
	JsonObject* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	JsonNode* _tmp6_;
	self = _data18_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _data18_->obj;
	_tmp1_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) child);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strescape (_tmp3_, "");
	_tmp5_ = _tmp4_;
	_tmp6_ = json_gobject_serialize ((GObject*) child);
	json_object_set_member (_tmp0_, _tmp5_, _tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

static void
____lambda27__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda27_ (self, (FontManagerCategory*) data);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static JsonNode*
font_manager_category_real_serialize_property (FontManagerCacheable* base,
                                               const gchar* prop_name,
                                               GValue* val,
                                               GParamSpec* pspec)
{
	FontManagerCategory * self;
	JsonNode* result;
	self = (FontManagerCategory*) base;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	g_return_val_if_fail (pspec != NULL, NULL);
	if (pspec->value_type == G_TYPE_PTR_ARRAY) {
		Block18Data* _data18_;
		JsonNode* node = NULL;
		JsonNode* _tmp0_;
		JsonObject* _tmp1_;
		GPtrArray* _tmp2_;
		JsonNode* _tmp3_;
		JsonObject* _tmp4_;
		_data18_ = g_slice_new0 (Block18Data);
		_data18_->_ref_count_ = 1;
		_data18_->self = g_object_ref (self);
		_tmp0_ = json_node_new (JSON_NODE_OBJECT);
		node = _tmp0_;
		_tmp1_ = json_object_new ();
		_data18_->obj = _tmp1_;
		_tmp2_ = self->priv->_children;
		g_ptr_array_foreach (_tmp2_, ____lambda27__gfunc, _data18_);
		_tmp3_ = node;
		_tmp4_ = _data18_->obj;
		json_node_set_object (_tmp3_, _tmp4_);
		result = node;
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return result;
	} else {
		if (pspec->value_type == font_manager_string_set_get_type ()) {
			JsonNode* node = NULL;
			JsonNode* _tmp5_;
			JsonArray* arr = NULL;
			JsonArray* _tmp6_;
			JsonNode* _tmp7_;
			JsonArray* _tmp8_;
			_tmp5_ = json_node_new (JSON_NODE_ARRAY);
			node = _tmp5_;
			_tmp6_ = json_array_new ();
			arr = _tmp6_;
			_tmp7_ = node;
			_tmp8_ = arr;
			json_node_set_array (_tmp7_, _tmp8_);
			result = node;
			_json_array_unref0 (arr);
			return result;
		} else {
			GValue _tmp9_;
			JsonNode* _tmp10_;
			_tmp9_ = *val;
			_tmp10_ = FONT_MANAGER_CACHEABLE_CLASS (font_manager_category_parent_class)->serialize_property ((FontManagerCacheable*) G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter), prop_name, &_tmp9_, pspec);
			result = _tmp10_;
			return result;
		}
	}
}

const gchar*
font_manager_category_get_sql (FontManagerCategory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql;
	result = _tmp0_;
	return result;
}

void
font_manager_category_set_sql (FontManagerCategory* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_get_sql (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql);
		self->priv->_sql = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_properties[FONT_MANAGER_CATEGORY_SQL_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_category_get_families (FontManagerCategory* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_families;
	result = _tmp0_;
	return result;
}

void
font_manager_category_set_families (FontManagerCategory* self,
                                    FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_get_families (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_families);
		self->priv->_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_properties[FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_category_get_variations (FontManagerCategory* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variations;
	result = _tmp0_;
	return result;
}

void
font_manager_category_set_variations (FontManagerCategory* self,
                                      FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_get_variations (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_variations);
		self->priv->_variations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_properties[FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY]);
	}
}

gboolean
font_manager_category_get_update_required (FontManagerCategory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_update_required;
	return result;
}

void
font_manager_category_set_update_required (FontManagerCategory* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_get_update_required (self);
	if (old_value != value) {
		self->priv->_update_required = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_properties[FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY]);
	}
}

GPtrArray*
font_manager_category_get_children (FontManagerCategory* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
font_manager_category_set_children (FontManagerCategory* self,
                                    GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_get_children (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_children);
		self->priv->_children = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_properties[FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY]);
	}
}

static gint
font_manager_category_real_get_size (FontManagerFontListFilter* base)
{
	gint result;
	FontManagerCategory* self;
	FontManagerStringSet* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = (FontManagerCategory*) base;
	_tmp0_ = self->priv->_families;
	g_object_get (_tmp0_, "size", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = (gint) _tmp2_;
	return result;
}

static void
font_manager_category_class_init (FontManagerCategoryClass * klass,
                                  gpointer klass_data)
{
	font_manager_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerCategory_private_offset);
	((FontManagerFontListFilterClass *) klass)->update = (void (*) (FontManagerFontListFilter*, GAsyncReadyCallback, gpointer)) font_manager_category_real_update;
	((FontManagerFontListFilterClass *) klass)->update_finish = (void (*) (FontManagerFontListFilter*, GAsyncResult*)) font_manager_category_update_finish;
	((FontManagerFontListFilterClass *) klass)->matches = (gboolean (*) (FontManagerFontListFilter*, GObject*)) font_manager_category_real_matches;
	((FontManagerCacheableClass *) klass)->deserialize_property = (gboolean (*) (FontManagerCacheable*, const gchar*, GValue*, GParamSpec*, JsonNode*)) font_manager_category_real_deserialize_property;
	((FontManagerCacheableClass *) klass)->serialize_property = (JsonNode* (*) (FontManagerCacheable*, const gchar*, GValue*, GParamSpec*)) font_manager_category_real_serialize_property;
	FONT_MANAGER_FONT_LIST_FILTER_CLASS (klass)->get_size = (gint (*) (FontManagerFontListFilter*)) font_manager_category_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_category_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_category_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_category_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_SQL_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_SQL_PROPERTY] = g_param_spec_string ("sql", "sql", "sql", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY] = g_param_spec_object ("families", "families", "families", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY] = g_param_spec_object ("variations", "variations", "variations", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY] = g_param_spec_boolean ("update-required", "update-required", "update-required", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY] = g_param_spec_boxed ("children", "children", "children", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_SIZE_PROPERTY, font_manager_category_properties[FONT_MANAGER_CATEGORY_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_category_instance_init (FontManagerCategory * self,
                                     gpointer klass)
{
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	GPtrArray* _tmp2_;
	self->priv = font_manager_category_get_instance_private (self);
	self->priv->_sql = NULL;
	_tmp0_ = font_manager_string_set_new ();
	self->priv->_families = _tmp0_;
	_tmp1_ = font_manager_string_set_new ();
	self->priv->_variations = _tmp1_;
	self->priv->_update_required = TRUE;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->_children = _tmp2_;
}

static void
font_manager_category_finalize (GObject * obj)
{
	FontManagerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory);
	_g_free0 (self->priv->_sql);
	_g_object_unref0 (self->priv->_families);
	_g_object_unref0 (self->priv->_variations);
	_g_ptr_array_unref0 (self->priv->_children);
	G_OBJECT_CLASS (font_manager_category_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_category_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCategory), 0, (GInstanceInitFunc) font_manager_category_instance_init, NULL };
	GType font_manager_category_type_id;
	font_manager_category_type_id = g_type_register_static (FONT_MANAGER_TYPE_FONT_LIST_FILTER, "FontManagerCategory", &g_define_type_info, 0);
	FontManagerCategory_private_offset = g_type_add_instance_private (font_manager_category_type_id, sizeof (FontManagerCategoryPrivate));
	return font_manager_category_type_id;
}

GType
font_manager_category_get_type (void)
{
	static volatile gsize font_manager_category_type_id__once = 0;
	if (g_once_init_enter (&font_manager_category_type_id__once)) {
		GType font_manager_category_type_id;
		font_manager_category_type_id = font_manager_category_get_type_once ();
		g_once_init_leave (&font_manager_category_type_id__once, font_manager_category_type_id);
	}
	return font_manager_category_type_id__once;
}

static void
_vala_font_manager_category_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	FontManagerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory);
	switch (property_id) {
		case FONT_MANAGER_CATEGORY_SQL_PROPERTY:
		g_value_set_string (value, font_manager_category_get_sql (self));
		break;
		case FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_category_get_families (self));
		break;
		case FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY:
		g_value_set_object (value, font_manager_category_get_variations (self));
		break;
		case FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY:
		g_value_set_boolean (value, font_manager_category_get_update_required (self));
		break;
		case FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY:
		g_value_set_boxed (value, font_manager_category_get_children (self));
		break;
		case FONT_MANAGER_CATEGORY_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_font_list_filter_get_size ((FontManagerFontListFilter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_category_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	FontManagerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory);
	switch (property_id) {
		case FONT_MANAGER_CATEGORY_SQL_PROPERTY:
		font_manager_category_set_sql (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_CATEGORY_FAMILIES_PROPERTY:
		font_manager_category_set_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_VARIATIONS_PROPERTY:
		font_manager_category_set_variations (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_UPDATE_REQUIRED_PROPERTY:
		font_manager_category_set_update_required (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_CATEGORY_CHILDREN_PROPERTY:
		font_manager_category_set_children (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

