/* THIS FILE IS AUTOGENERATED FROM Navigation.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_NAVIGATIONBINDING_H_
#define DOM_NAVIGATIONBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/PrototypeList.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class Navigation;
struct NavigationNavigateOptionsAtoms;
struct NavigationOptionsAtoms;
struct NavigationReloadOptionsAtoms;
struct NavigationResultAtoms;
struct NavigationUpdateCurrentEntryOptionsAtoms;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class NavigationHistoryBehavior : uint8_t {
  Auto,
  Push,
  Replace,
};

namespace binding_detail {
template <> struct EnumStrings<NavigationHistoryBehavior> {
  static constexpr nsLiteralCString Values[3] {
    "auto"_ns,
    "push"_ns,
    "replace"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, NavigationHistoryBehavior aArgument, JS::MutableHandle<JS::Value> aValue);


enum class NavigationType : uint8_t {
  Push,
  Replace,
  Reload,
  Traverse,
};

namespace binding_detail {
template <> struct EnumStrings<NavigationType> {
  static constexpr nsLiteralCString Values[4] {
    "push"_ns,
    "replace"_ns,
    "reload"_ns,
    "traverse"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, NavigationType aArgument, JS::MutableHandle<JS::Value> aValue);


struct NavigationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mInfo;

  NavigationOptions();

  explicit inline NavigationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NavigationOptions(NavigationOptions&& aOther) = default;

private:
  NavigationOptions(const NavigationOptions&) = delete;
  NavigationOptions& operator=(const NavigationOptions&) = delete;

  static bool
  InitIds(JSContext* cx, NavigationOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastNavigationOptions : public NavigationOptions
{
  inline FastNavigationOptions()
    : NavigationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct NavigationResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<Promise>> mCommitted;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<Promise>> mFinished;

  NavigationResult();

  explicit inline NavigationResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NavigationResult(NavigationResult&& aOther) = default;

private:
  NavigationResult(const NavigationResult&) = delete;
  NavigationResult& operator=(const NavigationResult&) = delete;

  static bool
  InitIds(JSContext* cx, NavigationResultAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mCommitted, "mCommitted", aFlags);
    ImplCycleCollectionTraverse(aCallback, mFinished, "mFinished", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mCommitted);
    ImplCycleCollectionUnlink(mFinished);
  }
};

namespace binding_detail {
struct FastNavigationResult : public NavigationResult
{
  inline FastNavigationResult()
    : NavigationResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct NavigationUpdateCurrentEntryOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mState;

  NavigationUpdateCurrentEntryOptions();

  explicit inline NavigationUpdateCurrentEntryOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NavigationUpdateCurrentEntryOptions(NavigationUpdateCurrentEntryOptions&& aOther) = default;

private:
  NavigationUpdateCurrentEntryOptions(const NavigationUpdateCurrentEntryOptions&) = delete;
  NavigationUpdateCurrentEntryOptions& operator=(const NavigationUpdateCurrentEntryOptions&) = delete;

  static bool
  InitIds(JSContext* cx, NavigationUpdateCurrentEntryOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastNavigationUpdateCurrentEntryOptions : public NavigationUpdateCurrentEntryOptions
{
  inline FastNavigationUpdateCurrentEntryOptions()
    : NavigationUpdateCurrentEntryOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct NavigationNavigateOptions : public NavigationOptions
{
  MOZ_INIT_OUTSIDE_CTOR NavigationHistoryBehavior mHistory;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mState;

  NavigationNavigateOptions();

  explicit inline NavigationNavigateOptions(const FastDictionaryInitializer& )
    : NavigationOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NavigationNavigateOptions(NavigationNavigateOptions&& aOther) = default;

private:
  NavigationNavigateOptions(const NavigationNavigateOptions&) = delete;
  NavigationNavigateOptions& operator=(const NavigationNavigateOptions&) = delete;

  static bool
  InitIds(JSContext* cx, NavigationNavigateOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastNavigationNavigateOptions : public NavigationNavigateOptions
{
  inline FastNavigationNavigateOptions()
    : NavigationNavigateOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct NavigationReloadOptions : public NavigationOptions
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mState;

  NavigationReloadOptions();

  explicit inline NavigationReloadOptions(const FastDictionaryInitializer& )
    : NavigationOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NavigationReloadOptions(NavigationReloadOptions&& aOther) = default;

private:
  NavigationReloadOptions(const NavigationReloadOptions&) = delete;
  NavigationReloadOptions& operator=(const NavigationReloadOptions&) = delete;

  static bool
  InitIds(JSContext* cx, NavigationReloadOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastNavigationReloadOptions : public NavigationReloadOptions
{
  inline FastNavigationReloadOptions()
    : NavigationReloadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Navigation_Binding {

  typedef mozilla::dom::Navigation NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Navigation* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Navigation,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Navigation_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::NavigationHistoryBehavior>
{
  static constexpr dom::NavigationHistoryBehavior value = dom::NavigationHistoryBehavior::Replace;

  static_assert(static_cast<uint8_t>(dom::NavigationHistoryBehavior::Auto) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::NavigationHistoryBehavior>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::NavigationType>
{
  static constexpr dom::NavigationType value = dom::NavigationType::Traverse;

  static_assert(static_cast<uint8_t>(dom::NavigationType::Push) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::NavigationType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_NAVIGATIONBINDING_H_
