#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_PINYIN_ENHANCE_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_PINYIN_ENHANCE_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-pinyin-enhance", _PinyinEnhance_)

static void*
__fcitx_PinyinEnhance_function_FindPy(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(PinyinEnhance*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    PinyinEnhance* self = __self;
    FCITX_UNUSED(self);
    const int8_t* res = (py_enhance_py_find_py(self, arg0));
    FCITX_RETURN_AS_PTR(const int8_t*, res);
}

static void*
__fcitx_PinyinEnhance_function_PyToString(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(PinyinEnhance*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const int8_t*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(int*, arg2, _args.args[2]);
    PinyinEnhance* self = __self;
    FCITX_UNUSED(self);
    char* res = (py_enhance_py_to_str(arg0, arg1, arg2));
    FCITX_RETURN_AS_PTR(char*, res);
}

static void
FcitxPinyinEnhanceAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_PinyinEnhance_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_PinyinEnhance_addon_functions_table[] = {
        __fcitx_PinyinEnhance_function_FindPy,
        __fcitx_PinyinEnhance_function_PyToString,
    };
    for (i = 0;i < 2;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_PinyinEnhance_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
