
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "wheelhelper_wrapper.h"

// Argument includes
#include <qevent.h>
#include <wheelhelper.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_WheelHelper_Type = nullptr;
static PyTypeObject *Sbk_WheelHelper_TypeF(void)
{
    return _Sbk_WheelHelper_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WheelHelper_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WheelHelper >()))
        return -1;

    ::WheelHelper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "WheelHelper", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: WheelHelper::WheelHelper()
    // 1: WheelHelper::WheelHelper(WheelHelper)
    if (numArgs == 0) {
        overloadId = 0; // WheelHelper()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), (pyArgs[0])))) {
        overloadId = 1; // WheelHelper(WheelHelper)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // WheelHelper()
        {

            // WheelHelper()
            cptr = new ::WheelHelper();
            break;
        }
        case 1: // WheelHelper(const WheelHelper &WheelHelper)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WheelHelper cppArg0_local;
            ::WheelHelper *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // WheelHelper(WheelHelper)
                cptr = new ::WheelHelper(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::WheelHelper >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_WheelHelperFunc_processEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WheelHelper::processEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArg)))) {
        overloadId = 0; // processEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "processEvent", errInfo, SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processEvent(QWheelEvent*)
            cppSelf->processEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WheelHelperFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reset()
        cppSelf->reset();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WheelHelperFunc_takeDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // takeDirection()
        WheelHelper::Direction cppResult = WheelHelper::Direction(cppSelf->takeDirection());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_Direction_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WheelHelper__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_WheelHelper_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_WheelHelper_EnumFlagInfo[] = {
    "Direction:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_WheelHelper_methods[] = {
    {"processEvent", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_processEvent), METH_O, nullptr},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_reset), METH_NOARGS, nullptr},
    {"takeDirection", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_takeDirection), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_WheelHelper__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_WheelHelper_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_WheelHelper_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_WheelHelper_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WheelHelper_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WheelHelper_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WheelHelper_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WheelHelper_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_WheelHelper_spec = {
    "1:PyFalkon.WheelHelper",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_WheelHelper_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_WheelHelper_Direction(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::WheelHelper::Direction>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::WheelHelper::Direction *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_WheelHelper_Direction_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_Direction_IDX])))
        return Enum_PythonToCpp_WheelHelper_Direction;
    return {};
}

static PyObject *WheelHelper_Direction_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::WheelHelper::Direction>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::WheelHelper::Direction *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WheelHelper_PythonToCpp_WheelHelper_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_WheelHelper_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WheelHelper_PythonToCpp_WheelHelper_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_WheelHelper_TypeF()))
        return WheelHelper_PythonToCpp_WheelHelper_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WheelHelper_PTR_CppToPython_WheelHelper(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_WheelHelper_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_WheelHelper_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *WheelHelper_COPY_CppToPython_WheelHelper(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::WheelHelper *>(cppIn);
    return Shiboken::Object::newObject(Sbk_WheelHelper_TypeF(), new ::WheelHelper(*source), true, true);
}

// Python to C++ copy conversion.
static void WheelHelper_PythonToCpp_WheelHelper_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::WheelHelper *>(cppOut) = *reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_WheelHelper_PythonToCpp_WheelHelper_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_WheelHelper_TypeF()))
        return WheelHelper_PythonToCpp_WheelHelper_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *WheelHelper_SignatureStrings[] = {
    "1:PyFalkon.WheelHelper(self)",
    "0:PyFalkon.WheelHelper(self,WheelHelper:PyFalkon.WheelHelper)",
    "PyFalkon.WheelHelper.processEvent(self,event:PySide6.QtGui.QWheelEvent)",
    "PyFalkon.WheelHelper.reset(self)",
    "PyFalkon.WheelHelper.takeDirection(self)->PyFalkon.WheelHelper.Direction",
    "PyFalkon.WheelHelper.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t WheelHelper_SignatureByteSize = 144;
static constexpr uint8_t WheelHelper_SignatureBytes[144] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0xcf, 0x48,
    0x4d, 0xcd, 0xf1, 0x48, 0xcd, 0x29, 0x48, 0x2d, 0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32,
    0xc0, 0x2d, 0xa9, 0x83, 0x24, 0x80, 0x55, 0x95, 0x26, 0x17, 0x36, 0x51, 0xbd, 0x82, 0xa2, 0xfc,
    0xe4, 0xd4, 0xe2, 0x62, 0xd7, 0xb2, 0xd4, 0xbc, 0x12, 0x88, 0x41, 0xa9, 0x20, 0x26, 0xd0, 0x88,
    0xe0, 0xcc, 0x94, 0x54, 0x33, 0xbd, 0xc0, 0x12, 0xf7, 0xd2, 0x4c, 0xbd, 0x40, 0xb0, 0x16, 0xb0,
    0x22, 0x1c, 0xe6, 0x14, 0xa5, 0x16, 0xa7, 0x96, 0x40, 0x9d, 0x89, 0x55, 0x41, 0x49, 0x62, 0x76,
    0xaa, 0x4b, 0x66, 0x51, 0x6a, 0x72, 0x49, 0x66, 0x7e, 0x1e, 0x44, 0xa1, 0xae, 0x1d, 0x56, 0x95,
    0x70, 0x55, 0xd8, 0x0d, 0x8a, 0x8f, 0x4f, 0xce, 0x2f, 0xa8, 0x8c, 0x8f, 0x87, 0x99, 0x51, 0x52,
    0x59, 0x90, 0x99, 0x97, 0xae, 0x17, 0x1f, 0x0c, 0xe4, 0x72, 0x01, 0x00, 0x7a, 0xa8, 0x74, 0x31
};
#endif

PyTypeObject *init_WheelHelper(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX].type;

    Shiboken::AutoDecRef Sbk_WheelHelper_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_WheelHelper_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WheelHelper",
        "WheelHelper",
        &Sbk_WheelHelper_spec,
        &Shiboken::callCppDestructor< ::WheelHelper >,
        Sbk_WheelHelper_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_WheelHelper_Type; // references _Sbk_WheelHelper_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, WheelHelper_SignatureStrings);
#else
    InitSignatureBytes(pyType, WheelHelper_SignatureBytes, WheelHelper_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_WheelHelper_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_WheelHelper_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        WheelHelper_PythonToCpp_WheelHelper_PTR,
        is_WheelHelper_PythonToCpp_WheelHelper_PTR_Convertible,
        WheelHelper_PTR_CppToPython_WheelHelper,
        WheelHelper_COPY_CppToPython_WheelHelper);

    Shiboken::Conversions::registerConverterName(converter, "WheelHelper");
    Shiboken::Conversions::registerConverterName(converter, "WheelHelper*");
    Shiboken::Conversions::registerConverterName(converter, "WheelHelper&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WheelHelper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WheelHelper_PythonToCpp_WheelHelper_COPY,
        is_WheelHelper_PythonToCpp_WheelHelper_COPY_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_WheelHelper_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Direction'.
    const char *Direction_Initializer[] = {
        "None_",
        "WheelUp",
        "WheelDown",
        "WheelLeft",
        "WheelRight",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Direction_InitializerValues[] = {
        uint8_t(WheelHelper::Direction::None),      //  0x00  0
        uint8_t(WheelHelper::Direction::WheelUp),   //  0x01  1
        uint8_t(WheelHelper::Direction::WheelDown), //  0x02  2
        uint8_t(WheelHelper::Direction::WheelLeft), //  0x03  3
        uint8_t(WheelHelper::Direction::WheelRight) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_WheelHelper_TypeF(),
        "1:PyFalkon.WheelHelper.Direction",
        Direction_Initializer, Direction_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_WheelHelper_Direction_IDX].type = EType;
    // Register converter for enum 'WheelHelper::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            WheelHelper_Direction_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_WheelHelper_Direction,
            is_Enum_PythonToCpp_WheelHelper_Direction_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "WheelHelper::Direction");
        Shiboken::Conversions::registerConverterAlias(converter, "Direction");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Direction' enum.

    qRegisterMetaType< ::WheelHelper >("WheelHelper");
    qRegisterMetaType< ::WheelHelper::Direction >("WheelHelper::Direction");

    return pyType;
}
