
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sqldatabase_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SqlDatabase_Type = nullptr;
static PyTypeObject *Sbk_SqlDatabase_TypeF(void)
{
    return _Sbk_SqlDatabase_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SqlDatabaseWrapper::pysideInitQtMetaTypes()
{
}

void SqlDatabaseWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SqlDatabaseWrapper::SqlDatabaseWrapper(::QObject * parent) : SqlDatabase(parent)
{
}

void SqlDatabaseWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SqlDatabase", funcName, gil, pyOverride, event);
}

void SqlDatabaseWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqlDatabase", funcName, gil, pyOverride, signal);
}

void SqlDatabaseWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SqlDatabase", funcName, gil, pyOverride, event);
}

void SqlDatabaseWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqlDatabase", funcName, gil, pyOverride, signal);
}

bool SqlDatabaseWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SqlDatabase", funcName, gil, pyOverride, event);
}

bool SqlDatabaseWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SqlDatabase", funcName, gil, pyOverride, watched, event);
}

void SqlDatabaseWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlDatabase_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SqlDatabase", funcName, gil, pyOverride, event);
}

const QMetaObject *SqlDatabaseWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SqlDatabase::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SqlDatabaseWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SqlDatabase::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SqlDatabaseWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SqlDatabaseWrapper *>(this));
    }
    return SqlDatabase::qt_metacast(_clname);
}

SqlDatabaseWrapper::~SqlDatabaseWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SqlDatabase_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SqlDatabase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SqlDatabase >()))
        return -1;

    SqlDatabaseWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:SqlDatabase", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SqlDatabase::SqlDatabase(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // SqlDatabase(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SqlDatabase(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SqlDatabase(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SqlDatabaseWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SqlDatabaseWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SqlDatabase >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SqlDatabaseFunc_database(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlDatabaseWrapper *>(reinterpret_cast< ::SqlDatabase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // database()
        QSqlDatabase cppResult = cppSelf->database();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlDatabase_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlDatabaseFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        SqlDatabase * cppResult = ::SqlDatabase::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlDatabaseFunc_setDatabase(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlDatabaseWrapper *>(reinterpret_cast< ::SqlDatabase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SqlDatabase::setDatabase(QSqlDatabase)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlDatabase_IDX]), (pyArg)))) {
        overloadId = 0; // setDatabase(QSqlDatabase)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDatabase", errInfo, SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSqlDatabase cppArg0_local;
        ::QSqlDatabase *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDatabase(QSqlDatabase)
            cppSelf->setDatabase(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_SqlDatabase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SqlDatabase_methods[] = {
    {"database", reinterpret_cast<PyCFunction>(Sbk_SqlDatabaseFunc_database), METH_NOARGS, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_SqlDatabaseFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"setDatabase", reinterpret_cast<PyCFunction>(Sbk_SqlDatabaseFunc_setDatabase), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SqlDatabase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SqlDatabase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SqlDatabaseWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SqlDatabase_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SqlDatabase_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SqlDatabase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SqlDatabase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SqlDatabase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SqlDatabase_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SqlDatabase_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SqlDatabase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SqlDatabase_spec = {
    "1:PyFalkon.SqlDatabase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SqlDatabase_slots
};

} //extern "C"

static void *Sbk_SqlDatabase_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SqlDatabase *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SqlDatabase_PythonToCpp_SqlDatabase_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SqlDatabase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SqlDatabase_PythonToCpp_SqlDatabase_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SqlDatabase_TypeF()))
        return SqlDatabase_PythonToCpp_SqlDatabase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SqlDatabase_PTR_CppToPython_SqlDatabase(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SqlDatabase *>(const_cast<void *>(cppIn)), Sbk_SqlDatabase_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SqlDatabase_SignatureStrings[] = {
    "PyFalkon.SqlDatabase(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.SqlDatabase.database(self)->PySide6.QtSql.QSqlDatabase",
    "PyFalkon.SqlDatabase.instance()->PyFalkon.SqlDatabase",
    "PyFalkon.SqlDatabase.setDatabase(self,database:PySide6.QtSql.QSqlDatabase)",
    nullptr}; // Sentinel
#else
static constexpr size_t SqlDatabase_SignatureByteSize = 122;
static constexpr uint8_t SqlDatabase_SignatureBytes[122] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x2e, 0xcc, 0x71, 0x49,
    0x2c, 0x49, 0x4c, 0x4a, 0x2c, 0x4e, 0xd5, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0x4a,
    0xcd, 0x2b, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x71, 0xce, 0x2f,
    0x4a, 0xd5, 0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d, 0x2e, 0xb1, 0xcd, 0x2b, 0xcd, 0xc9, 0x29, 0x28,
    0x29, 0xd2, 0xe4, 0x0a, 0xc0, 0x62, 0x80, 0x5e, 0x0a, 0xb2, 0x49, 0x9a, 0xba, 0x76, 0x08, 0x43,
    0x80, 0xaa, 0xf4, 0x02, 0x91, 0x94, 0x62, 0xd7, 0x9f, 0x99, 0x57, 0x5c, 0x92, 0x98, 0x97, 0x9c,
    0xaa, 0x01, 0xd6, 0x8b, 0xa9, 0x00, 0xbb, 0xae, 0xe2, 0xd4, 0x12, 0x54, 0x2f, 0xc0, 0x9c, 0x61,
    0x85, 0xdb, 0x7e, 0x4d, 0x2e, 0x00, 0x65, 0x43, 0x5d, 0x2e
};
#endif

PyTypeObject *init_SqlDatabase(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX].type;

    Shiboken::AutoDecRef Sbk_SqlDatabase_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SqlDatabase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SqlDatabase",
        "SqlDatabase*",
        &Sbk_SqlDatabase_spec,
        &Shiboken::callCppDestructor< SqlDatabase >,
        Sbk_SqlDatabase_Type_bases.object(),
        0);
    auto *pyType = _Sbk_SqlDatabase_Type; // references _Sbk_SqlDatabase_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SqlDatabase_SignatureStrings);
#else
    InitSignatureBytes(pyType, SqlDatabase_SignatureBytes, SqlDatabase_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SqlDatabase_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SqlDatabase_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SqlDatabase_PythonToCpp_SqlDatabase_PTR,
        is_SqlDatabase_PythonToCpp_SqlDatabase_PTR_Convertible,
        SqlDatabase_PTR_CppToPython_SqlDatabase);

    Shiboken::Conversions::registerConverterName(converter, "SqlDatabase");
    Shiboken::Conversions::registerConverterName(converter, "SqlDatabase*");
    Shiboken::Conversions::registerConverterName(converter, "SqlDatabase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SqlDatabase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SqlDatabaseWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SqlDatabase_TypeF(), &Sbk_SqlDatabase_typeDiscovery);

    SqlDatabaseWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SqlDatabase::staticMetaObject, sizeof(SqlDatabaseWrapper));

    return pyType;
}
