
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarksmodel_wrapper.h"

// Wrappers providing overrides
#include "tabtreemodel_wrapper.h"
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BookmarksModel_Type = nullptr;
static PyTypeObject *Sbk_BookmarksModel_TypeF(void)
{
    return _Sbk_BookmarksModel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void BookmarksModelWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::BookmarksModel::Roles >("BookmarksModel::Roles");
}

void BookmarksModelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

BookmarksModelWrapper::BookmarksModelWrapper(::BookmarkItem * root, ::Bookmarks * bookmarks, ::QObject * parent) : BookmarksModel(root, bookmarks, parent)
{
}

::QModelIndex BookmarksModelWrapper::buddy(const ::QModelIndex & index) const
{
    static const char *funcName = "buddy";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::buddy(index);
    }
    return TabTreeModelWrapper::sbk_o_buddy("BookmarksModel", funcName, gil, pyOverride, index);
}

bool BookmarksModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "canDropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canDropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("BookmarksModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool BookmarksModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    static const char *funcName = "canFetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canFetchMore(parent);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("BookmarksModel", funcName, gil, pyOverride, parent);
}

void BookmarksModelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("BookmarksModel", funcName, gil, pyOverride, event);
}

bool BookmarksModelWrapper::clearItemData(const ::QModelIndex & index)
{
    static const char *funcName = "clearItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::clearItemData(index);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("BookmarksModel", funcName, gil, pyOverride, index);
}

int BookmarksModelWrapper::columnCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "columnCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::columnCount(parent);
    }
    return TabTreeModelWrapper::sbk_o_columnCount("BookmarksModel", funcName, gil, pyOverride, parent);
}

void BookmarksModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarksModel", funcName, gil, pyOverride, signal);
}

void BookmarksModelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("BookmarksModel", funcName, gil, pyOverride, event);
}

::QVariant BookmarksModelWrapper::data(const ::QModelIndex & index, int role) const
{
    static const char *funcName = "data";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::data(index, role);
    }
    return TabTreeModelWrapper::sbk_o_data("BookmarksModel", funcName, gil, pyOverride, index, role);
}

void BookmarksModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarksModel", funcName, gil, pyOverride, signal);
}

bool BookmarksModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    static const char *funcName = "dropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::dropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("BookmarksModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool BookmarksModelWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("BookmarksModel", funcName, gil, pyOverride, event);
}

bool BookmarksModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("BookmarksModel", funcName, gil, pyOverride, watched, event);
}

void BookmarksModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    static const char *funcName = "fetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::fetchMore(parent);
    }
    TabTreeModelWrapper::sbk_o_fetchMore("BookmarksModel", funcName, gil, pyOverride, parent);
}

::QFlags<Qt::ItemFlag> BookmarksModelWrapper::flags(const ::QModelIndex & index) const
{
    static const char *funcName = "flags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::flags(index);
    }
    return TabTreeModelWrapper::sbk_o_flags("BookmarksModel", funcName, gil, pyOverride, index);
}

bool BookmarksModelWrapper::hasChildren(const ::QModelIndex & parent) const
{
    static const char *funcName = "hasChildren";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::hasChildren(parent);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("BookmarksModel", funcName, gil, pyOverride, parent);
}

::QVariant BookmarksModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    static const char *funcName = "headerData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::headerData(section, orientation, role);
    }
    return TabTreeModelWrapper::sbk_o_headerData("BookmarksModel", funcName, gil, pyOverride, section, orientation, role);
}

::QModelIndex BookmarksModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "index";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::index(row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_index("BookmarksModel", funcName, gil, pyOverride, row, column, parent);
}

bool BookmarksModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("BookmarksModel", funcName, gil, pyOverride, column, count, parent);
}

bool BookmarksModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("BookmarksModel", funcName, gil, pyOverride, row, count, parent);
}

::QMap<int,QVariant> BookmarksModelWrapper::itemData(const ::QModelIndex & index) const
{
    static const char *funcName = "itemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::itemData(index);
    }
    return TabTreeModelWrapper::sbk_o_itemData("BookmarksModel", funcName, gil, pyOverride, index);
}

::QList<QModelIndex> BookmarksModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    static const char *funcName = "match";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }
    return TabTreeModelWrapper::sbk_o_match("BookmarksModel", funcName, gil, pyOverride, start, role, value, hits, flags);
}

::QMimeData * BookmarksModelWrapper::mimeData(const ::QList<QModelIndex> & indexes) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::mimeData(indexes);
    }
    return TabTreeModelWrapper::sbk_o_mimeData("BookmarksModel", funcName, gil, pyOverride, indexes);
}

::QStringList BookmarksModelWrapper::mimeTypes() const
{
    static const char *funcName = "mimeTypes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::mimeTypes();
    }
    return TabTreeModelWrapper::sbk_o_mimeTypes("BookmarksModel", funcName, gil, pyOverride);
}

bool BookmarksModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("BookmarksModel", funcName, gil, pyOverride, sourceParent, sourceColumn, count, destinationParent, destinationChild);
}

bool BookmarksModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("BookmarksModel", funcName, gil, pyOverride, sourceParent, sourceRow, count, destinationParent, destinationChild);
}

void BookmarksModelWrapper::multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const
{
    static const char *funcName = "multiData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::multiData(index, roleDataSpan);
    }
    TabTreeModelWrapper::sbk_o_multiData("BookmarksModel", funcName, gil, pyOverride, index, roleDataSpan);
}

::QModelIndex BookmarksModelWrapper::parent(const ::QModelIndex & child) const
{
    static const char *funcName = "parent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::parent(child);
    }
    return TabTreeModelWrapper::sbk_o_buddy("BookmarksModel", funcName, gil, pyOverride, child);
}

bool BookmarksModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("BookmarksModel", funcName, gil, pyOverride, column, count, parent);
}

bool BookmarksModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("BookmarksModel", funcName, gil, pyOverride, row, count, parent);
}

void BookmarksModelWrapper::resetInternalData()
{
    static const char *funcName = "resetInternalData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::resetInternalData();
    }
    WebViewWrapper::sbk_o_closeView("BookmarksModel", funcName, gil, pyOverride);
}

void BookmarksModelWrapper::revert()
{
    static const char *funcName = "revert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::revert();
    }
    WebViewWrapper::sbk_o_closeView("BookmarksModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> BookmarksModelWrapper::roleNames() const
{
    static const char *funcName = "roleNames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::roleNames();
    }
    return TabTreeModelWrapper::sbk_o_roleNames("BookmarksModel", funcName, gil, pyOverride);
}

int BookmarksModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "rowCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::rowCount(parent);
    }
    return TabTreeModelWrapper::sbk_o_columnCount("BookmarksModel", funcName, gil, pyOverride, parent);
}

bool BookmarksModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    static const char *funcName = "setData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setData(index, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setData("BookmarksModel", funcName, gil, pyOverride, index, value, role);
}

bool BookmarksModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    static const char *funcName = "setHeaderData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setHeaderData("BookmarksModel", funcName, gil, pyOverride, section, orientation, value, role);
}

bool BookmarksModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    static const char *funcName = "setItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setItemData(index, roles);
    }
    return TabTreeModelWrapper::sbk_o_setItemData("BookmarksModel", funcName, gil, pyOverride, index, roles);
}

::QModelIndex BookmarksModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    static const char *funcName = "sibling";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sibling(row, column, idx);
    }
    return TabTreeModelWrapper::sbk_o_index("BookmarksModel", funcName, gil, pyOverride, row, column, idx);
}

void BookmarksModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    static const char *funcName = "sort";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sort(column, order);
    }
    TabTreeModelWrapper::sbk_o_sort("BookmarksModel", funcName, gil, pyOverride, column, order);
}

::QSize BookmarksModelWrapper::span(const ::QModelIndex & index) const
{
    static const char *funcName = "span";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::span(index);
    }
    return TabTreeModelWrapper::sbk_o_span("BookmarksModel", funcName, gil, pyOverride, index);
}

bool BookmarksModelWrapper::submit()
{
    static const char *funcName = "submit";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::submit();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("BookmarksModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> BookmarksModelWrapper::supportedDragActions() const
{
    static const char *funcName = "supportedDragActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDragActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("BookmarksModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> BookmarksModelWrapper::supportedDropActions() const
{
    static const char *funcName = "supportedDropActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::BookmarksModel::supportedDropActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("BookmarksModel", funcName, gil, pyOverride);
}

void BookmarksModelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksModel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("BookmarksModel", funcName, gil, pyOverride, event);
}

const QMetaObject *BookmarksModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return BookmarksModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BookmarksModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = BookmarksModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BookmarksModelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< BookmarksModelWrapper *>(this));
    }
    return BookmarksModel::qt_metacast(_clname);
}

BookmarksModelWrapper::~BookmarksModelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_BookmarksModel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarksModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarksModel >()))
        return -1;

    BookmarksModelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:BookmarksModel", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: BookmarksModel::BookmarksModel(BookmarkItem*,Bookmarks*,QObject*=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // BookmarksModel(BookmarkItem*,Bookmarks*,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
            overloadId = 0; // BookmarksModel(BookmarkItem*,Bookmarks*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::Bookmarks *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // BookmarksModel(BookmarkItem*,Bookmarks*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) BookmarksModelWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new BookmarksModelWrapper(cppArg0, cppArg1, cppArg2);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[2], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< BookmarksModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_BookmarksModelFunc_addBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addBookmark", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BookmarksModel::addBookmark(BookmarkItem*,int,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addBookmark(BookmarkItem*,int,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addBookmark(BookmarkItem*,int,BookmarkItem*)
            cppSelf->addBookmark(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksModelFunc_columnCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::columnCount(QModelIndex)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // columnCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "columnCount", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // columnCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::columnCount(*cppArg0)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->columnCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_data(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "data", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::data(QModelIndex,int)const->QVariant
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // data(QModelIndex,int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // data(QModelIndex,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::data(*cppArg0, cppArg1)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->data(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_dropMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)->bool
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_DropAction_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[4])))) {
        overloadId = 0; // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "dropMimeData", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::DropAction cppArg1{Qt::IgnoreAction};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QModelIndex cppArg4_local;
        ::QModelIndex *cppArg4 = &cppArg4_local;
        if (pythonToCpp[4].isValue())
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (Shiboken::Errors::occurred() == nullptr) {
            // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::BookmarksModel::dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4)
                : cppSelf->dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_flags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::flags(QModelIndex)const->QFlags<Qt::ItemFlag>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // flags(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "flags", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // flags(QModelIndex)const
            QFlags<Qt::ItemFlag> cppResult = QFlags<Qt::ItemFlag>(Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::flags(*cppArg0)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->flags(*cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_ItemFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_hasChildren(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::hasChildren(QModelIndex)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // hasChildren(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hasChildren", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // hasChildren(QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::hasChildren(*cppArg0)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->hasChildren(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_headerData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "headerData", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::headerData(int,Qt::Orientation,int)const->QVariant
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // headerData(int,Qt::Orientation,int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "headerData", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::Orientation cppArg1 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // headerData(int,Qt::Orientation,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::headerData(cppArg0, cppArg1, cppArg2)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->headerData(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_index(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:index", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::index(int,int,const QModelIndex&=)const->QModelIndex
    // 1: BookmarksModel::index(BookmarkItem*,int=)const->QModelIndex
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // index(BookmarkItem*,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // index(BookmarkItem*,int)const
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // index(int,int,QModelIndex)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2])))) {
            overloadId = 0; // index(int,int,QModelIndex)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // index(int row, int column, const QModelIndex &parent) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QModelIndex cppArg2_local = QModelIndex();
            ::QModelIndex *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
                if (pythonToCpp[2].isValue())
                    pythonToCpp[2](pyArgs[2], &cppArg2_local);
                else
                    pythonToCpp[2](pyArgs[2], &cppArg2);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // index(int,int,QModelIndex)const
                QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::index(cppArg0, cppArg1, *cppArg2)
                    : const_cast<const BookmarksModelWrapper *>(cppSelf)->index(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
        case 1: // index(BookmarkItem *item, int column) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"column", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::BookmarkItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // index(BookmarkItem*,int)const
                QModelIndex cppResult = const_cast<const BookmarksModelWrapper *>(cppSelf)->index(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_item(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarksModel::item(QModelIndex)const->BookmarkItem*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // item(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "item", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // item(QModelIndex)const
            BookmarkItem * cppResult = const_cast<const BookmarksModelWrapper *>(cppSelf)->item(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_mimeData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::mimeData(QList<QModelIndex>)const->QMimeData*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX], (pyArg)))) {
        overloadId = 0; // mimeData(QList<QModelIndex>)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mimeData", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        ::QList<QModelIndex> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mimeData(QList<QModelIndex>)const
            QMimeData * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::mimeData(cppArg0)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->mimeData(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_mimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mimeTypes()const
        QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::mimeTypes()
            : const_cast<const BookmarksModelWrapper *>(cppSelf)->mimeTypes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_parent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "parent", 0, 1, &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::parent(QModelIndex)const->QModelIndex
    // 1: QObject::parent()const->QObject*
    if (numArgs == 0) {
        overloadId = 1; // parent()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // parent(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "parent", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // parent(const QModelIndex &child) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // parent(QModelIndex)const
                QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::parent(*cppArg0)
                    : const_cast<const BookmarksModelWrapper *>(cppSelf)->parent(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
        case 1: // parent() const
        {

            // parent()const
            QObject * cppResult = const_cast<const QObjectWrapper *>(reinterpret_cast<QObjectWrapper *>(cppSelf))->parent();
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), cppResult);

            // Ownership transferences.
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_removeBookmark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarksModel::removeBookmark(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // removeBookmark(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeBookmark(BookmarkItem*)
            cppSelf->removeBookmark(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksModelFunc_rowCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::rowCount(QModelIndex)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // rowCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // rowCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::rowCount(*cppArg0)
                : const_cast<const BookmarksModelWrapper *>(cppSelf)->rowCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksModelFunc_supportedDropActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksModelWrapper *>(reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // supportedDropActions()const
        QFlags<Qt::DropAction> cppResult = QFlags<Qt::DropAction>(Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const BookmarksModelWrapper *>(cppSelf)->::BookmarksModel::supportedDropActions()
            : const_cast<const BookmarksModelWrapper *>(cppSelf)->supportedDropActions());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_DropAction_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_BookmarksModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_BookmarksModel_EnumFlagInfo[] = {
    "Roles:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarksModel_methods[] = {
    {"addBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_addBookmark), METH_VARARGS, nullptr},
    {"columnCount", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_columnCount), METH_O, nullptr},
    {"data", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_data), METH_VARARGS, nullptr},
    {"dropMimeData", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_dropMimeData), METH_VARARGS, nullptr},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_flags), METH_O, nullptr},
    {"hasChildren", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_hasChildren), METH_O, nullptr},
    {"headerData", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_headerData), METH_VARARGS, nullptr},
    {"index", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_index), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"item", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_item), METH_O, nullptr},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_mimeData), METH_O, nullptr},
    {"mimeTypes", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_mimeTypes), METH_NOARGS, nullptr},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_parent), METH_VARARGS, nullptr},
    {"removeBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_removeBookmark), METH_O, nullptr},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_rowCount), METH_O, nullptr},
    {"supportedDropActions", reinterpret_cast<PyCFunction>(Sbk_BookmarksModelFunc_supportedDropActions), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_BookmarksModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::BookmarksModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<BookmarksModelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_BookmarksModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BookmarksModel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BookmarksModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_BookmarksModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarksModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarksModel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarksModel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarksModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarksModel_spec = {
    "1:PyFalkon.BookmarksModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarksModel_slots
};

} //extern "C"

static void *Sbk_BookmarksModel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::BookmarksModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_BookmarksModel_Roles(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::BookmarksModel::Roles>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::BookmarksModel::Roles *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_BookmarksModel_Roles_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_Roles_IDX])))
        return Enum_PythonToCpp_BookmarksModel_Roles;
    return {};
}

static PyObject *BookmarksModel_Roles_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::BookmarksModel::Roles>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::BookmarksModel::Roles *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarksModel_PythonToCpp_BookmarksModel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarksModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarksModel_PythonToCpp_BookmarksModel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BookmarksModel_TypeF()))
        return BookmarksModel_PythonToCpp_BookmarksModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarksModel_PTR_CppToPython_BookmarksModel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::BookmarksModel *>(const_cast<void *>(cppIn)), Sbk_BookmarksModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BookmarksModel_SignatureStrings[] = {
    "PyFalkon.BookmarksModel(self,root:PyFalkon.BookmarkItem,bookmarks:PyFalkon.Bookmarks,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.BookmarksModel.addBookmark(self,parent:PyFalkon.BookmarkItem,row:int,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksModel.columnCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->int",
    "PyFalkon.BookmarksModel.data(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],role:int)->QVariant",
    "PyFalkon.BookmarksModel.dropMimeData(self,data:PySide6.QtCore.QMimeData,action:PySide6.QtCore.Qt.DropAction,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.BookmarksModel.flags(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.Qt.ItemFlag",
    "PyFalkon.BookmarksModel.hasChildren(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.BookmarksModel.headerData(self,section:int,orientation:PySide6.QtCore.Qt.Orientation,role:int)->QVariant",
    "1:PyFalkon.BookmarksModel.index(self,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->PySide6.QtCore.QModelIndex",
    "0:PyFalkon.BookmarksModel.index(self,item:PyFalkon.BookmarkItem,column:int=0)->PySide6.QtCore.QModelIndex",
    "PyFalkon.BookmarksModel.item(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PyFalkon.BookmarkItem",
    "PyFalkon.BookmarksModel.mimeData(self,indexes:QList[PySide6.QtCore.QModelIndex])->PySide6.QtCore.QMimeData",
    "PyFalkon.BookmarksModel.mimeTypes(self)->QStringList",
    "1:PyFalkon.BookmarksModel.parent(self,child:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.QModelIndex",
    "0:PyFalkon.BookmarksModel.parent(self)->PySide6.QtCore.QObject",
    "PyFalkon.BookmarksModel.removeBookmark(self,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksModel.rowCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->int",
    "PyFalkon.BookmarksModel.supportedDropActions(self)->PySide6.QtCore.Qt.DropAction",
    nullptr}; // Sentinel
#else
static constexpr size_t BookmarksModel_SignatureByteSize = 437;
static constexpr uint8_t BookmarksModel_SignatureBytes[437] = {
    0x78, 0xda, 0xc5, 0x55, 0x41, 0x4f, 0xc2, 0x30, 0x14, 0xbe, 0xf3, 0x2b, 0x3c, 0x42, 0x32, 0x17,
    0xbc, 0x78, 0x58, 0x82, 0x89, 0x42, 0x48, 0x48, 0x24, 0x6c, 0x41, 0xbd, 0x18, 0x0f, 0x65, 0x7d,
    0x40, 0xa5, 0x6b, 0x97, 0xb6, 0x53, 0xf9, 0xf7, 0xb6, 0x6b, 0xc6, 0x80, 0xb5, 0x0b, 0x31, 0x4e,
    0x6f, 0x8c, 0xf7, 0xfa, 0xbe, 0xaf, 0xdf, 0xfb, 0x5e, 0x5f, 0xbc, 0x9f, 0x22, 0xba, 0xe3, 0x2c,
    0x7c, 0xe0, 0x7c, 0x97, 0x21, 0xb1, 0x93, 0x73, 0x8e, 0x81, 0xf6, 0x25, 0xd0, 0x75, 0x20, 0x38,
    0x57, 0x51, 0x7c, 0x9e, 0x31, 0x53, 0x90, 0x05, 0xab, 0x2a, 0xbd, 0x19, 0x97, 0x41, 0x8e, 0x04,
    0x30, 0x73, 0x72, 0x49, 0x30, 0xdc, 0x86, 0x89, 0x1a, 0x73, 0x01, 0x61, 0xb2, 0x58, 0xbd, 0x43,
    0xaa, 0x46, 0xac, 0xa0, 0x34, 0x57, 0x62, 0xd0, 0x8b, 0xdd, 0xd8, 0x21, 0xc2, 0xb8, 0xfa, 0xc7,
    0xf2, 0x38, 0xd4, 0x73, 0x31, 0x11, 0xfc, 0x33, 0x22, 0x4c, 0x05, 0x44, 0x7f, 0xb8, 0x53, 0xfc,
    0x48, 0x29, 0xa7, 0x45, 0xc6, 0xc6, 0xbc, 0x60, 0xea, 0x04, 0x49, 0xed, 0x73, 0xc2, 0x36, 0xe1,
    0x33, 0x23, 0x9c, 0xbd, 0x9e, 0x5f, 0xa3, 0x3c, 0x3a, 0x63, 0x18, 0xbe, 0x82, 0xab, 0xf3, 0x58,
    0x0c, 0x42, 0x12, 0xa9, 0x74, 0x8d, 0x3a, 0xeb, 0x6d, 0x70, 0x7d, 0xa7, 0x09, 0x7a, 0x49, 0x60,
    0xa4, 0x90, 0x45, 0x27, 0x26, 0xfd, 0x97, 0xc1, 0xb5, 0x3e, 0x14, 0x8c, 0x40, 0x9a, 0x45, 0xf2,
    0x82, 0x04, 0x41, 0x6d, 0x54, 0x04, 0xcf, 0xe7, 0x24, 0x83, 0xc9, 0x81, 0x92, 0x21, 0xd7, 0x68,
    0x64, 0x95, 0x12, 0xa0, 0x54, 0x69, 0x92, 0x8d, 0xb8, 0x0a, 0x27, 0xba, 0xd0, 0x7d, 0x19, 0x3c,
    0xf4, 0xc7, 0x6a, 0x5d, 0xfe, 0xec, 0x4a, 0x65, 0x6d, 0x4a, 0xea, 0xbd, 0xdb, 0x9a, 0xa2, 0x8d,
    0xec, 0x4e, 0x67, 0x0d, 0xdf, 0x94, 0xc1, 0xb8, 0x6f, 0xaa, 0x71, 0xbd, 0xa4, 0xb6, 0x48, 0x8e,
    0xb7, 0x84, 0x62, 0xad, 0x47, 0xb7, 0x06, 0x6c, 0x95, 0x66, 0x0b, 0x08, 0x83, 0xa8, 0x9b, 0x2e,
    0xc1, 0xf6, 0xd5, 0xf4, 0x8a, 0x0b, 0xa2, 0x8b, 0x21, 0x4f, 0x9f, 0x17, 0x75, 0xd4, 0x69, 0xb4,
    0x9b, 0xc8, 0x87, 0x59, 0xf6, 0xa0, 0x7a, 0x66, 0xfe, 0xc6, 0x21, 0xa3, 0xa3, 0x23, 0xfd, 0x81,
    0xa3, 0x61, 0x75, 0xb8, 0x37, 0xbc, 0x84, 0xb8, 0xff, 0xc9, 0x39, 0xba, 0xcb, 0x68, 0xd8, 0x8e,
    0xe4, 0xc5, 0xd1, 0x65, 0x3a, 0xb6, 0xab, 0x83, 0xb8, 0x97, 0x4e, 0x76, 0xf2, 0x2c, 0x94, 0x94,
    0x40, 0x46, 0xc9, 0xa3, 0xae, 0xdc, 0xc2, 0xc6, 0x35, 0x16, 0xd5, 0xeb, 0xd1, 0x0a, 0xf5, 0xb4,
    0xcf, 0xc1, 0x4e, 0xab, 0xb1, 0xd3, 0x52, 0x09, 0x7d, 0x77, 0x83, 0xd5, 0xe2, 0x28, 0xeb, 0x19,
    0xcb, 0x2f, 0x35, 0x43, 0xd5, 0xfd, 0x84, 0x5f, 0x64, 0x98, 0x23, 0x5e, 0x8e, 0x12, 0x76, 0x29,
    0x7a, 0xb5, 0x10, 0x90, 0xf1, 0x0f, 0x38, 0x5d, 0x87, 0x3f, 0xd9, 0x74, 0x7a, 0xc6, 0xfe, 0x79,
    0xcd, 0xc9, 0x22, 0xcf, 0xb9, 0x50, 0x80, 0xeb, 0xdd, 0x20, 0x7d, 0xa2, 0x1c, 0x2f, 0x90, 0xde,
    0x37, 0xed, 0xbf, 0x2b, 0xbf
};
#endif

PyTypeObject *init_BookmarksModel(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX].type;

    Shiboken::AutoDecRef Sbk_BookmarksModel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]))));

    _Sbk_BookmarksModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarksModel",
        "BookmarksModel*",
        &Sbk_BookmarksModel_spec,
        &Shiboken::callCppDestructor< BookmarksModel >,
        Sbk_BookmarksModel_Type_bases.object(),
        0);
    auto *pyType = _Sbk_BookmarksModel_Type; // references _Sbk_BookmarksModel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BookmarksModel_SignatureStrings);
#else
    InitSignatureBytes(pyType, BookmarksModel_SignatureBytes, BookmarksModel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BookmarksModel_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BookmarksModel_PythonToCpp_BookmarksModel_PTR,
        is_BookmarksModel_PythonToCpp_BookmarksModel_PTR_Convertible,
        BookmarksModel_PTR_CppToPython_BookmarksModel);

    Shiboken::Conversions::registerConverterName(converter, "BookmarksModel");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksModel*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarksModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(BookmarksModelWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_BookmarksModel_TypeF(), &Sbk_BookmarksModel_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_BookmarksModel_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Roles'.
    const char *Roles_Initializer[] = {
        "TypeRole",
        "UrlRole",
        "UrlStringRole",
        "TitleRole",
        "IconRole",
        "DescriptionRole",
        "KeywordRole",
        "VisitCountRole",
        "ExpandedRole",
        "SidebarExpandedRole",
        "MaxRole",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Roles_InitializerValues[] = {
        uint16_t(BookmarksModel::Roles::TypeRole),            //  0x0101  257
        uint16_t(BookmarksModel::Roles::UrlRole),             //  0x0102  258
        uint16_t(BookmarksModel::Roles::UrlStringRole),       //  0x0103  259
        uint16_t(BookmarksModel::Roles::TitleRole),           //  0x0104  260
        uint16_t(BookmarksModel::Roles::IconRole),            //  0x0105  261
        uint16_t(BookmarksModel::Roles::DescriptionRole),     //  0x0106  262
        uint16_t(BookmarksModel::Roles::KeywordRole),         //  0x0107  263
        uint16_t(BookmarksModel::Roles::VisitCountRole),      //  0x0108  264
        uint16_t(BookmarksModel::Roles::ExpandedRole),        //  0x0109  265
        uint16_t(BookmarksModel::Roles::SidebarExpandedRole), //  0x010a  266
        uint16_t(BookmarksModel::Roles::MaxRole)              //  0x010a  266
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_BookmarksModel_TypeF(),
        "1:PyFalkon.BookmarksModel.Roles",
        Roles_Initializer, Roles_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_BookmarksModel_Roles_IDX].type = EType;
    // Register converter for enum 'BookmarksModel::Roles'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            BookmarksModel_Roles_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_BookmarksModel_Roles,
            is_Enum_PythonToCpp_BookmarksModel_Roles_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "BookmarksModel::Roles");
        Shiboken::Conversions::registerConverterAlias(converter, "Roles");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Roles' enum.

    BookmarksModelWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::BookmarksModel::staticMetaObject, sizeof(BookmarksModelWrapper));

    return pyType;
}
