/* scanner.c generated by valac 0.56.18, the Vala compiler
 * generated from scanner.vala, do not modify */

#include "caribou.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef void (*CaribouScannerUnconfigureSwitchFunc) (gpointer user_data);
enum  {
	CARIBOU_SCANNER_0_PROPERTY,
	CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY,
	CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY,
	CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY,
	CARIBOU_SCANNER_STEP_TIME_PROPERTY,
	CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY,
	CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY,
	CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY,
	CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY,
	CARIBOU_SCANNER_AUTORESTART_PROPERTY,
	CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY,
	CARIBOU_SCANNER_NUM_PROPERTIES
};
static GParamSpec* caribou_scanner_properties[CARIBOU_SCANNER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

struct _CaribouScannerPrivate {
	gboolean _bind_settings;
	CaribouScanGrouping _scan_grouping;
	gboolean _scan_enabled;
	gdouble _step_time;
	gchar* _switch_device;
	gchar* _keyboard_key;
	gint _mouse_button;
	gint _scan_cycles;
	gboolean _autorestart;
	gboolean _inverse_scanning;
	CaribouScannerUnconfigureSwitchFunc unconfigure_switch_func;
	gpointer unconfigure_switch_func_target;
	GDestroyNotify unconfigure_switch_func_target_destroy_notify;
	guint scan_tid;
	CaribouKeyboardModel* keyboard;
	CaribouIScannableGroup* root_group;
	gboolean started;
};

struct _Block1Data {
	int _ref_count_;
	CaribouScanner* self;
	CaribouDisplayAdapter* xadapter;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	guint keyval;
};

static gint CaribouScanner_private_offset;
static gpointer caribou_scanner_parent_class = NULL;

static void caribou_scanner_do_bind_settings (CaribouScanner* self);
static gboolean caribou_scanner_select (CaribouScanner* self);
static CaribouIScannableItem* caribou_scanner_step (CaribouScanner* self);
static void caribou_scanner_switch_pressed (CaribouScanner* self,
                                     guint code,
                                     gboolean pressed);
static void caribou_scanner_start (CaribouScanner* self);
static void caribou_scanner_stop (CaribouScanner* self);
static void caribou_scanner_on_group_changed (CaribouScanner* self,
                                       GObject* obj,
                                       GParamSpec* prop);
static void _caribou_scanner_on_group_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void caribou_scanner_set_active_level (CaribouScanner* self,
                                       CaribouLevelModel* level);
static void caribou_scanner_on_level_changed (CaribouScanner* self,
                                       GObject* obj,
                                       GParamSpec* prop);
static void _caribou_scanner_on_level_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void caribou_scanner_enable (CaribouScanner* self);
static void caribou_scanner_configure_switch (CaribouScanner* self);
static void caribou_scanner_disable (CaribouScanner* self);
static void caribou_scanner_unconfigure_switch (CaribouScanner* self);
static gboolean caribou_scanner_scan (CaribouScanner* self);
static gboolean _caribou_scanner_scan_gsource_func (gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _caribou_scanner_switch_pressed_caribou_key_button_callback (guint keybuttoncode,
                                                                  gboolean pressed,
                                                                  gpointer self);
static void ___lambda16_ (Block2Data* _data2_);
static void ____lambda16__caribou_scanner_unconfigure_switch_func (gpointer self);
static void ____lambda17_ (Block1Data* _data1_);
static void _____lambda17__caribou_scanner_unconfigure_switch_func (gpointer self);
static GObject * caribou_scanner_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void caribou_scanner_finalize (GObject * obj);
static GType caribou_scanner_get_type_once (void);
static void _vala_caribou_scanner_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_caribou_scanner_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
caribou_scanner_get_instance_private (CaribouScanner* self)
{
	return G_STRUCT_MEMBER_P (self, CaribouScanner_private_offset);
}

static void
caribou_scanner_do_bind_settings (CaribouScanner* self)
{
	GSettings* caribou_settings = NULL;
	GSettings* _tmp0_;
	gchar** settings = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint settings_length1;
	gint _settings_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.caribou");
	caribou_settings = _tmp0_;
	_tmp1_ = g_strdup ("scan-grouping");
	_tmp2_ = g_strdup ("step-time");
	_tmp3_ = g_strdup ("scan-cycles");
	_tmp4_ = g_strdup ("autorestart");
	_tmp5_ = g_strdup ("inverse-scanning");
	_tmp6_ = g_strdup ("switch-device");
	_tmp7_ = g_strdup ("keyboard-key");
	_tmp8_ = g_strdup ("mouse-button");
	_tmp9_ = g_strdup ("scan-enabled");
	_tmp10_ = g_new0 (gchar*, 9 + 1);
	_tmp10_[0] = _tmp1_;
	_tmp10_[1] = _tmp2_;
	_tmp10_[2] = _tmp3_;
	_tmp10_[3] = _tmp4_;
	_tmp10_[4] = _tmp5_;
	_tmp10_[5] = _tmp6_;
	_tmp10_[6] = _tmp7_;
	_tmp10_[7] = _tmp8_;
	_tmp10_[8] = _tmp9_;
	settings = _tmp10_;
	settings_length1 = 9;
	_settings_size_ = settings_length1;
	_tmp11_ = settings;
	_tmp11__length1 = settings_length1;
	{
		gchar** setting_collection = NULL;
		gint setting_collection_length1 = 0;
		gint _setting_collection_size_ = 0;
		gint setting_it = 0;
		setting_collection = _tmp11_;
		setting_collection_length1 = _tmp11__length1;
		for (setting_it = 0; setting_it < setting_collection_length1; setting_it = setting_it + 1) {
			gchar* _tmp12_;
			gchar* setting = NULL;
			_tmp12_ = g_strdup (setting_collection[setting_it]);
			setting = _tmp12_;
			{
				GSettings* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = caribou_settings;
				_tmp14_ = setting;
				_tmp15_ = setting;
				g_settings_bind (_tmp13_, _tmp14_, (GObject*) self, _tmp15_, G_SETTINGS_BIND_GET);
				_g_free0 (setting);
			}
		}
	}
	settings = (_vala_array_free (settings, settings_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (caribou_settings);
}

static gboolean
caribou_scanner_select (CaribouScanner* self)
{
	CaribouIScannableItem* item = NULL;
	CaribouIScannableGroup* _tmp0_;
	CaribouIScannableItem* _tmp1_;
	CaribouIScannableItem* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->root_group;
	_tmp1_ = caribou_iscannable_group_child_select (_tmp0_);
	item = _tmp1_;
	_tmp2_ = item;
	if (CARIBOU_IS_ISCANNABLE_GROUP (_tmp2_)) {
		CaribouIScannableItem* _tmp3_;
		CaribouIScannableItem* _tmp4_;
		_tmp3_ = caribou_scanner_step (self);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		result = TRUE;
		_g_object_unref0 (item);
		return result;
	} else {
		caribou_scanner_reset (self);
		result = FALSE;
		_g_object_unref0 (item);
		return result;
	}
}

static void
caribou_scanner_switch_pressed (CaribouScanner* self,
                                guint code,
                                gboolean pressed)
{
	g_return_if_fail (self != NULL);
	if (pressed) {
		gboolean _tmp2_;
		if (!self->priv->started) {
			CaribouIScannableItem* _tmp0_;
			CaribouIScannableItem* _tmp1_;
			_tmp0_ = caribou_scanner_step (self);
			_tmp1_ = _tmp0_;
			_g_object_unref0 (_tmp1_);
			caribou_scanner_start (self);
			return;
		}
		caribou_scanner_stop (self);
		_tmp2_ = self->priv->_inverse_scanning;
		if (_tmp2_) {
			CaribouIScannableItem* _tmp3_;
			CaribouIScannableItem* _tmp4_;
			_tmp3_ = caribou_scanner_step (self);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp4_);
			caribou_scanner_start (self);
		} else {
			gboolean _tmp5_ = FALSE;
			if (caribou_scanner_select (self)) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp6_;
				_tmp6_ = self->priv->_autorestart;
				_tmp5_ = _tmp6_;
			}
			if (_tmp5_) {
				caribou_scanner_start (self);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_caribou_scanner_on_group_changed_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	caribou_scanner_on_group_changed ((CaribouScanner*) self, _sender, pspec);
}

static void
_caribou_scanner_on_level_changed_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	caribou_scanner_on_level_changed ((CaribouScanner*) self, _sender, pspec);
}

void
caribou_scanner_set_keyboard (CaribouScanner* self,
                              CaribouKeyboardModel* keyboard)
{
	CaribouGroupModel* group = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	CaribouGroupModel* _tmp2_;
	CaribouKeyboardModel* _tmp3_;
	CaribouKeyboardModel* _tmp4_;
	CaribouGroupModel* _tmp5_;
	CaribouGroupModel* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	CaribouLevelModel* _tmp9_;
	CaribouLevelModel* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyboard != NULL);
	_tmp0_ = caribou_keyboard_model_get_active_group (keyboard);
	_tmp1_ = _tmp0_;
	_tmp2_ = caribou_keyboard_model_get_group (keyboard, _tmp1_);
	group = _tmp2_;
	_tmp3_ = _g_object_ref0 (keyboard);
	_g_object_unref0 (self->priv->keyboard);
	self->priv->keyboard = _tmp3_;
	_tmp4_ = self->priv->keyboard;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active-group", (GCallback) _caribou_scanner_on_group_changed_g_object_notify, self, 0);
	_tmp5_ = group;
	_tmp6_ = group;
	_tmp7_ = caribou_group_model_get_active_level (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = caribou_group_model_get_level (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	caribou_scanner_set_active_level (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp12_ = caribou_keyboard_model_get_groups (keyboard, &_tmp11_);
	{
		gchar** group_name_collection = NULL;
		gint group_name_collection_length1 = 0;
		gint _group_name_collection_size_ = 0;
		gint group_name_it = 0;
		group_name_collection = _tmp12_;
		group_name_collection_length1 = _tmp11_;
		for (group_name_it = 0; group_name_it < group_name_collection_length1; group_name_it = group_name_it + 1) {
			gchar* _tmp13_;
			gchar* group_name = NULL;
			_tmp13_ = g_strdup (group_name_collection[group_name_it]);
			group_name = _tmp13_;
			{
				const gchar* _tmp14_;
				CaribouGroupModel* _tmp15_;
				CaribouGroupModel* _tmp16_;
				_tmp14_ = group_name;
				_tmp15_ = caribou_keyboard_model_get_group (keyboard, _tmp14_);
				_g_object_unref0 (group);
				group = _tmp15_;
				_tmp16_ = group;
				g_signal_connect_object ((GObject*) _tmp16_, "notify::active-level", (GCallback) _caribou_scanner_on_level_changed_g_object_notify, self, 0);
				_g_free0 (group_name);
			}
		}
		group_name_collection = (_vala_array_free (group_name_collection, group_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (group);
}

static void
caribou_scanner_on_level_changed (CaribouScanner* self,
                                  GObject* obj,
                                  GParamSpec* prop)
{
	CaribouGroupModel* group = NULL;
	CaribouGroupModel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	CaribouLevelModel* _tmp3_;
	CaribouLevelModel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, CARIBOU_TYPE_GROUP_MODEL, CaribouGroupModel));
	group = _tmp0_;
	_tmp1_ = caribou_group_model_get_active_level (group);
	_tmp2_ = _tmp1_;
	_tmp3_ = caribou_group_model_get_level (group, _tmp2_);
	_tmp4_ = _tmp3_;
	caribou_scanner_set_active_level (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (group);
}

static void
caribou_scanner_on_group_changed (CaribouScanner* self,
                                  GObject* obj,
                                  GParamSpec* prop)
{
	CaribouGroupModel* group = NULL;
	CaribouKeyboardModel* _tmp0_;
	CaribouKeyboardModel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	CaribouGroupModel* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	CaribouLevelModel* _tmp7_;
	CaribouLevelModel* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->keyboard;
	_tmp1_ = self->priv->keyboard;
	_tmp2_ = caribou_keyboard_model_get_active_group (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = caribou_keyboard_model_get_group (_tmp0_, _tmp3_);
	group = _tmp4_;
	_tmp5_ = caribou_group_model_get_active_level (group);
	_tmp6_ = _tmp5_;
	_tmp7_ = caribou_group_model_get_level (group, _tmp6_);
	_tmp8_ = _tmp7_;
	caribou_scanner_set_active_level (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (group);
}

static void
caribou_scanner_set_active_level (CaribouScanner* self,
                                  CaribouLevelModel* level)
{
	CaribouIScannableGroup* _tmp0_;
	CaribouIScannableGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (level != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (level, CARIBOU_TYPE_ISCANNABLE_GROUP, CaribouIScannableGroup));
	_g_object_unref0 (self->priv->root_group);
	self->priv->root_group = _tmp0_;
	_tmp1_ = self->priv->root_group;
	caribou_iscannable_group_set_scan_grouping (_tmp1_, self->priv->_scan_grouping);
}

void
caribou_scanner_reset (CaribouScanner* self)
{
	CaribouIScannableGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_group;
	if (_tmp0_ != NULL) {
		CaribouIScannableGroup* _tmp1_;
		_tmp1_ = self->priv->root_group;
		caribou_iscannable_group_scan_reset (_tmp1_);
	}
}

static void
caribou_scanner_enable (CaribouScanner* self)
{
	g_return_if_fail (self != NULL);
	caribou_scanner_configure_switch (self);
}

static void
caribou_scanner_disable (CaribouScanner* self)
{
	g_return_if_fail (self != NULL);
	caribou_scanner_unconfigure_switch (self);
}

static gboolean
_caribou_scanner_scan_gsource_func (gpointer self)
{
	gboolean result;
	result = caribou_scanner_scan ((CaribouScanner*) self);
	return result;
}

static void
caribou_scanner_start (CaribouScanner* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->started) {
		_tmp0_ = TRUE;
	} else {
		CaribouIScannableGroup* _tmp1_;
		_tmp1_ = self->priv->root_group;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->started = TRUE;
	self->priv->scan_tid = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (self->priv->_step_time * 1000)), _caribou_scanner_scan_gsource_func, g_object_ref (self), g_object_unref);
}

static void
caribou_scanner_stop (CaribouScanner* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->started) {
		return;
	}
	self->priv->started = FALSE;
	if (self->priv->scan_tid != ((guint) 0)) {
		g_source_remove (self->priv->scan_tid);
	}
	self->priv->scan_tid = (guint) 0;
}

static CaribouIScannableItem*
caribou_scanner_step (CaribouScanner* self)
{
	CaribouIScannableItem* item = NULL;
	CaribouIScannableGroup* _tmp0_;
	gint _tmp1_;
	CaribouIScannableItem* _tmp2_;
	CaribouIScannableItem* _tmp3_;
	CaribouIScannableItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_group;
	_tmp1_ = self->priv->_scan_cycles;
	_tmp2_ = caribou_iscannable_group_child_step (_tmp0_, _tmp1_);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ == NULL) {
		caribou_scanner_reset (self);
	}
	result = item;
	return result;
}

static gboolean
caribou_scanner_scan (CaribouScanner* self)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_inverse_scanning;
	if (_tmp0_) {
		caribou_scanner_select (self);
	} else {
		CaribouIScannableItem* _tmp1_;
		CaribouIScannableItem* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = caribou_scanner_step (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_g_object_unref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = TRUE;
	return result;
}

static void
caribou_scanner_unconfigure_switch (CaribouScanner* self)
{
	CaribouScannerUnconfigureSwitchFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unconfigure_switch_func;
	_tmp0__target = self->priv->unconfigure_switch_func_target;
	if (_tmp0_ != NULL) {
		CaribouScannerUnconfigureSwitchFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->unconfigure_switch_func;
		_tmp1__target = self->priv->unconfigure_switch_func_target;
		_tmp1_ (_tmp1__target);
	}
	(self->priv->unconfigure_switch_func_target_destroy_notify == NULL) ? NULL : (self->priv->unconfigure_switch_func_target_destroy_notify (self->priv->unconfigure_switch_func_target), NULL);
	self->priv->unconfigure_switch_func = NULL;
	self->priv->unconfigure_switch_func_target = NULL;
	self->priv->unconfigure_switch_func_target_destroy_notify = NULL;
	self->priv->unconfigure_switch_func = NULL;
	self->priv->unconfigure_switch_func_target = NULL;
	self->priv->unconfigure_switch_func_target_destroy_notify = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CaribouScanner* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->xadapter);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CaribouScanner* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_caribou_scanner_switch_pressed_caribou_key_button_callback (guint keybuttoncode,
                                                             gboolean pressed,
                                                             gpointer self)
{
	caribou_scanner_switch_pressed ((CaribouScanner*) self, keybuttoncode, pressed);
}

static void
___lambda16_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	CaribouScanner* self;
	CaribouDisplayAdapter* _tmp0_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->xadapter;
	caribou_display_adapter_register_key_func (_tmp0_, _data2_->keyval, NULL, NULL);
}

static void
____lambda16__caribou_scanner_unconfigure_switch_func (gpointer self)
{
	___lambda16_ (self);
}

static void
____lambda17_ (Block1Data* _data1_)
{
	CaribouScanner* self;
	CaribouDisplayAdapter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data1_->self;
	_tmp0_ = _data1_->xadapter;
	_tmp1_ = caribou_scanner_get_mouse_button (self);
	_tmp2_ = _tmp1_;
	caribou_display_adapter_register_key_func (_tmp0_, (guint) _tmp2_, NULL, NULL);
}

static void
_____lambda17__caribou_scanner_unconfigure_switch_func (gpointer self)
{
	____lambda17_ (self);
}

static void
caribou_scanner_configure_switch (CaribouScanner* self)
{
	Block1Data* _data1_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	CaribouDisplayAdapter* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = caribou_scanner_get_scan_enabled (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	caribou_scanner_unconfigure_switch (self);
	_tmp2_ = caribou_display_adapter_get_default ();
	_data1_->xadapter = _tmp2_;
	_tmp4_ = caribou_scanner_get_switch_device (self);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp5_, "keyboard") == 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = caribou_scanner_get_keyboard_key (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Block2Data* _data2_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		CaribouDisplayAdapter* _tmp10_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp8_ = caribou_scanner_get_keyboard_key (self);
		_tmp9_ = _tmp8_;
		_data2_->keyval = gdk_keyval_from_name (_tmp9_);
		_tmp10_ = _data1_->xadapter;
		caribou_display_adapter_register_key_func (_tmp10_, _data2_->keyval, _caribou_scanner_switch_pressed_caribou_key_button_callback, self);
		(self->priv->unconfigure_switch_func_target_destroy_notify == NULL) ? NULL : (self->priv->unconfigure_switch_func_target_destroy_notify (self->priv->unconfigure_switch_func_target), NULL);
		self->priv->unconfigure_switch_func = NULL;
		self->priv->unconfigure_switch_func_target = NULL;
		self->priv->unconfigure_switch_func_target_destroy_notify = NULL;
		self->priv->unconfigure_switch_func = ____lambda16__caribou_scanner_unconfigure_switch_func;
		self->priv->unconfigure_switch_func_target = block2_data_ref (_data2_);
		self->priv->unconfigure_switch_func_target_destroy_notify = block2_data_unref;
		block2_data_unref (_data2_);
		_data2_ = NULL;
	} else {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = caribou_scanner_get_switch_device (self);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp13_, "mouse") == 0) {
			gint _tmp14_;
			gint _tmp15_;
			_tmp14_ = caribou_scanner_get_mouse_button (self);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ != 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			CaribouDisplayAdapter* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = _data1_->xadapter;
			_tmp17_ = caribou_scanner_get_mouse_button (self);
			_tmp18_ = _tmp17_;
			caribou_display_adapter_register_button_func (_tmp16_, (guint) _tmp18_, _caribou_scanner_switch_pressed_caribou_key_button_callback, self);
			(self->priv->unconfigure_switch_func_target_destroy_notify == NULL) ? NULL : (self->priv->unconfigure_switch_func_target_destroy_notify (self->priv->unconfigure_switch_func_target), NULL);
			self->priv->unconfigure_switch_func = NULL;
			self->priv->unconfigure_switch_func_target = NULL;
			self->priv->unconfigure_switch_func_target_destroy_notify = NULL;
			self->priv->unconfigure_switch_func = _____lambda17__caribou_scanner_unconfigure_switch_func;
			self->priv->unconfigure_switch_func_target = block1_data_ref (_data1_);
			self->priv->unconfigure_switch_func_target_destroy_notify = block1_data_unref;
		}
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

CaribouScanner*
caribou_scanner_construct (GType object_type)
{
	CaribouScanner * self = NULL;
	self = (CaribouScanner*) g_object_new (object_type, NULL);
	return self;
}

CaribouScanner*
caribou_scanner_new (void)
{
	return caribou_scanner_construct (CARIBOU_TYPE_SCANNER);
}

gboolean
caribou_scanner_get_bind_settings (CaribouScanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bind_settings;
	return result;
}

static void
caribou_scanner_set_bind_settings (CaribouScanner* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_scanner_get_bind_settings (self);
	if (old_value != value) {
		self->priv->_bind_settings = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY]);
	}
}

gint
caribou_scanner_get_scan_grouping (CaribouScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->priv->_scan_grouping;
	return result;
}

void
caribou_scanner_set_scan_grouping (CaribouScanner* self,
                                   gint value)
{
	CaribouIScannableGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_scan_grouping = (CaribouScanGrouping) value;
	_tmp0_ = self->priv->root_group;
	if (_tmp0_ != NULL) {
		CaribouIScannableGroup* _tmp1_;
		_tmp1_ = self->priv->root_group;
		caribou_iscannable_group_set_scan_grouping (_tmp1_, self->priv->_scan_grouping);
	}
	caribou_scanner_reset (self);
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY]);
}

gboolean
caribou_scanner_get_scan_enabled (CaribouScanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_scan_enabled;
	return result;
}

void
caribou_scanner_set_scan_enabled (CaribouScanner* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_scan_enabled = value;
	if (self->priv->_scan_enabled) {
		caribou_scanner_enable (self);
	} else {
		caribou_scanner_disable (self);
	}
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY]);
}

gdouble
caribou_scanner_get_step_time (CaribouScanner* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_step_time;
	return result;
}

void
caribou_scanner_set_step_time (CaribouScanner* self,
                               gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_step_time = value;
	if (self->priv->scan_tid != ((guint) 0)) {
		g_source_remove (self->priv->scan_tid);
		self->priv->scan_tid = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (self->priv->_step_time * 1000)), _caribou_scanner_scan_gsource_func, g_object_ref (self), g_object_unref);
	}
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_STEP_TIME_PROPERTY]);
}

const gchar*
caribou_scanner_get_switch_device (CaribouScanner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_switch_device;
	result = _tmp0_;
	return result;
}

void
caribou_scanner_set_switch_device (CaribouScanner* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_switch_device);
	self->priv->_switch_device = _tmp0_;
	caribou_scanner_configure_switch (self);
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY]);
}

const gchar*
caribou_scanner_get_keyboard_key (CaribouScanner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keyboard_key;
	result = _tmp0_;
	return result;
}

void
caribou_scanner_set_keyboard_key (CaribouScanner* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_keyboard_key);
	self->priv->_keyboard_key = _tmp0_;
	caribou_scanner_configure_switch (self);
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY]);
}

gint
caribou_scanner_get_mouse_button (CaribouScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mouse_button;
	return result;
}

void
caribou_scanner_set_mouse_button (CaribouScanner* self,
                                  gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_button = value;
	caribou_scanner_configure_switch (self);
	g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY]);
}

gint
caribou_scanner_get_scan_cycles (CaribouScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scan_cycles;
	return result;
}

void
caribou_scanner_set_scan_cycles (CaribouScanner* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_scanner_get_scan_cycles (self);
	if (old_value != value) {
		self->priv->_scan_cycles = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY]);
	}
}

gboolean
caribou_scanner_get_autorestart (CaribouScanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_autorestart;
	return result;
}

void
caribou_scanner_set_autorestart (CaribouScanner* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_scanner_get_autorestart (self);
	if (old_value != value) {
		self->priv->_autorestart = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_AUTORESTART_PROPERTY]);
	}
}

gboolean
caribou_scanner_get_inverse_scanning (CaribouScanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inverse_scanning;
	return result;
}

void
caribou_scanner_set_inverse_scanning (CaribouScanner* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_scanner_get_inverse_scanning (self);
	if (old_value != value) {
		self->priv->_inverse_scanning = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_scanner_properties[CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY]);
	}
}

static GObject *
caribou_scanner_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CaribouScanner * self;
	gchar* _tmp0_;
	gboolean _tmp1_;
	parent_class = G_OBJECT_CLASS (caribou_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CARIBOU_TYPE_SCANNER, CaribouScanner);
	self->priv->_scan_grouping = CARIBOU_SCAN_GROUPING_SUBGROUPS;
	self->priv->_step_time = 1.0;
	_tmp0_ = g_strdup ("keyboard");
	_g_free0 (self->priv->_switch_device);
	self->priv->_switch_device = _tmp0_;
	_tmp1_ = self->priv->_bind_settings;
	if (_tmp1_) {
		caribou_scanner_do_bind_settings (self);
	}
	return obj;
}

static void
caribou_scanner_class_init (CaribouScannerClass * klass,
                            gpointer klass_data)
{
	caribou_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaribouScanner_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_caribou_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_caribou_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = caribou_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = caribou_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY] = g_param_spec_boolean ("bind-settings", "bind-settings", "bind-settings", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY] = g_param_spec_int ("scan-grouping", "scan-grouping", "scan-grouping", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY] = g_param_spec_boolean ("scan-enabled", "scan-enabled", "scan-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_STEP_TIME_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_STEP_TIME_PROPERTY] = g_param_spec_double ("step-time", "step-time", "step-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY] = g_param_spec_string ("switch-device", "switch-device", "switch-device", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY] = g_param_spec_string ("keyboard-key", "keyboard-key", "keyboard-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY] = g_param_spec_int ("mouse-button", "mouse-button", "mouse-button", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY] = g_param_spec_int ("scan-cycles", "scan-cycles", "scan-cycles", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_AUTORESTART_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_AUTORESTART_PROPERTY] = g_param_spec_boolean ("autorestart", "autorestart", "autorestart", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY, caribou_scanner_properties[CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY] = g_param_spec_boolean ("inverse-scanning", "inverse-scanning", "inverse-scanning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
caribou_scanner_instance_init (CaribouScanner * self,
                               gpointer klass)
{
	self->priv = caribou_scanner_get_instance_private (self);
	self->priv->_bind_settings = TRUE;
	self->priv->_scan_cycles = 1;
	self->priv->_autorestart = FALSE;
	self->priv->_inverse_scanning = FALSE;
}

static void
caribou_scanner_finalize (GObject * obj)
{
	CaribouScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CARIBOU_TYPE_SCANNER, CaribouScanner);
	_g_free0 (self->priv->_switch_device);
	_g_free0 (self->priv->_keyboard_key);
	(self->priv->unconfigure_switch_func_target_destroy_notify == NULL) ? NULL : (self->priv->unconfigure_switch_func_target_destroy_notify (self->priv->unconfigure_switch_func_target), NULL);
	self->priv->unconfigure_switch_func = NULL;
	self->priv->unconfigure_switch_func_target = NULL;
	self->priv->unconfigure_switch_func_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->keyboard);
	_g_object_unref0 (self->priv->root_group);
	G_OBJECT_CLASS (caribou_scanner_parent_class)->finalize (obj);
}

/**
     * Object providing access to keyboard in scanning mode.
     */
static GType
caribou_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaribouScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caribou_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaribouScanner), 0, (GInstanceInitFunc) caribou_scanner_instance_init, NULL };
	GType caribou_scanner_type_id;
	caribou_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "CaribouScanner", &g_define_type_info, 0);
	CaribouScanner_private_offset = g_type_add_instance_private (caribou_scanner_type_id, sizeof (CaribouScannerPrivate));
	return caribou_scanner_type_id;
}

GType
caribou_scanner_get_type (void)
{
	static volatile gsize caribou_scanner_type_id__once = 0;
	if (g_once_init_enter (&caribou_scanner_type_id__once)) {
		GType caribou_scanner_type_id;
		caribou_scanner_type_id = caribou_scanner_get_type_once ();
		g_once_init_leave (&caribou_scanner_type_id__once, caribou_scanner_type_id);
	}
	return caribou_scanner_type_id__once;
}

static void
_vala_caribou_scanner_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CaribouScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CARIBOU_TYPE_SCANNER, CaribouScanner);
	switch (property_id) {
		case CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY:
		g_value_set_boolean (value, caribou_scanner_get_bind_settings (self));
		break;
		case CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY:
		g_value_set_int (value, caribou_scanner_get_scan_grouping (self));
		break;
		case CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY:
		g_value_set_boolean (value, caribou_scanner_get_scan_enabled (self));
		break;
		case CARIBOU_SCANNER_STEP_TIME_PROPERTY:
		g_value_set_double (value, caribou_scanner_get_step_time (self));
		break;
		case CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY:
		g_value_set_string (value, caribou_scanner_get_switch_device (self));
		break;
		case CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY:
		g_value_set_string (value, caribou_scanner_get_keyboard_key (self));
		break;
		case CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY:
		g_value_set_int (value, caribou_scanner_get_mouse_button (self));
		break;
		case CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY:
		g_value_set_int (value, caribou_scanner_get_scan_cycles (self));
		break;
		case CARIBOU_SCANNER_AUTORESTART_PROPERTY:
		g_value_set_boolean (value, caribou_scanner_get_autorestart (self));
		break;
		case CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY:
		g_value_set_boolean (value, caribou_scanner_get_inverse_scanning (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_caribou_scanner_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CaribouScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CARIBOU_TYPE_SCANNER, CaribouScanner);
	switch (property_id) {
		case CARIBOU_SCANNER_BIND_SETTINGS_PROPERTY:
		caribou_scanner_set_bind_settings (self, g_value_get_boolean (value));
		break;
		case CARIBOU_SCANNER_SCAN_GROUPING_PROPERTY:
		caribou_scanner_set_scan_grouping (self, g_value_get_int (value));
		break;
		case CARIBOU_SCANNER_SCAN_ENABLED_PROPERTY:
		caribou_scanner_set_scan_enabled (self, g_value_get_boolean (value));
		break;
		case CARIBOU_SCANNER_STEP_TIME_PROPERTY:
		caribou_scanner_set_step_time (self, g_value_get_double (value));
		break;
		case CARIBOU_SCANNER_SWITCH_DEVICE_PROPERTY:
		caribou_scanner_set_switch_device (self, g_value_get_string (value));
		break;
		case CARIBOU_SCANNER_KEYBOARD_KEY_PROPERTY:
		caribou_scanner_set_keyboard_key (self, g_value_get_string (value));
		break;
		case CARIBOU_SCANNER_MOUSE_BUTTON_PROPERTY:
		caribou_scanner_set_mouse_button (self, g_value_get_int (value));
		break;
		case CARIBOU_SCANNER_SCAN_CYCLES_PROPERTY:
		caribou_scanner_set_scan_cycles (self, g_value_get_int (value));
		break;
		case CARIBOU_SCANNER_AUTORESTART_PROPERTY:
		caribou_scanner_set_autorestart (self, g_value_get_boolean (value));
		break;
		case CARIBOU_SCANNER_INVERSE_SCANNING_PROPERTY:
		caribou_scanner_set_inverse_scanning (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

