// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/resolve.proto

package registryv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/module/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ResolvedReferenceType int32

const (
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED ResolvedReferenceType = 0
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_COMMIT      ResolvedReferenceType = 1
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_BRANCH      ResolvedReferenceType = 2
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_TAG         ResolvedReferenceType = 3
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_DRAFT       ResolvedReferenceType = 5
)

// Enum value maps for ResolvedReferenceType.
var (
	ResolvedReferenceType_name = map[int32]string{
		0: "RESOLVED_REFERENCE_TYPE_UNSPECIFIED",
		1: "RESOLVED_REFERENCE_TYPE_COMMIT",
		2: "RESOLVED_REFERENCE_TYPE_BRANCH",
		3: "RESOLVED_REFERENCE_TYPE_TAG",
		5: "RESOLVED_REFERENCE_TYPE_DRAFT",
	}
	ResolvedReferenceType_value = map[string]int32{
		"RESOLVED_REFERENCE_TYPE_UNSPECIFIED": 0,
		"RESOLVED_REFERENCE_TYPE_COMMIT":      1,
		"RESOLVED_REFERENCE_TYPE_BRANCH":      2,
		"RESOLVED_REFERENCE_TYPE_TAG":         3,
		"RESOLVED_REFERENCE_TYPE_DRAFT":       5,
	}
)

func (x ResolvedReferenceType) Enum() *ResolvedReferenceType {
	p := new(ResolvedReferenceType)
	*p = x
	return p
}

func (x ResolvedReferenceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolvedReferenceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0].Descriptor()
}

func (ResolvedReferenceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0]
}

func (x ResolvedReferenceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetModulePinsRequest struct {
	state                        protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_ModuleReferences  *[]*v1alpha1.ModuleReference `protobuf:"bytes,1,rep,name=module_references,json=moduleReferences,proto3"`
	xxx_hidden_CurrentModulePins *[]*v1alpha1.ModulePin       `protobuf:"bytes,2,rep,name=current_module_pins,json=currentModulePins,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *GetModulePinsRequest) Reset() {
	*x = GetModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsRequest) ProtoMessage() {}

func (x *GetModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePinsRequest) GetModuleReferences() []*v1alpha1.ModuleReference {
	if x != nil {
		if x.xxx_hidden_ModuleReferences != nil {
			return *x.xxx_hidden_ModuleReferences
		}
	}
	return nil
}

func (x *GetModulePinsRequest) GetCurrentModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_CurrentModulePins != nil {
			return *x.xxx_hidden_CurrentModulePins
		}
	}
	return nil
}

func (x *GetModulePinsRequest) SetModuleReferences(v []*v1alpha1.ModuleReference) {
	x.xxx_hidden_ModuleReferences = &v
}

func (x *GetModulePinsRequest) SetCurrentModulePins(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_CurrentModulePins = &v
}

type GetModulePinsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModuleReferences []*v1alpha1.ModuleReference
	// current_module_pins allows for partial dependency updates by letting clients
	// send a request with the pins for their current module and only the
	// identities of the dependencies they want to update in module_references.
	//
	// When resolving, if a client supplied module pin is:
	//   - in the transitive closure of pins resolved from the module_references,
	//     the client supplied module pin will be an extra candidate for tie
	//     breaking.
	//   - NOT in the in the transitive closure of pins resolved from the
	//     module_references, it will be returned as is.
	CurrentModulePins []*v1alpha1.ModulePin
}

func (b0 GetModulePinsRequest_builder) Build() *GetModulePinsRequest {
	m0 := &GetModulePinsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModuleReferences = &b.ModuleReferences
	x.xxx_hidden_CurrentModulePins = &b.CurrentModulePins
	return m0
}

type GetModulePinsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ModulePins *[]*v1alpha1.ModulePin `protobuf:"bytes,1,rep,name=module_pins,json=modulePins,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetModulePinsResponse) Reset() {
	*x = GetModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsResponse) ProtoMessage() {}

func (x *GetModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePinsResponse) GetModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_ModulePins != nil {
			return *x.xxx_hidden_ModulePins
		}
	}
	return nil
}

func (x *GetModulePinsResponse) SetModulePins(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_ModulePins = &v
}

type GetModulePinsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModulePins []*v1alpha1.ModulePin
}

func (b0 GetModulePinsResponse_builder) Build() *GetModulePinsResponse {
	m0 := &GetModulePinsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModulePins = &b.ModulePins
	return m0
}

type GetLocalModulePinsRequest struct {
	state                            protoimpl.MessageState   `protogen:"opaque.v1"`
	xxx_hidden_LocalModuleReferences *[]*LocalModuleReference `protobuf:"bytes,1,rep,name=local_module_references,json=localModuleReferences,proto3"`
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *GetLocalModulePinsRequest) Reset() {
	*x = GetLocalModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsRequest) ProtoMessage() {}

func (x *GetLocalModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLocalModulePinsRequest) GetLocalModuleReferences() []*LocalModuleReference {
	if x != nil {
		if x.xxx_hidden_LocalModuleReferences != nil {
			return *x.xxx_hidden_LocalModuleReferences
		}
	}
	return nil
}

func (x *GetLocalModulePinsRequest) SetLocalModuleReferences(v []*LocalModuleReference) {
	x.xxx_hidden_LocalModuleReferences = &v
}

type GetLocalModulePinsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	LocalModuleReferences []*LocalModuleReference
}

func (b0 GetLocalModulePinsRequest_builder) Build() *GetLocalModulePinsRequest {
	m0 := &GetLocalModulePinsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LocalModuleReferences = &b.LocalModuleReferences
	return m0
}

type LocalModuleResolveResult struct {
	state                            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Reference             *LocalModuleReference  `protobuf:"bytes,1,opt,name=reference,proto3"`
	xxx_hidden_Pin                   *LocalModulePin        `protobuf:"bytes,2,opt,name=pin,proto3"`
	xxx_hidden_ResolvedReferenceType ResolvedReferenceType  `protobuf:"varint,3,opt,name=resolved_reference_type,json=resolvedReferenceType,proto3,enum=buf.alpha.registry.v1alpha1.ResolvedReferenceType"`
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *LocalModuleResolveResult) Reset() {
	*x = LocalModuleResolveResult{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalModuleResolveResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalModuleResolveResult) ProtoMessage() {}

func (x *LocalModuleResolveResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LocalModuleResolveResult) GetReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return nil
}

func (x *LocalModuleResolveResult) GetPin() *LocalModulePin {
	if x != nil {
		return x.xxx_hidden_Pin
	}
	return nil
}

func (x *LocalModuleResolveResult) GetResolvedReferenceType() ResolvedReferenceType {
	if x != nil {
		return x.xxx_hidden_ResolvedReferenceType
	}
	return ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED
}

func (x *LocalModuleResolveResult) SetReference(v *LocalModuleReference) {
	x.xxx_hidden_Reference = v
}

func (x *LocalModuleResolveResult) SetPin(v *LocalModulePin) {
	x.xxx_hidden_Pin = v
}

func (x *LocalModuleResolveResult) SetResolvedReferenceType(v ResolvedReferenceType) {
	x.xxx_hidden_ResolvedReferenceType = v
}

func (x *LocalModuleResolveResult) HasReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Reference != nil
}

func (x *LocalModuleResolveResult) HasPin() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Pin != nil
}

func (x *LocalModuleResolveResult) ClearReference() {
	x.xxx_hidden_Reference = nil
}

func (x *LocalModuleResolveResult) ClearPin() {
	x.xxx_hidden_Pin = nil
}

type LocalModuleResolveResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// A copy of the reference that was resolved.
	Reference *LocalModuleReference
	// The pin the reference resolved to.
	Pin *LocalModulePin
	// The type the reference resolved as.
	ResolvedReferenceType ResolvedReferenceType
}

func (b0 LocalModuleResolveResult_builder) Build() *LocalModuleResolveResult {
	m0 := &LocalModuleResolveResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_Pin = b.Pin
	x.xxx_hidden_ResolvedReferenceType = b.ResolvedReferenceType
	return m0
}

type GetLocalModulePinsResponse struct {
	state                                protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_LocalModuleResolveResults *[]*LocalModuleResolveResult `protobuf:"bytes,1,rep,name=local_module_resolve_results,json=localModuleResolveResults,proto3"`
	xxx_hidden_Dependencies              *[]*v1alpha1.ModulePin       `protobuf:"bytes,2,rep,name=dependencies,proto3"`
	unknownFields                        protoimpl.UnknownFields
	sizeCache                            protoimpl.SizeCache
}

func (x *GetLocalModulePinsResponse) Reset() {
	*x = GetLocalModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsResponse) ProtoMessage() {}

func (x *GetLocalModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLocalModulePinsResponse) GetLocalModuleResolveResults() []*LocalModuleResolveResult {
	if x != nil {
		if x.xxx_hidden_LocalModuleResolveResults != nil {
			return *x.xxx_hidden_LocalModuleResolveResults
		}
	}
	return nil
}

func (x *GetLocalModulePinsResponse) GetDependencies() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_Dependencies != nil {
			return *x.xxx_hidden_Dependencies
		}
	}
	return nil
}

func (x *GetLocalModulePinsResponse) SetLocalModuleResolveResults(v []*LocalModuleResolveResult) {
	x.xxx_hidden_LocalModuleResolveResults = &v
}

func (x *GetLocalModulePinsResponse) SetDependencies(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_Dependencies = &v
}

type GetLocalModulePinsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	LocalModuleResolveResults []*LocalModuleResolveResult
	// dependencies are the dependencies of the LocalModulePins.
	//
	// This includes the transitive deps.
	Dependencies []*v1alpha1.ModulePin
}

func (b0 GetLocalModulePinsResponse_builder) Build() *GetLocalModulePinsResponse {
	m0 := &GetLocalModulePinsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LocalModuleResolveResults = &b.LocalModuleResolveResults
	x.xxx_hidden_Dependencies = &b.Dependencies
	return m0
}

type GetGoVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetGoVersionRequest) Reset() {
	*x = GetGoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionRequest) ProtoMessage() {}

func (x *GetGoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetGoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetGoVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetGoVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetGoVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetGoVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetGoVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetGoVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetGoVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetGoVersionRequest_builder) Build() *GetGoVersionRequest {
	m0 := &GetGoVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetGoVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetGoVersionResponse) Reset() {
	*x = GetGoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionResponse) ProtoMessage() {}

func (x *GetGoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGoVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetGoVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetGoVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the go module proxy.
	Version string
}

func (b0 GetGoVersionResponse_builder) Build() *GetGoVersionResponse {
	m0 := &GetGoVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetMavenVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetMavenVersionRequest) Reset() {
	*x = GetMavenVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionRequest) ProtoMessage() {}

func (x *GetMavenVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetMavenVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetMavenVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetMavenVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetMavenVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetMavenVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetMavenVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetMavenVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetMavenVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetMavenVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetMavenVersionRequest_builder) Build() *GetMavenVersionRequest {
	m0 := &GetMavenVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetMavenVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetMavenVersionResponse) Reset() {
	*x = GetMavenVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionResponse) ProtoMessage() {}

func (x *GetMavenVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetMavenVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetMavenVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetMavenVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the maven repository.
	Version string
}

func (b0 GetMavenVersionResponse_builder) Build() *GetMavenVersionResponse {
	m0 := &GetMavenVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetNPMVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetNPMVersionRequest) Reset() {
	*x = GetNPMVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionRequest) ProtoMessage() {}

func (x *GetNPMVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNPMVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetNPMVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetNPMVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetNPMVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetNPMVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetNPMVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetNPMVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetNPMVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetNPMVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetNPMVersionRequest_builder) Build() *GetNPMVersionRequest {
	m0 := &GetNPMVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetNPMVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetNPMVersionResponse) Reset() {
	*x = GetNPMVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionResponse) ProtoMessage() {}

func (x *GetNPMVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNPMVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetNPMVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetNPMVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the npm registry.
	Version string
}

func (b0 GetNPMVersionResponse_builder) Build() *GetNPMVersionResponse {
	m0 := &GetNPMVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetSwiftVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetSwiftVersionRequest) Reset() {
	*x = GetSwiftVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionRequest) ProtoMessage() {}

func (x *GetSwiftVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSwiftVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetSwiftVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetSwiftVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetSwiftVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetSwiftVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetSwiftVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetSwiftVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetSwiftVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetSwiftVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetSwiftVersionRequest_builder) Build() *GetSwiftVersionRequest {
	m0 := &GetSwiftVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetSwiftVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetSwiftVersionResponse) Reset() {
	*x = GetSwiftVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionResponse) ProtoMessage() {}

func (x *GetSwiftVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSwiftVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetSwiftVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetSwiftVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the swift registry.
	Version string
}

func (b0 GetSwiftVersionResponse_builder) Build() *GetSwiftVersionResponse {
	m0 := &GetSwiftVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetPythonVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetPythonVersionRequest) Reset() {
	*x = GetPythonVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionRequest) ProtoMessage() {}

func (x *GetPythonVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPythonVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetPythonVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetPythonVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetPythonVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetPythonVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetPythonVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetPythonVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetPythonVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetPythonVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetPythonVersionRequest_builder) Build() *GetPythonVersionRequest {
	m0 := &GetPythonVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetPythonVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetPythonVersionResponse) Reset() {
	*x = GetPythonVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionResponse) ProtoMessage() {}

func (x *GetPythonVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPythonVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetPythonVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetPythonVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the python repository.
	Version string
}

func (b0 GetPythonVersionResponse_builder) Build() *GetPythonVersionResponse {
	m0 := &GetPythonVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetCargoVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetCargoVersionRequest) Reset() {
	*x = GetCargoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionRequest) ProtoMessage() {}

func (x *GetCargoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCargoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetCargoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetCargoVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetCargoVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetCargoVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetCargoVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetCargoVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetCargoVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetCargoVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetCargoVersionRequest_builder) Build() *GetCargoVersionRequest {
	m0 := &GetCargoVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetCargoVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetCargoVersionResponse) Reset() {
	*x = GetCargoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionResponse) ProtoMessage() {}

func (x *GetCargoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCargoVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetCargoVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetCargoVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the cargo registry.
	Version string
}

func (b0 GetCargoVersionResponse_builder) Build() *GetCargoVersionResponse {
	m0 := &GetCargoVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetNugetVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetNugetVersionRequest) Reset() {
	*x = GetNugetVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionRequest) ProtoMessage() {}

func (x *GetNugetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNugetVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetNugetVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetNugetVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetNugetVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetNugetVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetNugetVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetNugetVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetNugetVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetNugetVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetNugetVersionRequest_builder) Build() *GetNugetVersionRequest {
	m0 := &GetNugetVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetNugetVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetNugetVersionResponse) Reset() {
	*x = GetNugetVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionResponse) ProtoMessage() {}

func (x *GetNugetVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNugetVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetNugetVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetNugetVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the nuget registry.
	Version string
}

func (b0 GetNugetVersionResponse_builder) Build() *GetNugetVersionResponse {
	m0 := &GetNugetVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetCmakeVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetCmakeVersionRequest) Reset() {
	*x = GetCmakeVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionRequest) ProtoMessage() {}

func (x *GetCmakeVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCmakeVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetCmakeVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetCmakeVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetCmakeVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetCmakeVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetCmakeVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetCmakeVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetCmakeVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetCmakeVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetCmakeVersionRequest_builder) Build() *GetCmakeVersionRequest {
	m0 := &GetCmakeVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetCmakeVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetCmakeVersionResponse) Reset() {
	*x = GetCmakeVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionResponse) ProtoMessage() {}

func (x *GetCmakeVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCmakeVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetCmakeVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetCmakeVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the cmake registry.
	Version string
}

func (b0 GetCmakeVersionResponse_builder) Build() *GetCmakeVersionResponse {
	m0 := &GetCmakeVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

// GetRemotePackageVersionPlugin is a plugin reference.
// If the version is empty, this is a reference to the latest version.
type GetRemotePackageVersionPlugin struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner    string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name     string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version  string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Revision uint32                 `protobuf:"varint,4,opt,name=revision,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRemotePackageVersionPlugin) Reset() {
	*x = GetRemotePackageVersionPlugin{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRemotePackageVersionPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRemotePackageVersionPlugin) ProtoMessage() {}

func (x *GetRemotePackageVersionPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRemotePackageVersionPlugin) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *GetRemotePackageVersionPlugin) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetRemotePackageVersionPlugin) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetRemotePackageVersionPlugin) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *GetRemotePackageVersionPlugin) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

type GetRemotePackageVersionPlugin_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin.
	// example: bufbuild
	Owner string
	// The name of the plugin.
	// example: connect-go
	Name string
	// The version of the plugin.
	// If empty, this is a reference to the latest version.
	// example: v1.0.0
	Version string
	// The revision of the plugin version.
	// example: 1
	Revision uint32
}

func (b0 GetRemotePackageVersionPlugin_builder) Build() *GetRemotePackageVersionPlugin {
	m0 := &GetRemotePackageVersionPlugin{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Revision = b.Revision
	return m0
}

type GetSDKInfoRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,1,opt,name=module_reference,json=moduleReference,proto3"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,2,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_SdkVersion      string                         `protobuf:"bytes,3,opt,name=sdk_version,json=sdkVersion,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetSDKInfoRequest) Reset() {
	*x = GetSDKInfoRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSDKInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSDKInfoRequest) ProtoMessage() {}

func (x *GetSDKInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSDKInfoRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetSDKInfoRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetSDKInfoRequest) GetSdkVersion() string {
	if x != nil {
		return x.xxx_hidden_SdkVersion
	}
	return ""
}

func (x *GetSDKInfoRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetSDKInfoRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetSDKInfoRequest) SetSdkVersion(v string) {
	x.xxx_hidden_SdkVersion = v
}

func (x *GetSDKInfoRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetSDKInfoRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetSDKInfoRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

func (x *GetSDKInfoRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

type GetSDKInfoRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The local module reference for the SDK.
	ModuleReference *LocalModuleReference
	// The plugin reference for the SDK.
	PluginReference *GetRemotePackageVersionPlugin
	// The SDK version string. If this is not provided, then it will be resolved using the module
	// and plugin references provided.
	SdkVersion string
}

func (b0 GetSDKInfoRequest_builder) Build() *GetSDKInfoRequest {
	m0 := &GetSDKInfoRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModuleReference = b.ModuleReference
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_SdkVersion = b.SdkVersion
	return m0
}

type GetSDKInfoResponse struct {
	state                 protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_ModuleInfo *GetSDKInfoResponse_ModuleInfo `protobuf:"bytes,1,opt,name=module_info,json=moduleInfo,proto3"`
	xxx_hidden_PluginInfo *GetSDKInfoResponse_PluginInfo `protobuf:"bytes,2,opt,name=plugin_info,json=pluginInfo,proto3"`
	xxx_hidden_SdkVersion string                         `protobuf:"bytes,3,opt,name=sdk_version,json=sdkVersion,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetSDKInfoResponse) Reset() {
	*x = GetSDKInfoResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSDKInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSDKInfoResponse) ProtoMessage() {}

func (x *GetSDKInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSDKInfoResponse) GetModuleInfo() *GetSDKInfoResponse_ModuleInfo {
	if x != nil {
		return x.xxx_hidden_ModuleInfo
	}
	return nil
}

func (x *GetSDKInfoResponse) GetPluginInfo() *GetSDKInfoResponse_PluginInfo {
	if x != nil {
		return x.xxx_hidden_PluginInfo
	}
	return nil
}

func (x *GetSDKInfoResponse) GetSdkVersion() string {
	if x != nil {
		return x.xxx_hidden_SdkVersion
	}
	return ""
}

func (x *GetSDKInfoResponse) SetModuleInfo(v *GetSDKInfoResponse_ModuleInfo) {
	x.xxx_hidden_ModuleInfo = v
}

func (x *GetSDKInfoResponse) SetPluginInfo(v *GetSDKInfoResponse_PluginInfo) {
	x.xxx_hidden_PluginInfo = v
}

func (x *GetSDKInfoResponse) SetSdkVersion(v string) {
	x.xxx_hidden_SdkVersion = v
}

func (x *GetSDKInfoResponse) HasModuleInfo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleInfo != nil
}

func (x *GetSDKInfoResponse) HasPluginInfo() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginInfo != nil
}

func (x *GetSDKInfoResponse) ClearModuleInfo() {
	x.xxx_hidden_ModuleInfo = nil
}

func (x *GetSDKInfoResponse) ClearPluginInfo() {
	x.xxx_hidden_PluginInfo = nil
}

type GetSDKInfoResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModuleInfo *GetSDKInfoResponse_ModuleInfo
	PluginInfo *GetSDKInfoResponse_PluginInfo
	// The SDK version string. The format is based on the SDK registry supported by the
	// provided plugin.
	SdkVersion string
}

func (b0 GetSDKInfoResponse_builder) Build() *GetSDKInfoResponse {
	m0 := &GetSDKInfoResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModuleInfo = b.ModuleInfo
	x.xxx_hidden_PluginInfo = b.PluginInfo
	x.xxx_hidden_SdkVersion = b.SdkVersion
	return m0
}

// ModuleInfo is the parsed module information for the SDK.
type GetSDKInfoResponse_ModuleInfo struct {
	state                             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner                  string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name                   string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Commit                 string                 `protobuf:"bytes,3,opt,name=commit,proto3"`
	xxx_hidden_ModuleCommitCreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=module_commit_create_time,json=moduleCommitCreateTime,proto3"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *GetSDKInfoResponse_ModuleInfo) Reset() {
	*x = GetSDKInfoResponse_ModuleInfo{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSDKInfoResponse_ModuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSDKInfoResponse_ModuleInfo) ProtoMessage() {}

func (x *GetSDKInfoResponse_ModuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSDKInfoResponse_ModuleInfo) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetSDKInfoResponse_ModuleInfo) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetSDKInfoResponse_ModuleInfo) GetCommit() string {
	if x != nil {
		return x.xxx_hidden_Commit
	}
	return ""
}

func (x *GetSDKInfoResponse_ModuleInfo) GetModuleCommitCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_ModuleCommitCreateTime
	}
	return nil
}

func (x *GetSDKInfoResponse_ModuleInfo) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetSDKInfoResponse_ModuleInfo) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetSDKInfoResponse_ModuleInfo) SetCommit(v string) {
	x.xxx_hidden_Commit = v
}

func (x *GetSDKInfoResponse_ModuleInfo) SetModuleCommitCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_ModuleCommitCreateTime = v
}

func (x *GetSDKInfoResponse_ModuleInfo) HasModuleCommitCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleCommitCreateTime != nil
}

func (x *GetSDKInfoResponse_ModuleInfo) ClearModuleCommitCreateTime() {
	x.xxx_hidden_ModuleCommitCreateTime = nil
}

type GetSDKInfoResponse_ModuleInfo_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The module owner name.
	Owner string
	// The module name.
	Name string
	// The module commit for the SDK.
	Commit string
	// The module commit create time. This will always be in UTC.
	ModuleCommitCreateTime *timestamppb.Timestamp
}

func (b0 GetSDKInfoResponse_ModuleInfo_builder) Build() *GetSDKInfoResponse_ModuleInfo {
	m0 := &GetSDKInfoResponse_ModuleInfo{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Commit = b.Commit
	x.xxx_hidden_ModuleCommitCreateTime = b.ModuleCommitCreateTime
	return m0
}

// PluginInfo is the parsed plugin information for the SDK.
type GetSDKInfoResponse_PluginInfo struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner          string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name           string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version        string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_PluginRevision uint32                 `protobuf:"varint,4,opt,name=plugin_revision,json=pluginRevision,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetSDKInfoResponse_PluginInfo) Reset() {
	*x = GetSDKInfoResponse_PluginInfo{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSDKInfoResponse_PluginInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSDKInfoResponse_PluginInfo) ProtoMessage() {}

func (x *GetSDKInfoResponse_PluginInfo) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSDKInfoResponse_PluginInfo) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetSDKInfoResponse_PluginInfo) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetSDKInfoResponse_PluginInfo) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetSDKInfoResponse_PluginInfo) GetPluginRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_PluginRevision
	}
	return 0
}

func (x *GetSDKInfoResponse_PluginInfo) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetSDKInfoResponse_PluginInfo) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetSDKInfoResponse_PluginInfo) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *GetSDKInfoResponse_PluginInfo) SetPluginRevision(v uint32) {
	x.xxx_hidden_PluginRevision = v
}

type GetSDKInfoResponse_PluginInfo_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin owner.
	Owner string
	// The plugin name.
	Name string
	// The semver plugin version. This will always be valid semver.
	Version string
	// The plugin revision.
	PluginRevision uint32
}

func (b0 GetSDKInfoResponse_PluginInfo_builder) Build() *GetSDKInfoResponse_PluginInfo {
	m0 := &GetSDKInfoResponse_PluginInfo{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_PluginRevision = b.PluginRevision
	return m0
}

var File_buf_alpha_registry_v1alpha1_resolve_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc = "" +
	"\n" +
	")buf/alpha/registry/v1alpha1/resolve.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/module/v1alpha1/module.proto\x1a(buf/alpha/registry/v1alpha1/module.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xc5\x01\n" +
	"\x14GetModulePinsRequest\x12W\n" +
	"\x11module_references\x18\x01 \x03(\v2*.buf.alpha.module.v1alpha1.ModuleReferenceR\x10moduleReferences\x12T\n" +
	"\x13current_module_pins\x18\x02 \x03(\v2$.buf.alpha.module.v1alpha1.ModulePinR\x11currentModulePins\"^\n" +
	"\x15GetModulePinsResponse\x12E\n" +
	"\vmodule_pins\x18\x01 \x03(\v2$.buf.alpha.module.v1alpha1.ModulePinR\n" +
	"modulePins\"\x86\x01\n" +
	"\x19GetLocalModulePinsRequest\x12i\n" +
	"\x17local_module_references\x18\x01 \x03(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x15localModuleReferences\"\xa9\x02\n" +
	"\x18LocalModuleResolveResult\x12O\n" +
	"\treference\x18\x01 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\treference\x12=\n" +
	"\x03pin\x18\x02 \x01(\v2+.buf.alpha.registry.v1alpha1.LocalModulePinR\x03pin\x12j\n" +
	"\x17resolved_reference_type\x18\x03 \x01(\x0e22.buf.alpha.registry.v1alpha1.ResolvedReferenceTypeR\x15resolvedReferenceTypeJ\x04\b\x04\x10\x05R\vis_bsr_head\"\xde\x01\n" +
	"\x1aGetLocalModulePinsResponse\x12v\n" +
	"\x1clocal_module_resolve_results\x18\x01 \x03(\v25.buf.alpha.registry.v1alpha1.LocalModuleResolveResultR\x19localModuleResolveResults\x12H\n" +
	"\fdependencies\x18\x02 \x03(\v2$.buf.alpha.module.v1alpha1.ModulePinR\fdependencies\"\xda\x01\n" +
	"\x13GetGoVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"0\n" +
	"\x14GetGoVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdd\x01\n" +
	"\x16GetMavenVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"3\n" +
	"\x17GetMavenVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdb\x01\n" +
	"\x14GetNPMVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"1\n" +
	"\x15GetNPMVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdd\x01\n" +
	"\x16GetSwiftVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"3\n" +
	"\x17GetSwiftVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xde\x01\n" +
	"\x17GetPythonVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"4\n" +
	"\x18GetPythonVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdd\x01\n" +
	"\x16GetCargoVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"3\n" +
	"\x17GetCargoVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdd\x01\n" +
	"\x16GetNugetVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"3\n" +
	"\x17GetNugetVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xdd\x01\n" +
	"\x16GetCmakeVersionRequest\x12e\n" +
	"\x10plugin_reference\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\\\n" +
	"\x10module_reference\x18\x02 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\"3\n" +
	"\x17GetCmakeVersionResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\x7f\n" +
	"\x1dGetRemotePackageVersionPlugin\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1a\n" +
	"\brevision\x18\x04 \x01(\rR\brevision\"\xf9\x01\n" +
	"\x11GetSDKInfoRequest\x12\\\n" +
	"\x10module_reference\x18\x01 \x01(\v21.buf.alpha.registry.v1alpha1.LocalModuleReferenceR\x0fmoduleReference\x12e\n" +
	"\x10plugin_reference\x18\x02 \x01(\v2:.buf.alpha.registry.v1alpha1.GetRemotePackageVersionPluginR\x0fpluginReference\x12\x1f\n" +
	"\vsdk_version\x18\x03 \x01(\tR\n" +
	"sdkVersion\"\x92\x04\n" +
	"\x12GetSDKInfoResponse\x12[\n" +
	"\vmodule_info\x18\x01 \x01(\v2:.buf.alpha.registry.v1alpha1.GetSDKInfoResponse.ModuleInfoR\n" +
	"moduleInfo\x12[\n" +
	"\vplugin_info\x18\x02 \x01(\v2:.buf.alpha.registry.v1alpha1.GetSDKInfoResponse.PluginInfoR\n" +
	"pluginInfo\x12\x1f\n" +
	"\vsdk_version\x18\x03 \x01(\tR\n" +
	"sdkVersion\x1a\xa5\x01\n" +
	"\n" +
	"ModuleInfo\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x16\n" +
	"\x06commit\x18\x03 \x01(\tR\x06commit\x12U\n" +
	"\x19module_commit_create_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x16moduleCommitCreateTime\x1ay\n" +
	"\n" +
	"PluginInfo\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12'\n" +
	"\x0fplugin_revision\x18\x04 \x01(\rR\x0epluginRevision*\xf1\x01\n" +
	"\x15ResolvedReferenceType\x12'\n" +
	"#RESOLVED_REFERENCE_TYPE_UNSPECIFIED\x10\x00\x12\"\n" +
	"\x1eRESOLVED_REFERENCE_TYPE_COMMIT\x10\x01\x12\"\n" +
	"\x1eRESOLVED_REFERENCE_TYPE_BRANCH\x10\x02\x12\x1f\n" +
	"\x1bRESOLVED_REFERENCE_TYPE_TAG\x10\x03\x12!\n" +
	"\x1dRESOLVED_REFERENCE_TYPE_DRAFT\x10\x05\"\x04\b\x04\x10\x04*\x1dRESOLVED_REFERENCE_TYPE_TRACK2\x93\n" +
	"\n" +
	"\x0eResolveService\x12{\n" +
	"\rGetModulePins\x121.buf.alpha.registry.v1alpha1.GetModulePinsRequest\x1a2.buf.alpha.registry.v1alpha1.GetModulePinsResponse\"\x03\x90\x02\x01\x12r\n" +
	"\n" +
	"GetSDKInfo\x12..buf.alpha.registry.v1alpha1.GetSDKInfoRequest\x1a/.buf.alpha.registry.v1alpha1.GetSDKInfoResponse\"\x03\x90\x02\x01\x12x\n" +
	"\fGetGoVersion\x120.buf.alpha.registry.v1alpha1.GetGoVersionRequest\x1a1.buf.alpha.registry.v1alpha1.GetGoVersionResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fGetSwiftVersion\x123.buf.alpha.registry.v1alpha1.GetSwiftVersionRequest\x1a4.buf.alpha.registry.v1alpha1.GetSwiftVersionResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fGetMavenVersion\x123.buf.alpha.registry.v1alpha1.GetMavenVersionRequest\x1a4.buf.alpha.registry.v1alpha1.GetMavenVersionResponse\"\x03\x90\x02\x01\x12{\n" +
	"\rGetNPMVersion\x121.buf.alpha.registry.v1alpha1.GetNPMVersionRequest\x1a2.buf.alpha.registry.v1alpha1.GetNPMVersionResponse\"\x03\x90\x02\x01\x12\x84\x01\n" +
	"\x10GetPythonVersion\x124.buf.alpha.registry.v1alpha1.GetPythonVersionRequest\x1a5.buf.alpha.registry.v1alpha1.GetPythonVersionResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fGetCargoVersion\x123.buf.alpha.registry.v1alpha1.GetCargoVersionRequest\x1a4.buf.alpha.registry.v1alpha1.GetCargoVersionResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fGetNugetVersion\x123.buf.alpha.registry.v1alpha1.GetNugetVersionRequest\x1a4.buf.alpha.registry.v1alpha1.GetNugetVersionResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fGetCmakeVersion\x123.buf.alpha.registry.v1alpha1.GetCmakeVersionRequest\x1a4.buf.alpha.registry.v1alpha1.GetCmakeVersionResponse\"\x03\x90\x02\x012\xa2\x01\n" +
	"\x13LocalResolveService\x12\x8a\x01\n" +
	"\x12GetLocalModulePins\x126.buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest\x1a7.buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse\"\x03\x90\x02\x01B\x99\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\fResolveProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = []any{
	(ResolvedReferenceType)(0),            // 0: buf.alpha.registry.v1alpha1.ResolvedReferenceType
	(*GetModulePinsRequest)(nil),          // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest
	(*GetModulePinsResponse)(nil),         // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse
	(*GetLocalModulePinsRequest)(nil),     // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	(*LocalModuleResolveResult)(nil),      // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	(*GetLocalModulePinsResponse)(nil),    // 5: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	(*GetGoVersionRequest)(nil),           // 6: buf.alpha.registry.v1alpha1.GetGoVersionRequest
	(*GetGoVersionResponse)(nil),          // 7: buf.alpha.registry.v1alpha1.GetGoVersionResponse
	(*GetMavenVersionRequest)(nil),        // 8: buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	(*GetMavenVersionResponse)(nil),       // 9: buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	(*GetNPMVersionRequest)(nil),          // 10: buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	(*GetNPMVersionResponse)(nil),         // 11: buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	(*GetSwiftVersionRequest)(nil),        // 12: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	(*GetSwiftVersionResponse)(nil),       // 13: buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	(*GetPythonVersionRequest)(nil),       // 14: buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	(*GetPythonVersionResponse)(nil),      // 15: buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	(*GetCargoVersionRequest)(nil),        // 16: buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	(*GetCargoVersionResponse)(nil),       // 17: buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	(*GetNugetVersionRequest)(nil),        // 18: buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	(*GetNugetVersionResponse)(nil),       // 19: buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	(*GetCmakeVersionRequest)(nil),        // 20: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	(*GetCmakeVersionResponse)(nil),       // 21: buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	(*GetRemotePackageVersionPlugin)(nil), // 22: buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	(*GetSDKInfoRequest)(nil),             // 23: buf.alpha.registry.v1alpha1.GetSDKInfoRequest
	(*GetSDKInfoResponse)(nil),            // 24: buf.alpha.registry.v1alpha1.GetSDKInfoResponse
	(*GetSDKInfoResponse_ModuleInfo)(nil), // 25: buf.alpha.registry.v1alpha1.GetSDKInfoResponse.ModuleInfo
	(*GetSDKInfoResponse_PluginInfo)(nil), // 26: buf.alpha.registry.v1alpha1.GetSDKInfoResponse.PluginInfo
	(*v1alpha1.ModuleReference)(nil),      // 27: buf.alpha.module.v1alpha1.ModuleReference
	(*v1alpha1.ModulePin)(nil),            // 28: buf.alpha.module.v1alpha1.ModulePin
	(*LocalModuleReference)(nil),          // 29: buf.alpha.registry.v1alpha1.LocalModuleReference
	(*LocalModulePin)(nil),                // 30: buf.alpha.registry.v1alpha1.LocalModulePin
	(*timestamppb.Timestamp)(nil),         // 31: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = []int32{
	27, // 0: buf.alpha.registry.v1alpha1.GetModulePinsRequest.module_references:type_name -> buf.alpha.module.v1alpha1.ModuleReference
	28, // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest.current_module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	28, // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse.module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	29, // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest.local_module_references:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	29, // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	30, // 5: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.pin:type_name -> buf.alpha.registry.v1alpha1.LocalModulePin
	0,  // 6: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.resolved_reference_type:type_name -> buf.alpha.registry.v1alpha1.ResolvedReferenceType
	4,  // 7: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.local_module_resolve_results:type_name -> buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	28, // 8: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.dependencies:type_name -> buf.alpha.module.v1alpha1.ModulePin
	22, // 9: buf.alpha.registry.v1alpha1.GetGoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 10: buf.alpha.registry.v1alpha1.GetGoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 11: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 12: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 13: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 14: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 15: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 16: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 17: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 18: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 19: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 20: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 21: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 22: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 23: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	29, // 24: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	29, // 25: buf.alpha.registry.v1alpha1.GetSDKInfoRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 26: buf.alpha.registry.v1alpha1.GetSDKInfoRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 27: buf.alpha.registry.v1alpha1.GetSDKInfoResponse.module_info:type_name -> buf.alpha.registry.v1alpha1.GetSDKInfoResponse.ModuleInfo
	26, // 28: buf.alpha.registry.v1alpha1.GetSDKInfoResponse.plugin_info:type_name -> buf.alpha.registry.v1alpha1.GetSDKInfoResponse.PluginInfo
	31, // 29: buf.alpha.registry.v1alpha1.GetSDKInfoResponse.ModuleInfo.module_commit_create_time:type_name -> google.protobuf.Timestamp
	1,  // 30: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:input_type -> buf.alpha.registry.v1alpha1.GetModulePinsRequest
	23, // 31: buf.alpha.registry.v1alpha1.ResolveService.GetSDKInfo:input_type -> buf.alpha.registry.v1alpha1.GetSDKInfoRequest
	6,  // 32: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:input_type -> buf.alpha.registry.v1alpha1.GetGoVersionRequest
	12, // 33: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:input_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	8,  // 34: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:input_type -> buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	10, // 35: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:input_type -> buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	14, // 36: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:input_type -> buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	16, // 37: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:input_type -> buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	18, // 38: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:input_type -> buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	20, // 39: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:input_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	3,  // 40: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:input_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	2,  // 41: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:output_type -> buf.alpha.registry.v1alpha1.GetModulePinsResponse
	24, // 42: buf.alpha.registry.v1alpha1.ResolveService.GetSDKInfo:output_type -> buf.alpha.registry.v1alpha1.GetSDKInfoResponse
	7,  // 43: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:output_type -> buf.alpha.registry.v1alpha1.GetGoVersionResponse
	13, // 44: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:output_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	9,  // 45: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:output_type -> buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	11, // 46: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:output_type -> buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	15, // 47: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:output_type -> buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	17, // 48: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:output_type -> buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	19, // 49: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:output_type -> buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	21, // 50: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:output_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	5,  // 51: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:output_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	41, // [41:52] is the sub-list for method output_type
	30, // [30:41] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_resolve_proto_init() }
func file_buf_alpha_registry_v1alpha1_resolve_proto_init() {
	if File_buf_alpha_registry_v1alpha1_resolve_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_module_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_resolve_proto = out.File
	file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = nil
}
