// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/repository_branch.proto

package registryv1alpha1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// RepositoryBranchServiceName is the fully-qualified name of the RepositoryBranchService service.
	RepositoryBranchServiceName = "buf.alpha.registry.v1alpha1.RepositoryBranchService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// RepositoryBranchServiceGetRepositoryBranchProcedure is the fully-qualified name of the
	// RepositoryBranchService's GetRepositoryBranch RPC.
	RepositoryBranchServiceGetRepositoryBranchProcedure = "/buf.alpha.registry.v1alpha1.RepositoryBranchService/GetRepositoryBranch"
	// RepositoryBranchServiceListRepositoryBranchesProcedure is the fully-qualified name of the
	// RepositoryBranchService's ListRepositoryBranches RPC.
	RepositoryBranchServiceListRepositoryBranchesProcedure = "/buf.alpha.registry.v1alpha1.RepositoryBranchService/ListRepositoryBranches"
	// RepositoryBranchServiceListRepositoryBranchesByReferenceProcedure is the fully-qualified name of
	// the RepositoryBranchService's ListRepositoryBranchesByReference RPC.
	RepositoryBranchServiceListRepositoryBranchesByReferenceProcedure = "/buf.alpha.registry.v1alpha1.RepositoryBranchService/ListRepositoryBranchesByReference"
	// RepositoryBranchServiceGetCurrentDefaultBranchProcedure is the fully-qualified name of the
	// RepositoryBranchService's GetCurrentDefaultBranch RPC.
	RepositoryBranchServiceGetCurrentDefaultBranchProcedure = "/buf.alpha.registry.v1alpha1.RepositoryBranchService/GetCurrentDefaultBranch"
)

// RepositoryBranchServiceClient is a client for the
// buf.alpha.registry.v1alpha1.RepositoryBranchService service.
type RepositoryBranchServiceClient interface {
	// GetRepositoryBranch gets a repository branch associated with a Repository by name
	GetRepositoryBranch(context.Context, *connect.Request[v1alpha1.GetRepositoryBranchRequest]) (*connect.Response[v1alpha1.GetRepositoryBranchResponse], error)
	// ListRepositoryBranches lists the repository branches associated with a Repository.
	ListRepositoryBranches(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesResponse], error)
	// ListRepositoryBranchesByReference lists the repository branches associated with a Repository,
	// filtered by a reference.
	ListRepositoryBranchesByReference(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesByReferenceRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesByReferenceResponse], error)
	// GetCurrentDefaultBranch returns the branch that is mapped to the repository's `default_branch` field.
	GetCurrentDefaultBranch(context.Context, *connect.Request[v1alpha1.GetCurrentDefaultBranchRequest]) (*connect.Response[v1alpha1.GetCurrentDefaultBranchResponse], error)
}

// NewRepositoryBranchServiceClient constructs a client for the
// buf.alpha.registry.v1alpha1.RepositoryBranchService service. By default, it uses the Connect
// protocol with the binary Protobuf Codec, asks for gzipped responses, and sends uncompressed
// requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewRepositoryBranchServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) RepositoryBranchServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	repositoryBranchServiceMethods := v1alpha1.File_buf_alpha_registry_v1alpha1_repository_branch_proto.Services().ByName("RepositoryBranchService").Methods()
	return &repositoryBranchServiceClient{
		getRepositoryBranch: connect.NewClient[v1alpha1.GetRepositoryBranchRequest, v1alpha1.GetRepositoryBranchResponse](
			httpClient,
			baseURL+RepositoryBranchServiceGetRepositoryBranchProcedure,
			connect.WithSchema(repositoryBranchServiceMethods.ByName("GetRepositoryBranch")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listRepositoryBranches: connect.NewClient[v1alpha1.ListRepositoryBranchesRequest, v1alpha1.ListRepositoryBranchesResponse](
			httpClient,
			baseURL+RepositoryBranchServiceListRepositoryBranchesProcedure,
			connect.WithSchema(repositoryBranchServiceMethods.ByName("ListRepositoryBranches")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listRepositoryBranchesByReference: connect.NewClient[v1alpha1.ListRepositoryBranchesByReferenceRequest, v1alpha1.ListRepositoryBranchesByReferenceResponse](
			httpClient,
			baseURL+RepositoryBranchServiceListRepositoryBranchesByReferenceProcedure,
			connect.WithSchema(repositoryBranchServiceMethods.ByName("ListRepositoryBranchesByReference")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		getCurrentDefaultBranch: connect.NewClient[v1alpha1.GetCurrentDefaultBranchRequest, v1alpha1.GetCurrentDefaultBranchResponse](
			httpClient,
			baseURL+RepositoryBranchServiceGetCurrentDefaultBranchProcedure,
			connect.WithSchema(repositoryBranchServiceMethods.ByName("GetCurrentDefaultBranch")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
	}
}

// repositoryBranchServiceClient implements RepositoryBranchServiceClient.
type repositoryBranchServiceClient struct {
	getRepositoryBranch               *connect.Client[v1alpha1.GetRepositoryBranchRequest, v1alpha1.GetRepositoryBranchResponse]
	listRepositoryBranches            *connect.Client[v1alpha1.ListRepositoryBranchesRequest, v1alpha1.ListRepositoryBranchesResponse]
	listRepositoryBranchesByReference *connect.Client[v1alpha1.ListRepositoryBranchesByReferenceRequest, v1alpha1.ListRepositoryBranchesByReferenceResponse]
	getCurrentDefaultBranch           *connect.Client[v1alpha1.GetCurrentDefaultBranchRequest, v1alpha1.GetCurrentDefaultBranchResponse]
}

// GetRepositoryBranch calls
// buf.alpha.registry.v1alpha1.RepositoryBranchService.GetRepositoryBranch.
func (c *repositoryBranchServiceClient) GetRepositoryBranch(ctx context.Context, req *connect.Request[v1alpha1.GetRepositoryBranchRequest]) (*connect.Response[v1alpha1.GetRepositoryBranchResponse], error) {
	return c.getRepositoryBranch.CallUnary(ctx, req)
}

// ListRepositoryBranches calls
// buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranches.
func (c *repositoryBranchServiceClient) ListRepositoryBranches(ctx context.Context, req *connect.Request[v1alpha1.ListRepositoryBranchesRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesResponse], error) {
	return c.listRepositoryBranches.CallUnary(ctx, req)
}

// ListRepositoryBranchesByReference calls
// buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranchesByReference.
func (c *repositoryBranchServiceClient) ListRepositoryBranchesByReference(ctx context.Context, req *connect.Request[v1alpha1.ListRepositoryBranchesByReferenceRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesByReferenceResponse], error) {
	return c.listRepositoryBranchesByReference.CallUnary(ctx, req)
}

// GetCurrentDefaultBranch calls
// buf.alpha.registry.v1alpha1.RepositoryBranchService.GetCurrentDefaultBranch.
func (c *repositoryBranchServiceClient) GetCurrentDefaultBranch(ctx context.Context, req *connect.Request[v1alpha1.GetCurrentDefaultBranchRequest]) (*connect.Response[v1alpha1.GetCurrentDefaultBranchResponse], error) {
	return c.getCurrentDefaultBranch.CallUnary(ctx, req)
}

// RepositoryBranchServiceHandler is an implementation of the
// buf.alpha.registry.v1alpha1.RepositoryBranchService service.
type RepositoryBranchServiceHandler interface {
	// GetRepositoryBranch gets a repository branch associated with a Repository by name
	GetRepositoryBranch(context.Context, *connect.Request[v1alpha1.GetRepositoryBranchRequest]) (*connect.Response[v1alpha1.GetRepositoryBranchResponse], error)
	// ListRepositoryBranches lists the repository branches associated with a Repository.
	ListRepositoryBranches(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesResponse], error)
	// ListRepositoryBranchesByReference lists the repository branches associated with a Repository,
	// filtered by a reference.
	ListRepositoryBranchesByReference(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesByReferenceRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesByReferenceResponse], error)
	// GetCurrentDefaultBranch returns the branch that is mapped to the repository's `default_branch` field.
	GetCurrentDefaultBranch(context.Context, *connect.Request[v1alpha1.GetCurrentDefaultBranchRequest]) (*connect.Response[v1alpha1.GetCurrentDefaultBranchResponse], error)
}

// NewRepositoryBranchServiceHandler builds an HTTP handler from the service implementation. It
// returns the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewRepositoryBranchServiceHandler(svc RepositoryBranchServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	repositoryBranchServiceMethods := v1alpha1.File_buf_alpha_registry_v1alpha1_repository_branch_proto.Services().ByName("RepositoryBranchService").Methods()
	repositoryBranchServiceGetRepositoryBranchHandler := connect.NewUnaryHandler(
		RepositoryBranchServiceGetRepositoryBranchProcedure,
		svc.GetRepositoryBranch,
		connect.WithSchema(repositoryBranchServiceMethods.ByName("GetRepositoryBranch")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	repositoryBranchServiceListRepositoryBranchesHandler := connect.NewUnaryHandler(
		RepositoryBranchServiceListRepositoryBranchesProcedure,
		svc.ListRepositoryBranches,
		connect.WithSchema(repositoryBranchServiceMethods.ByName("ListRepositoryBranches")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	repositoryBranchServiceListRepositoryBranchesByReferenceHandler := connect.NewUnaryHandler(
		RepositoryBranchServiceListRepositoryBranchesByReferenceProcedure,
		svc.ListRepositoryBranchesByReference,
		connect.WithSchema(repositoryBranchServiceMethods.ByName("ListRepositoryBranchesByReference")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	repositoryBranchServiceGetCurrentDefaultBranchHandler := connect.NewUnaryHandler(
		RepositoryBranchServiceGetCurrentDefaultBranchProcedure,
		svc.GetCurrentDefaultBranch,
		connect.WithSchema(repositoryBranchServiceMethods.ByName("GetCurrentDefaultBranch")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.alpha.registry.v1alpha1.RepositoryBranchService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case RepositoryBranchServiceGetRepositoryBranchProcedure:
			repositoryBranchServiceGetRepositoryBranchHandler.ServeHTTP(w, r)
		case RepositoryBranchServiceListRepositoryBranchesProcedure:
			repositoryBranchServiceListRepositoryBranchesHandler.ServeHTTP(w, r)
		case RepositoryBranchServiceListRepositoryBranchesByReferenceProcedure:
			repositoryBranchServiceListRepositoryBranchesByReferenceHandler.ServeHTTP(w, r)
		case RepositoryBranchServiceGetCurrentDefaultBranchProcedure:
			repositoryBranchServiceGetCurrentDefaultBranchHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedRepositoryBranchServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedRepositoryBranchServiceHandler struct{}

func (UnimplementedRepositoryBranchServiceHandler) GetRepositoryBranch(context.Context, *connect.Request[v1alpha1.GetRepositoryBranchRequest]) (*connect.Response[v1alpha1.GetRepositoryBranchResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RepositoryBranchService.GetRepositoryBranch is not implemented"))
}

func (UnimplementedRepositoryBranchServiceHandler) ListRepositoryBranches(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranches is not implemented"))
}

func (UnimplementedRepositoryBranchServiceHandler) ListRepositoryBranchesByReference(context.Context, *connect.Request[v1alpha1.ListRepositoryBranchesByReferenceRequest]) (*connect.Response[v1alpha1.ListRepositoryBranchesByReferenceResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranchesByReference is not implemented"))
}

func (UnimplementedRepositoryBranchServiceHandler) GetCurrentDefaultBranch(context.Context, *connect.Request[v1alpha1.GetCurrentDefaultBranchRequest]) (*connect.Response[v1alpha1.GetCurrentDefaultBranchResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RepositoryBranchService.GetCurrentDefaultBranch is not implemented"))
}
