/* usage_monitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from usage_monitor.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.UsageMonitor.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "raven-plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	USAGE_MONITOR_RAVEN_PLUGIN_0_PROPERTY,
	USAGE_MONITOR_RAVEN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* usage_monitor_raven_plugin_properties[USAGE_MONITOR_RAVEN_PLUGIN_NUM_PROPERTIES];

#define TYPE_USAGE_MONITOR_ROW (usage_monitor_row_get_type ())
#define USAGE_MONITOR_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USAGE_MONITOR_ROW, UsageMonitorRow))
#define USAGE_MONITOR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USAGE_MONITOR_ROW, UsageMonitorRowClass))
#define IS_USAGE_MONITOR_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USAGE_MONITOR_ROW))
#define IS_USAGE_MONITOR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USAGE_MONITOR_ROW))
#define USAGE_MONITOR_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USAGE_MONITOR_ROW, UsageMonitorRowClass))

typedef struct _UsageMonitorRow UsageMonitorRow;
typedef struct _UsageMonitorRowClass UsageMonitorRowClass;

#define TYPE_PROC_STAT_CONTENTS (proc_stat_contents_get_type ())
typedef struct _ProcStatContents ProcStatContents;
enum  {
	USAGE_MONITOR_RAVEN_WIDGET_0_PROPERTY,
	USAGE_MONITOR_RAVEN_WIDGET_NUM_PROPERTIES
};
static GParamSpec* usage_monitor_raven_widget_properties[USAGE_MONITOR_RAVEN_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _usage_monitor_row_unref0(var) ((var == NULL) ? NULL : (var = (usage_monitor_row_unref (var), NULL)))
#define _proc_stat_contents_free0(var) ((var == NULL) ? NULL : (var = (proc_stat_contents_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _UsageMonitorRowPrivate UsageMonitorRowPrivate;

#define TYPE_PROC_MEMINFO_CONTENTS (proc_meminfo_contents_get_type ())
typedef struct _ProcMeminfoContents ProcMeminfoContents;
#define _proc_meminfo_contents_free0(var) ((var == NULL) ? NULL : (var = (proc_meminfo_contents_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	USAGE_MONITOR_RAVEN_WIDGET_SETTINGS_0_PROPERTY,
	USAGE_MONITOR_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* usage_monitor_raven_widget_settings_properties[USAGE_MONITOR_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES];
typedef struct _ParamSpecUsageMonitorRow ParamSpecUsageMonitorRow;

struct _ProcStatContents {
	gulong total;
	gulong busy;
};

struct _UsageMonitorRavenWidgetPrivate {
	GtkRevealer* content_revealer;
	UsageMonitorRow* cpu;
	UsageMonitorRow* ram;
	UsageMonitorRow* swap;
	ProcStatContents* prev;
	guint timeout_id;
};

struct _Block1Data {
	int _ref_count_;
	UsageMonitorRavenWidget* self;
	GtkButton* header_reveal_button;
};

struct _UsageMonitorRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageMonitorRowPrivate * priv;
	GtkLabel* label;
	GtkLevelBar* bar;
	GtkLabel* percentage;
	gint index;
	gboolean stay_hidden;
};

struct _UsageMonitorRowClass {
	GTypeClass parent_class;
	void (*finalize) (UsageMonitorRow *self);
};

struct _ProcMeminfoContents {
	gulong mem_total;
	gulong mem_available;
	gulong swap_total;
	gulong swap_free;
	gulong swap_cached;
};

struct _UsageMonitorRavenWidgetSettingsPrivate {
	GtkSwitch* switch_show_swap_usage;
};

struct _ParamSpecUsageMonitorRow {
	GParamSpec parent_instance;
};

static gpointer usage_monitor_raven_plugin_parent_class = NULL;
static BudgieRavenPluginIface * usage_monitor_raven_plugin_budgie_raven_plugin_parent_iface = NULL;
static GType usage_monitor_raven_plugin_type_id = 0;
static gint UsageMonitorRavenWidget_private_offset;
static gpointer usage_monitor_raven_widget_parent_class = NULL;
static GType usage_monitor_raven_widget_type_id = 0;
static gint UsageMonitorRavenWidgetSettings_private_offset;
static gpointer usage_monitor_raven_widget_settings_parent_class = NULL;
static GType usage_monitor_raven_widget_settings_type_id = 0;
static gpointer usage_monitor_row_parent_class = NULL;
static GType usage_monitor_row_type_id = 0;

static BudgieRavenWidget* usage_monitor_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                                        const gchar* uuid,
                                                                        GSettings* settings);
static gboolean usage_monitor_raven_plugin_real_supports_settings (BudgieRavenPlugin* base);
VALA_EXTERN gpointer usage_monitor_row_ref (gpointer instance);
VALA_EXTERN void usage_monitor_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_usage_monitor_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_usage_monitor_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_usage_monitor_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_usage_monitor_row (const GValue* value);
GType usage_monitor_row_register_type (GTypeModule * module);
VALA_EXTERN GType usage_monitor_row_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType proc_stat_contents_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ProcStatContents* proc_stat_contents_dup (const ProcStatContents* self);
VALA_EXTERN void proc_stat_contents_free (ProcStatContents* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
VALA_EXTERN UsageMonitorRow* usage_monitor_row_new (const gchar* name,
                                        gint index);
VALA_EXTERN UsageMonitorRow* usage_monitor_row_construct (GType object_type,
                                              const gchar* name,
                                              gint index);
static void usage_monitor_raven_widget_settings_updated (UsageMonitorRavenWidget* self,
                                                  const gchar* key);
static void _usage_monitor_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self);
static void usage_monitor_raven_widget_update_cpu (UsageMonitorRavenWidget* self);
static void usage_monitor_raven_widget_update_ram_and_swap (UsageMonitorRavenWidget* self);
static void __lambda5_ (UsageMonitorRavenWidget* self,
                 gboolean expanded);
static gboolean ____lambda6_ (UsageMonitorRavenWidget* self);
static gboolean _____lambda6__gsource_func (gpointer self);
static void ___lambda5__budgie_raven_widget_raven_expanded (BudgieRavenWidget* _sender,
                                                     gboolean object,
                                                     gpointer self);
VALA_EXTERN void usage_monitor_row_show (UsageMonitorRow* self);
VALA_EXTERN void usage_monitor_row_hide (UsageMonitorRow* self);
static ProcStatContents* usage_monitor_raven_widget_read_proc_stat (UsageMonitorRavenWidget* self);
VALA_EXTERN void usage_monitor_row_update (UsageMonitorRow* self,
                               gfloat new_value);
VALA_EXTERN GType proc_meminfo_contents_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ProcMeminfoContents* proc_meminfo_contents_dup (const ProcMeminfoContents* self);
VALA_EXTERN void proc_meminfo_contents_free (ProcMeminfoContents* self);
static ProcMeminfoContents* usage_monitor_raven_widget_read_proc_meminfo (UsageMonitorRavenWidget* self);
static GtkWidget* usage_monitor_raven_widget_real_build_settings_ui (BudgieRavenWidget* base);
static void usage_monitor_raven_widget_finalize (GObject * obj);
static void usage_monitor_raven_widget_settings_finalize (GObject * obj);
static void usage_monitor_row_finalize (UsageMonitorRow * obj);

static BudgieRavenWidget*
usage_monitor_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                     const gchar* uuid,
                                                     GSettings* settings)
{
	UsageMonitorRavenPlugin * self;
	UsageMonitorRavenWidget* _tmp0_;
	BudgieRavenWidget* result;
	self = (UsageMonitorRavenPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = usage_monitor_raven_widget_new (uuid, settings);
	g_object_ref_sink (_tmp0_);
	result = (BudgieRavenWidget*) _tmp0_;
	return result;
}

static gboolean
usage_monitor_raven_plugin_real_supports_settings (BudgieRavenPlugin* base)
{
	UsageMonitorRavenPlugin * self;
	gboolean result;
	self = (UsageMonitorRavenPlugin*) base;
	result = TRUE;
	return result;
}

UsageMonitorRavenPlugin*
usage_monitor_raven_plugin_construct (GType object_type)
{
	UsageMonitorRavenPlugin * self = NULL;
	self = (UsageMonitorRavenPlugin*) g_object_new (object_type, NULL);
	return self;
}

UsageMonitorRavenPlugin*
usage_monitor_raven_plugin_new (void)
{
	return usage_monitor_raven_plugin_construct (TYPE_USAGE_MONITOR_RAVEN_PLUGIN);
}

static void
usage_monitor_raven_plugin_class_init (UsageMonitorRavenPluginClass * klass,
                                       gpointer klass_data)
{
	usage_monitor_raven_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
usage_monitor_raven_plugin_budgie_raven_plugin_interface_init (BudgieRavenPluginIface * iface,
                                                               gpointer iface_data)
{
	usage_monitor_raven_plugin_budgie_raven_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->new_widget_instance = (BudgieRavenWidget* (*) (BudgieRavenPlugin*, const gchar*, GSettings*)) usage_monitor_raven_plugin_real_new_widget_instance;
	iface->supports_settings = (gboolean (*) (BudgieRavenPlugin*)) usage_monitor_raven_plugin_real_supports_settings;
}

static void
usage_monitor_raven_plugin_instance_init (UsageMonitorRavenPlugin * self,
                                          gpointer klass)
{
}

GType
usage_monitor_raven_plugin_get_type (void)
{
	return usage_monitor_raven_plugin_type_id;
}

GType
usage_monitor_raven_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMonitorRavenPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_monitor_raven_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMonitorRavenPlugin), 0, (GInstanceInitFunc) usage_monitor_raven_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_raven_plugin_info = { (GInterfaceInitFunc) usage_monitor_raven_plugin_budgie_raven_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	usage_monitor_raven_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "UsageMonitorRavenPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, usage_monitor_raven_plugin_type_id, budgie_raven_plugin_get_type (), &budgie_raven_plugin_info);
	return usage_monitor_raven_plugin_type_id;
}

static inline gpointer
usage_monitor_raven_widget_get_instance_private (UsageMonitorRavenWidget* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMonitorRavenWidget_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		UsageMonitorRavenWidget* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->header_reveal_button);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_)
{
	UsageMonitorRavenWidget* self;
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkImage* image = NULL;
	GtkWidget* _tmp4_;
	GtkImage* _tmp5_;
	GtkRevealer* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = _data1_->self;
	_tmp0_ = self->priv->content_revealer;
	_tmp1_ = self->priv->content_revealer;
	_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
	_tmp4_ = gtk_button_get_image (_data1_->header_reveal_button);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_image_get_type (), GtkImage));
	image = _tmp5_;
	_tmp6_ = self->priv->content_revealer;
	_tmp7_ = gtk_revealer_get_reveal_child (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GtkImage* _tmp9_;
		_tmp9_ = image;
		gtk_image_set_from_icon_name (_tmp9_, "pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp10_;
		_tmp10_ = image;
		gtk_image_set_from_icon_name (_tmp10_, "pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_g_object_unref0 (image);
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ (self);
}

static void
_usage_monitor_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self)
{
	usage_monitor_raven_widget_settings_updated ((UsageMonitorRavenWidget*) self, key);
}

static gboolean
____lambda6_ (UsageMonitorRavenWidget* self)
{
	gboolean result;
	usage_monitor_raven_widget_update_cpu (self);
	usage_monitor_raven_widget_update_ram_and_swap (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
_____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda6_ ((UsageMonitorRavenWidget*) self);
	return result;
}

static void
__lambda5_ (UsageMonitorRavenWidget* self,
            gboolean expanded)
{
	gboolean _tmp0_ = FALSE;
	if (!expanded) {
		_tmp0_ = self->priv->timeout_id != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	} else {
		gboolean _tmp1_ = FALSE;
		if (expanded) {
			_tmp1_ = self->priv->timeout_id == ((guint) 0);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _____lambda6__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}

static void
___lambda5__budgie_raven_widget_raven_expanded (BudgieRavenWidget* _sender,
                                                gboolean object,
                                                gpointer self)
{
	__lambda5_ ((UsageMonitorRavenWidget*) self, object);
}

UsageMonitorRavenWidget*
usage_monitor_raven_widget_construct (GType object_type,
                                      const gchar* uuid,
                                      GSettings* settings)
{
	UsageMonitorRavenWidget * self = NULL;
	Block1Data* _data1_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp0_;
	GtkBox* header = NULL;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkImage* icon = NULL;
	GtkImage* _tmp3_;
	GtkLabel* header_label = NULL;
	GtkLabel* _tmp4_;
	GtkBox* content = NULL;
	GtkBox* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkRevealer* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkRevealer* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkButton* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkGrid* rows = NULL;
	GtkGrid* _tmp14_;
	UsageMonitorRow* _tmp15_;
	UsageMonitorRow* _tmp16_;
	GtkLabel* _tmp17_;
	UsageMonitorRow* _tmp18_;
	UsageMonitorRow* _tmp19_;
	GtkLevelBar* _tmp20_;
	UsageMonitorRow* _tmp21_;
	UsageMonitorRow* _tmp22_;
	GtkLabel* _tmp23_;
	UsageMonitorRow* _tmp24_;
	UsageMonitorRow* _tmp25_;
	UsageMonitorRow* _tmp26_;
	GtkLabel* _tmp27_;
	UsageMonitorRow* _tmp28_;
	UsageMonitorRow* _tmp29_;
	GtkLevelBar* _tmp30_;
	UsageMonitorRow* _tmp31_;
	UsageMonitorRow* _tmp32_;
	GtkLabel* _tmp33_;
	UsageMonitorRow* _tmp34_;
	UsageMonitorRow* _tmp35_;
	UsageMonitorRow* _tmp36_;
	GtkLabel* _tmp37_;
	UsageMonitorRow* _tmp38_;
	UsageMonitorRow* _tmp39_;
	GtkLevelBar* _tmp40_;
	UsageMonitorRow* _tmp41_;
	UsageMonitorRow* _tmp42_;
	GtkLabel* _tmp43_;
	UsageMonitorRow* _tmp44_;
	g_return_val_if_fail (uuid != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (UsageMonitorRavenWidget*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	budgie_raven_widget_initialize ((BudgieRavenWidget*) self, uuid, settings);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	main_box = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp2_, "raven-header");
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) header);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("utilities-system-monitor-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp3_);
	icon = _tmp3_;
	g_object_set ((GtkWidget*) icon, "margin", 4, NULL);
	gtk_widget_set_margin_start ((GtkWidget*) icon, 12);
	gtk_widget_set_margin_end ((GtkWidget*) icon, 10);
	gtk_container_add ((GtkContainer*) header, (GtkWidget*) icon);
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Usage Monitor"));
	g_object_ref_sink (_tmp4_);
	header_label = _tmp4_;
	gtk_container_add ((GtkContainer*) header, (GtkWidget*) header_label);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	content = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) content);
	gtk_style_context_add_class (_tmp6_, "raven-background");
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->content_revealer);
	self->priv->content_revealer = _tmp7_;
	_tmp8_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) content);
	_tmp9_ = self->priv->content_revealer;
	gtk_revealer_set_reveal_child (_tmp9_, TRUE);
	_tmp10_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp11_);
	_data1_->header_reveal_button = _tmp11_;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _data1_->header_reveal_button);
	gtk_style_context_add_class (_tmp12_, "flat");
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _data1_->header_reveal_button);
	gtk_style_context_add_class (_tmp13_, "expander-button");
	g_object_set ((GtkWidget*) _data1_->header_reveal_button, "margin", 4, NULL);
	gtk_widget_set_valign ((GtkWidget*) _data1_->header_reveal_button, GTK_ALIGN_CENTER);
	g_signal_connect_data (_data1_->header_reveal_button, "clicked", (GCallback) ___lambda4__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_box_pack_end (header, (GtkWidget*) _data1_->header_reveal_button, FALSE, FALSE, (guint) 0);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp14_);
	rows = _tmp14_;
	gtk_widget_set_hexpand ((GtkWidget*) rows, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) rows, 12);
	gtk_widget_set_margin_end ((GtkWidget*) rows, 12);
	gtk_widget_set_margin_top ((GtkWidget*) rows, 8);
	gtk_widget_set_margin_bottom ((GtkWidget*) rows, 8);
	gtk_grid_set_column_spacing (rows, (guint) 8);
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) rows);
	_tmp15_ = usage_monitor_row_new (_ ("CPU"), 0);
	_usage_monitor_row_unref0 (self->priv->cpu);
	self->priv->cpu = _tmp15_;
	_tmp16_ = self->priv->cpu;
	_tmp17_ = _tmp16_->label;
	_tmp18_ = self->priv->cpu;
	gtk_grid_attach (rows, (GtkWidget*) _tmp17_, 0, _tmp18_->index, 1, 1);
	_tmp19_ = self->priv->cpu;
	_tmp20_ = _tmp19_->bar;
	_tmp21_ = self->priv->cpu;
	gtk_grid_attach (rows, (GtkWidget*) _tmp20_, 1, _tmp21_->index, 1, 1);
	_tmp22_ = self->priv->cpu;
	_tmp23_ = _tmp22_->percentage;
	_tmp24_ = self->priv->cpu;
	gtk_grid_attach (rows, (GtkWidget*) _tmp23_, 2, _tmp24_->index, 1, 1);
	_tmp25_ = usage_monitor_row_new (_ ("RAM"), 1);
	_usage_monitor_row_unref0 (self->priv->ram);
	self->priv->ram = _tmp25_;
	_tmp26_ = self->priv->ram;
	_tmp27_ = _tmp26_->label;
	_tmp28_ = self->priv->ram;
	gtk_grid_attach (rows, (GtkWidget*) _tmp27_, 0, _tmp28_->index, 1, 1);
	_tmp29_ = self->priv->ram;
	_tmp30_ = _tmp29_->bar;
	_tmp31_ = self->priv->ram;
	gtk_grid_attach (rows, (GtkWidget*) _tmp30_, 1, _tmp31_->index, 1, 1);
	_tmp32_ = self->priv->ram;
	_tmp33_ = _tmp32_->percentage;
	_tmp34_ = self->priv->ram;
	gtk_grid_attach (rows, (GtkWidget*) _tmp33_, 2, _tmp34_->index, 1, 1);
	_tmp35_ = usage_monitor_row_new (_ ("Swap"), 2);
	_usage_monitor_row_unref0 (self->priv->swap);
	self->priv->swap = _tmp35_;
	_tmp36_ = self->priv->swap;
	_tmp37_ = _tmp36_->label;
	_tmp38_ = self->priv->swap;
	gtk_grid_attach (rows, (GtkWidget*) _tmp37_, 0, _tmp38_->index, 1, 1);
	_tmp39_ = self->priv->swap;
	_tmp40_ = _tmp39_->bar;
	_tmp41_ = self->priv->swap;
	gtk_grid_attach (rows, (GtkWidget*) _tmp40_, 1, _tmp41_->index, 1, 1);
	_tmp42_ = self->priv->swap;
	_tmp43_ = _tmp42_->percentage;
	_tmp44_ = self->priv->swap;
	gtk_grid_attach (rows, (GtkWidget*) _tmp43_, 2, _tmp44_->index, 1, 1);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object (settings, "changed", (GCallback) _usage_monitor_raven_widget_settings_updated_g_settings_changed, self, 0);
	usage_monitor_raven_widget_settings_updated (self, "show-swap-usage");
	usage_monitor_raven_widget_update_cpu (self);
	usage_monitor_raven_widget_update_ram_and_swap (self);
	g_signal_connect_object ((BudgieRavenWidget*) self, "raven-expanded", (GCallback) ___lambda5__budgie_raven_widget_raven_expanded, self, 0);
	_g_object_unref0 (rows);
	_g_object_unref0 (content);
	_g_object_unref0 (header_label);
	_g_object_unref0 (icon);
	_g_object_unref0 (header);
	_g_object_unref0 (main_box);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

UsageMonitorRavenWidget*
usage_monitor_raven_widget_new (const gchar* uuid,
                                GSettings* settings)
{
	return usage_monitor_raven_widget_construct (TYPE_USAGE_MONITOR_RAVEN_WIDGET, uuid, settings);
}

static void
usage_monitor_raven_widget_settings_updated (UsageMonitorRavenWidget* self,
                                             const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "show-swap-usage") == 0) {
		gboolean should_show = FALSE;
		GSettings* _tmp0_;
		UsageMonitorRow* _tmp1_;
		_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
		should_show = g_settings_get_boolean (_tmp0_, key);
		_tmp1_ = self->priv->swap;
		_tmp1_->stay_hidden = !should_show;
		if (should_show) {
			UsageMonitorRow* _tmp2_;
			_tmp2_ = self->priv->swap;
			usage_monitor_row_show (_tmp2_);
		} else {
			UsageMonitorRow* _tmp3_;
			_tmp3_ = self->priv->swap;
			usage_monitor_row_hide (_tmp3_);
		}
	}
}

static gpointer
_proc_stat_contents_dup0 (gpointer self)
{
	return self ? proc_stat_contents_dup (self) : NULL;
}

static void
usage_monitor_raven_widget_update_cpu (UsageMonitorRavenWidget* self)
{
	ProcStatContents* stat = NULL;
	ProcStatContents* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ProcStatContents* _tmp2_;
	ProcStatContents* _tmp9_;
	ProcStatContents* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = usage_monitor_raven_widget_read_proc_stat (self);
	stat = _tmp0_;
	_tmp2_ = self->priv->prev;
	if (_tmp2_ != NULL) {
		ProcStatContents* _tmp3_;
		_tmp3_ = stat;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gfloat total_cpu_usage = 0.0F;
		ProcStatContents* _tmp4_;
		ProcStatContents* _tmp5_;
		ProcStatContents* _tmp6_;
		ProcStatContents* _tmp7_;
		UsageMonitorRow* _tmp8_;
		_tmp4_ = stat;
		_tmp5_ = self->priv->prev;
		_tmp6_ = stat;
		_tmp7_ = self->priv->prev;
		total_cpu_usage = ((gfloat) ((*_tmp4_).busy - (*_tmp5_).busy)) / ((gfloat) ((*_tmp6_).total - (*_tmp7_).total));
		_tmp8_ = self->priv->cpu;
		usage_monitor_row_update (_tmp8_, total_cpu_usage);
	}
	_tmp9_ = stat;
	_tmp10_ = _proc_stat_contents_dup0 (_tmp9_);
	_proc_stat_contents_free0 (self->priv->prev);
	self->priv->prev = _tmp10_;
	_proc_stat_contents_free0 (stat);
}

static void
usage_monitor_raven_widget_update_ram_and_swap (UsageMonitorRavenWidget* self)
{
	ProcMeminfoContents* meminfo = NULL;
	ProcMeminfoContents* _tmp0_;
	ProcMeminfoContents* _tmp1_;
	gboolean _tmp4_ = FALSE;
	ProcMeminfoContents* _tmp5_;
	ProcMeminfoContents* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = usage_monitor_raven_widget_read_proc_meminfo (self);
	meminfo = _tmp0_;
	_tmp1_ = meminfo;
	if (_tmp1_ == NULL) {
		UsageMonitorRow* _tmp2_;
		UsageMonitorRow* _tmp3_;
		_tmp2_ = self->priv->ram;
		usage_monitor_row_hide (_tmp2_);
		_tmp3_ = self->priv->swap;
		usage_monitor_row_hide (_tmp3_);
		_proc_meminfo_contents_free0 (meminfo);
		return;
	}
	_tmp5_ = meminfo;
	if ((*_tmp5_).swap_total > ((gulong) 0)) {
		UsageMonitorRow* _tmp6_;
		_tmp6_ = self->priv->swap;
		_tmp4_ = !_tmp6_->stay_hidden;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gulong swap_used = 0UL;
		ProcMeminfoContents* _tmp7_;
		ProcMeminfoContents* _tmp8_;
		ProcMeminfoContents* _tmp9_;
		UsageMonitorRow* _tmp10_;
		ProcMeminfoContents* _tmp11_;
		_tmp7_ = meminfo;
		_tmp8_ = meminfo;
		_tmp9_ = meminfo;
		swap_used = ((*_tmp7_).swap_total - (*_tmp8_).swap_free) - (*_tmp9_).swap_cached;
		_tmp10_ = self->priv->swap;
		_tmp11_ = meminfo;
		usage_monitor_row_update (_tmp10_, ((gfloat) swap_used) / ((gfloat) (*_tmp11_).swap_total));
	} else {
		UsageMonitorRow* _tmp12_;
		_tmp12_ = self->priv->swap;
		usage_monitor_row_hide (_tmp12_);
	}
	_tmp13_ = meminfo;
	if ((*_tmp13_).mem_total > ((gulong) 0)) {
		gulong mem_used = 0UL;
		ProcMeminfoContents* _tmp14_;
		ProcMeminfoContents* _tmp15_;
		UsageMonitorRow* _tmp16_;
		ProcMeminfoContents* _tmp17_;
		_tmp14_ = meminfo;
		_tmp15_ = meminfo;
		mem_used = (*_tmp14_).mem_total - (*_tmp15_).mem_available;
		_tmp16_ = self->priv->ram;
		_tmp17_ = meminfo;
		usage_monitor_row_update (_tmp16_, ((gfloat) mem_used) / ((gfloat) (*_tmp17_).mem_total));
	} else {
		UsageMonitorRow* _tmp18_;
		_tmp18_ = self->priv->ram;
		usage_monitor_row_hide (_tmp18_);
	}
	_proc_meminfo_contents_free0 (meminfo);
}

static ProcStatContents*
usage_monitor_raven_widget_read_proc_stat (UsageMonitorRavenWidget* self)
{
	GFile* stat_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	ProcStatContents* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_file_new_for_path ("/proc/stat");
	stat_file = _tmp0_;
	_tmp1_ = stat_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = NULL;
		_g_object_unref0 (stat_file);
		return result;
	}
	{
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* input_stream = NULL;
		GDataInputStream* _tmp5_;
		gchar* line = NULL;
		_tmp3_ = stat_file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		input_stream = _tmp5_;
		while (TRUE) {
			gchar* _tmp6_ = NULL;
			GDataInputStream* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gulong user = 0UL;
			gulong nice = 0UL;
			gulong system = 0UL;
			gulong idle = 0UL;
			gulong iowait = 0UL;
			gulong irq = 0UL;
			gulong softirq = 0UL;
			gint read = 0;
			const gchar* _tmp12_;
			_tmp7_ = input_stream;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (input_stream);
				_g_object_unref0 (_tmp2_);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				_g_free0 (_tmp6_);
				break;
			}
			_tmp11_ = line;
			if (!g_str_has_prefix (_tmp11_, "cpu ")) {
				_g_free0 (_tmp6_);
				continue;
			}
			user = (gulong) 0;
			nice = (gulong) 0;
			system = (gulong) 0;
			idle = (gulong) 0;
			iowait = (gulong) 0;
			irq = (gulong) 0;
			softirq = (gulong) 0;
			_tmp12_ = line;
			read = sscanf (_tmp12_, "%*s %lu %lu %lu %lu %lu %lu %lu", &user, &nice, &system, &idle, &iowait, &irq, &softirq);
			if (read == 7) {
				ProcStatContents* contents = NULL;
				ProcStatContents _tmp13_ = {0};
				ProcStatContents* _tmp14_;
				ProcStatContents* _tmp15_;
				ProcStatContents* _tmp16_;
				ProcStatContents* _tmp17_;
				memset (&_tmp13_, 0, sizeof (ProcStatContents));
				_tmp14_ = _proc_stat_contents_dup0 (&_tmp13_);
				contents = _tmp14_;
				_tmp15_ = contents;
				(*_tmp15_).total = (((((user + nice) + system) + idle) + iowait) + irq) + softirq;
				_tmp16_ = contents;
				_tmp17_ = contents;
				(*_tmp16_).busy = ((*_tmp17_).total - idle) - iowait;
				result = contents;
				_g_free0 (_tmp6_);
				_g_free0 (line);
				_g_object_unref0 (input_stream);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (stat_file);
				return result;
			}
			_g_free0 (_tmp6_);
		}
		_g_free0 (line);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (stat_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (stat_file);
	return result;
}

static gpointer
_proc_meminfo_contents_dup0 (gpointer self)
{
	return self ? proc_meminfo_contents_dup (self) : NULL;
}

static ProcMeminfoContents*
usage_monitor_raven_widget_read_proc_meminfo (UsageMonitorRavenWidget* self)
{
	GFile* meminfo_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	ProcMeminfoContents* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_file_new_for_path ("/proc/meminfo");
	meminfo_file = _tmp0_;
	_tmp1_ = meminfo_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = NULL;
		_g_object_unref0 (meminfo_file);
		return result;
	}
	{
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* input_stream = NULL;
		GDataInputStream* _tmp5_;
		ProcMeminfoContents contents = {0};
		gchar* line = NULL;
		ProcMeminfoContents* _tmp19_;
		_tmp3_ = meminfo_file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		input_stream = _tmp5_;
		memset (&contents, 0, sizeof (ProcMeminfoContents));
		while (TRUE) {
			gchar* _tmp6_ = NULL;
			GDataInputStream* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* label = NULL;
			gchar* _tmp11_;
			gulong value = 0UL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp7_ = input_stream;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (input_stream);
				_g_object_unref0 (_tmp2_);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				_g_free0 (_tmp6_);
				break;
			}
			_tmp11_ = g_strdup ("");
			label = _tmp11_;
			value = (gulong) -1;
			_tmp12_ = line;
			_tmp13_ = label;
			sscanf (_tmp12_, "%s %lu", _tmp13_, &value);
			_tmp14_ = label;
			if (g_strcmp0 (_tmp14_, "MemTotal:") == 0) {
				contents.mem_total = value;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = label;
				if (g_strcmp0 (_tmp15_, "MemAvailable:") == 0) {
					contents.mem_available = value;
				} else {
					const gchar* _tmp16_;
					_tmp16_ = label;
					if (g_strcmp0 (_tmp16_, "SwapTotal:") == 0) {
						contents.swap_total = value;
					} else {
						const gchar* _tmp17_;
						_tmp17_ = label;
						if (g_strcmp0 (_tmp17_, "SwapFree:") == 0) {
							contents.swap_free = value;
						} else {
							const gchar* _tmp18_;
							_tmp18_ = label;
							if (g_strcmp0 (_tmp18_, "SwapCached:") == 0) {
								contents.swap_cached = value;
							}
						}
					}
				}
			}
			_g_free0 (label);
			_g_free0 (_tmp6_);
		}
		_tmp19_ = _proc_meminfo_contents_dup0 (&contents);
		result = _tmp19_;
		_g_free0 (line);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (meminfo_file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (meminfo_file);
		return result;
	}
	__finally0:
	_g_object_unref0 (meminfo_file);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GtkWidget*
usage_monitor_raven_widget_real_build_settings_ui (BudgieRavenWidget* base)
{
	UsageMonitorRavenWidget * self;
	GSettings* _tmp0_;
	UsageMonitorRavenWidgetSettings* _tmp1_;
	GtkWidget* result;
	self = (UsageMonitorRavenWidget*) base;
	_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	_tmp1_ = usage_monitor_raven_widget_settings_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWidget*) _tmp1_;
	return result;
}

static void
usage_monitor_raven_widget_class_init (UsageMonitorRavenWidgetClass * klass,
                                       gpointer klass_data)
{
	usage_monitor_raven_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageMonitorRavenWidget_private_offset);
	((BudgieRavenWidgetClass *) klass)->build_settings_ui = (GtkWidget* (*) (BudgieRavenWidget*)) usage_monitor_raven_widget_real_build_settings_ui;
	G_OBJECT_CLASS (klass)->finalize = usage_monitor_raven_widget_finalize;
}

static void
usage_monitor_raven_widget_instance_init (UsageMonitorRavenWidget * self,
                                          gpointer klass)
{
	self->priv = usage_monitor_raven_widget_get_instance_private (self);
	self->priv->content_revealer = NULL;
	self->priv->cpu = NULL;
	self->priv->ram = NULL;
	self->priv->swap = NULL;
	self->priv->prev = NULL;
	self->priv->timeout_id = (guint) 0;
}

static void
usage_monitor_raven_widget_finalize (GObject * obj)
{
	UsageMonitorRavenWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USAGE_MONITOR_RAVEN_WIDGET, UsageMonitorRavenWidget);
	_g_object_unref0 (self->priv->content_revealer);
	_usage_monitor_row_unref0 (self->priv->cpu);
	_usage_monitor_row_unref0 (self->priv->ram);
	_usage_monitor_row_unref0 (self->priv->swap);
	_proc_stat_contents_free0 (self->priv->prev);
	G_OBJECT_CLASS (usage_monitor_raven_widget_parent_class)->finalize (obj);
}

GType
usage_monitor_raven_widget_get_type (void)
{
	return usage_monitor_raven_widget_type_id;
}

GType
usage_monitor_raven_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMonitorRavenWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_monitor_raven_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMonitorRavenWidget), 0, (GInstanceInitFunc) usage_monitor_raven_widget_instance_init, NULL };
	usage_monitor_raven_widget_type_id = g_type_module_register_type (module, budgie_raven_widget_get_type (), "UsageMonitorRavenWidget", &g_define_type_info, 0);
	UsageMonitorRavenWidget_private_offset = sizeof (UsageMonitorRavenWidgetPrivate);
	return usage_monitor_raven_widget_type_id;
}

static inline gpointer
usage_monitor_raven_widget_settings_get_instance_private (UsageMonitorRavenWidgetSettings* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMonitorRavenWidgetSettings_private_offset);
}

UsageMonitorRavenWidgetSettings*
usage_monitor_raven_widget_settings_construct (GType object_type,
                                               GSettings* settings)
{
	UsageMonitorRavenWidgetSettings * self = NULL;
	GtkSwitch* _tmp0_;
	self = (UsageMonitorRavenWidgetSettings*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->switch_show_swap_usage;
	g_settings_bind (settings, "show-swap-usage", (GObject*) _tmp0_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

UsageMonitorRavenWidgetSettings*
usage_monitor_raven_widget_settings_new (GSettings* settings)
{
	return usage_monitor_raven_widget_settings_construct (TYPE_USAGE_MONITOR_RAVEN_WIDGET_SETTINGS, settings);
}

static void
usage_monitor_raven_widget_settings_class_init (UsageMonitorRavenWidgetSettingsClass * klass,
                                                gpointer klass_data)
{
	usage_monitor_raven_widget_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageMonitorRavenWidgetSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = usage_monitor_raven_widget_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/buddiesofbudgie/budgie-desktop/raven/widget/UsageMonitor/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_swap_usage", FALSE, UsageMonitorRavenWidgetSettings_private_offset + G_STRUCT_OFFSET (UsageMonitorRavenWidgetSettingsPrivate, switch_show_swap_usage));
}

static void
usage_monitor_raven_widget_settings_instance_init (UsageMonitorRavenWidgetSettings * self,
                                                   gpointer klass)
{
	self->priv = usage_monitor_raven_widget_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_monitor_raven_widget_settings_finalize (GObject * obj)
{
	UsageMonitorRavenWidgetSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USAGE_MONITOR_RAVEN_WIDGET_SETTINGS, UsageMonitorRavenWidgetSettings);
	G_OBJECT_CLASS (usage_monitor_raven_widget_settings_parent_class)->finalize (obj);
}

GType
usage_monitor_raven_widget_settings_get_type (void)
{
	return usage_monitor_raven_widget_settings_type_id;
}

GType
usage_monitor_raven_widget_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMonitorRavenWidgetSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_monitor_raven_widget_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMonitorRavenWidgetSettings), 0, (GInstanceInitFunc) usage_monitor_raven_widget_settings_instance_init, NULL };
	usage_monitor_raven_widget_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "UsageMonitorRavenWidgetSettings", &g_define_type_info, 0);
	UsageMonitorRavenWidgetSettings_private_offset = sizeof (UsageMonitorRavenWidgetSettingsPrivate);
	return usage_monitor_raven_widget_settings_type_id;
}

ProcMeminfoContents*
proc_meminfo_contents_dup (const ProcMeminfoContents* self)
{
	ProcMeminfoContents* dup;
	dup = g_new0 (ProcMeminfoContents, 1);
	memcpy (dup, self, sizeof (ProcMeminfoContents));
	return dup;
}

void
proc_meminfo_contents_free (ProcMeminfoContents* self)
{
	g_free (self);
}

static GType
proc_meminfo_contents_get_type_once (void)
{
	GType proc_meminfo_contents_type_id;
	proc_meminfo_contents_type_id = g_boxed_type_register_static ("ProcMeminfoContents", (GBoxedCopyFunc) proc_meminfo_contents_dup, (GBoxedFreeFunc) proc_meminfo_contents_free);
	return proc_meminfo_contents_type_id;
}

GType
proc_meminfo_contents_get_type (void)
{
	static volatile gsize proc_meminfo_contents_type_id__once = 0;
	if (g_once_init_enter (&proc_meminfo_contents_type_id__once)) {
		GType proc_meminfo_contents_type_id;
		proc_meminfo_contents_type_id = proc_meminfo_contents_get_type_once ();
		g_once_init_leave (&proc_meminfo_contents_type_id__once, proc_meminfo_contents_type_id);
	}
	return proc_meminfo_contents_type_id__once;
}

ProcStatContents*
proc_stat_contents_dup (const ProcStatContents* self)
{
	ProcStatContents* dup;
	dup = g_new0 (ProcStatContents, 1);
	memcpy (dup, self, sizeof (ProcStatContents));
	return dup;
}

void
proc_stat_contents_free (ProcStatContents* self)
{
	g_free (self);
}

static GType
proc_stat_contents_get_type_once (void)
{
	GType proc_stat_contents_type_id;
	proc_stat_contents_type_id = g_boxed_type_register_static ("ProcStatContents", (GBoxedCopyFunc) proc_stat_contents_dup, (GBoxedFreeFunc) proc_stat_contents_free);
	return proc_stat_contents_type_id;
}

GType
proc_stat_contents_get_type (void)
{
	static volatile gsize proc_stat_contents_type_id__once = 0;
	if (g_once_init_enter (&proc_stat_contents_type_id__once)) {
		GType proc_stat_contents_type_id;
		proc_stat_contents_type_id = proc_stat_contents_get_type_once ();
		g_once_init_leave (&proc_stat_contents_type_id__once, proc_stat_contents_type_id);
	}
	return proc_stat_contents_type_id__once;
}

UsageMonitorRow*
usage_monitor_row_construct (GType object_type,
                             const gchar* name,
                             gint index)
{
	UsageMonitorRow* self = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLevelBar* _tmp4_;
	GtkLevelBar* _tmp5_;
	GtkLevelBar* _tmp6_;
	GtkLevelBar* _tmp7_;
	GtkLevelBar* _tmp8_;
	GtkLevelBar* _tmp9_;
	GtkLevelBar* _tmp10_;
	GtkLevelBar* _tmp11_;
	GtkLevelBar* _tmp12_;
	GtkLevelBar* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (UsageMonitorRow*) g_type_create_instance (object_type);
	self->index = index;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->label);
	self->label = _tmp0_;
	_tmp1_ = self->label;
	gtk_label_set_xalign (_tmp1_, 0.0f);
	_tmp2_ = self->label;
	gtk_label_set_width_chars (_tmp2_, 5);
	_tmp3_ = self->label;
	gtk_label_set_markup (_tmp3_, name);
	_tmp4_ = (GtkLevelBar*) gtk_level_bar_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->bar);
	self->bar = _tmp4_;
	_tmp5_ = self->bar;
	gtk_level_bar_add_offset_value (_tmp5_, "full", 0.8);
	_tmp6_ = self->bar;
	gtk_level_bar_add_offset_value (_tmp6_, "high", 0.9);
	_tmp7_ = self->bar;
	gtk_level_bar_add_offset_value (_tmp7_, "low", 1.0);
	_tmp8_ = self->bar;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = self->bar;
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_FILL);
	_tmp10_ = self->bar;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 6);
	_tmp11_ = self->bar;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = self->bar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = self->bar;
	gtk_widget_set_size_request ((GtkWidget*) _tmp13_, -1, 10);
	_tmp14_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->percentage);
	self->percentage = _tmp14_;
	_tmp15_ = self->percentage;
	gtk_label_set_xalign (_tmp15_, 1.0f);
	_tmp16_ = self->percentage;
	gtk_label_set_width_chars (_tmp16_, 4);
	_tmp17_ = self->percentage;
	gtk_label_set_markup (_tmp17_, "<span size='small'>0%</span>");
	return self;
}

UsageMonitorRow*
usage_monitor_row_new (const gchar* name,
                       gint index)
{
	return usage_monitor_row_construct (TYPE_USAGE_MONITOR_ROW, name, index);
}

void
usage_monitor_row_update (UsageMonitorRow* self,
                          gfloat new_value)
{
	GtkLevelBar* _tmp0_;
	GtkLevelBar* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->bar;
	gtk_level_bar_set_value (_tmp0_, (gdouble) new_value);
	_tmp1_ = self->bar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
	_tmp2_ = self->percentage;
	_tmp3_ = g_strdup_printf ("<span size='small'>%.0f%%</span>", (gdouble) (new_value * 100));
	_tmp4_ = _tmp3_;
	gtk_label_set_markup (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	usage_monitor_row_show (self);
}

void
usage_monitor_row_show (UsageMonitorRow* self)
{
	GtkLabel* _tmp0_;
	GtkLevelBar* _tmp1_;
	GtkLabel* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->stay_hidden) {
		return;
	}
	_tmp0_ = self->label;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->bar;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->percentage;
	gtk_widget_show ((GtkWidget*) _tmp2_);
}

void
usage_monitor_row_hide (UsageMonitorRow* self)
{
	GtkLabel* _tmp0_;
	GtkLevelBar* _tmp1_;
	GtkLabel* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->bar;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->percentage;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}

static void
value_usage_monitor_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_usage_monitor_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		usage_monitor_row_unref (value->data[0].v_pointer);
	}
}

static void
value_usage_monitor_row_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = usage_monitor_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_usage_monitor_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_usage_monitor_row_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UsageMonitorRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = usage_monitor_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_usage_monitor_row_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	UsageMonitorRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = usage_monitor_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_usage_monitor_row (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecUsageMonitorRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USAGE_MONITOR_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_usage_monitor_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USAGE_MONITOR_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_usage_monitor_row (GValue* value,
                             gpointer v_object)
{
	UsageMonitorRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USAGE_MONITOR_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USAGE_MONITOR_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		usage_monitor_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_monitor_row_unref (old);
	}
}

void
value_take_usage_monitor_row (GValue* value,
                              gpointer v_object)
{
	UsageMonitorRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USAGE_MONITOR_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USAGE_MONITOR_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_monitor_row_unref (old);
	}
}

static void
usage_monitor_row_class_init (UsageMonitorRowClass * klass,
                              gpointer klass_data)
{
	usage_monitor_row_parent_class = g_type_class_peek_parent (klass);
	((UsageMonitorRowClass *) klass)->finalize = usage_monitor_row_finalize;
}

static void
usage_monitor_row_instance_init (UsageMonitorRow * self,
                                 gpointer klass)
{
	self->stay_hidden = FALSE;
	self->ref_count = 1;
}

static void
usage_monitor_row_finalize (UsageMonitorRow * obj)
{
	UsageMonitorRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USAGE_MONITOR_ROW, UsageMonitorRow);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->label);
	_g_object_unref0 (self->bar);
	_g_object_unref0 (self->percentage);
}

GType
usage_monitor_row_get_type (void)
{
	return usage_monitor_row_type_id;
}

GType
usage_monitor_row_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { value_usage_monitor_row_init, value_usage_monitor_row_free_value, value_usage_monitor_row_copy_value, value_usage_monitor_row_peek_pointer, "p", value_usage_monitor_row_collect_value, "p", value_usage_monitor_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UsageMonitorRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_monitor_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMonitorRow), 0, (GInstanceInitFunc) usage_monitor_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	usage_monitor_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UsageMonitorRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return usage_monitor_row_type_id;
}

gpointer
usage_monitor_row_ref (gpointer instance)
{
	UsageMonitorRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
usage_monitor_row_unref (gpointer instance)
{
	UsageMonitorRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USAGE_MONITOR_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	usage_monitor_raven_plugin_register_type (module);
	usage_monitor_raven_widget_register_type (module);
	usage_monitor_raven_widget_settings_register_type (module);
	usage_monitor_row_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_raven_plugin_get_type (), TYPE_USAGE_MONITOR_RAVEN_PLUGIN);
	_g_object_unref0 (objmodule);
}

