/* media_controls.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from media_controls.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.MediaControls.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "raven-plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MEDIA_CONTROLS_RAVEN_PLUGIN_0_PROPERTY,
	MEDIA_CONTROLS_RAVEN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* media_controls_raven_plugin_properties[MEDIA_CONTROLS_RAVEN_PLUGIN_NUM_PROPERTIES];

#define TYPE_START_LISTENING (start_listening_get_type ())
#define START_LISTENING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_START_LISTENING, StartListening))
#define START_LISTENING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_START_LISTENING, StartListeningClass))
#define IS_START_LISTENING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_START_LISTENING))
#define IS_START_LISTENING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_START_LISTENING))
#define START_LISTENING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_START_LISTENING, StartListeningClass))

typedef struct _StartListening StartListening;
typedef struct _StartListeningClass StartListeningClass;
enum  {
	MEDIA_CONTROLS_RAVEN_WIDGET_0_PROPERTY,
	MEDIA_CONTROLS_RAVEN_WIDGET_NUM_PROPERTIES
};
static GParamSpec* media_controls_raven_widget_properties[MEDIA_CONTROLS_RAVEN_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MediaControlsRavenWidgetSetupDbusData MediaControlsRavenWidgetSetupDbusData;
typedef struct _StartListeningPrivate StartListeningPrivate;
enum  {
	START_LISTENING_0_PROPERTY,
	START_LISTENING_NUM_PROPERTIES
};
static GParamSpec* start_listening_properties[START_LISTENING_NUM_PROPERTIES];

struct _MediaControlsRavenWidgetPrivate {
	MprisDBusImpl* impl;
	GHashTable* ifaces;
	GtkBox* content;
	StartListening* placeholder;
	gint our_width;
};

struct _Block1Data {
	int _ref_count_;
	MediaControlsRavenWidget* self;
	gchar* n;
};

struct _MediaControlsRavenWidgetSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MediaControlsRavenWidget* self;
	MprisDBusImpl* _tmp0_;
	MprisDBusImpl* _tmp1_;
	MprisDBusImpl* _tmp2_;
	gchar** names;
	MprisDBusImpl* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	gchar* _tmp7_;
	gchar* name;
	const gchar* _tmp8_;
	MprisClient* iface;
	const gchar* _tmp9_;
	MprisClient* _tmp10_;
	MprisClient* _tmp11_;
	const gchar* _tmp12_;
	MprisClient* _tmp13_;
	MprisDBusImpl* _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _StartListening {
	GtkBox parent_instance;
	StartListeningPrivate * priv;
};

struct _StartListeningClass {
	GtkBoxClass parent_class;
};

struct _StartListeningPrivate {
	GAppInfo* music_app;
	gboolean has_music_player;
	GtkButton* start_listening;
};

static gpointer media_controls_raven_plugin_parent_class = NULL;
static BudgieRavenPluginIface * media_controls_raven_plugin_budgie_raven_plugin_parent_iface = NULL;
static GType media_controls_raven_plugin_type_id = 0;
static gint MediaControlsRavenWidget_private_offset;
static gpointer media_controls_raven_widget_parent_class = NULL;
static GType media_controls_raven_widget_type_id = 0;
static gint StartListening_private_offset;
static gpointer start_listening_parent_class = NULL;
static GType start_listening_type_id = 0;

static BudgieRavenWidget* media_controls_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                                         const gchar* uuid,
                                                                         GSettings* settings);
static gboolean media_controls_raven_plugin_real_supports_settings (BudgieRavenPlugin* base);
GType start_listening_register_type (GTypeModule * module);
VALA_EXTERN GType start_listening_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StartListening* start_listening_new (void);
VALA_EXTERN StartListening* start_listening_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void media_controls_raven_widget_on_size_allocate (MediaControlsRavenWidget* self);
static void _media_controls_raven_widget_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                             GtkAllocation* allocation,
                                                                             gpointer self);
static gboolean media_controls_raven_widget_notify_clients_on_width_change (MediaControlsRavenWidget* self);
static gboolean _media_controls_raven_widget_notify_clients_on_width_change_gsource_func (gpointer self);
static void media_controls_raven_widget_add_iface (MediaControlsRavenWidget* self,
                                            const gchar* name,
                                            MprisClient* iface);
static void media_controls_raven_widget_destroy_iface (MediaControlsRavenWidget* self,
                                                const gchar* name);
static void media_controls_raven_widget_on_name_owner_changed (MediaControlsRavenWidget* self,
                                                        const gchar* n,
                                                        const gchar* o,
                                                        const gchar* ne);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda16_ (Block1Data* _data1_,
                   GObject* o,
                   GAsyncResult* r);
static void ____lambda16__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean ___lambda17_ (Block1Data* _data1_);
static gboolean ____lambda17__gsource_func (gpointer self);
static void media_controls_raven_widget_setup_dbus_data_free (gpointer _data);
static gboolean media_controls_raven_widget_setup_dbus_co (MediaControlsRavenWidgetSetupDbusData* _data_);
static void media_controls_raven_widget_setup_dbus_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _media_controls_raven_widget_on_name_owner_changed_mpris_dbus_impl_name_owner_changed (MprisDBusImpl* _sender,
                                                                                            const gchar* name,
                                                                                            const gchar* old_owner,
                                                                                            const gchar* new_owner,
                                                                                            gpointer self);
static void media_controls_raven_widget_finalize (GObject * obj);
static void start_listening_check_music_support (StartListening* self);
static void _start_listening_check_music_support_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                      gpointer self);
static void start_listening_launch_music_player (StartListening* self);
static void _start_listening_launch_music_player_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void start_listening_finalize (GObject * obj);
GType mpris_client_register_type (GTypeModule * module);
GType mpris_client_widget_register_type (GTypeModule * module);
GType mpris_dbus_impl_register_type (GTypeModule * module);
VALA_EXTERN void mpris_dbus_impl_proxy_register_dynamic_type (GTypeModule* module);
GType mpris_dbus_prop_iface_register_type (GTypeModule * module);
VALA_EXTERN void mpris_dbus_prop_iface_proxy_register_dynamic_type (GTypeModule* module);
GType mpris_iface_register_type (GTypeModule * module);
VALA_EXTERN void mpris_iface_proxy_register_dynamic_type (GTypeModule* module);
GType mpris_player_iface_register_type (GTypeModule * module);
VALA_EXTERN void mpris_player_iface_proxy_register_dynamic_type (GTypeModule* module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static BudgieRavenWidget*
media_controls_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                      const gchar* uuid,
                                                      GSettings* settings)
{
	MediaControlsRavenPlugin * self;
	MediaControlsRavenWidget* _tmp0_;
	BudgieRavenWidget* result;
	self = (MediaControlsRavenPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = media_controls_raven_widget_new (uuid, settings);
	g_object_ref_sink (_tmp0_);
	result = (BudgieRavenWidget*) _tmp0_;
	return result;
}

static gboolean
media_controls_raven_plugin_real_supports_settings (BudgieRavenPlugin* base)
{
	MediaControlsRavenPlugin * self;
	gboolean result;
	self = (MediaControlsRavenPlugin*) base;
	result = FALSE;
	return result;
}

MediaControlsRavenPlugin*
media_controls_raven_plugin_construct (GType object_type)
{
	MediaControlsRavenPlugin * self = NULL;
	self = (MediaControlsRavenPlugin*) g_object_new (object_type, NULL);
	return self;
}

MediaControlsRavenPlugin*
media_controls_raven_plugin_new (void)
{
	return media_controls_raven_plugin_construct (TYPE_MEDIA_CONTROLS_RAVEN_PLUGIN);
}

static void
media_controls_raven_plugin_class_init (MediaControlsRavenPluginClass * klass,
                                        gpointer klass_data)
{
	media_controls_raven_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
media_controls_raven_plugin_budgie_raven_plugin_interface_init (BudgieRavenPluginIface * iface,
                                                                gpointer iface_data)
{
	media_controls_raven_plugin_budgie_raven_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->new_widget_instance = (BudgieRavenWidget* (*) (BudgieRavenPlugin*, const gchar*, GSettings*)) media_controls_raven_plugin_real_new_widget_instance;
	iface->supports_settings = (gboolean (*) (BudgieRavenPlugin*)) media_controls_raven_plugin_real_supports_settings;
}

static void
media_controls_raven_plugin_instance_init (MediaControlsRavenPlugin * self,
                                           gpointer klass)
{
}

GType
media_controls_raven_plugin_get_type (void)
{
	return media_controls_raven_plugin_type_id;
}

GType
media_controls_raven_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaControlsRavenPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_controls_raven_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaControlsRavenPlugin), 0, (GInstanceInitFunc) media_controls_raven_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_raven_plugin_info = { (GInterfaceInitFunc) media_controls_raven_plugin_budgie_raven_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	media_controls_raven_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "MediaControlsRavenPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, media_controls_raven_plugin_type_id, budgie_raven_plugin_get_type (), &budgie_raven_plugin_info);
	return media_controls_raven_plugin_type_id;
}

static inline gpointer
media_controls_raven_widget_get_instance_private (MediaControlsRavenWidget* self)
{
	return G_STRUCT_MEMBER_P (self, MediaControlsRavenWidget_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_media_controls_raven_widget_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                        GtkAllocation* allocation,
                                                                        gpointer self)
{
	media_controls_raven_widget_on_size_allocate ((MediaControlsRavenWidget*) self);
}

MediaControlsRavenWidget*
media_controls_raven_widget_construct (GType object_type,
                                       const gchar* uuid,
                                       GSettings* settings)
{
	MediaControlsRavenWidget * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	StartListening* _tmp2_;
	StartListening* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkBox* _tmp5_;
	StartListening* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (MediaControlsRavenWidget*) g_object_new (object_type, NULL);
	budgie_raven_widget_initialize ((BudgieRavenWidget*) self, uuid, settings);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 8);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp0_;
	_tmp1_ = self->priv->content;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = start_listening_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp2_;
	_tmp3_ = self->priv->placeholder;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "raven-header");
	_tmp5_ = self->priv->content;
	_tmp6_ = self->priv->placeholder;
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->ifaces);
	self->priv->ifaces = _tmp9_;
	media_controls_raven_widget_setup_dbus (self, NULL, NULL);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _media_controls_raven_widget_on_size_allocate_gtk_widget_size_allocate, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

MediaControlsRavenWidget*
media_controls_raven_widget_new (const gchar* uuid,
                                 GSettings* settings)
{
	return media_controls_raven_widget_construct (TYPE_MEDIA_CONTROLS_RAVEN_WIDGET, uuid, settings);
}

static gboolean
_media_controls_raven_widget_notify_clients_on_width_change_gsource_func (gpointer self)
{
	gboolean result;
	result = media_controls_raven_widget_notify_clients_on_width_change ((MediaControlsRavenWidget*) self);
	return result;
}

static void
media_controls_raven_widget_on_size_allocate (MediaControlsRavenWidget* self)
{
	gint w = 0;
	g_return_if_fail (self != NULL);
	w = gtk_widget_get_allocated_width ((GtkWidget*) self);
	if (w > self->priv->our_width) {
		self->priv->our_width = w;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _media_controls_raven_widget_notify_clients_on_width_change_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
media_controls_raven_widget_notify_clients_on_width_change (MediaControlsRavenWidget* self)
{
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	MprisClientWidget* widget = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ifaces;
	g_hash_table_iter_init (&iter, _tmp0_);
	widget = NULL;
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		MprisClientWidget* _tmp3_;
		MprisClientWidget* _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_object_unref0 (widget);
		_tmp3_ = _g_object_ref0 ((MprisClientWidget*) _tmp1_);
		widget = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = widget;
		mpris_client_widget_update_width (_tmp4_, self->priv->our_width);
	}
	result = FALSE;
	_g_object_unref0 (widget);
	return result;
}

/**
 * Add an interface handler/widget to known list and UI
 *
 * @param name DBUS name (object path)
 * @param iface The constructed MprisClient instance
 */
static void
media_controls_raven_widget_add_iface (MediaControlsRavenWidget* self,
                                       const gchar* name,
                                       MprisClient* iface)
{
	MprisClientWidget* widg = NULL;
	MprisClientWidget* _tmp0_;
	MprisClientWidget* _tmp1_;
	GtkBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	StartListening* _tmp5_;
	gboolean _tmp6_;
	GtkBox* _tmp9_;
	MprisClientWidget* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	MprisClientWidget* _tmp13_;
	MprisClientWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = mpris_client_widget_new (iface, self->priv->our_width);
	g_object_ref_sink (_tmp0_);
	widg = _tmp0_;
	_tmp1_ = widg;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->content;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->placeholder;
	_tmp6_ = g_list_index (_tmp4_, (GtkWidget*) _tmp5_) != -1;
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	if (_tmp6_) {
		GtkBox* _tmp7_;
		StartListening* _tmp8_;
		_tmp7_ = self->priv->content;
		_tmp8_ = self->priv->placeholder;
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	}
	_tmp9_ = self->priv->content;
	_tmp10_ = widg;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->priv->ifaces;
	_tmp12_ = g_strdup (name);
	_tmp13_ = widg;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp14_);
	_g_object_unref0 (widg);
}

/**
 * Destroy an interface handler and remove from UI
 *
 * @param name DBUS name to remove handler for
 */
static void
media_controls_raven_widget_destroy_iface (MediaControlsRavenWidget* self,
                                           const gchar* name)
{
	MprisClientWidget* widg = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	MprisClientWidget* _tmp2_;
	MprisClientWidget* _tmp3_;
	GHashTable* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->ifaces;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((MprisClientWidget*) _tmp1_);
	widg = _tmp2_;
	_tmp3_ = widg;
	if (_tmp3_ != NULL) {
		GtkBox* _tmp4_;
		MprisClientWidget* _tmp5_;
		GHashTable* _tmp6_;
		_tmp4_ = self->priv->content;
		_tmp5_ = widg;
		gtk_container_remove ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->ifaces;
		g_hash_table_remove (_tmp6_, name);
	}
	_tmp7_ = self->priv->ifaces;
	if (g_hash_table_size (_tmp7_) == ((guint) 0)) {
		GtkBox* _tmp8_;
		StartListening* _tmp9_;
		_tmp8_ = self->priv->content;
		_tmp9_ = self->priv->placeholder;
		gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	}
	_g_object_unref0 (widg);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MediaControlsRavenWidget* self;
		self = _data1_->self;
		_g_free0 (_data1_->n);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda16_ (Block1Data* _data1_,
              GObject* o,
              GAsyncResult* r)
{
	MediaControlsRavenWidget* self;
	MprisClient* iface = NULL;
	MprisClient* _tmp0_;
	MprisClient* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	_tmp0_ = new_iface_finish (r);
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ != NULL) {
		MprisClient* _tmp2_;
		_tmp2_ = iface;
		media_controls_raven_widget_add_iface (self, _data1_->n, _tmp2_);
	}
	_g_object_unref0 (iface);
}

static void
____lambda16__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda16_ (self, source_object, res);
	block1_data_unref (self);
}

static gboolean
___lambda17_ (Block1Data* _data1_)
{
	MediaControlsRavenWidget* self;
	gboolean result;
	self = _data1_->self;
	media_controls_raven_widget_destroy_iface (self, _data1_->n);
	result = FALSE;
	return result;
}

static gboolean
____lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda17_ (self);
	return result;
}

static void
media_controls_raven_widget_on_name_owner_changed (MediaControlsRavenWidget* self,
                                                   const gchar* n,
                                                   const gchar* o,
                                                   const gchar* ne)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (n);
	_g_free0 (_data1_->n);
	_data1_->n = _tmp0_;
	if (!g_str_has_prefix (_data1_->n, "org.mpris.MediaPlayer2.")) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	if (g_strcmp0 (o, "") == 0) {
		new_iface (_data1_->n, ____lambda16__gasync_ready_callback, block1_data_ref (_data1_));
	} else {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda17__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
media_controls_raven_widget_setup_dbus_data_free (gpointer _data)
{
	MediaControlsRavenWidgetSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MediaControlsRavenWidgetSetupDbusData, _data_);
}

void
media_controls_raven_widget_setup_dbus (MediaControlsRavenWidget* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	MediaControlsRavenWidgetSetupDbusData* _data_;
	MediaControlsRavenWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MediaControlsRavenWidgetSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, media_controls_raven_widget_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	media_controls_raven_widget_setup_dbus_co (_data_);
}

void
media_controls_raven_widget_setup_dbus_finish (MediaControlsRavenWidget* self,
                                               GAsyncResult* _res_)
{
	MediaControlsRavenWidgetSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Do basic dbus initialisation
 */
static void
media_controls_raven_widget_setup_dbus_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	MediaControlsRavenWidgetSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	media_controls_raven_widget_setup_dbus_co (_data_);
}

static void
_media_controls_raven_widget_on_name_owner_changed_mpris_dbus_impl_name_owner_changed (MprisDBusImpl* _sender,
                                                                                       const gchar* name,
                                                                                       const gchar* old_owner,
                                                                                       const gchar* new_owner,
                                                                                       gpointer self)
{
	media_controls_raven_widget_on_name_owner_changed ((MediaControlsRavenWidget*) self, name, old_owner, new_owner);
}

static gboolean
media_controls_raven_widget_setup_dbus_co (MediaControlsRavenWidgetSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_MPRIS_DBUS_IMPL_PROXY, 0, NULL, media_controls_raven_widget_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (MprisDBusImpl*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (MprisDBusImpl*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->impl);
		_data_->self->priv->impl = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->impl;
		_data_->_tmp4_ = 0;
		_data_->_state_ = 2;
		mpris_dbus_impl_list_names (_data_->_tmp3_, media_controls_raven_widget_setup_dbus_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = mpris_dbus_impl_list_names_finish (_data_->_tmp3_, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->names = _data_->_tmp5_;
		_data_->names_length1 = _data_->_tmp4_;
		_data_->_names_size_ = _data_->names_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->names;
		_data_->_tmp6__length1 = _data_->names_length1;
		{
			_data_->name_collection_length1 = 0;
			_data_->_name_collection_size_ = 0;
			_data_->name_collection = _data_->_tmp6_;
			_data_->name_collection_length1 = _data_->_tmp6__length1;
			for (_data_->name_it = 0; _data_->name_it < _data_->name_collection_length1; _data_->name_it = _data_->name_it + 1) {
				_data_->_tmp7_ = g_strdup (_data_->name_collection[_data_->name_it]);
				_data_->name = _data_->_tmp7_;
				{
					_data_->_tmp8_ = _data_->name;
					if (g_str_has_prefix (_data_->_tmp8_, "org.mpris.MediaPlayer2.")) {
						_data_->_tmp9_ = _data_->name;
						_data_->_state_ = 3;
						new_iface (_data_->_tmp9_, media_controls_raven_widget_setup_dbus_ready, _data_);
						return FALSE;
						_state_3:
						_data_->_tmp10_ = new_iface_finish (_data_->_res_);
						_data_->iface = _data_->_tmp10_;
						_data_->_tmp11_ = _data_->iface;
						if (_data_->_tmp11_ != NULL) {
							_data_->_tmp12_ = _data_->name;
							_data_->_tmp13_ = _data_->iface;
							media_controls_raven_widget_add_iface (_data_->self, _data_->_tmp12_, _data_->_tmp13_);
						}
						_g_object_unref0 (_data_->iface);
					}
					_g_free0 (_data_->name);
				}
			}
		}
		_data_->_tmp14_ = _data_->self->priv->impl;
		g_signal_connect_object (_data_->_tmp14_, "name-owner-changed", (GCallback) _media_controls_raven_widget_on_name_owner_changed_mpris_dbus_impl_name_owner_changed, _data_->self, 0);
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning ("media_controls.vala:142: Failed to initialise dbus: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
media_controls_raven_widget_class_init (MediaControlsRavenWidgetClass * klass,
                                        gpointer klass_data)
{
	media_controls_raven_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MediaControlsRavenWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = media_controls_raven_widget_finalize;
}

static void
media_controls_raven_widget_instance_init (MediaControlsRavenWidget * self,
                                           gpointer klass)
{
	self->priv = media_controls_raven_widget_get_instance_private (self);
	self->priv->content = NULL;
	self->priv->placeholder = NULL;
	self->priv->our_width = 250;
}

static void
media_controls_raven_widget_finalize (GObject * obj)
{
	MediaControlsRavenWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_CONTROLS_RAVEN_WIDGET, MediaControlsRavenWidget);
	_g_object_unref0 (self->priv->impl);
	_g_hash_table_unref0 (self->priv->ifaces);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->placeholder);
	G_OBJECT_CLASS (media_controls_raven_widget_parent_class)->finalize (obj);
}

GType
media_controls_raven_widget_get_type (void)
{
	return media_controls_raven_widget_type_id;
}

GType
media_controls_raven_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaControlsRavenWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_controls_raven_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaControlsRavenWidget), 0, (GInstanceInitFunc) media_controls_raven_widget_instance_init, NULL };
	media_controls_raven_widget_type_id = g_type_module_register_type (module, budgie_raven_widget_get_type (), "MediaControlsRavenWidget", &g_define_type_info, 0);
	MediaControlsRavenWidget_private_offset = sizeof (MediaControlsRavenWidgetPrivate);
	return media_controls_raven_widget_type_id;
}

static inline gpointer
start_listening_get_instance_private (StartListening* self)
{
	return G_STRUCT_MEMBER_P (self, StartListening_private_offset);
}

static void
_start_listening_check_music_support_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                 gpointer self)
{
	start_listening_check_music_support ((StartListening*) self);
}

static void
_start_listening_launch_music_player_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	start_listening_launch_music_player ((StartListening*) self);
}

StartListening*
start_listening_construct (GType object_type)
{
	StartListening * self = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GAppInfoMonitor* monitor = NULL;
	GAppInfoMonitor* _tmp6_;
	GtkButton* _tmp7_;
	self = (StartListening*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 8, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("No apps are currently playing audio."));
	g_object_set (_tmp0_, "wrap", TRUE, NULL);
	g_object_set (_tmp0_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp0_, 1);
	gtk_label_set_justify (_tmp0_, GTK_JUSTIFY_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_set_margin_top ((GtkWidget*) label, 4);
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Play some music"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->start_listening);
	self->priv->start_listening = _tmp1_;
	_tmp2_ = self->priv->start_listening;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = self->priv->start_listening;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 4);
	_tmp4_ = self->priv->start_listening;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, FALSE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp5_ = self->priv->start_listening;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = g_app_info_monitor_get ();
	monitor = _tmp6_;
	g_signal_connect_object (monitor, "changed", (GCallback) _start_listening_check_music_support_g_app_info_monitor_changed, self, 0);
	_tmp7_ = self->priv->start_listening;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) _start_listening_launch_music_player_gtk_button_clicked, self, 0);
	start_listening_check_music_support (self);
	_g_object_unref0 (monitor);
	_g_object_unref0 (label);
	return self;
}

StartListening*
start_listening_new (void)
{
	return start_listening_construct (TYPE_START_LISTENING);
}

static void
start_listening_check_music_support (StartListening* self)
{
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	GtkButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_default_for_type ("audio/vorbis", FALSE);
	_g_object_unref0 (self->priv->music_app);
	self->priv->music_app = _tmp0_;
	_tmp1_ = self->priv->music_app;
	self->priv->has_music_player = _tmp1_ != NULL;
	_tmp2_ = self->priv->start_listening;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, self->priv->has_music_player);
}

static void
start_listening_launch_music_player (StartListening* self)
{
	GAppInfo* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->music_app;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		GAppInfo* _tmp1_;
		_tmp1_ = self->priv->music_app;
		g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GAppInfo* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->music_app;
		_tmp3_ = g_app_info_get_name (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("media_controls.vala:198: Unable to launch %s: %s", _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
start_listening_class_init (StartListeningClass * klass,
                            gpointer klass_data)
{
	start_listening_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartListening_private_offset);
	G_OBJECT_CLASS (klass)->finalize = start_listening_finalize;
}

static void
start_listening_instance_init (StartListening * self,
                               gpointer klass)
{
	self->priv = start_listening_get_instance_private (self);
	self->priv->music_app = NULL;
}

static void
start_listening_finalize (GObject * obj)
{
	StartListening * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_START_LISTENING, StartListening);
	_g_object_unref0 (self->priv->music_app);
	_g_object_unref0 (self->priv->start_listening);
	G_OBJECT_CLASS (start_listening_parent_class)->finalize (obj);
}

GType
start_listening_get_type (void)
{
	return start_listening_type_id;
}

GType
start_listening_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartListeningClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) start_listening_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartListening), 0, (GInstanceInitFunc) start_listening_instance_init, NULL };
	start_listening_type_id = g_type_module_register_type (module, gtk_box_get_type (), "StartListening", &g_define_type_info, 0);
	StartListening_private_offset = sizeof (StartListeningPrivate);
	return start_listening_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	media_controls_raven_plugin_register_type (module);
	media_controls_raven_widget_register_type (module);
	start_listening_register_type (module);
	mpris_client_register_type (module);
	mpris_client_widget_register_type (module);
	mpris_dbus_impl_register_type (module);
	mpris_dbus_impl_proxy_register_dynamic_type (module);
	mpris_dbus_prop_iface_register_type (module);
	mpris_dbus_prop_iface_proxy_register_dynamic_type (module);
	mpris_iface_register_type (module);
	mpris_iface_proxy_register_dynamic_type (module);
	mpris_player_iface_register_type (module);
	mpris_player_iface_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_raven_plugin_get_type (), TYPE_MEDIA_CONTROLS_RAVEN_PLUGIN);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

