﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/AWSMigrationHub/model/ResourceAttribute.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MigrationHub {
namespace Model {

ResourceAttribute::ResourceAttribute(JsonView jsonValue) { *this = jsonValue; }

ResourceAttribute& ResourceAttribute::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Type")) {
    m_type = ResourceAttributeTypeMapper::GetResourceAttributeTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Value")) {
    m_value = jsonValue.GetString("Value");
    m_valueHasBeenSet = true;
  }
  return *this;
}

JsonValue ResourceAttribute::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("Type", ResourceAttributeTypeMapper::GetNameForResourceAttributeType(m_type));
  }

  if (m_valueHasBeenSet) {
    payload.WithString("Value", m_value);
  }

  return payload;
}

}  // namespace Model
}  // namespace MigrationHub
}  // namespace Aws
