// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "BackgroundProperty.h"
#include "BorderProperty.h"
#include "CornersProperty.h"
#include "IconProperty.h"
#include "LayoutProperty.h"
#include "OutlineProperty.h"
#include "ShadowProperty.h"
#include "TextProperty.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class StylePropertyPrivate;

/*!
\class Union::Properties::StyleProperty
\inmodule core
\ingroup core-properties

\brief The root property group for all elements.

This class contains all the properties that are used to style an element.

*/
class UNION_EXPORT StyleProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    StyleProperty();
    /*!
     * Copy constructor.
     */
    StyleProperty(const StyleProperty &other);
    /*!
     * Move constructor.
     */
    StyleProperty(StyleProperty &&other);
    ~StyleProperty();

    /*!
     * Copy assignment operator.
     */
    StyleProperty &operator=(const StyleProperty &other);
    /*!
     * Move assignment operator.
     */
    StyleProperty &operator=(StyleProperty &&other);

    /*!
     * Returns the value of layout.
     */
    std::optional<LayoutProperty> layout() const;
    /*!
     * Returns layout if set or a new LayoutProperty if not.
     */
    LayoutProperty layout_or_new() const;
    /*!
     * Set the value of layout.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLayout(const std::optional<LayoutProperty> &newValue);

    /*!
     * Returns the value of text.
     */
    std::optional<TextProperty> text() const;
    /*!
     * Returns text if set or a new TextProperty if not.
     */
    TextProperty text_or_new() const;
    /*!
     * Set the value of text.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setText(const std::optional<TextProperty> &newValue);

    /*!
     * Returns the value of icon.
     */
    std::optional<IconProperty> icon() const;
    /*!
     * Returns icon if set or a new IconProperty if not.
     */
    IconProperty icon_or_new() const;
    /*!
     * Set the value of icon.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setIcon(const std::optional<IconProperty> &newValue);

    /*!
     * Returns the value of background.
     */
    std::optional<BackgroundProperty> background() const;
    /*!
     * Returns background if set or a new BackgroundProperty if not.
     */
    BackgroundProperty background_or_new() const;
    /*!
     * Set the value of background.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBackground(const std::optional<BackgroundProperty> &newValue);

    /*!
     * Returns the value of border.
     */
    std::optional<BorderProperty> border() const;
    /*!
     * Returns border if set or a new BorderProperty if not.
     */
    BorderProperty border_or_new() const;
    /*!
     * Set the value of border.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBorder(const std::optional<BorderProperty> &newValue);

    /*!
     * Returns the value of outline.
     */
    std::optional<OutlineProperty> outline() const;
    /*!
     * Returns outline if set or a new OutlineProperty if not.
     */
    OutlineProperty outline_or_new() const;
    /*!
     * Set the value of outline.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setOutline(const std::optional<OutlineProperty> &newValue);

    /*!
     * Returns the value of corners.
     */
    std::optional<CornersProperty> corners() const;
    /*!
     * Returns corners if set or a new CornersProperty if not.
     */
    CornersProperty corners_or_new() const;
    /*!
     * Set the value of corners.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setCorners(const std::optional<CornersProperty> &newValue);

    /*!
     * Returns the value of shadow.
     */
    std::optional<ShadowProperty> shadow() const;
    /*!
     * Returns shadow if set or a new ShadowProperty if not.
     */
    ShadowProperty shadow_or_new() const;
    /*!
     * Set the value of shadow.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setShadow(const std::optional<ShadowProperty> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const StyleProperty &source, StyleProperty &destination);

    /*!
     * Create and return an empty StyleProperty instance.
     *
     * This will create an empty StyleProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static StyleProperty empty();

private:
    std::unique_ptr<StylePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::StyleProperty
 * Equality comparison for StyleProperty.
 */
UNION_EXPORT bool operator==(const StyleProperty &left, const StyleProperty &right);
}
}

/*!
 * \relates Union::Properties::StyleProperty
 * QDebug support for StyleProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::StyleProperty &type);