// Copyright (C) 2020 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include <Qt3DRender/private/stringtoint_p.h>
#include "gllights_p.h"

#define LIGHT_POSITION_NAME  QLatin1String(".position")
#define LIGHT_TYPE_NAME      QLatin1String(".type")
#define LIGHT_COLOR_NAME     QLatin1String(".color")
#define LIGHT_INTENSITY_NAME QLatin1String(".intensity")
#define LIGHT_DIRECTION_NAME QLatin1String(".direction")
#define LIGHT_LINEAR_ATTENUATION_NAME QLatin1String(".linearAttenuation")
#define LIGHT_QUADRATIC_ATTENUATION_NAME QLatin1String(".quadraticAttenuation")
#define LIGHT_CONSTANT_ATTENUATION_NAME QLatin1String(".constantAttenuation")
#define LIGHT_CUT_OFF_ANGLE_NAME QLatin1String(".cutOffAngle")

#define DECLARE_LIGHT_STRUCT_NAME(idx)\
    QLatin1String("lights[") + QLatin1Char(char('0' + idx)) + QLatin1Char(']')

#define DECLARE_LIGHT_POSITION_NAME(idx)\
     StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_POSITION_NAME)

#define DECLARE_LIGHT_TYPE_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_TYPE_NAME)

#define DECLARE_LIGHT_COLOR_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_COLOR_NAME)

#define DECLARE_LIGHT_INTENSITY_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_INTENSITY_NAME)

#define DECLARE_LIGHT_DIRECTION_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_DIRECTION_NAME)

#define DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_LINEAR_ATTENUATION_NAME)

#define DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_QUADRATIC_ATTENUATION_NAME)

#define DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_CONSTANT_ATTENUATION_NAME)

#define DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_NAMES[idx] + LIGHT_CUT_OFF_ANGLE_NAME)

#define DECLARE_LIGHT_STRUCT_UNROLL_NAME(idx)\
     QLatin1String("light_") + QLatin1Char(char('0' + idx))

#define DECLARE_LIGHT_POSITION_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_POSITION_NAME)

#define DECLARE_LIGHT_TYPE_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_TYPE_NAME)

#define DECLARE_LIGHT_COLOR_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_COLOR_NAME)

#define DECLARE_LIGHT_INTENSITY_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_INTENSITY_NAME)

#define DECLARE_LIGHT_DIRECTION_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_DIRECTION_NAME)

#define DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_LINEAR_ATTENUATION_NAME)

#define DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_QUADRATIC_ATTENUATION_NAME)

#define DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_CONSTANT_ATTENUATION_NAME)

#define DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(idx)\
    StringToInt::lookupId(LIGHT_STRUCT_UNROLL_NAMES[idx] + LIGHT_CUT_OFF_ANGLE_NAME)

QT_BEGIN_NAMESPACE

namespace Qt3DRender {
namespace Render {
namespace OpenGL {

int GLLights::LIGHT_COUNT_NAME_ID = StringToInt::lookupId(QLatin1String("lightCount"));

QString GLLights::LIGHT_STRUCT_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_STRUCT_NAME(0),
    DECLARE_LIGHT_STRUCT_NAME(1),
    DECLARE_LIGHT_STRUCT_NAME(2),
    DECLARE_LIGHT_STRUCT_NAME(3),
    DECLARE_LIGHT_STRUCT_NAME(4),
    DECLARE_LIGHT_STRUCT_NAME(5),
    DECLARE_LIGHT_STRUCT_NAME(6),
    DECLARE_LIGHT_STRUCT_NAME(7)
};

int GLLights::LIGHT_POSITION_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_POSITION_NAME(0),
    DECLARE_LIGHT_POSITION_NAME(1),
    DECLARE_LIGHT_POSITION_NAME(2),
    DECLARE_LIGHT_POSITION_NAME(3),
    DECLARE_LIGHT_POSITION_NAME(4),
    DECLARE_LIGHT_POSITION_NAME(5),
    DECLARE_LIGHT_POSITION_NAME(6),
    DECLARE_LIGHT_POSITION_NAME(7)
};

int GLLights::LIGHT_TYPE_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_TYPE_NAME(0),
    DECLARE_LIGHT_TYPE_NAME(1),
    DECLARE_LIGHT_TYPE_NAME(2),
    DECLARE_LIGHT_TYPE_NAME(3),
    DECLARE_LIGHT_TYPE_NAME(4),
    DECLARE_LIGHT_TYPE_NAME(5),
    DECLARE_LIGHT_TYPE_NAME(6),
    DECLARE_LIGHT_TYPE_NAME(7)
};

int GLLights::LIGHT_COLOR_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_COLOR_NAME(0),
    DECLARE_LIGHT_COLOR_NAME(1),
    DECLARE_LIGHT_COLOR_NAME(2),
    DECLARE_LIGHT_COLOR_NAME(3),
    DECLARE_LIGHT_COLOR_NAME(4),
    DECLARE_LIGHT_COLOR_NAME(5),
    DECLARE_LIGHT_COLOR_NAME(6),
    DECLARE_LIGHT_COLOR_NAME(7)
};

int GLLights::LIGHT_INTENSITY_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_INTENSITY_NAME(0),
    DECLARE_LIGHT_INTENSITY_NAME(1),
    DECLARE_LIGHT_INTENSITY_NAME(2),
    DECLARE_LIGHT_INTENSITY_NAME(3),
    DECLARE_LIGHT_INTENSITY_NAME(4),
    DECLARE_LIGHT_INTENSITY_NAME(5),
    DECLARE_LIGHT_INTENSITY_NAME(6),
    DECLARE_LIGHT_INTENSITY_NAME(7)
};

int GLLights::LIGHT_DIRECTION_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_DIRECTION_NAME(0),
    DECLARE_LIGHT_DIRECTION_NAME(1),
    DECLARE_LIGHT_DIRECTION_NAME(2),
    DECLARE_LIGHT_DIRECTION_NAME(3),
    DECLARE_LIGHT_DIRECTION_NAME(4),
    DECLARE_LIGHT_DIRECTION_NAME(5),
    DECLARE_LIGHT_DIRECTION_NAME(6),
    DECLARE_LIGHT_DIRECTION_NAME(7)
};

int GLLights::LIGHT_LINEAR_ATTENUATION_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(0),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(1),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(2),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(3),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(4),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(5),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(6),
    DECLARE_LIGHT_LINEAR_ATTENUATION_NAME(7)
};

int GLLights::LIGHT_QUADRATIC_ATTENUATION_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(0),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(1),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(2),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(3),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(4),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(5),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(6),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_NAME(7)
};

int GLLights::LIGHT_CONSTANT_ATTENUATION_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(0),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(1),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(2),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(3),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(4),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(5),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(6),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_NAME(7)
};

int GLLights::LIGHT_CUT_OFF_ANGLE_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(0),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(1),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(2),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(3),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(4),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(5),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(6),
    DECLARE_LIGHT_CUT_OFF_ANGLE_NAME(7)
};

QString GLLights::LIGHT_STRUCT_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(0),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(1),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(2),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(3),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(4),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(5),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(6),
    DECLARE_LIGHT_STRUCT_UNROLL_NAME(7)
};

int GLLights::LIGHT_POSITION_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_POSITION_UNROLL_NAME(0),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(1),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(2),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(3),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(4),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(5),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(6),
    DECLARE_LIGHT_POSITION_UNROLL_NAME(7)
};

int GLLights::LIGHT_TYPE_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_TYPE_UNROLL_NAME(0),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(1),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(2),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(3),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(4),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(5),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(6),
    DECLARE_LIGHT_TYPE_UNROLL_NAME(7)
};

int GLLights::LIGHT_COLOR_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_COLOR_UNROLL_NAME(0),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(1),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(2),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(3),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(4),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(5),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(6),
    DECLARE_LIGHT_COLOR_UNROLL_NAME(7)
};

int GLLights::LIGHT_INTENSITY_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(0),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(1),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(2),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(3),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(4),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(5),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(6),
    DECLARE_LIGHT_INTENSITY_UNROLL_NAME(7)
};

int GLLights::LIGHT_DIRECTION_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(0),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(1),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(2),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(3),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(4),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(5),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(6),
    DECLARE_LIGHT_DIRECTION_UNROLL_NAME(7)
};

int GLLights::LIGHT_LINEAR_ATTENUATION_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(0),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(1),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(2),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(3),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(4),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(5),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(6),
    DECLARE_LIGHT_LINEAR_ATTENUATION_UNROLL_NAME(7)
};

int GLLights::LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(0),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(1),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(2),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(3),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(4),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(5),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(6),
    DECLARE_LIGHT_QUADRATIC_ATTENUATION_UNROLL_NAME(7)
};

int GLLights::LIGHT_CONSTANT_ATTENUATION_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(0),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(1),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(2),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(3),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(4),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(5),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(6),
    DECLARE_LIGHT_CONSTANT_ATTENUATION_UNROLL_NAME(7)
};

int GLLights::LIGHT_CUT_OFF_ANGLE_UNROLL_NAMES[MAX_LIGHTS] = {
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(0),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(1),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(2),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(3),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(4),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(5),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(6),
    DECLARE_LIGHT_CUT_OFF_ANGLE_UNROLL_NAME(7)
};

} // namespace OpenGL
} // namespace Render
} // namespace Qt3DRender

QT_END_NAMESPACE
