/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.util.file.Matcher;

public class StandardJarScanFilter
implements JarScanFilter {
    private final ReadWriteLock configurationLock = new ReentrantReadWriteLock();
    private static final String defaultSkip;
    private static final String defaultScan;
    private static final Set<String> defaultSkipSet;
    private static final Set<String> defaultScanSet;
    private static final boolean defaultSkipAll;
    private String tldSkip = defaultSkip;
    private String tldScan;
    private final Set<String> tldSkipSet = new HashSet<String>(defaultSkipSet);
    private final Set<String> tldScanSet;
    private boolean defaultTldScan = true;
    private String pluggabilitySkip;
    private String pluggabilityScan;
    private final Set<String> pluggabilitySkipSet;
    private final Set<String> pluggabilityScanSet;
    private boolean defaultPluggabilityScan = true;

    public StandardJarScanFilter() {
        this.tldScan = defaultScan;
        this.tldScanSet = new HashSet<String>(defaultScanSet);
        this.pluggabilitySkip = defaultSkip;
        this.pluggabilitySkipSet = new HashSet<String>(defaultSkipSet);
        this.pluggabilityScan = defaultScan;
        this.pluggabilityScanSet = new HashSet<String>(defaultScanSet);
    }

    public String getTldSkip() {
        return this.tldSkip;
    }

    public void setTldSkip(String string) {
        this.tldSkip = string;
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            StandardJarScanFilter.populateSetFromAttribute(string, this.tldSkipSet);
        }
        finally {
            lock.unlock();
        }
    }

    public String getTldScan() {
        return this.tldScan;
    }

    public void setTldScan(String string) {
        this.tldScan = string;
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            StandardJarScanFilter.populateSetFromAttribute(string, this.tldScanSet);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isSkipAll() {
        return defaultSkipAll;
    }

    public boolean isDefaultTldScan() {
        return this.defaultTldScan;
    }

    public void setDefaultTldScan(boolean bl) {
        this.defaultTldScan = bl;
    }

    public String getPluggabilitySkip() {
        return this.pluggabilitySkip;
    }

    public void setPluggabilitySkip(String string) {
        this.pluggabilitySkip = string;
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            StandardJarScanFilter.populateSetFromAttribute(string, this.pluggabilitySkipSet);
        }
        finally {
            lock.unlock();
        }
    }

    public String getPluggabilityScan() {
        return this.pluggabilityScan;
    }

    public void setPluggabilityScan(String string) {
        this.pluggabilityScan = string;
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            StandardJarScanFilter.populateSetFromAttribute(string, this.pluggabilityScanSet);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isDefaultPluggabilityScan() {
        return this.defaultPluggabilityScan;
    }

    public void setDefaultPluggabilityScan(boolean bl) {
        this.defaultPluggabilityScan = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(JarScanType jarScanType, String string) {
        Lock lock = this.configurationLock.readLock();
        lock.lock();
        try {
            Set<String> set;
            Set<String> set2;
            boolean bl;
            switch (jarScanType) {
                case TLD: {
                    bl = this.defaultTldScan;
                    set2 = this.tldSkipSet;
                    set = this.tldScanSet;
                    break;
                }
                case PLUGGABILITY: {
                    bl = this.defaultPluggabilityScan;
                    set2 = this.pluggabilitySkipSet;
                    set = this.pluggabilityScanSet;
                    break;
                }
                default: {
                    bl = true;
                    set2 = defaultSkipSet;
                    set = defaultScanSet;
                }
            }
            if (bl) {
                if (Matcher.matchName(set2, (String)string)) {
                    boolean bl2 = Matcher.matchName(set, (String)string);
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            if (Matcher.matchName(set, (String)string)) {
                boolean bl4 = !Matcher.matchName(set2, (String)string);
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    private static void populateSetFromAttribute(String string, Set<String> set) {
        set.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                set.add(string2);
            }
        }
    }

    static {
        defaultSkipSet = new HashSet<String>();
        defaultScanSet = new HashSet<String>();
        defaultSkip = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip");
        StandardJarScanFilter.populateSetFromAttribute(defaultSkip, defaultSkipSet);
        defaultScan = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToScan");
        StandardJarScanFilter.populateSetFromAttribute(defaultScan, defaultScanSet);
        defaultSkipAll = (defaultSkipSet.contains("*") || defaultSkipSet.contains("*.jar")) && defaultScanSet.isEmpty();
    }
}

