/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.nlctdoc.SummaryBox;
import java.io.IOException;

public class SummaryCommandBox
extends SummaryBox {
    protected FrameBox frameBox;
    protected FrameBox rightBox;
    protected FrameBox noteBox;

    public SummaryCommandBox(FrameBox frameBox, FrameBox frameBox2, FrameBox frameBox3, GlossariesSty glossariesSty) {
        this("summaryglossentrycommand", frameBox, frameBox2, frameBox3, glossariesSty);
    }

    public SummaryCommandBox(String string, FrameBox frameBox, FrameBox frameBox2, FrameBox frameBox3, GlossariesSty glossariesSty) {
        super(string, frameBox, frameBox2, frameBox3, glossariesSty);
    }

    @Override
    public Object clone() {
        return new SummaryCommandBox(this.getName(), this.frameBox, this.rightBox, this.noteBox, this.getSty());
    }

    @Override
    protected void addPostEntryName(TeXObjectList teXObjectList, GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        TeXObject teXObject = glossaryEntry.get("syntax");
        if (teXObject != null) {
            teXObjectList.add(teXParser.getListener().getControlSequence("code"));
            Group group = teXParser.getListener().createGroup();
            teXObjectList.add(group);
            group.add(teXObject);
        }
    }

    @Override
    protected void initHook(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.putControlSequence(true, new GenericCommand(true, "explTFsuffix", null, TeXParserUtils.createStack(teXParser, new TeXCsRef("@explboolsyntaxfmt"), teXParser.getListener().createGroup("TF"))));
    }

    @Override
    protected void preNote(TeXObjectList teXObjectList, GlsLabel glsLabel, TeXParser teXParser) throws IOException {
        TeXObject teXObject;
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry != null && (teXObject = glossaryEntry.get("explsuffix")) != null && !teXObject.isEmpty()) {
            Group group = teXParser.getListener().createGroup();
            teXObjectList.add(group);
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("explsuffix"));
            group.add(teXParser.getListener().createGroup(teXParser.expandToString(teXObject, teXParser)));
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("explTFsuffix"));
            group.add(teXParser.getListener().createGroup());
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("TFsuffix"));
            group.add(teXParser.getListener().createGroup());
            group.add(teXParser.getListener().getControlSequence("newline"));
            group.add(teXParser.getListener().getControlSequence("code"));
            group.add(TeXParserUtils.createGroup(teXParser, glossaryEntry.get("name"), glossaryEntry.get("syntax")));
        }
    }
}

