/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.ExperimentalApi;
import io.grpc.ServerCall;
import io.grpc.alts.AltsContext;
import io.grpc.alts.internal.AltsInternalContext;
import io.grpc.alts.internal.AltsProtocolNegotiator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7864")
public final class AltsContextUtil {
    private AltsContextUtil() {
    }

    public static AltsContext createFrom(ServerCall<?, ?> call) {
        Object authContext = call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        if (!(authContext instanceof AltsInternalContext)) {
            throw new IllegalArgumentException("No ALTS context information found");
        }
        return new AltsContext((AltsInternalContext)authContext);
    }

    public static boolean check(ServerCall<?, ?> call) {
        Object authContext = call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        return authContext instanceof AltsInternalContext;
    }
}

