/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

final class NumberConversion {
    private static final double MAX_SAFE_INTEGER = Math.pow(2.0, 53.0) - 1.0;
    private static final double MIN_SAFE_INTEGER = -MAX_SAFE_INTEGER;
    private static final long MAX_SAFE_INTEGER_LONG = (long)Math.pow(2.0, 53.0) - 1L;
    private static final long MIN_SAFE_INTEGER_LONG = (long)MIN_SAFE_INTEGER;
    private static final String DIGIT_PAIRS;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final long[] LONG_LENGTH_TABLE;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final long[] INT_LENGTH_TABLE;

    private NumberConversion() {
    }

    static int parseInt(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, int radix, InlinedBranchProfile errorProfile, TruffleStringIterator.InternalNextNode nextNode) throws TruffleString.NumberFormatException {
        return (int)NumberConversion.parseNum(node, it, encoding, radix, errorProfile, Integer.MIN_VALUE, Integer.MAX_VALUE, nextNode);
    }

    static long parseLong(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, int radix, InlinedBranchProfile errorProfile, TruffleStringIterator.InternalNextNode nextNode) throws TruffleString.NumberFormatException {
        return NumberConversion.parseNum(node, it, encoding, radix, errorProfile, Long.MIN_VALUE, Long.MAX_VALUE, nextNode);
    }

    static int parseInt7Bit(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int stride, int radix, InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
        return (int)NumberConversion.parseNum7Bit(node, a, arrayA, offsetA, stride, radix, errorProfile, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    static long parseLong7Bit(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int stride, int radix, InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
        return NumberConversion.parseNum7Bit(node, a, arrayA, offsetA, stride, radix, errorProfile, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    static boolean isSafeInteger(long value) {
        return MIN_SAFE_INTEGER_LONG <= value && value <= MAX_SAFE_INTEGER_LONG;
    }

    private static long parseNum(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, int radix, InlinedBranchProfile errorProfile, long min, long max, TruffleStringIterator.InternalNextNode nextNode) throws TruffleString.NumberFormatException {
        NumberConversion.checkArgs(node, it, radix, errorProfile);
        long result = 0L;
        boolean negative = false;
        long limit = -max;
        if (it.hasNext()) {
            int firstChar = nextNode.execute(node, it, encoding);
            if (firstChar < 48) {
                if (firstChar == 45) {
                    negative = true;
                    limit = min;
                } else if (firstChar != 43) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.INVALID_CODEPOINT);
                }
                if (!it.hasNext()) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.LONE_SIGN);
                }
            } else {
                int digit = Character.digit(firstChar, radix);
                if (digit < 0) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.INVALID_CODEPOINT);
                }
                assert (result >= limit + (long)digit);
                result -= (long)digit;
            }
            long multmin = limit / (long)radix;
            while (it.hasNext()) {
                int digit = Character.digit(nextNode.execute(node, it, encoding), radix);
                if (digit < 0) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.INVALID_CODEPOINT);
                }
                if (result < multmin) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.OVERFLOW);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    errorProfile.enter(node);
                    throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.OVERFLOW);
                }
                result -= (long)digit;
            }
        } else {
            errorProfile.enter(node);
            throw NumberConversion.numberFormatException(it, TruffleString.NumberFormatException.Reason.EMPTY);
        }
        return negative ? result : -result;
    }

    private static long parseNum7Bit(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int stride, int radix, InlinedBranchProfile errorProfile, long min, long max) throws TruffleString.NumberFormatException {
        CompilerAsserts.partialEvaluationConstant(stride);
        assert (TStringGuards.is7Bit(a.codeRange()));
        NumberConversion.checkRadix(node, a, radix, errorProfile);
        NumberConversion.checkEmptyStr(node, a, errorProfile);
        long result = 0L;
        boolean negative = false;
        long limit = -max;
        int i = 0;
        int firstChar = TStringOps.readValue(a, arrayA, offsetA, stride, i);
        if (firstChar < 48) {
            if (firstChar == 45) {
                negative = true;
                limit = min;
            } else if (firstChar != 43) {
                errorProfile.enter(node);
                throw NumberConversion.numberFormatException(a, i, TruffleString.NumberFormatException.Reason.INVALID_CODEPOINT);
            }
            if (a.length() == 1) {
                errorProfile.enter(node);
                throw NumberConversion.numberFormatException(a, i, TruffleString.NumberFormatException.Reason.LONE_SIGN);
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        while (i < a.length()) {
            int c = TStringOps.readValue(a, arrayA, offsetA, stride, i++);
            int digit = NumberConversion.parseDigit7Bit(node, a, i, radix, errorProfile, c);
            if (result < multmin) {
                errorProfile.enter(node);
                throw NumberConversion.numberFormatException(a, i, TruffleString.NumberFormatException.Reason.OVERFLOW);
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                errorProfile.enter(node);
                throw NumberConversion.numberFormatException(a, i, TruffleString.NumberFormatException.Reason.OVERFLOW);
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    private static int parseDigit7Bit(Node node, AbstractTruffleString a, int i, int radix, InlinedBranchProfile errorProfile, int c) throws TruffleString.NumberFormatException {
        int lc;
        if (48 <= c && c <= Math.min(radix - 1 + 48, 57)) {
            return c & 0xF;
        }
        if (radix > 10 && 97 <= (lc = c | 0x20) && lc <= radix - 11 + 97) {
            return lc - 87;
        }
        errorProfile.enter(node);
        throw NumberConversion.numberFormatException(a, i, TruffleString.NumberFormatException.Reason.INVALID_CODEPOINT);
    }

    private static void checkArgs(Node node, TruffleStringIterator it, int radix, InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
        assert (it != null);
        NumberConversion.checkRadix(node, it.a, radix, errorProfile);
    }

    private static void checkRadix(Node node, AbstractTruffleString a, int radix, InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
        if (radix < 2 || radix > 36) {
            errorProfile.enter(node);
            throw NumberConversion.numberFormatException(a, TruffleString.NumberFormatException.Reason.UNSUPPORTED_RADIX);
        }
    }

    private static void checkEmptyStr(Node node, AbstractTruffleString a, InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
        if (a.isEmpty()) {
            errorProfile.enter(node);
            throw NumberConversion.numberFormatException(a, TruffleString.NumberFormatException.Reason.EMPTY);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString.NumberFormatException numberFormatException(AbstractTruffleString a, TruffleString.NumberFormatException.Reason msg) {
        return new TruffleString.NumberFormatException(a, msg);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString.NumberFormatException numberFormatException(TruffleStringIterator it, TruffleString.NumberFormatException.Reason msg) {
        return new TruffleString.NumberFormatException(it.a, it.getRawIndex(), 1, msg);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString.NumberFormatException numberFormatException(AbstractTruffleString a, int regionOffset, TruffleString.NumberFormatException.Reason msg) {
        return new TruffleString.NumberFormatException(a, regionOffset, 1, msg);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString.NumberFormatException numberFormatException(AbstractTruffleString a, int regionOffset, int regionLength, TruffleString.NumberFormatException.Reason msg) {
        return new TruffleString.NumberFormatException(a, regionOffset, regionLength, msg);
    }

    @HostCompilerDirectives.InliningCutoff
    static byte[] longToString(long i, int length) {
        byte[] buf = new byte[length];
        NumberConversion.writeLongToBytesIntl(i, length, buf, 0);
        return buf;
    }

    private static int floorLog2(long n) {
        assert (n >= 0L || n == Long.MIN_VALUE) : n;
        return 0x3F ^ Long.numberOfLeadingZeros(n | 1L);
    }

    static int stringLengthInt(long intValue) {
        int sign;
        assert (Integer.MIN_VALUE <= intValue && intValue <= Integer.MAX_VALUE);
        long n = intValue;
        if (CompilerDirectives.injectBranchProbability(0.25, n < 0L)) {
            sign = 1;
            n = -n;
        } else {
            sign = 0;
        }
        int digits = (int)(n + INT_LENGTH_TABLE[NumberConversion.floorLog2(n)] >>> 32);
        return sign + digits;
    }

    static int stringLengthLong(long longValue) {
        int sign;
        long n = longValue;
        if (CompilerDirectives.injectBranchProbability(0.25, n < 0L)) {
            sign = 1;
            n = -n;
        } else {
            sign = 0;
        }
        int bits = NumberConversion.floorLog2(n);
        int digits = (int)(LONG_LENGTH_TABLE[bits] + (n >> (bits >> 2)) >> 52);
        return sign + digits;
    }

    static void writeLongToBytes(long i, byte[] buf, int stride, int fromIndex, int length) {
        NumberConversion.writeLongToBytesIntl(i, fromIndex + length, buf, stride);
    }

    private static void writeLongToBytesIntl(long value, int index, byte[] buf, int stride) {
        int r;
        boolean negative;
        long i = value;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        int bytePos = index;
        while (i < Integer.MIN_VALUE) {
            long q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            NumberConversion.writeDigitPairToByteArray(buf, stride, bytePos -= 2, r);
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q = i2 / 100;
            r = q * 100 - i2;
            i2 = q;
            NumberConversion.writeDigitPairToByteArray(buf, stride, bytePos -= 2, r);
        }
        if (i2 < -9) {
            r = -i2;
            NumberConversion.writeDigitPairToByteArray(buf, stride, bytePos -= 2, r);
        } else {
            r = 48 - i2;
            TStringOps.writeToByteArray(buf, stride, --bytePos, r);
        }
        if (negative) {
            TStringOps.writeToByteArray(buf, stride, --bytePos, 45);
        }
    }

    static void writeIntToBytes(int i, byte[] buf, int stride, int fromIndex, int length) {
        NumberConversion.writeIntToBytesIntl(i, fromIndex + length, buf, stride);
    }

    private static void writeIntToBytesIntl(int value, int index, byte[] buf, int stride) {
        boolean negative;
        int i = value;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        int bytePos = index;
        while (i <= -100) {
            int q = i / 100;
            int r = q * 100 - i;
            i = q;
            NumberConversion.writeDigitPairToByteArray(buf, stride, bytePos -= 2, r);
        }
        if (i < -9) {
            int r = -i;
            NumberConversion.writeDigitPairToByteArray(buf, stride, bytePos -= 2, r);
        } else {
            TStringOps.writeToByteArray(buf, stride, --bytePos, 48 - i);
        }
        if (negative) {
            TStringOps.writeToByteArray(buf, stride, --bytePos, 45);
        }
    }

    private static char digitPair(int i) {
        assert (0 <= i && i <= 99) : i;
        return DIGIT_PAIRS.charAt(i);
    }

    private static int digitPairHi(char digitPair) {
        return digitPair & 0xFF;
    }

    private static int digitPairLo(char digitPair) {
        return digitPair >>> 8;
    }

    private static void writeDigitPairToByteArray(byte[] buf, int stride, int bufPos, int r) {
        char digitPair = NumberConversion.digitPair(r);
        TStringOps.writeToByteArray(buf, stride, bufPos, NumberConversion.digitPairHi(digitPair));
        TStringOps.writeToByteArray(buf, stride, bufPos + 1, NumberConversion.digitPairLo(digitPair));
    }

    static int computeLongStringHashCode(long value) {
        char digitPair;
        int r;
        boolean negative;
        long i = value;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        int hash = 0;
        int coef = 1;
        while (i < Integer.MIN_VALUE) {
            long q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            digitPair = NumberConversion.digitPair(r);
            hash += coef * NumberConversion.digitPairLo(digitPair);
            hash += (coef *= 31) * NumberConversion.digitPairHi(digitPair);
            coef *= 31;
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q = i2 / 100;
            r = q * 100 - i2;
            i2 = q;
            digitPair = NumberConversion.digitPair(r);
            hash += coef * NumberConversion.digitPairLo(digitPair);
            hash += (coef *= 31) * NumberConversion.digitPairHi(digitPair);
            coef *= 31;
        }
        if (i2 < -9) {
            int r2 = -i2;
            char digitPair2 = NumberConversion.digitPair(r2);
            hash += coef * NumberConversion.digitPairLo(digitPair2);
            hash += (coef *= 31) * NumberConversion.digitPairHi(digitPair2);
            coef *= 31;
        } else {
            hash += coef * (48 - i2);
            coef *= 31;
        }
        if (negative) {
            hash += coef * 45;
        }
        assert (hash == Long.toString(value).hashCode()) : value;
        return hash;
    }

    static {
        char[] digits = new char[100];
        for (int i = 0; i < 10; ++i) {
            char hi = (char)(i + 48);
            for (int j = 0; j < 10; ++j) {
                char lo = (char)(j + 48 << 8);
                digits[i * 10 + j] = (char)(hi | lo);
            }
        }
        DIGIT_PAIRS = new String(digits);
        LONG_LENGTH_TABLE = new long[]{0x1FFFFFFFFFFFF6L, 0x1FFFFFFFFFFFF6L, 0x1FFFFFFFFFFFF6L, 0x1FFFFFFFFFFFF6L, 13510798882111438L, 13510798882111438L, 13510798882111438L, 18014398509481484L, 18014398509481734L, 18014398509481734L, 22517998136849980L, 22517998136849980L, 22517998136851230L, 22517998136851230L, 27021597764210476L, 27021597764210476L, 27021597764216726L, 31525197391530972L, 31525197391530972L, 31525197391530972L, 36028797018651468L, 36028797018651468L, 36028797018651468L, 36028797018651468L, 40532396644771964L, 40532396644771964L, 40532396644771964L, 45035996258079960L, 45035996265892460L, 45035996265892460L, 49539595822950456L, 49539595822950456L, 49539595862012956L, 49539595862012956L, 54043195137820952L, 54043195137820952L, 54043195333133452L, 58546793202691448L, 58546793202691448L, 58546793202691448L, 63050385017561944L, 63050385017561944L, 63050385017561944L, 63050385017561944L, 67553945582432440L, 67553945582432440L, 67553945582432440L, 72057105756677936L, 72057349897302936L, 72057349897302936L, 76558752259048432L, 76558752259048432L, 76559972962173432L, 76559972962173432L, 81052586261418928L, 81052586261418928L, 81058689777043928L, 85507357763789424L, 85507357763789424L, 85507357763789424L, 89766816766159920L, 89766816766159920L, 89766816766159920L, 89766816766159920L};
        INT_LENGTH_TABLE = new long[]{0x100000000L, 0x1FFFFFFF6L, 0x1FFFFFFF6L, 0x1FFFFFFF6L, 12884901788L, 12884901788L, 12884901788L, 17179868184L, 17179868184L, 17179868184L, 21474826480L, 21474826480L, 21474826480L, 21474826480L, 25769703776L, 25769703776L, 25769703776L, 30063771072L, 30063771072L, 30063771072L, 34349738368L, 34349738368L, 34349738368L, 34349738368L, 38554705664L, 38554705664L, 38554705664L, 41949672960L, 41949672960L, 41949672960L, 0xA00000000L, 0xA00000000L};
    }
}

