/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=InteropLibrary.class)
public final class PTuple
extends PSequence {
    private SequenceStorage store;
    private long hash = -1L;

    public PTuple(Object cls, Shape instanceShape, Object[] elements) {
        super(PythonUtils.builtinClassToType(cls), instanceShape);
        this.store = new ObjectSequenceStorage(elements);
    }

    public PTuple(Object cls, Shape instanceShape, SequenceStorage store) {
        super(PythonUtils.builtinClassToType(cls), instanceShape);
        this.store = store;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("tuple(%s)", this.store);
    }

    @Override
    public SequenceStorage getSequenceStorage() {
        return this.store;
    }

    @Override
    public void setSequenceStorage(SequenceStorage store) {
        assert (!(this.store instanceof MroSequenceStorage)) : "attempting to replace MroSequenceStorage";
        this.store = store;
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }

    @ExportMessage
    public static boolean isArrayElementModifiable(PTuple self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementInsertable(PTuple self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementRemovable(PTuple self, long index) {
        return false;
    }

    @ExportMessage
    public static void writeArrayElement(PTuple self, long key, Object value) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static void removeArrayElement(PTuple self, long key) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }
}

