/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FbInflaterInputStream
extends InflaterInputStream
implements EncryptedStreamSupport {
    private static final Logger log = LoggerFactory.getLogger(FbInflaterInputStream.class);
    private boolean encrypted;

    public FbInflaterInputStream(InputStream in) {
        super(in, new Inflater());
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("FbInflaterInputStream: Compressed bytes: %d to uncompressed bytes: %d", (Object)this.inf.getBytesRead(), (Object)this.inf.getBytesWritten());
            }
            this.inf.end();
        }
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Input stream already encrypted");
        }
        this.in = new CipherInputStream(this.in, cipher);
        this.encrypted = true;
    }
}

