/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.core.nio.fs.FileSystemTracingListener;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import com.intellij.platform.eel.impl.fs.telemetry.Measurer;
import com.intellij.platform.eel.impl.fs.telemetry.TracingDirectoryStream;
import com.intellij.platform.eel.impl.fs.telemetry.TracingSeekableByteChannel;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.time.Instant;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u0000 T2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003RSTB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J9\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001b0\u001a\"\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJC\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0\u001a\"\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"JA\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000e2\u001e\u0010%\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010&0\u001a\"\b\u0012\u0002\b\u0003\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J&\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\u000e2\b\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016JK\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u001e\u0010%\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010&0\u001a\"\b\u0012\u0002\b\u0003\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010,J\u001c\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0016JK\u0010/\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0010\u00100\u001a\f\u0012\u0006\b\u0001\u0012\u000202\u0018\u0001012\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001030\u001a\"\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\u001c\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u00106\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0016J&\u00107\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016JC\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0\u001a\"\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"JU\u00109\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0012\u0010 \u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010;\u0018\u00010:2\u001e\u0010%\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010&0\u001a\"\b\u0012\u0002\b\u0003\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010<J\u001e\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\u00022\b\u0010@\u001a\u0004\u0018\u00010>H\u0016J0\u0010A\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000e2\u0012\u0010B\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u000e\u0018\u00010CH\u0016J*\u0010D\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010E2\b\u0010?\u001a\u0004\u0018\u00010\u00022\u000e\u0010@\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010EH\u0016JK\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0010\u00100\u001a\f\u0012\u0006\b\u0001\u0012\u00020G\u0018\u0001012\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001030\u001a\"\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104JC\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010H\u001a\u0004\u0018\u00010\t2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001030\u001a\"\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010IJ\u001c\u0010J\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0016JM\u0010K\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010L\u001a\u0004\u0018\u00010\t2\b\u0010M\u001a\u0004\u0018\u00010N2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001030\u001a\"\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010OJ\u0012\u0010P\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010Q\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener;", "Lcom/intellij/platform/core/nio/fs/FileSystemTracingListener;", "Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "<init>", "()V", "openOperations", "Ljava/lang/ThreadLocal;", "Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$State;", "spanNamePrefixWithFileSystemClass", "", "delegate", "Ljava/nio/file/spi/FileSystemProvider;", "opStarted", "path1", "Ljava/nio/file/Path;", "path2", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "opFinished", "", "spanEntry", "err", "", "providerCheckAccessStarted", "path", "modes", "", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerCopyStarted", "source", "target", "options", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerCreateDirectoryStarted", "dir", "attrs", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerCreateLinkStarted", "link", "existing", "providerCreateSymbolicLinkStarted", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerDeleteStarted", "providerDeleteIfExistsStarted", "providerGetFileAttributeViewStarted", "type", "Ljava/lang/Class;", "Ljava/nio/file/attribute/FileAttributeView;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerGetFileStoreStarted", "providerIsHiddenStarted", "providerIsSameFileStarted", "providerMoveStarted", "providerNewByteChannelStarted", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerNewByteChannelReturn", "Ljava/nio/channels/SeekableByteChannel;", "token", "result", "providerNewDirectoryStreamStarted", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "providerNewDirectoryStreamReturn", "Ljava/nio/file/DirectoryStream;", "providerReadAttributesStarted", "Ljava/nio/file/attribute/BasicFileAttributes;", "attributes", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerReadSymbolicLinkStarted", "providerSetAttributeStarted", "attribute", "value", "", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "providerGenericReturn", "providerGenericError", "State", "SpanEntry", "Companion", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nMeasuringFileSystemListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasuringFileSystemListener.kt\ncom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,165:1\n1#2:166\n13#3:167\n*S KotlinDebug\n*F\n+ 1 MeasuringFileSystemListener.kt\ncom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener\n*L\n75#1:167\n*E\n"})
public final class MeasuringFileSystemListener
implements FileSystemTracingListener<SpanEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadLocal<State> openOperations;
    @NotNull
    private static final Logger LOG;

    public MeasuringFileSystemListener() {
        TuplesKt.to((Object)TuplesKt.to((Object)TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Measurer.Operation.class), (Object)Measurer.INSTANCE), (Object)Reflection.getOrCreateKotlinClass(TracingSeekableByteChannel.class)), (Object)Reflection.getOrCreateKotlinClass(TracingDirectoryStream.class));
        ThreadLocal<State> threadLocal = ThreadLocal.withInitial(MeasuringFileSystemListener::openOperations$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        this.openOperations = threadLocal;
    }

    @NotNull
    public final String spanNamePrefixWithFileSystemClass(@NotNull FileSystemProvider delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return Measurer.DelegateType.Companion.fromDelegateClass(delegate.getClass()).toString();
    }

    @Nullable
    public final SpanEntry opStarted(@NotNull FileSystemProvider delegate, @Nullable Path path1, @Nullable Path path2, @NotNull Measurer.Operation operation) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        if (this.openOperations.get().getRecursionFlag()) {
            return null;
        }
        this.openOperations.get().setRecursionFlag(true);
        Span span = Measurer.INSTANCE.getIjentTracer$intellij_platform_eel_impl().spanBuilder(this.spanNamePrefixWithFileSystemClass(delegate) + "." + operation.name(), TracerLevel.DETAILED).startSpan();
        Measurer.INSTANCE.getEventsCounter$intellij_platform_eel_impl().incrementAndGet();
        Intrinsics.checkNotNull((Object)span);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        SpanEntry spanEntry = new SpanEntry(span, operation, delegate, path1, path2, instant);
        this.openOperations.get().setRecursionFlag(false);
        return spanEntry;
    }

    public final void opFinished(@NotNull SpanEntry spanEntry, @Nullable Throwable err) {
        Intrinsics.checkNotNullParameter((Object)spanEntry, (String)"spanEntry");
        boolean unexpectedException = false;
        if (err != null) {
            spanEntry.getSpan().setStatus(StatusCode.ERROR);
            if (!(err instanceof IOException)) {
                LOG.debug("nio method threw unexpected exception", err);
                unexpectedException = true;
            }
        }
        spanEntry.getSpan().end();
        Instant endTime = Instant.now();
        FileSystemProvider fileSystemProvider = spanEntry.getDelegate();
        Path path = spanEntry.getPath1();
        Path path2 = spanEntry.getPath2();
        Measurer.Operation operation = spanEntry.getOperation();
        Instant instant = spanEntry.getStartTime();
        Intrinsics.checkNotNull((Object)endTime);
        Measurer.INSTANCE.reportFsEvent(fileSystemProvider, path, path2, operation, instant, endTime, err == null);
    }

    @Nullable
    public SpanEntry providerCheckAccessStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerCheckAccess);
    }

    @Nullable
    public SpanEntry providerCopyStarted(@NotNull FileSystemProvider delegate, @Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, source, target, Measurer.Operation.providerCopy);
    }

    @Nullable
    public SpanEntry providerCreateDirectoryStarted(@NotNull FileSystemProvider delegate, @Nullable Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        return this.opStarted(delegate, dir, null, Measurer.Operation.providerCreateDirectory);
    }

    @Nullable
    public SpanEntry providerCreateLinkStarted(@NotNull FileSystemProvider delegate, @Nullable Path link, @Nullable Path existing) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, link, existing, Measurer.Operation.providerCreateLink);
    }

    @Nullable
    public SpanEntry providerCreateSymbolicLinkStarted(@NotNull FileSystemProvider delegate, @Nullable Path link, @Nullable Path target, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        return this.opStarted(delegate, link, target, Measurer.Operation.providerCreateSymbolicLink);
    }

    @Nullable
    public SpanEntry providerDeleteStarted(@NotNull FileSystemProvider delegate, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerDelete);
    }

    @Nullable
    public SpanEntry providerDeleteIfExistsStarted(@NotNull FileSystemProvider delegate, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerDeleteIfExists);
    }

    @Nullable
    public SpanEntry providerGetFileAttributeViewStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable Class<? extends FileAttributeView> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerGetFileAttributeView);
    }

    @Nullable
    public SpanEntry providerGetFileStoreStarted(@NotNull FileSystemProvider delegate, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerGetFileStore);
    }

    @Nullable
    public SpanEntry providerIsHiddenStarted(@NotNull FileSystemProvider delegate, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerIsHidden);
    }

    @Nullable
    public SpanEntry providerIsSameFileStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable Path path2) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, path, path2, Measurer.Operation.providerIsSameFile);
    }

    @Nullable
    public SpanEntry providerMoveStarted(@NotNull FileSystemProvider delegate, @Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, source, target, Measurer.Operation.providerMove);
    }

    @Nullable
    public SpanEntry providerNewByteChannelStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Path path2 = path;
        if (Intrinsics.areEqual((Object)(path2 != null ? PathsKt.getExtension((Path)path2) : null), (Object)"class")) {
            return null;
        }
        return this.opStarted(delegate, path, null, Measurer.Operation.providerNewByteChannel);
    }

    @Nullable
    public SeekableByteChannel providerNewByteChannelReturn(@Nullable SpanEntry token, @Nullable SeekableByteChannel result2) {
        if (token != null) {
            TracingSeekableByteChannel tracingSeekableByteChannel;
            this.opFinished(token, null);
            SeekableByteChannel seekableByteChannel = result2;
            if (seekableByteChannel != null) {
                SeekableByteChannel it = seekableByteChannel;
                boolean bl = false;
                tracingSeekableByteChannel = new TracingSeekableByteChannel(it, this.spanNamePrefixWithFileSystemClass(token.getDelegate()));
            } else {
                tracingSeekableByteChannel = null;
            }
            return tracingSeekableByteChannel;
        }
        return result2;
    }

    @Nullable
    public SpanEntry providerNewDirectoryStreamStarted(@NotNull FileSystemProvider delegate, @Nullable Path dir, @Nullable DirectoryStream.Filter<? super Path> filter) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, dir, null, Measurer.Operation.providerNewDirectoryStream);
    }

    @Nullable
    public DirectoryStream<Path> providerNewDirectoryStreamReturn(@Nullable SpanEntry token, @Nullable DirectoryStream<Path> result2) {
        if (token != null) {
            TracingDirectoryStream<Path> tracingDirectoryStream;
            this.opFinished(token, null);
            DirectoryStream<Path> directoryStream = result2;
            if (directoryStream != null) {
                DirectoryStream<Path> it = directoryStream;
                boolean bl = false;
                tracingDirectoryStream = new TracingDirectoryStream<Path>(it, this.spanNamePrefixWithFileSystemClass(token.getDelegate()));
            } else {
                tracingDirectoryStream = null;
            }
            return tracingDirectoryStream;
        }
        return result2;
    }

    @Nullable
    public SpanEntry providerReadAttributesStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable Class<? extends BasicFileAttributes> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerReadAttributes);
    }

    @Nullable
    public SpanEntry providerReadAttributesStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable String attributes, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerReadAttributes);
    }

    @Nullable
    public SpanEntry providerReadSymbolicLinkStarted(@NotNull FileSystemProvider delegate, @Nullable Path link) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return this.opStarted(delegate, link, null, Measurer.Operation.providerReadSymbolicLink);
    }

    @Nullable
    public SpanEntry providerSetAttributeStarted(@NotNull FileSystemProvider delegate, @Nullable Path path, @Nullable String attribute, @Nullable Object value, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.opStarted(delegate, path, null, Measurer.Operation.providerSetAttribute);
    }

    public void providerGenericReturn(@Nullable SpanEntry token) {
        if (token != null) {
            this.opFinished(token, null);
        }
    }

    public void providerGenericError(@Nullable SpanEntry token, @Nullable Throwable err) {
        if (token != null) {
            this.opFinished(token, err);
        }
    }

    private static final State openOperations$lambda$0() {
        return new State();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MeasuringFileSystemListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.eel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00c6\u0003JI\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$SpanEntry;", "", "span", "Lio/opentelemetry/api/trace/Span;", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "delegate", "Ljava/nio/file/spi/FileSystemProvider;", "path1", "Ljava/nio/file/Path;", "path2", "startTime", "Ljava/time/Instant;", "<init>", "(Lio/opentelemetry/api/trace/Span;Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/time/Instant;)V", "getSpan", "()Lio/opentelemetry/api/trace/Span;", "getOperation", "()Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "getDelegate", "()Ljava/nio/file/spi/FileSystemProvider;", "getPath1", "()Ljava/nio/file/Path;", "getPath2", "getStartTime", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.eel.impl"})
    public static final class SpanEntry {
        @NotNull
        private final Span span;
        @NotNull
        private final Measurer.Operation operation;
        @NotNull
        private final FileSystemProvider delegate;
        @Nullable
        private final Path path1;
        @Nullable
        private final Path path2;
        @NotNull
        private final Instant startTime;

        public SpanEntry(@NotNull Span span, @NotNull Measurer.Operation operation, @NotNull FileSystemProvider delegate, @Nullable Path path1, @Nullable Path path2, @NotNull Instant startTime) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            this.span = span;
            this.operation = operation;
            this.delegate = delegate;
            this.path1 = path1;
            this.path2 = path2;
            this.startTime = startTime;
        }

        @NotNull
        public final Span getSpan() {
            return this.span;
        }

        @NotNull
        public final Measurer.Operation getOperation() {
            return this.operation;
        }

        @NotNull
        public final FileSystemProvider getDelegate() {
            return this.delegate;
        }

        @Nullable
        public final Path getPath1() {
            return this.path1;
        }

        @Nullable
        public final Path getPath2() {
            return this.path2;
        }

        @NotNull
        public final Instant getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final Span component1() {
            return this.span;
        }

        @NotNull
        public final Measurer.Operation component2() {
            return this.operation;
        }

        @NotNull
        public final FileSystemProvider component3() {
            return this.delegate;
        }

        @Nullable
        public final Path component4() {
            return this.path1;
        }

        @Nullable
        public final Path component5() {
            return this.path2;
        }

        @NotNull
        public final Instant component6() {
            return this.startTime;
        }

        @NotNull
        public final SpanEntry copy(@NotNull Span span, @NotNull Measurer.Operation operation, @NotNull FileSystemProvider delegate, @Nullable Path path1, @Nullable Path path2, @NotNull Instant startTime) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            return new SpanEntry(span, operation, delegate, path1, path2, startTime);
        }

        public static /* synthetic */ SpanEntry copy$default(SpanEntry spanEntry, Span span, Measurer.Operation operation, FileSystemProvider fileSystemProvider, Path path, Path path2, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                span = spanEntry.span;
            }
            if ((n & 2) != 0) {
                operation = spanEntry.operation;
            }
            if ((n & 4) != 0) {
                fileSystemProvider = spanEntry.delegate;
            }
            if ((n & 8) != 0) {
                path = spanEntry.path1;
            }
            if ((n & 0x10) != 0) {
                path2 = spanEntry.path2;
            }
            if ((n & 0x20) != 0) {
                instant = spanEntry.startTime;
            }
            return spanEntry.copy(span, operation, fileSystemProvider, path, path2, instant);
        }

        @NotNull
        public String toString() {
            return "SpanEntry(span=" + this.span + ", operation=" + this.operation + ", delegate=" + this.delegate + ", path1=" + this.path1 + ", path2=" + this.path2 + ", startTime=" + this.startTime + ")";
        }

        public int hashCode() {
            int result2 = this.span.hashCode();
            result2 = result2 * 31 + this.operation.hashCode();
            result2 = result2 * 31 + this.delegate.hashCode();
            result2 = result2 * 31 + (this.path1 == null ? 0 : ((Object)this.path1).hashCode());
            result2 = result2 * 31 + (this.path2 == null ? 0 : ((Object)this.path2).hashCode());
            result2 = result2 * 31 + this.startTime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpanEntry)) {
                return false;
            }
            SpanEntry spanEntry = (SpanEntry)other;
            if (!Intrinsics.areEqual((Object)this.span, (Object)spanEntry.span)) {
                return false;
            }
            if (this.operation != spanEntry.operation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.delegate, (Object)spanEntry.delegate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path1, (Object)spanEntry.path1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path2, (Object)spanEntry.path2)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.startTime, (Object)spanEntry.startTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/MeasuringFileSystemListener$State;", "", "<init>", "()V", "recursionFlag", "", "getRecursionFlag", "()Z", "setRecursionFlag", "(Z)V", "intellij.platform.eel.impl"})
    private static final class State {
        private boolean recursionFlag;

        public final boolean getRecursionFlag() {
            return this.recursionFlag;
        }

        public final void setRecursionFlag(boolean bl) {
            this.recursionFlag = bl;
        }
    }
}

