/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthItem;

public class ResolveAuthActionsInput {
    private final String tableName;
    private final List<AuthItem> authActions;
    private final ByteBuffer headerBytes;

    protected ResolveAuthActionsInput(BuilderImpl builder) {
        this.tableName = builder.tableName();
        this.authActions = builder.authActions();
        this.headerBytes = builder.headerBytes();
    }

    public String tableName() {
        return this.tableName;
    }

    public List<AuthItem> authActions() {
        return this.authActions;
    }

    public ByteBuffer headerBytes() {
        return this.headerBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String tableName;
        protected List<AuthItem> authActions;
        protected ByteBuffer headerBytes;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ResolveAuthActionsInput model) {
            this.tableName = model.tableName();
            this.authActions = model.authActions();
            this.headerBytes = model.headerBytes();
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public Builder authActions(List<AuthItem> authActions) {
            this.authActions = authActions;
            return this;
        }

        @Override
        public List<AuthItem> authActions() {
            return this.authActions;
        }

        @Override
        public Builder headerBytes(ByteBuffer headerBytes) {
            this.headerBytes = headerBytes;
            return this;
        }

        @Override
        public ByteBuffer headerBytes() {
            return this.headerBytes;
        }

        @Override
        public ResolveAuthActionsInput build() {
            if (Objects.isNull(this.tableName())) {
                throw new IllegalArgumentException("Missing value for required field `tableName`");
            }
            if (Objects.isNull(this.authActions())) {
                throw new IllegalArgumentException("Missing value for required field `authActions`");
            }
            if (Objects.isNull(this.headerBytes())) {
                throw new IllegalArgumentException("Missing value for required field `headerBytes`");
            }
            return new ResolveAuthActionsInput(this);
        }
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public String tableName();

        public Builder authActions(List<AuthItem> var1);

        public List<AuthItem> authActions();

        public Builder headerBytes(ByteBuffer var1);

        public ByteBuffer headerBytes();

        public ResolveAuthActionsInput build();
    }
}

