# Folder Purpose
This folder is primarily used to hold documentation for Metasploit's various modules, as well as the developers guide
at `developers_guide.pdf`.

# Metasploit Developer Documentation

Metasploit is actively supported by a community of hundreds of
contributors and thousands of users world-wide. As a result, the
accompanying documentation moves quite quickly.

The best source of documentation on Metasploit development is
https://docs.metasploit.com/. There are many
treasures there, such as:

  * [Evading Antivirus](https://docs.metasploit.com/docs/using-metasploit/intermediate/evading-anti-virus.html)
  * [How Payloads Work](https://docs.metasploit.com/docs/using-metasploit/basics/how-payloads-work.html)
  * [How to use Datastore Options](https://docs.metasploit.com/docs/development/developing-modules/module-metadata/how-to-use-datastore-options.html)
  * [How to write browser exploits with BES](https://docs.metasploit.com/docs/development/developing-modules/libraries/http/how-to-write-a-browser-exploit-using-browserexploitserver.html)
  * [How to write a bruteforcer](https://docs.metasploit.com/docs/development/developing-modules/libraries/how-to-use-msf-auxiliary-authbrute-to-write-a-bruteforcer.html)

...and many, many more.

## API Documentation

If you are looking for API documentation, you may run `rake yard` to
generate a navigable view of the comment documentation used throughout
Metasploit, or visit https://rapid7.github.io/metasploit-framework/api
for a recently generated online version.

## Contributing

If you would like to contribute to the documentation effort, please see
http://yardoc.org/ for details on how to write YARD-compatible comments,
and send us a [Pull Request](https://github.com/rapid7/metasploit-framework/pulls)
with your contribution.

