/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.DefaultWorkflowExecutionContext;
import org.keycloak.models.workflow.RunWorkflowTask;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStep;

class RestartWorkflowTask
extends RunWorkflowTask {
    private static final Logger log = Logger.getLogger(RestartWorkflowTask.class);
    private final int position;

    RestartWorkflowTask(DefaultWorkflowExecutionContext context, int position) {
        super(context);
        this.position = position;
    }

    @Override
    protected WorkflowStep runCurrentStep(DefaultWorkflowExecutionContext context) {
        Workflow workflow = context.getWorkflow();
        List steps = workflow.getSteps().toList();
        if (this.position < 0 || this.position >= steps.size()) {
            throw new IllegalArgumentException("Invalid position to restart workflow: " + this.position);
        }
        return (WorkflowStep)steps.get(this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(KeycloakSession session) {
        if (log.isDebugEnabled()) {
            Workflow workflow = this.context.getWorkflow();
            String resourceId = this.context.getResourceId();
            String executionId = this.context.getExecutionId();
            WorkflowStep currentStep = this.context.getStep();
            if (currentStep == null) {
                currentStep = workflow.getSteps().findFirst().orElse(null);
            }
            log.debugf("Restarting workflow '%s' for resource %s (execution id: %s) at step %s", new Object[]{workflow.getName(), resourceId, executionId, currentStep.getProviderId()});
        }
        try {
            super.run(session);
        }
        finally {
            this.context.complete();
        }
    }
}

