/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import org.keycloak.config.Option;

public class WildcardOptionsUtil {
    public static final String WILDCARD_START = "<";
    public static final String WILDCARD_END = ">";

    public static boolean isWildcardOption(String key) {
        return key != null && key.contains(WILDCARD_START) && key.contains(WILDCARD_END);
    }

    public static String getWildcardPrefix(String wildcardKey) {
        return wildcardKey != null && wildcardKey.contains(WILDCARD_START) ? wildcardKey.substring(0, wildcardKey.indexOf(WILDCARD_START)) : null;
    }

    public static String getWildcardNamedKey(String wildcardKey, String value) {
        String prefix = WildcardOptionsUtil.getWildcardPrefix(wildcardKey);
        return prefix != null ? prefix.concat(value) : null;
    }

    public static String getWildcardValue(Option<?> option, String namedKey) {
        if (option == null || namedKey == null) {
            return null;
        }
        String key = namedKey.startsWith("kc.") ? namedKey.substring("kc.".length()) : namedKey;
        String prefix = WildcardOptionsUtil.getWildcardPrefix(option.getKey());
        return prefix != null && key.startsWith(prefix) ? key.substring(prefix.length()) : null;
    }
}

