/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;

public class MigrateTo14_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("14.0.0");

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    private void migrateRealm(KeycloakSession session, RealmModel realm) {
        try {
            session.clientPolicy().updateClientProfiles(realm, new ClientProfilesRepresentation());
            session.clientPolicy().updateClientPolicies(realm, new ClientPoliciesRepresentation());
        }
        catch (ClientPolicyException cpe) {
            throw new ModelException("Exception during migration client profiles or client policies", (Throwable)cpe);
        }
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

