/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class NameCache {
    protected static final LazyRemovalCache<Address, String> cache;
    protected static final LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<String>> print_function;

    public static void add(Address uuid, String logical_name) {
        cache.add(uuid, logical_name);
    }

    public static void add(Map<Address, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<Address, String> entry : map.entrySet()) {
            NameCache.add(entry.getKey(), entry.getValue());
        }
    }

    public static String get(Address logical_addr) {
        return cache.get(logical_addr);
    }

    public static Map<Address, String> getContents() {
        return cache.contents();
    }

    public static void remove(Address addr) {
        cache.remove(addr);
    }

    public static void removeAll(Collection<Address> mbrs) {
        cache.removeAll(mbrs);
    }

    public static void retainAll(Collection<Address> logical_addrs) {
        cache.retainAll(logical_addrs);
    }

    public static String printCache() {
        return cache.printCache(print_function);
    }

    static {
        String tmp2;
        print_function = (key, entry) -> (String)entry.getVal() + ": " + (Comparable)(key instanceof UUID ? ((UUID)key).toStringLong() : key) + "\n";
        int max_elements = 500;
        long max_age = 5000L;
        try {
            tmp2 = Util.getProperty(new String[]{"jgroups.name_cache.max_elements"}, null, null, "500");
            if (tmp2 != null) {
                max_elements = Integer.parseInt(tmp2);
            }
        }
        catch (Throwable tmp2) {
            // empty catch block
        }
        try {
            tmp2 = Util.getProperty(new String[]{"jgroups.name_cache.max_age"}, null, null, "120000");
            if (tmp2 != null) {
                max_age = Long.parseLong(tmp2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cache = new LazyRemovalCache(max_elements, max_age);
    }
}

