/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;

public abstract class AbstractClassDetailsRegistry
implements MutableClassDetailsRegistry {
    protected final ModelsContext context;
    private final boolean trackImplementors;
    protected final Map<String, ClassDetails> classDetailsMap;
    protected final Map<String, Set<ClassDetails>> directSubtypeMap;
    protected final Map<String, Set<ClassDetails>> directImplementorMap;

    protected AbstractClassDetailsRegistry(boolean trackImplementors, ModelsContext context) {
        this(trackImplementors, new ConcurrentHashMap<String, ClassDetails>(), new ConcurrentHashMap<String, Set<ClassDetails>>(), new ConcurrentHashMap<String, Set<ClassDetails>>(), context);
    }

    protected AbstractClassDetailsRegistry(boolean trackImplementors, Map<String, ClassDetails> classDetailsMap, Map<String, Set<ClassDetails>> directSubtypeMap, Map<String, Set<ClassDetails>> directImplementorMap, ModelsContext context) {
        this.trackImplementors = trackImplementors;
        this.classDetailsMap = classDetailsMap;
        this.directSubtypeMap = directSubtypeMap;
        this.directImplementorMap = directImplementorMap;
        this.context = context;
        classDetailsMap.put(ClassDetails.CLASS_CLASS_DETAILS.getName(), ClassDetails.CLASS_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.OBJECT_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.VOID_CLASS_DETAILS.getClassName(), ClassDetails.VOID_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.VOID_OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.VOID_OBJECT_CLASS_DETAILS);
    }

    @Override
    public boolean isTrackingImplementors() {
        return this.trackImplementors;
    }

    @Override
    public List<ClassDetails> getDirectSubTypes(String typeName) {
        Set<ClassDetails> directSubtypes = this.getDirectSubtypes(typeName);
        return CollectionHelper.isNotEmpty(directSubtypes) ? new ArrayList<ClassDetails>(directSubtypes) : List.of();
    }

    @Override
    public Set<ClassDetails> getDirectSubtypes(String typeName) {
        Set<ClassDetails> directSubtypes = this.directSubtypeMap.get(typeName);
        return directSubtypes != null ? directSubtypes : Set.of();
    }

    @Override
    public void forEachDirectSubtype(String typeName, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        List<ClassDetails> directSubTypes = this.getDirectSubTypes(typeName);
        if (directSubTypes == null) {
            return;
        }
        for (int i = 0; i < directSubTypes.size(); ++i) {
            consumer.consume(directSubTypes.get(i));
        }
    }

    @Override
    public Set<ClassDetails> getDirectImplementors(String interfaceName) {
        if (!this.trackImplementors) {
            return Collections.emptySet();
        }
        Set<ClassDetails> implementors = this.directImplementorMap.get(interfaceName);
        return implementors != null ? implementors : Set.of();
    }

    @Override
    public void forEachDirectImplementor(String interfaceName, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        if (!this.trackImplementors) {
            return;
        }
        Set<ClassDetails> directImplementors = this.getDirectImplementors(interfaceName);
        if (directImplementors != null) {
            directImplementors.forEach(consumer::consume);
        }
    }

    @Override
    public void walkConcreteTypes(String base, boolean includeBase, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        this.walkImplementors(base, includeBase, classDetails -> {
            if (!classDetails.isAbstract() && !classDetails.isInterface()) {
                consumer.consume(classDetails);
            }
        });
    }

    @Override
    public Set<ClassDetails> collectImplementors(String base, boolean includeBase, Predicate<ClassDetails> exclusions) {
        LinkedHashSet<ClassDetails> result = new LinkedHashSet<ClassDetails>();
        this.walkImplementors(base, includeBase, classDetails -> {
            if (exclusions == null || !exclusions.test(classDetails)) {
                result.add(classDetails);
            }
        });
        return result;
    }

    @Override
    public void walkImplementors(String base, boolean includeBase, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        if (includeBase) {
            ClassDetails baseDetails = this.resolveClassDetails(base);
            consumer.consume(baseDetails);
        }
        this.forEachDirectSubtype(base, subType -> {
            consumer.consume(subType);
            this.walkSubtypes(subType, consumer);
        });
        if (this.trackImplementors) {
            this.forEachDirectImplementor(base, implementor -> {
                consumer.consume(implementor);
                this.walkInterfaceImplementors(implementor, consumer);
            });
        }
    }

    private void walkSubtypes(ClassDetails base, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        this.forEachDirectSubtype(base.getName(), subType -> {
            consumer.consume(subType);
            this.walkSubtypes(subType, consumer);
        });
    }

    private void walkInterfaceImplementors(ClassDetails implementor, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        if (implementor.isInterface()) {
            this.forEachDirectImplementor(implementor.getName(), implementorImplementor -> {
                consumer.consume(implementorImplementor);
                this.walkInterfaceImplementors(implementorImplementor, consumer);
            });
        } else {
            this.forEachDirectSubtype(implementor.getName(), subtype -> {
                consumer.consume(subtype);
                this.walkSubtypes(subtype, consumer);
            });
        }
    }

    @Override
    public ClassDetails findClassDetails(String name) {
        return this.classDetailsMap.get(name);
    }

    @Override
    public void forEachClassDetails(ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        for (Map.Entry<String, ClassDetails> entry : this.classDetailsMap.entrySet()) {
            consumer.consume(entry.getValue());
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name);
    }

    protected ClassDetails createClassDetails(String name) {
        try {
            ClassDetails created = this.getClassDetailsBuilder().buildClassDetails(name, this.context);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return this.getClassDetailsBuilder().buildClassDetails(name + ".package-info", this.context);
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    @Override
    public void addClassDetails(ClassDetails classDetails) {
        this.addClassDetails(classDetails.getClassName(), classDetails);
    }

    @Override
    public void addClassDetails(String name, ClassDetails classDetails) {
        List<TypeDetails> implementedInterfaces;
        this.classDetailsMap.put(name, classDetails);
        if (classDetails.getSuperClass() != null) {
            Set<ClassDetails> subTypes = this.directSubtypeMap.get(classDetails.getSuperClass().getName());
            if (subTypes == null) {
                subTypes = new LinkedHashSet<ClassDetails>();
                this.directSubtypeMap.put(classDetails.getSuperClass().getName(), subTypes);
            }
            subTypes.add(classDetails);
        }
        if (this.trackImplementors && (implementedInterfaces = classDetails.getImplementedInterfaces()) != null) {
            implementedInterfaces.forEach(implementedInterface -> {
                Set directImplementors = this.directImplementorMap.computeIfAbsent(implementedInterface.getName(), interfaceName -> new LinkedHashSet());
                directImplementors.add(classDetails);
            });
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name, MutableClassDetailsRegistry.ClassDetailsCreator creator) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        if ("void".equals(name)) {
            return null;
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name, creator);
    }

    protected ClassDetails createClassDetails(String name, MutableClassDetailsRegistry.ClassDetailsCreator creator) {
        try {
            ClassDetails created = creator.createClassDetails(name);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return creator.createClassDetails(name + ".package-info");
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    public Map<String, ClassDetails> classDetailsMap() {
        return this.classDetailsMap;
    }

    public Map<String, ClassDetails> getClassDetailsMap() {
        return Collections.unmodifiableMap(this.classDetailsMap);
    }

    public Map<String, Set<ClassDetails>> getDirectSubTypeMap() {
        return Collections.unmodifiableMap(this.directSubtypeMap);
    }

    public Map<String, Set<ClassDetails>> getDirectImplementorMap() {
        return Collections.unmodifiableMap(this.directImplementorMap);
    }
}

