/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.ClientModel;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.RealmPermissions;

class RealmPermissionsV2
extends RealmPermissions {
    public RealmPermissionsV2(MgmtPermissions root) {
        super(root);
    }

    @Override
    public boolean canManageAuthorizationDefault(ResourceServer resourceServer) {
        if (super.canManageAuthorizationDefault(resourceServer)) {
            return true;
        }
        return this.root.clients().canManage(this.getClient(resourceServer));
    }

    @Override
    public boolean canViewAuthorizationDefault(ResourceServer resourceServer) {
        if (super.canViewAuthorizationDefault(resourceServer)) {
            return true;
        }
        return this.root.clients().canView(this.getClient(resourceServer));
    }

    private ClientModel getClient(ResourceServer resourceServer) {
        ClientModel client = this.root.session.clients().getClientById(this.root.realm, resourceServer.getId());
        return client;
    }
}

