/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.util.JsonSerialization;

public class SdJwtCredentialBody
implements CredentialBody {
    private static final String CNF_CLAIM = "cnf";
    private static final String JWK_CLAIM = "jwk";
    private final SdJwt.Builder sdJwtBuilder;
    private final Map<String, Object> claimSet;

    public SdJwtCredentialBody(SdJwt.Builder sdJwtBuilder, Map<String, Object> claimSet) {
        this.sdJwtBuilder = sdJwtBuilder;
        this.claimSet = claimSet;
    }

    @Override
    public void addKeyBinding(JWK jwk) throws CredentialBuilderException {
        this.claimSet.put(CNF_CLAIM, Map.of(JWK_CLAIM, jwk));
    }

    public Map<String, Object> getClaimSet() {
        return this.claimSet;
    }

    public String sign(SignatureSignerContext signatureSignerContext) {
        JsonNode claimSet = JsonSerialization.mapper.valueToTree(this.claimSet);
        SdJwt sdJwt = this.sdJwtBuilder.withClaimSet(claimSet).withSigner(signatureSignerContext).build();
        return sdJwt.toSdJwtString();
    }
}

