/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.browser.WebAuthnPasswordlessAuthenticator;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.common.Profile;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;

public class WebAuthnConditionalUIAuthenticator
extends WebAuthnPasswordlessAuthenticator {
    private final Function<AuthenticationFlowContext, Response> errorChallenge;

    public WebAuthnConditionalUIAuthenticator(KeycloakSession session, Function<AuthenticationFlowContext, Response> errorChallenge) {
        super(session);
        this.errorChallenge = errorChallenge;
    }

    @Override
    public LoginFormsProvider fillContextForm(AuthenticationFlowContext context) {
        context.form().setAttribute("enableWebAuthnConditionalUI", (Object)Boolean.TRUE);
        return super.fillContextForm(context);
    }

    @Override
    protected Response createErrorResponse(AuthenticationFlowContext context, String errorCase) {
        context.form().setError(errorCase, new Object[]{""});
        context.form().setAttribute("enableWebAuthnConditionalUI", (Object)Boolean.TRUE);
        AuthenticatorUtils.setupReauthenticationInUsernamePasswordFormError(context);
        this.fillContextForm(context);
        return this.errorChallenge.apply(context);
    }

    public boolean isPasskeysEnabled() {
        return WebAuthnConditionalUIAuthenticator.isPasskeysEnabled(this.session);
    }

    public static boolean isPasskeysEnabled(KeycloakSession session) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PASSKEYS) && session.getContext().getRealm() != null && Boolean.TRUE.equals(session.getContext().getRealm().getWebAuthnPolicyPasswordless().isPasskeysEnabled());
    }
}

