/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandler;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandlerBuildResult;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public abstract class AbstractMultiTableMutationQueryPlan<S extends SqmDmlStatement<?>, F>
implements NonSelectQueryPlan {
    private final S statement;
    private final DomainParameterXref domainParameterXref;
    private final F strategy;
    private volatile MultiTableHandler handler;

    public AbstractMultiTableMutationQueryPlan(S statement, DomainParameterXref domainParameterXref, F strategy) {
        this.statement = statement;
        this.domainParameterXref = domainParameterXref;
        this.strategy = strategy;
    }

    protected abstract MultiTableHandlerBuildResult buildHandler(S var1, DomainParameterXref var2, F var3, DomainQueryExecutionContext var4);

    @Override
    public int executeUpdate(DomainQueryExecutionContext context) {
        BulkOperationCleanupAction.schedule(context.getSession(), this.statement);
        Interpretation interpretation = this.getInterpretation(context);
        return interpretation.handler().execute(interpretation.jdbcParameterBindings(), context);
    }

    protected S getStatement() {
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interpretation getInterpretation(DomainQueryExecutionContext context) {
        Interpretation builtInterpretation = null;
        MultiTableHandler localCopy = this.handler;
        if (localCopy == null) {
            AbstractMultiTableMutationQueryPlan abstractMultiTableMutationQueryPlan = this;
            synchronized (abstractMultiTableMutationQueryPlan) {
                localCopy = this.handler;
                if (localCopy == null) {
                    MultiTableHandlerBuildResult buildResult = this.buildHandler(this.statement, this.domainParameterXref, this.strategy, context);
                    builtInterpretation = new Interpretation(buildResult.multiTableHandler(), buildResult.firstJdbcParameterBindings());
                    this.handler = localCopy = buildResult.multiTableHandler();
                } else {
                    builtInterpretation = this.updateInterpretation(localCopy, context);
                }
            }
        } else {
            builtInterpretation = this.updateInterpretation(localCopy, context);
        }
        return builtInterpretation != null ? builtInterpretation : new Interpretation(localCopy, localCopy.createJdbcParameterBindings(context));
    }

    private @Nullable Interpretation updateInterpretation(MultiTableHandler localCopy, DomainQueryExecutionContext context) {
        Interpretation builtInterpretation = null;
        if (localCopy.dependsOnParameterBindings()) {
            JdbcParameterBindings jdbcParameterBindings = localCopy.createJdbcParameterBindings(context);
            if (!localCopy.isCompatibleWith(jdbcParameterBindings, context.getQueryOptions())) {
                MultiTableHandlerBuildResult buildResult = this.buildHandler(this.statement, this.domainParameterXref, this.strategy, context);
                localCopy = buildResult.multiTableHandler();
                builtInterpretation = new Interpretation(buildResult.multiTableHandler(), buildResult.firstJdbcParameterBindings());
                this.handler = localCopy;
            } else {
                builtInterpretation = new Interpretation(localCopy, jdbcParameterBindings);
            }
        }
        return builtInterpretation;
    }

    protected record Interpretation(MultiTableHandler handler, JdbcParameterBindings jdbcParameterBindings) {
    }
}

