/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.ClassFileTransform;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodElement;
import io.github.dmlloyd.classfile.impl.TransformImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface MethodTransform
extends ClassFileTransform<MethodTransform, MethodElement, MethodBuilder> {
    public static final MethodTransform ACCEPT_ALL = new MethodTransform(){

        @Override
        public void accept(MethodBuilder builder, MethodElement element) {
            builder.with(element);
        }
    };

    public static MethodTransform ofStateful(Supplier<MethodTransform> supplier) {
        Objects.requireNonNull(supplier);
        return new TransformImpl.SupplierMethodTransform(supplier);
    }

    public static MethodTransform endHandler(final Consumer<MethodBuilder> finisher) {
        Objects.requireNonNull(finisher);
        return new MethodTransform(){

            @Override
            public void accept(MethodBuilder builder, MethodElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(MethodBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static MethodTransform dropping(Predicate<MethodElement> filter) {
        Objects.requireNonNull(filter);
        return (b, e) -> {
            if (!filter.test((MethodElement)e)) {
                b.with(e);
            }
        };
    }

    public static MethodTransform transformingCode(CodeTransform xform) {
        return new TransformImpl.MethodCodeTransform(Objects.requireNonNull(xform));
    }

    @Override
    default public MethodTransform andThen(MethodTransform t) {
        return new TransformImpl.ChainedMethodTransform(this, Objects.requireNonNull(t));
    }
}

