/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;

public class StatisticsImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected StatisticsImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.StatisticsImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(StatisticsImageFilter statisticsImageFilter) {
        return statisticsImageFilter == null ? 0L : statisticsImageFilter.swigCPtr;
    }

    protected static long swigRelease(StatisticsImageFilter statisticsImageFilter) {
        long l = 0L;
        if (statisticsImageFilter != null) {
            if (!statisticsImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = statisticsImageFilter.swigCPtr;
            statisticsImageFilter.swigCMemOwn = false;
            statisticsImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_StatisticsImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public StatisticsImageFilter() {
        this(SimpleITKJNI.new_StatisticsImageFilter(), true);
    }

    public double getMinimum() {
        return SimpleITKJNI.StatisticsImageFilter_getMinimum(this.swigCPtr, this);
    }

    public double getMaximum() {
        return SimpleITKJNI.StatisticsImageFilter_getMaximum(this.swigCPtr, this);
    }

    public double getMean() {
        return SimpleITKJNI.StatisticsImageFilter_getMean(this.swigCPtr, this);
    }

    public double getSigma() {
        return SimpleITKJNI.StatisticsImageFilter_getSigma(this.swigCPtr, this);
    }

    public double getVariance() {
        return SimpleITKJNI.StatisticsImageFilter_getVariance(this.swigCPtr, this);
    }

    public double getSum() {
        return SimpleITKJNI.StatisticsImageFilter_getSum(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.StatisticsImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.StatisticsImageFilter_toString(this.swigCPtr, this);
    }

    public void execute(Image image) {
        SimpleITKJNI.StatisticsImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image);
    }
}

