/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a \u0010\t\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\f\u001a\u0004\u0018\u00010\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a2\u0010\u000f\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0003\u001a,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0019"}, d2={"validateName", "Lcom/intellij/openapi/ui/ValidationInfo;", "repositories", "", "Lgit4idea/repo/GitRepository;", "inputString", "", "checkRefName", "checkRefNameEmptyOrHead", "checkBranchConflict", "conflictsWithLocalBranch", "conflictsWithRemoteBranch", "conflictsWithLocalBranchDirectory", "directories", "", "conflictsWithLocalOrRemote", "local", "", "message", "getAdditionalDescription", "", "getReposWithConflictingBranch", "findConflictingBranch", "Lgit4idea/GitBranch;", "repository", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchValidator.kt\ngit4idea/validators/GitBranchValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n774#2:75\n865#2,2:76\n1#3:78\n*S KotlinDebug\n*F\n+ 1 GitBranchValidator.kt\ngit4idea/validators/GitBranchValidatorKt\n*L\n69#1:75\n69#1:76,2\n*E\n"})
public final class GitBranchValidatorKt {
    @Nullable
    public static final ValidationInfo validateName(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        ValidationInfo validationInfo = GitBranchValidatorKt.checkRefName(inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.checkBranchConflict(repositories, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo checkRefName(@Nullable String inputString) {
        ValidationInfo validationInfo = GitBranchValidatorKt.checkRefNameEmptyOrHead(inputString);
        if (validationInfo == null) {
            if (!GitRefNameValidator.getInstance().checkInput(inputString)) {
                Object[] objectArray = new Object[]{inputString};
                ValidationInfo validationInfo2 = new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.invalid", objectArray));
                validationInfo = validationInfo2;
            } else {
                validationInfo = null;
            }
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo checkRefNameEmptyOrHead(@Nullable String inputString) {
        return StringUtil.isEmptyOrSpaces((String)inputString) ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.empty", new Object[0])) : (StringUtil.equalsIgnoreCase((CharSequence)inputString, (CharSequence)"HEAD") ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.head", new Object[0])) : null);
    }

    private static final ValidationInfo checkBranchConflict(Collection<? extends GitRepository> repositories, String inputString) {
        ValidationInfo validationInfo = GitBranchValidatorKt.conflictsWithLocalBranch(repositories, inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.conflictsWithRemoteBranch(repositories, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo conflictsWithLocalBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories, inputString, true, "new.branch.dialog.error.branch.already.exists");
    }

    @Nullable
    public static final ValidationInfo conflictsWithRemoteBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories, inputString, false, "new.branch.dialog.error.branch.clashes.with.remote");
    }

    @Nullable
    public static final ValidationInfo conflictsWithLocalBranchDirectory(@NotNull Set<String> directories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        if (directories.contains(inputString)) {
            Object[] objectArray = new Object[]{inputString};
            return new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.clashes.with.directory", objectArray));
        }
        return null;
    }

    private static final ValidationInfo conflictsWithLocalOrRemote(Collection<? extends GitRepository> repositories, String inputString, boolean local, @PropertyKey(resourceBundle="messages.GitBundle") String message) {
        List<GitRepository> reposWithConflictingBranch = GitBranchValidatorKt.getReposWithConflictingBranch(repositories, inputString, local);
        if (reposWithConflictingBranch.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{inputString};
        String string = GitBundle.message(message, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object errorText = string;
        if (repositories.size() > reposWithConflictingBranch.size()) {
            errorText = (String)errorText + GitBranchValidatorKt.getAdditionalDescription(reposWithConflictingBranch);
            if (local) {
                return new ValidationInfo((String)errorText).asWarning().withOKEnabled();
            }
        }
        return new ValidationInfo((String)errorText);
    }

    @Nls
    private static final String getAdditionalDescription(List<? extends GitRepository> repositories) {
        String string;
        if (repositories.size() > 1) {
            Object[] objectArray = new Object[]{repositories.size()};
            string = GitBundle.message("common.suffix.in.several.repositories", objectArray);
        } else {
            Object[] objectArray = new Object[]{DvcsUtil.getShortRepositoryName((Repository)((Repository)CollectionsKt.first(repositories)))};
            string = GitBundle.message("common.suffix.in.one.repository", objectArray);
        }
        return " " + string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitRepository> getReposWithConflictingBranch(Collection<? extends GitRepository> repositories, String inputString, boolean local) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = repositories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository repository2 = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(GitBranchValidatorKt.findConflictingBranch(inputString, repository2, local) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final GitBranch findConflictingBranch(String inputString, GitRepository repository2, boolean local) {
        GitBranchesCollection $this$findConflictingBranch_u24lambda_u241 = repository2.getBranches();
        boolean bl = false;
        return local ? (GitBranch)$this$findConflictingBranch_u24lambda_u241.findLocalBranch(inputString) : (GitBranch)$this$findConflictingBranch_u24lambda_u241.findRemoteBranch(inputString);
    }
}

