/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.log.GitExternalLogTabsProperties;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.MyContentComponent;
import git4idea.log.ShowLogTask;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0007\u001ak\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u00100\u0013\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0007\u001a>\u0010\u0016\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a*\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a.\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0003\u001a\u0016\u0010 \u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u001e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0003\u001a\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u001e\u0010(\u001a\u00020&2\u0006\u0010\"\u001a\u00020#2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0002\u001a&\u0010*\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010,H\u0002\"\u000e\u0010\u001f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"showExternalGitLogInToolwindow", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "vcs", "Lgit4idea/GitVcs;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "tabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "tabDescription", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "T", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "uiFactory", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "Lkotlin/ExtensionFunctionType;", "addLogContent", "component", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "showLogContentWindow", "content", "title", "createLogManager", "EXTERNAL", "calcLogId", "calcTabName", "cm", "Lcom/intellij/ui/content/ContentManager;", "getGitRootsFromUser", "selectProjectLog", "", "requestedRoots", "selectAlreadyOpened", "", "doOnProviderRemoval", "closeTab", "Lkotlin/Function0;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitShowExternalLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,270:1\n1563#2:271\n1634#2,3:272\n1869#2,2:282\n12637#3,2:275\n3829#3:277\n4344#3,2:278\n1310#3,2:280\n*S KotlinDebug\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n*L\n197#1:271\n197#1:272,3\n202#1:282,2\n223#1:275,2\n233#1:277\n233#1:278,2\n248#1:280,2\n*E\n"})
public final class GitShowExternalLogActionKt {
    @NotNull
    private static final String EXTERNAL = "EXTERNAL";

    @ApiStatus.Internal
    public static final void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        GitShowExternalLogActionKt.showExternalGitLogInToolwindow(project, toolWindow, arg_0 -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$0(roots, arg_0), vcs, roots, tabTitle, tabDescription);
    }

    @ApiStatus.Internal
    public static final <T extends VcsLogUiEx> void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Function1<? super VcsLogManager, ? extends T> uiFactory, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        Function0 showContent = () -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$2(project, vcs, roots, toolWindow, uiFactory, tabTitle, tabDescription);
        if (!toolWindow.isVisible()) {
            toolWindow.activate(() -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$3(showContent), true);
        } else {
            showContent.invoke();
        }
    }

    private static final void addLogContent(ToolWindow $this$addLogContent, Project project, JComponent component2, String tabTitle, String tabDescription, Disposable disposable) {
        Content content = ContentFactory.getInstance().createContent(component2, tabTitle, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setDisposer(disposable);
        content2.setDescription(tabDescription);
        content2.setCloseable(true);
        ContentManager contentManager = $this$addLogContent.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager cm = contentManager;
        cm.addContent(content2);
        cm.setSelectedContent(content2);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)() -> GitShowExternalLogActionKt.addLogContent$lambda$4(cm, content2)));
    }

    private static final void showLogContentWindow(Project project, JComponent content, @NlsContexts.DialogTitle String title, Disposable disposable) {
        WindowWrapper windowWrapper = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, content).setProject(project).setTitle(title).setPreferredFocusedComponent(content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
        Intrinsics.checkNotNullExpressionValue((Object)windowWrapper, (String)"build(...)");
        WindowWrapper window = windowWrapper;
        Disposer.register((Disposable)((Disposable)window), (Disposable)disposable);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)() -> GitShowExternalLogActionKt.showLogContentWindow$lambda$5(window)));
        window.show();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final VcsLogManager createLogManager(Project project, GitVcs vcs, List<? extends VirtualFile> roots, Disposable disposable) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile virtualFile : roots) {
            repositoryManager.addExternalRepository(virtualFile, GitRepositoryImpl.Companion.createInstance(virtualFile, project, disposable));
        }
        GitExternalLogTabsProperties properties = (GitExternalLogTabsProperties)ApplicationManager.getApplication().getService(GitExternalLogTabsProperties.class);
        Iterable iterable = roots;
        VcsLogManager.Companion companion = VcsLogManager.Companion;
        boolean $i$f$map = false;
        VcsLogManager vcsLogManager = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VcsRoot((AbstractVcs)vcs, (VirtualFile)it));
        }
        Map map2 = companion.findLogProviders((Collection)((List)destination$iv$iv), project);
        String name = "Vcs Log for " + VcsLogUtil.getProvidersMapText((Map)map2);
        Intrinsics.checkNotNull((Object)properties);
        VcsLogManager $this$createLogManager_u24lambda_u247 = vcsLogManager = new VcsLogManager(project, (VcsLogTabsProperties)properties, map2, name, false, null);
        boolean bl = false;
        $this$createLogManager_u24lambda_u247.initialize();
        VcsLogManager manager = vcsLogManager;
        Disposer.register((Disposable)disposable, () -> GitShowExternalLogActionKt.createLogManager$lambda$10(manager, roots, repositoryManager));
        return manager;
    }

    private static final String calcLogId(List<? extends VirtualFile> roots) {
        Iterable iterable = roots;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return "EXTERNAL " + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, GitShowExternalLogActionKt::calcLogId$lambda$11, (int)30, null);
    }

    @Nls
    private static final String calcTabName(ContentManager cm, List<? extends VirtualFile> roots) {
        String name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + ((VirtualFile)CollectionsKt.first(roots)).getName() + (roots.size() > 1 ? "+" : "") + ")";
        String candidate = null;
        candidate = name;
        int cnt = 1;
        while (true) {
            boolean bl;
            block2: {
                Content[] contentArray = cm.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$any$iv = contentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Content content = (Content)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)candidate)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getGitRootsFromUser(Project project) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFiles;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        VirtualFile[] $this$filter$iv = virtualFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!GitUtil.isGitRoot(it.toNioPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean selectProjectLog(Project project, GitVcs vcs, List<? extends VirtualFile> requestedRoots) {
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        List projectRoots = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        if (!projectRoots.containsAll((Collection)requestedRoots)) {
            return false;
        }
        if (requestedRoots.containsAll(projectRoots)) {
            return VcsLogContentUtil.INSTANCE.selectMainLog(project);
        }
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{VcsLogFilterObject.fromRoots((Collection)requestedRoots)};
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
        return VcsProjectLog.Companion.getInstance(project).openLogTab(filters) != null;
    }

    private static final boolean selectAlreadyOpened(ContentManager cm, Collection<? extends VirtualFile> roots) {
        Object object;
        block2: {
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JComponent component2;
                Content content = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
                boolean bl2 = component2 instanceof MyContentComponent ? Comparing.haveEqualElements(roots, ((MyContentComponent)component2).getRoots()) : false;
                if (!bl2) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return false;
        }
        Content content2 = content;
        cm.setSelectedContent(content2);
        return true;
    }

    private static final void doOnProviderRemoval(Project project, Disposable disposable, Function0<Unit> closeTab) {
        VcsLogProvider.LOG_PROVIDER_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<VcsLogProvider>(closeTab){
            final /* synthetic */ Function0<Unit> $closeTab;
            {
                this.$closeTab = $closeTab;
            }

            public void extensionRemoved(VcsLogProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)extension.getSupportedVcs(), (Object)GitVcs.getKey())) {
                    this.$closeTab.invoke();
                }
            }
        }, false, disposable);
    }

    private static final MainVcsLogUi showExternalGitLogInToolwindow$lambda$0(List $roots, VcsLogManager $this$showExternalGitLogInToolwindow) {
        Intrinsics.checkNotNullParameter((Object)$this$showExternalGitLogInToolwindow, (String)"$this$showExternalGitLogInToolwindow");
        return $this$showExternalGitLogInToolwindow.createLogUi(GitShowExternalLogActionKt.calcLogId($roots), null);
    }

    private static final Unit showExternalGitLogInToolwindow$lambda$2$lambda$1(Function1 $uiFactory, List $roots, ToolWindow $toolWindow, Project $project, String $tabTitle, String $tabDescription, VcsLogManager $this$ShowLogTask, Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)$this$ShowLogTask, (String)"$this$ShowLogTask");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        VcsLogUiEx ui = (VcsLogUiEx)$uiFactory.invoke((Object)$this$ShowLogTask);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)ui));
        MyContentComponent component2 = new MyContentComponent((JComponent)new VcsLogPanel($this$ShowLogTask, ui), $roots);
        GitShowExternalLogActionKt.addLogContent($toolWindow, $project, component2, $tabTitle, $tabDescription, disposable);
        return Unit.INSTANCE;
    }

    private static final Unit showExternalGitLogInToolwindow$lambda$2(Project $project, GitVcs $vcs, List $roots, ToolWindow $toolWindow, Function1 $uiFactory, String $tabTitle, String $tabDescription) {
        if (!GitShowExternalLogActionKt.selectProjectLog($project, $vcs, $roots)) {
            ContentManager contentManager = $toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            if (!GitShowExternalLogActionKt.selectAlreadyOpened(contentManager, $roots)) {
                ProgressManager.getInstance().run((Task)new ShowLogTask($project, $roots, $vcs, false, (Function2<? super VcsLogManager, ? super Disposable, Unit>)((Function2)(arg_0, arg_1) -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$2$lambda$1($uiFactory, $roots, $toolWindow, $project, $tabTitle, $tabDescription, arg_0, arg_1))));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void showExternalGitLogInToolwindow$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit addLogContent$lambda$4(ContentManager $cm, Content $content) {
        $cm.removeContent($content, true);
        return Unit.INSTANCE;
    }

    private static final Unit showLogContentWindow$lambda$5(WindowWrapper $window) {
        $window.close();
        return Unit.INSTANCE;
    }

    private static final void createLogManager$lambda$10$lambda$9(List $roots, GitRepositoryManager $repositoryManager) {
        Iterable $this$forEach$iv = $roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            $repositoryManager.removeExternalRepository(it);
        }
    }

    private static final void createLogManager$lambda$10(VcsLogManager $manager, List $roots, GitRepositoryManager $repositoryManager) {
        $manager.dispose(() -> GitShowExternalLogActionKt.createLogManager$lambda$10$lambda$9($roots, $repositoryManager));
    }

    private static final CharSequence calcLogId$lambda$11(VirtualFile obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = obj.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public static final /* synthetic */ List access$getGitRootsFromUser(Project project) {
        return GitShowExternalLogActionKt.getGitRootsFromUser(project);
    }

    public static final /* synthetic */ String access$calcTabName(ContentManager cm, List roots) {
        return GitShowExternalLogActionKt.calcTabName(cm, roots);
    }

    public static final /* synthetic */ String access$calcLogId(List roots) {
        return GitShowExternalLogActionKt.calcLogId(roots);
    }

    public static final /* synthetic */ void access$showLogContentWindow(Project project, JComponent content, String title, Disposable disposable) {
        GitShowExternalLogActionKt.showLogContentWindow(project, content, title, disposable);
    }

    public static final /* synthetic */ VcsLogManager access$createLogManager(Project project, GitVcs vcs, List roots, Disposable disposable) {
        return GitShowExternalLogActionKt.createLogManager(project, vcs, roots, disposable);
    }
}

