/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.popup.GitBranchesTreePopupOnBackend;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitBranchesComboBoxAction
extends ComboBoxAction
implements DumbAware {
    GitBranchesComboBoxAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed() || !project.isOpen()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitRepository repo2 = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
        if (repo2 == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (!ToolbarSettings.getInstance().isAvailable()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        String branchName = repo2.getCurrentRevision() != null ? GitBranchUtil.getDisplayableBranchText(repo2) : GitBundle.message("no.revisions.available", new Object[0]);
        String name = DvcsBranchUtil.shortenBranchName((String)branchName);
        presentation.setText(name, false);
        presentation.setIcon(BranchIconUtil.Companion.getBranchIcon(repo2));
        presentation.setEnabledAndVisible(true);
        presentation.setDescription(GitBundle.messagePointer("action.Git.ShowBranches.pretty.description", new Object[0]).get());
    }

    @NotNull
    protected JBPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component2, final @Nullable Runnable disposeCallback) {
        if (context == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(3);
        }
        Project project = Objects.requireNonNull((Project)context.getData(CommonDataKeys.PROJECT));
        GitRepository repo2 = Objects.requireNonNull(GitBranchUtil.guessWidgetRepository(project, context));
        JBPopup popup = GitBranchesTreePopupOnBackend.create(project, repo2);
        popup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (disposeCallback != null) {
                    disposeCallback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/actions/GitBranchesComboBoxAction$1", "onClosed"));
            }
        });
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(4);
        }
        return jBPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitBranchesComboBoxAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitBranchesComboBoxAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

